/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.BaseMenuPageDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.swing.PaginatedListModel;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MenuPageDAO
extends BaseMenuPageDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePages(List<MenuPage> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuPage menuPage : list) {
                session.saveOrUpdate((Object)menuPage);
            }
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, MenuGroup menuGroup, Object object) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            this.addOrderTypeCriteria((OrderType)object, criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuPage> findByGroup(MenuGroup menuGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, MenuGroup menuGroup, OrderType orderType, Boolean bl, PaginatedListModel paginatedListModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            if (menuGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)menuGroup.getId()));
            }
            this.addOrderTypeCriteria(orderType, criteria);
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            paginatedListModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    private void addOrderTypeCriteria(OrderType orderType, Criteria criteria) {
        if (orderType != null) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)MenuPage.PROP_ORDER_TYPE_ID), (Criterion)Restrictions.eq((String)MenuPage.PROP_ORDER_TYPE_ID, (Object)orderType.getId())));
        } else {
            criteria.add(Restrictions.isNull((String)MenuPage.PROP_ORDER_TYPE_ID));
        }
    }

    public void deleteAll(List<MenuPage> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.deleteAll(list, session);
            transaction.commit();
        }
    }

    public void deleteAll(List<MenuPage> list, Session session) {
        for (MenuPage menuPage : list) {
            session.delete((Object)menuPage);
        }
    }

    public void addToMenuGroupEndPage(MenuItem menuItem) {
        if (menuItem.getMenuGroupId() == null) {
            return;
        }
        MenuItemDAO.getInstance().initialize(menuItem);
        MenuPage menuPage = this.getLastPage(menuItem.getMenuGroupId());
        MenuPageItem menuPageItem = new MenuPageItem(null, null, menuItem, menuPage);
        for (int i = 0; i < menuPage.getRows(); ++i) {
            for (int j = 0; j < menuPage.getCols(); ++j) {
                if (menuPage.getItemForCell(j, i) != null) continue;
                menuPageItem.setCol(j);
                menuPageItem.setRow(i);
                menuPageItem.setMenuPage(menuPage);
                MenuPageItemDAO.getInstance().saveOrUpdate(menuPage);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MenuPage getLastPage(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_MENU_GROUP_ID, (Object)string));
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            List list = criteria.list();
            MenuPage menuPage = null;
            if (list != null && !list.isEmpty()) {
                menuPage = (MenuPage)list.get(list.size() - 1);
            }
            List<MenuPageItem> list2 = null;
            if (menuPage != null) {
                list2 = MenuPageItemDAO.getInstance().getPageItems(menuPage);
            }
            if (menuPage == null || list2 != null && !list2.isEmpty() && list2.size() == menuPage.getRows() * menuPage.getCols()) {
                menuPage = new MenuPage();
                menuPage.setMenuGroupId(string);
                int n = list.size() + 1;
                menuPage.setName("Page " + n);
                menuPage.setSortOrder(n);
                menuPage.setCols(5);
                menuPage.setRows(5);
                menuPage.setButtonHeight(120);
                menuPage.setButtonWidth(120);
                menuPage.setVisible(true);
            }
            MenuPage menuPage2 = menuPage;
            return menuPage2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initialize(MenuPage menuPage) {
        if (Hibernate.isInitialized(menuPage.getPageItems())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)menuPage);
            Hibernate.initialize(menuPage.getPageItems());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(Terminal terminal, List<String> list, Object object) {
        if (list == null || list.size() == 0) {
            return 0;
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, list));
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadItems(Terminal terminal, List<String> list, OrderType orderType, Boolean bl, PaginatedListModel paginatedListModel) {
        if (list == null || list.size() == 0) {
            return;
        }
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)MenuPage.PROP_SORT_ORDER));
            criteria.add(Restrictions.in((String)MenuPage.PROP_MENU_GROUP_ID, list));
            criteria.add((Criterion)Restrictions.eq((String)MenuPage.PROP_VISIBLE, (Object)Boolean.TRUE));
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(1);
            paginatedListModel.setData(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateMenuPageList(List<MenuPage> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (MenuPage menuPage : list) {
                MenuPage menuPage2 = this.get(menuPage.getId());
                if (menuPage2 != null) {
                    this.initialize(menuPage2);
                }
                List<MenuPageItem> list2 = menuPage.getPageItems();
                menuPage.setUpdateLastUpdateTime(bl);
                menuPage.setUpdateSyncTime(bl2);
                menuPage.setPageItems(null);
                this.saveOrUpdateMenuPage(session, menuPage, menuPage2);
                this.saveOrUpdateMenuPageItems(session, menuPage, menuPage2, list2);
                menuPage.setPageItems(list2);
                this.saveOrUpdate(menuPage, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void saveOrUpdateMenuPageItems(Session session, MenuPage menuPage, MenuPage menuPage2, List<MenuPageItem> list) {
        List<MenuPageItem> list2 = null;
        if (menuPage2 != null) {
            list2 = menuPage2.getPageItems();
        }
        for (MenuPageItem menuPageItem : list) {
            menuPageItem.setMenuPage(menuPage);
            this.saveOrUpdateMenuPageItem(session, menuPageItem, list2);
        }
    }

    private void saveOrUpdateMenuPageItem(Session session, MenuPageItem menuPageItem, List<MenuPageItem> list) {
        MenuPageItemDAO menuPageItemDAO = new MenuPageItemDAO();
        MenuPageItem menuPageItem2 = null;
        if (list == null || list.isEmpty()) {
            menuPageItemDAO.save(menuPageItem, session);
        } else {
            int n = list.indexOf(menuPageItem);
            if (n != -1) {
                menuPageItem2 = list.get(n);
                if (menuPageItem2 == null) {
                    menuPageItemDAO.save(menuPageItem, session);
                } else {
                    menuPageItem.setVersion(menuPageItem2.getVersion());
                }
            } else {
                menuPageItemDAO.save(menuPageItem, session);
            }
        }
    }

    private void saveOrUpdateMenuPage(Session session, MenuPage menuPage, MenuPage menuPage2) {
        if (menuPage2 == null) {
            this.save(menuPage, session);
        } else {
            menuPage.setVersion(menuPage2.getVersion());
        }
    }
}

