/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.dao.BaseShopFloorDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class ShopFloorDAO
extends BaseShopFloorDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShopFloor> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)ShopFloor.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean hasFloor() {
        Number number = (Number)this.getSession().createCriteria(this.getReferenceClass()).setProjection(Projections.rowCount()).uniqueResult();
        return number.intValue() != 0;
    }

    public void initializeTables(ShopFloor shopFloor) {
        if (shopFloor == null || shopFloor.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopFloor);
            Hibernate.initialize(shopFloor.getTables());
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(ShopFloor shopFloor) throws HibernateException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.refresh(shopFloor, session);
            Set<ShopTable> set = shopFloor.getTables();
            if (set != null && !set.isEmpty()) {
                for (ShopTable shopTable : set) {
                    shopTable.setFloorId(null);
                    ShopTableDAO.getInstance().update(shopTable, session);
                }
                shopFloor.getTables().removeAll(set);
                this.saveOrUpdate(shopFloor, session);
            }
            super.delete(shopFloor, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopFloorDAO.class).error((Object)exception);
            throw new HibernateException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateShopFloors(List<ShopFloor> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopFloor shopFloor : list) {
                ShopFloor shopFloor2 = this.get(shopFloor.getId());
                Hibernate.initialize(shopFloor.getTables());
                Set<ShopTable> set = shopFloor.getTables();
                shopFloor.setTables(null);
                shopFloor.setUpdateLastUpdateTime(bl);
                shopFloor.setUpdateSyncTime(bl2);
                if (shopFloor2 == null) {
                    this.save(shopFloor, session);
                } else {
                    shopFloor.setVersion(shopFloor2.getVersion());
                }
                this.saveShopTables(session, shopFloor, shopFloor2, set, bl, bl2);
                shopFloor.setTables(set);
                this.update(shopFloor, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void saveShopTables(Session session, ShopFloor shopFloor, ShopFloor shopFloor2, Set<ShopTable> set, boolean bl, boolean bl2) {
        if (set != null && set.size() > 0) {
            for (ShopTable shopTable : set) {
                shopTable.setFloor(shopFloor);
                ShopTable shopTable2 = ShopTableDAO.getInstance().get(shopTable.getId());
                if (shopTable2 == null) {
                    shopTable.setUpdateLastUpdateTime(bl);
                    shopTable.setUpdateSyncTime(bl2);
                    session.save((Object)shopTable);
                    continue;
                }
                shopTable.setUpdateLastUpdateTime(bl);
                shopTable.setUpdateSyncTime(bl2);
                shopTable.setVersion(shopTable2.getVersion());
            }
        }
    }
}

