/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseBookingInfo;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.BaseShopTableDAO;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class ShopTableDAO
extends BaseShopTableDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)ShopTable.PROP_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextTableNumber() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection((Projection)Projections.max((String)ShopTable.PROP_ID));
            int n = POSUtil.getInteger(criteria.uniqueResult());
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopTable getByNumber(int n) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_ID, (Object)n));
            ShopTable shopTable = (ShopTable)criteria.uniqueResult();
            return shopTable;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getByFloor(ShopFloor shopFloor) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_FLOOR_ID, (Object)shopFloor.getId()));
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getAllUnassigned() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.isNull((String)ShopTable.PROP_FLOOR_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> getByNumbers(Collection<Integer> collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            for (Integer n : collection) {
                disjunction.add((Criterion)Restrictions.eq((String)ShopTable.PROP_ID, (Object)n));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTable> getTables(Ticket ticket) {
        return this.getByNumbers(ticket.getTableNumbers());
    }

    public void bookedTables(List<ShopTableStatus> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : list) {
                shopTableStatus.setTableStatus(TableStatus.Seat);
                session.saveOrUpdate((Object)shopTableStatus);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void occupyTables(Ticket ticket) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.occupyTables(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void occupyTables(Ticket ticket, Session session) {
        List<Integer> list = ticket.getTableNumbers();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ticket.getId());
        User user = ticket.getOwner();
        for (Integer n : list) {
            ShopTableStatus shopTableStatus = ShopTableStatusDAO.getInstance().get(n, session);
            if (shopTableStatus == null) {
                shopTableStatus = new ShopTableStatus();
                shopTableStatus.setId(n);
            }
            shopTableStatus.setTableTicket(ticket.getId(), ticket.getTokenNo(), user.getId(), user.getFirstName(), ticket.getCreateDate());
            shopTableStatus.setTableStatus(TableStatus.Serving);
            shopTableStatus.setShouldPublishMqtt(ticket.isShouldPublishMqtt());
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
        }
    }

    public void freeTables(List<ShopTableStatus> list) {
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTableStatus shopTableStatus : list) {
                shopTableStatus.setTableStatus(TableStatus.Available);
                shopTableStatus.removeProperty("seat.time");
                ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void freeTablesByNumbers(List<Integer> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.freeTables(list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void freeTables(List<Integer> list, Session session) {
        for (Integer n : list) {
            ShopTableStatus shopTableStatus = (ShopTableStatus)session.get(ShopTableStatus.class, (Serializable)n);
            shopTableStatus.setTicketId(null);
            shopTableStatus.setTableStatus(TableStatus.Available);
            shopTableStatus.removeProperty("seat.time");
            this.saveOrUpdate(shopTableStatus, session);
        }
    }

    public void releaseTables(Ticket ticket) {
        List<ShopTable> list = this.getTables(ticket);
        if (list == null) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTable shopTable : list) {
                shopTable.setTableStatus(TableStatus.Available);
                ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
                shopTableStatus.removeProperty("seat.time");
                ShopTableStatusDAO.getInstance().update(shopTableStatus);
                this.saveOrUpdate(shopTable, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void releaseAndDeleteTicketTables(Ticket ticket) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.releaseTables(ticket);
            ticket.setTableNumbers(null);
            TicketDAO.getInstance().saveOrUpdate(ticket);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTables(Collection<ShopTable> collection) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTable shopTable : collection) {
                super.delete(shopTable, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<ShopTableType> getTableByTypes(List<ShopTableType> list) {
        ShopTableType shopTableType2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ShopTableType shopTableType2 : list) {
            arrayList.add(shopTableType2.getId());
        }
        Session session = this.getSession();
        shopTableType2 = session.createCriteria(ShopTable.class);
        shopTableType2.createAlias("types", "t");
        shopTableType2.add(Restrictions.in((String)"t.id", arrayList));
        shopTableType2.addOrder(Order.asc((String)ShopTable.PROP_ID));
        return shopTableType2.list();
    }

    public void createNewTables(int n) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (int i = 0; i < n; ++i) {
                ShopTable shopTable = new ShopTable();
                shopTable.setId(i + 1);
                shopTable.setCapacity(4);
                super.save(shopTable, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableStatus(List list, Integer n, Ticket ticket, boolean bl) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.updateTableStatus((List<Integer>)list, n, ticket, session);
            if (bl) {
                session.saveOrUpdate((Object)ticket);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopTableDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableStatus(List<Integer> list, Integer n, Ticket ticket, Session session) {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        String string3 = null;
        if (ticket != null) {
            string = ticket.getId();
            string2 = ticket.getOwner().getId();
            string3 = ticket.getOwner().getFirstName();
            arrayList.add(ticket.getId());
        }
        for (Integer n2 : list) {
            ShopTableStatus shopTableStatus = ShopTableStatusDAO.getInstance().get(n2, session);
            if (shopTableStatus == null) continue;
            if (ticket != null) {
                shopTableStatus.setTableTicket(string, ticket.getTokenNo(), string2, string3, ticket.getCreateDate());
            } else {
                shopTableStatus.setTicketId(null);
            }
            session.saveOrUpdate((Object)shopTableStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findByCapacity(String string) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isEmpty((String)string)) {
                List<ShopTable> list2 = null;
                return list2;
            }
            if (StringUtils.isNumeric((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_CAPACITY, (Object)Integer.valueOf(string)));
            }
            if ((list = criteria.list()) != null || list.size() > 0) {
                for (ShopTable shopTable : list) {
                    Hibernate.initialize(shopTable.getTypes());
                }
                List list3 = list;
                return list3;
            }
            List<ShopTable> list4 = null;
            return list4;
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception.getMessage(), exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableNames(List list) {
        Session session = null;
        try {
            session = this.createNewSession();
            String string = String.format("select %s, %s from %s table where ", ShopTable.PROP_ID, ShopTable.PROP_NAME, ShopTable.class.getSimpleName());
            Query query = session.createQuery(string + "table.id IN (:tableNumbers)");
            query.setParameterList("tableNumbers", (Collection)list);
            List list2 = query.list();
            if (list2 == null || list2.isEmpty()) {
                List<String> list3 = null;
                return list3;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list2.size(); ++i) {
                Object[] objectArray = (Object[])list2.get(i);
                if (objectArray[1] != null) {
                    arrayList.add((String)objectArray[1]);
                    continue;
                }
                arrayList.add(String.valueOf(objectArray[0]));
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            PosLog.error(ShopTableDAO.class, exception.getMessage(), exception);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShopTable loadWithSeats(Integer n) {
        if (n == null) {
            return null;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            ShopTable shopTable = this.get(n, session);
            Hibernate.initialize(shopTable.getSeats());
            Set<ShopSeat> set = shopTable.getSeats();
            for (ShopSeat shopSeat : set) {
                shopSeat.setShopTable(shopTable);
            }
            ShopTable shopTable2 = shopTable;
            return shopTable2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeSeats(ShopTable shopTable) {
        if (shopTable == null || shopTable.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(shopTable.getSeats())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopTable);
            Hibernate.initialize(shopTable.getSeats());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTablesSeats(List<ShopTable> list) {
        Session session = null;
        try {
            session = this.createNewSession();
            for (ShopTable shopTable : list) {
                session.refresh((Object)shopTable);
                Hibernate.initialize(shopTable.getSeats());
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    public void detachFloor(List<ShopTable> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTable shopTable : list) {
                shopTable.setFloorId(null);
                this.saveOrUpdate(shopTable, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findAllWithTypes() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            List list = criteria.list();
            for (ShopTable shopTable : list) {
                Hibernate.initialize(shopTable.getTypes());
            }
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void initializeTypes(ShopTable shopTable) {
        if (shopTable == null || shopTable.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(shopTable.getTypes())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopTable);
            Hibernate.initialize(shopTable.getTypes());
        }
        finally {
            this.closeSession(session);
        }
    }

    public void updateTableList(List<ShopTable> list, Session session) {
        for (ShopTable shopTable : list) {
            this.update(shopTable, session);
        }
    }

    public void updateTableList(List<ShopTable> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.updateTableList(list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findByBookingInfo(String string) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_CURRENT_BOOKING_ID, (Object)string));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getTotalCapacity(Date date, Date date2, BookingInfo bookingInfo) {
        Session session = null;
        try {
            boolean bl;
            Object object322;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.setProjection((Projection)Projections.sum((String)ShopTable.PROP_CAPACITY));
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_RESERVABLE, (Object)true));
            Long l = (Long)criteria.uniqueResult();
            if (l == null) {
                l = 0L;
            }
            criteria = session.createCriteria(BookingInfo.class);
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.gt((String)BookingInfo.PROP_TO_DATE, (Object)date), (Criterion)Restrictions.lt((String)BookingInfo.PROP_FROM_DATE, (Object)date2))).add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"open"), (Criterion)Restrictions.eq((String)BookingInfo.PROP_STATUS, (Object)"seat")));
            List list = criteria.list();
            ArrayList<ShopTable> arrayList = new ArrayList<ShopTable>();
            for (Object object322 : list) {
                for (ShopTable shopTable : ((BaseBookingInfo)object322).getTables()) {
                    arrayList.add(shopTable);
                }
            }
            int n = 0;
            for (ShopTable shopTable : arrayList) {
                n += shopTable.getCapacity().intValue();
            }
            criteria.setProjection(null);
            criteria.setProjection((Projection)Projections.sum((String)BookingInfo.PROP_GUEST_COUNT));
            object322 = (Long)criteria.uniqueResult();
            if (object322 == null) {
                object322 = 0L;
            }
            boolean bl2 = false;
            List<BookingInfo> list2 = BookingInfoDAO.getInstance().getAllBookingInfoByDate(date, date2);
            for (BookingInfo bookingInfo2 : list2) {
                if (!bookingInfo.equals(bookingInfo2)) continue;
                bl = true;
                break;
            }
            int n2 = 0;
            int n3 = 0;
            if (bookingInfo.getId() != null) {
                List<ShopTable> list3 = bookingInfo.getTables();
                for (ShopTable shopTable : list3) {
                    n2 += shopTable.getCapacity().intValue();
                }
                n3 = bookingInfo.getGuestCount();
            }
            int n4 = 0;
            for (BookingInfo bookingInfo3 : list) {
                if (bookingInfo3.getTables() != null && !bookingInfo3.getTables().isEmpty()) {
                    for (ShopTable shopTable : bookingInfo3.getTables()) {
                        if (bookingInfo3.getGuestCount() > shopTable.getCapacity()) {
                            n4 += bookingInfo3.getGuestCount().intValue();
                            continue;
                        }
                        n4 += shopTable.getCapacity().intValue();
                    }
                    continue;
                }
                n4 += bookingInfo3.getGuestCount().intValue();
            }
            int n5 = 0;
            int n6 = n4 - n;
            List<ShopTable> list4 = this.findAll();
            List list5 = (List)CollectionUtils.subtract(list4, arrayList);
            for (ShopTable shopTable : list5) {
                n5 += shopTable.getCapacity().intValue();
            }
            n5 -= n6;
            if (bl) {
                n5 = n2 > n3 ? (n5 += n2) : (n5 += n3);
            }
            if (n5 < 0) {
                n5 = 0;
            }
            Long l2 = n5;
            return l2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ShopTable> findReservableTables() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.add((Criterion)Restrictions.eq((String)ShopTable.PROP_RESERVABLE, (Object)true));
            criteria.addOrder(Order.asc((String)ShopTable.PROP_ID));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAllTables() {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(ShopTable.class);
            criteria.createAlias(ShopTable.PROP_SHOP_TABLE_STATUS, "shopTableStatus");
            criteria.add((Criterion)Restrictions.eq((String)("shopTableStatus." + ShopTableStatus.PROP_TABLE_STATUS_NUM), (Object)TableStatus.Available.getValue()));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                throw new PosException("Available tables not found!");
            }
            for (Comparable comparable : list) {
                List<BookingInfo> list2 = BookingInfoDAO.getInstance().findByShopTable((ShopTable)comparable, session);
                boolean bl = false;
                if (list2 != null && !list2.isEmpty()) {
                    for (BookingInfo bookingInfo : list2) {
                        if (!bookingInfo.isClosed().booleanValue()) {
                            bl = true;
                            break;
                        }
                        bookingInfo.setTables(null);
                        BookingInfoDAO.getInstance().saveOrUpdate(bookingInfo, session);
                    }
                }
                if (bl) continue;
                ((ShopTable)comparable).setFloor(null);
                ((BaseShopTable)comparable).setTypes(null);
                ShopTableDAO.getInstance().delete((ShopTable)comparable, session);
            }
            transaction.commit();
            criteria = session.createCriteria(ShopTable.class);
            criteria.setProjection(Projections.rowCount());
            Object object = criteria.uniqueResult();
            if (object instanceof Long) {
                Comparable comparable;
                comparable = (Long)object;
                boolean bl = (Long)comparable <= 0L;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        return false;
    }

    public void saveOrUpdateShoptables(List<ShopTable> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (ShopTable shopTable : list) {
                ShopTable shopTable2 = this.get(shopTable.getId());
                ShopTableDAO.getInstance().initializeTypes(shopTable);
                if (shopTable2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(shopTable.getLastUpdateTime(), shopTable2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shopTable.getName() + " already updated");
                        continue;
                    }
                    long l = shopTable2.getVersion();
                    PropertyUtils.copyProperties((Object)shopTable2, (Object)shopTable);
                    shopTable2.setVersion(l);
                    ShopTableStatus shopTableStatus = ShopTableStatusDAO.getInstance().updateVersionOfShopTableStatus(shopTable2.getShopTableStatus());
                    shopTable2.setShopTableStatus(shopTableStatus);
                    shopTable2.setUpdateLastUpdateTime(bl);
                    shopTable2.setUpdateSyncTime(bl2);
                    this.update(shopTable2, session);
                    continue;
                }
                shopTable.setUpdateLastUpdateTime(bl);
                shopTable.setUpdateSyncTime(bl2);
                this.save(shopTable, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void transferTickets(Ticket ticket, List<Integer> list) throws Exception {
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(ticket, session);
            ticket.setTableNumbers(list);
            ShopTableDAO.getInstance().occupyTables(ticket, session);
            TicketDAO.getInstance().update(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

