/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketReportModel;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

public class OpenTicketSummaryReport
extends Report {
    @Override
    public void refresh() throws Exception {
        String string = this.getUserType() == null ? POSConstants.ALL : this.getUserType().getName();
        List<Ticket> list = TicketDAO.getInstance().findOpenTickets(this.getTerminal(), this.getUserType());
        TicketReportModel ticketReportModel = new TicketReportModel();
        ticketReportModel.setItems(list);
        ticketReportModel.calculateGrandTotal();
        ticketReportModel.calculateTotalDue();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportHeader(hashMap, this.getTerminal(), this.getStartDate(), this.getEndDate(), string);
        hashMap.put("reportTitle", Messages.getString("OpenTicketSummaryReport.0"));
        hashMap.put("grandTotal", ticketReportModel.getGrandTotalAsString());
        hashMap.put("totalDue", ticketReportModel.getTotalDueAsString());
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("open_ticket_summary_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)ticketReportModel));
        this.viewer = new JRViewer(jasperPrint);
    }

    @Override
    public boolean isDateRangeSupported() {
        return false;
    }

    @Override
    public boolean isTypeSupported() {
        return false;
    }
}

