/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesExceptionReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JButton c = new JButton(POSConstants.GO);
    private JPanel d;

    public SalesExceptionReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)this.c, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SalesExceptionReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(SalesExceptionReportView.this, POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
    }

    private void a() throws Exception {
        Date date;
        Date date2 = this.a.getDate();
        if (date2.after(date = this.b.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        date2 = DateUtil.startOfDay(date2);
        date = DateUtil.endOfDay(date);
        ReportService reportService = new ReportService();
        SalesExceptionReport salesExceptionReport = reportService.getSalesExceptionReport(date2, date);
        JasperReport jasperReport = ReportUtil.getReport("sales_summary_exception_voids");
        JasperReport jasperReport2 = ReportUtil.getReport("sales_summary_exception_refund_trns");
        JasperReport jasperReport3 = ReportUtil.getReport("sales_summary_exception_discounts");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(hashMap, true);
        ReportUtil.populateReportHeader(hashMap, null, date2, date, null);
        ReportUtil.pupulateReportFooter(hashMap);
        this.a(hashMap);
        hashMap.put("voidReport", jasperReport);
        hashMap.put("voidReportDataSource", new JRTableModelDataSource((TableModel)salesExceptionReport.getVoidTableModel()));
        hashMap.put("refundReport", jasperReport2);
        hashMap.put("refundReportDataSource", new JRTableModelDataSource((TableModel)salesExceptionReport.getRefundTableModel()));
        hashMap.put("discountReport", jasperReport3);
        hashMap.put("discountReportDataSource", new JRTableModelDataSource((TableModel)salesExceptionReport.getDiscountTableModel()));
        JasperReport jasperReport4 = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_exception_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport4, hashMap, (JRDataSource)new JREmptyDataSource());
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.d.removeAll();
        this.d.add((Component)jRViewer);
        this.d.revalidate();
    }

    private void a(HashMap hashMap) {
        hashMap.put("SERTitle", Messages.getString("SERTitle"));
        hashMap.put("VSRTitle", Messages.getString("VSRTitle"));
        hashMap.put("VSRCode", Messages.getString("VSRCode"));
        hashMap.put("VSRReason", Messages.getString("VSRReason"));
        hashMap.put("VSRWasted", Messages.getString("VSRWasted"));
        hashMap.put("VSRQTY", POSConstants.QTY);
        hashMap.put("VSRAmount", POSConstants.AMOUNT);
        hashMap.put("VSRTVW", Messages.getString("VSRTVW"));
        hashMap.put("VSRTVoids", Messages.getString("VSRTVoids"));
        hashMap.put("TSRTitle", Messages.getString("TSRTitle"));
        hashMap.put("TSRTime", POSConstants.TIME);
        hashMap.put("TSRTID", POSConstants.TICKET_ID);
        hashMap.put("TSRTRNID", Messages.getString("SessionBasedTransactionBrowser.10"));
        hashMap.put("TSRPType", Messages.getString("SettleTicketDialog.9"));
        hashMap.put("TSRAmount", POSConstants.AMOUNT);
        hashMap.put("TSRTRefund", Messages.getString("ReceiptPrintService.1"));
        hashMap.put("DSRTitle", Messages.getString("DSRTitle"));
        hashMap.put("DSRName", POSConstants.NAME);
        hashMap.put("DSRTCount", Messages.getString("DSRTCount"));
        hashMap.put("DSRTDiscount", Messages.getString("DSRTDiscount"));
        hashMap.put("DSRTNSales", Messages.getString("DSRTNSales"));
        hashMap.put("DSRPSize", Messages.getString("DSRPSize"));
        hashMap.put("DSRCSize", Messages.getString("DSRCSize"));
        hashMap.put("DSRTD", Messages.getString("DSRTD"));
    }
}

