/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.ImageIcon;

public class OrderTypeButton
extends PosButton
implements ActionListener {
    private OrderType a;

    public OrderTypeButton() {
        super("");
    }

    public OrderTypeButton(OrderType orderType) {
        this.a = orderType;
        if (orderType != null) {
            ImageIcon imageIcon = orderType.getImage();
            Color color = orderType.getButtonColor();
            Color color2 = orderType.getTextColor();
            if (imageIcon != null) {
                if (orderType.isShowImageOnly().booleanValue()) {
                    this.setIcon(POSUtil.scaleImage(imageIcon, 60));
                } else {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setText(orderType.name());
                    if (color != null) {
                        this.setBackground(color);
                    }
                    if (color2 != null) {
                        this.setForeground(color2);
                    }
                    this.setIcon(POSUtil.scaleImage(imageIcon, 60));
                }
            } else {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setText(orderType.name());
                if (color != null) {
                    this.setBackground(color);
                }
                if (color2 != null) {
                    this.setForeground(color2);
                }
            }
        }
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.a()) {
            POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
            return;
        }
        try {
            if (this.a.isRetailOrder().booleanValue()) {
                try {
                    OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null);
                    RootView.getInstance().showView("ORDER_VIEW");
                }
                catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
                    PosLog.error(this.getClass(), ticketAlreadyExistsException);
                }
            } else if (this.a.isShowTableSelection().booleanValue()) {
                TableSelectorDialog tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(this.a);
                tableSelectorDialog.setTitle(Messages.getString("OrderTypeButton.0"));
                tableSelectorDialog.setCreateNewTicket(true);
                tableSelectorDialog.getTableSelector().setTicketTransferMode(false);
                tableSelectorDialog.updateView(true);
                tableSelectorDialog.openUndecoratedFullScreen();
                if (!tableSelectorDialog.isCanceled()) {
                    return;
                }
            } else if (this.a.isRequiredCustomerData().booleanValue()) {
                CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.a);
                customerSelectorDialog.setCreateNewTicket(true);
                customerSelectorDialog.updateView(true);
                customerSelectorDialog.openUndecoratedFullScreen();
                if (!customerSelectorDialog.isCanceled()) {
                    return;
                }
            } else {
                OrderServiceFactory.getOrderService().createNewTicket(this.a, null, null);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this.getParent(), exception.getMessage(), exception);
        }
    }

    private boolean a() {
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            Set<UserPermission> set = userType.getPermissions();
            for (UserPermission userPermission : set) {
                if (!userPermission.equals(UserPermission.CREATE_TICKET)) continue;
                return true;
            }
        }
        return false;
    }
}

