/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class GratuityDialog
extends OkCancelOptionDialog
implements ActionListener {
    private JList<User> a;
    private JButton b;
    private JLabel c;
    private JLabel d;
    private JLabel e;
    private JTable f;
    private JPanel g;
    private GratuityTableModel h;
    private PosButton i;
    private JLabel j;
    private JLabel k;
    private PosButton l;
    private Map<String, TipsCashoutReportData> m;
    private User n;

    public GratuityDialog(Window window, User user) {
        super(window, "");
        this.n = user;
        this.setModal(true);
        this.setTitle(AppProperties.getAppName());
        this.a();
        UserDAO userDAO = new UserDAO();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Messages.getString("ALL"));
        arrayList.addAll(userDAO.findAll());
        this.a.setModel(new ListComboBoxModel(arrayList));
        this.f.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.f.setRowHeight(PosUIManager.getSize(35));
        this.f.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.h = new GratuityTableModel(null);
        this.f.setModel(this.h);
        for (Object e : arrayList) {
            if (!(e instanceof User) || !((User)e).getId().equals(user.getId())) continue;
            this.a.setSelectedValue(e, true);
            break;
        }
        this.b.addActionListener(this);
    }

    private void a() {
        this.setCaption(Messages.getString("GratuityDialog.2"));
        this.g = new JPanel();
        this.g.setLayout((LayoutManager)new MigLayout("fill"));
        this.a = new JList();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("GratuityDialog.5")));
        jPanel.setPreferredSize(PosUIManager.getSize(200, 0));
        jPanel.add((Component)new JScrollPane(this.a), "grow");
        this.getContentPanel().add((Component)jPanel, "West");
        this.a.setFixedCellHeight(40);
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                GratuityDialog.this.showGratuity(GratuityDialog.this.d());
            }
        });
        this.b = new JButton();
        this.i = new PosButton();
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GratuityDialog.this.b();
            }
        });
        this.i.setText(Messages.getString("GratuityDialog.7"));
        this.l = new PosButton();
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GratuityDialog.this.c();
            }
        });
        this.l.setText(Messages.getString("GratuityDialog.8"));
        this.getButtonPanel().add((Component)this.l, 0);
        this.getButtonPanel().add((Component)this.i, 0);
        this.g.add(new JLabel(POSConstants.USER_ID + ":"));
        this.c = new JLabel();
        this.g.add((Component)this.c, "wrap");
        this.g.add(new JLabel(POSConstants.USER_NAME + ":"));
        this.d = new JLabel();
        this.g.add((Component)this.d, "wrap");
        this.g.add(new JLabel(POSConstants.DETAILS));
        this.g.add((Component)new JSeparator(), "grow,span");
        JScrollPane jScrollPane = new JScrollPane();
        this.g.add((Component)jScrollPane, "grow,span");
        this.f = new JTable();
        jScrollPane.setViewportView(this.f);
        this.g.add((Component)new JSeparator(), "newline,span");
        JLabel jLabel = new JLabel(POSConstants.TOTAL_GRATUITY + ":");
        this.e = new JLabel();
        this.k = new JLabel();
        this.j = new JLabel();
        Font font = new Font(null, 1, 14);
        this.j.setFont(font);
        this.g.add((Component)jLabel, "split 2,right,span");
        this.g.add((Component)this.e, "wrap,gapright 5");
        this.g.add((Component)new JLabel(Messages.getString("GratuityDialog.16")), "split 2,right,span");
        this.g.add((Component)this.k, "wrap,gapright 5");
        this.g.add((Component)new JLabel(Messages.getString("GratuityDialog.19")), "split 2,right,span");
        this.g.add((Component)this.j, "wrap,gapright 5");
        this.getContentPanel().add(this.g);
    }

    private void b() {
        try {
            ListComboBoxModel listComboBoxModel = (ListComboBoxModel)this.a.getModel();
            TipsCashoutReportDialog tipsCashoutReportDialog = new TipsCashoutReportDialog(null, listComboBoxModel, this.d(), true);
            tipsCashoutReportDialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            tipsCashoutReportDialog.setSize(810, 600);
            tipsCashoutReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            GratuityDAO gratuityDAO = new GratuityDAO();
            TipsCashoutReport tipsCashoutReport = gratuityDAO.createReport(null, null, this.d());
            TipsCashoutReportDialog tipsCashoutReportDialog = new TipsCashoutReportDialog(tipsCashoutReport);
            tipsCashoutReportDialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            tipsCashoutReportDialog.setSize(650, 600);
            tipsCashoutReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void showGratuity(User user) {
        Object object;
        Object object2;
        GratuityDAO gratuityDAO = new GratuityDAO();
        List<Gratuity> list = gratuityDAO.findByUser(user, true);
        this.m = new HashMap<String, TipsCashoutReportData>();
        for (Gratuity gratuity : list) {
            String string = gratuity.getOwnerId();
            if (string == null) continue;
            TipsCashoutReportData tipsCashoutReportData = this.m.get(string);
            if (tipsCashoutReportData == null) {
                object2 = new TipsCashoutReportData();
                object = UserDAO.getInstance().get(string);
                if (object == null) continue;
                ((TipsCashoutReportData)object2).setOwner((User)object);
                ((TipsCashoutReportData)object2).setTicketId(gratuity.getTicketId());
                ((TipsCashoutReportData)object2).setAmount(gratuity.getTransactionTipsAmount());
                ((TipsCashoutReportData)object2).setTipsPaidAmount(gratuity.getTipsPaidAmount());
                this.m.put(string, (TipsCashoutReportData)object2);
                continue;
            }
            tipsCashoutReportData.setAmount(tipsCashoutReportData.getAmount() + gratuity.getTransactionTipsAmount());
            tipsCashoutReportData.setTipsPaidAmount(tipsCashoutReportData.getTipsPaidAmount() + gratuity.getTipsPaidAmount());
        }
        double d = 0.0;
        double d2 = 0.0;
        object2 = this.m.values().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (((TipsCashoutReportData)object).getAmount() - ((TipsCashoutReportData)object).getTipsPaidAmount() <= 0.0) {
                object2.remove();
                continue;
            }
            d += ((TipsCashoutReportData)object).getAmount().doubleValue();
            d2 += ((TipsCashoutReportData)object).getTipsPaidAmount().doubleValue();
        }
        if (user != null) {
            this.c.setText(String.valueOf(user.getId()));
            this.d.setText(user.getFirstName() + " " + user.getLastName());
        } else {
            this.c.setText(Messages.getString("ALL"));
            this.d.setText(Messages.getString("ALL"));
        }
        this.e.setText(NumberUtil.formatNumber(d));
        this.k.setText(NumberUtil.formatNumber(d2));
        this.j.setText(NumberUtil.formatNumber(d - d2));
        this.h.setRows(new ArrayList<TipsCashoutReportData>(this.m.values()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.GO.equalsIgnoreCase(string)) {
            this.showGratuity(this.d());
        }
    }

    private User d() {
        User user = this.a.getSelectedValue();
        if (user instanceof User) {
            return user;
        }
        return null;
    }

    @Override
    public void doOk() {
        try {
            List<Gratuity> list;
            User user = this.d();
            TipsCashoutReportData tipsCashoutReportData = null;
            if (user == null) {
                int n = this.f.getSelectedRow();
                if (n == -1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.25"));
                    return;
                }
                tipsCashoutReportData = (TipsCashoutReportData)this.h.getRowData(n);
                if (tipsCashoutReportData == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.25"));
                    return;
                }
                user = UserDAO.getInstance().get(tipsCashoutReportData.getOwner().getId());
            }
            if ((list = GratuityDAO.getInstance().findByUser(user, false)) == null || list.size() <= 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.27"));
                return;
            }
            if (tipsCashoutReportData == null && this.h.getRowCount() > 0) {
                tipsCashoutReportData = (TipsCashoutReportData)this.h.getRowData(0);
            }
            double d = 0.0;
            if (tipsCashoutReportData != null) {
                try {
                    d = tipsCashoutReportData.getAmount() - tipsCashoutReportData.getTipsPaidAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (d == 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.28"));
                return;
            }
            d = NumberUtil.roundToTwoDigit(d);
            Double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), d);
            if (d2 == -1.0) {
                return;
            }
            if (d2 < 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.30"));
                return;
            }
            if (d2 > d) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.31"));
                return;
            }
            double d3 = d2;
            ArrayList<Gratuity> arrayList = new ArrayList<Gratuity>();
            ArrayList<GratuityPaymentHistory> arrayList2 = new ArrayList<GratuityPaymentHistory>();
            for (Gratuity gratuity : list) {
                if (gratuity.isPaid().booleanValue()) continue;
                arrayList.add(gratuity);
                double d4 = gratuity.getAmount();
                double d5 = gratuity.getTipsPaidAmount();
                gratuity.calculateTransactionTips();
                double d6 = gratuity.getTransactionTipsAmount();
                double d7 = NumberUtil.roundToTwoDigit(d6 - d5);
                GratuityPaymentHistory gratuityPaymentHistory = new GratuityPaymentHistory();
                gratuityPaymentHistory.setAmount(d7);
                gratuityPaymentHistory.setTenderedAmount(d3);
                gratuityPaymentHistory.setCashDrawer(user.getActiveDrawerPullReport());
                gratuityPaymentHistory.setTransactionTime(new Date());
                gratuityPaymentHistory.setGratuity(gratuity);
                gratuityPaymentHistory.setPaidBy(this.n);
                gratuityPaymentHistory.setStoreSessionId(DataProvider.get().getStoreSession().getId());
                arrayList2.add(gratuityPaymentHistory);
                if (d2 == d7) {
                    gratuity.setTipsPaidAmount(d5 + d7);
                    if (d4 != d6) break;
                    gratuity.setPaid(true);
                    break;
                }
                if (d2 > d7) {
                    gratuity.setTipsPaidAmount(d5 + d7);
                    if (d4 == d6) {
                        gratuity.setPaid(true);
                    }
                    d2 = d2 - d7;
                    continue;
                }
                gratuityPaymentHistory.setAmount(d2);
                gratuity.setTipsPaidAmount(d5 + d2);
                gratuity.setPaid(false);
                break;
            }
            new GratuityDAO().payGratuities(arrayList, arrayList2);
            String string = POSConstants.PAY_TIPS;
            ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.PAY_TIPS, string);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.32"));
            this.showGratuity(this.d());
        }
        catch (PosException posException) {
            BOMessageDialog.showError(this.g, posException.getMessage(), posException);
        }
    }

    private class GratuityTableModel
    extends ListTableModel {
        public GratuityTableModel(List<TipsCashoutReportData> list) {
            super(new String[]{Messages.getString("GratuityDialog.22"), POSConstants.FIRST_NAME, POSConstants.LAST_NAME, POSConstants.AMOUNT, Messages.getString("GratuityDialog.23")}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TipsCashoutReportData tipsCashoutReportData = (TipsCashoutReportData)this.rows.get(n);
            User user = tipsCashoutReportData.getOwner();
            switch (n2) {
                case 0: {
                    return user == null ? null : user.getId();
                }
                case 1: {
                    return user == null ? null : user.getFirstName();
                }
                case 2: {
                    return user == null ? null : user.getLastName();
                }
                case 3: {
                    return NumberUtil.roundToTwoDigit(tipsCashoutReportData.getAmount());
                }
                case 4: {
                    return NumberUtil.roundToTwoDigit(tipsCashoutReportData.getAmount() - tipsCashoutReportData.getTipsPaidAmount());
                }
            }
            return null;
        }
    }
}

