/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.swing.POSFileChooser;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.io.FileUtils;

public class ImageUploaderDialog
extends POSDialog {
    public static String LAST_USED_FOLDER = "";
    public ImageResource.IMAGE_CATEGORY imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
    public JLabel lblImagePreview;
    public JLabel lblDescription;
    public File imageFile;
    public File[] imageFiles;
    public ImageResource imgResource;
    public POSTextField tfDescription;
    public POSToggleButton tbtnUnlisted;
    public POSToggleButton tbtnFloorPlan;
    public POSToggleButton tbtnProducts;
    public POSToggleButton tbtnPeople;
    private JPanel b;
    private ArrayList<File> c;
    private boolean d;
    private JProgressBar e;
    private JLabel f;
    private PosButton g;
    private POSFileChooser h = null;
    boolean a = false;

    public ImageUploaderDialog(ImageResource imageResource, ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imageType = iMAGE_CATEGORY;
        this.imgResource = imageResource;
        this.a();
        this.d();
    }

    public ImageUploaderDialog(ImageResource imageResource) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imgResource = imageResource;
        this.a();
        this.d();
    }

    public ImageUploaderDialog(ImageResource.IMAGE_CATEGORY iMAGE_CATEGORY) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.imageType = iMAGE_CATEGORY;
        this.a();
        this.d();
        this.d = true;
    }

    public ImageUploaderDialog() {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.a();
        this.d();
        this.d = true;
    }

    private void a() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ImageUploaderDialog.1"));
        this.add((Component)titlePanel, "North");
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.tbtnUnlisted = new POSToggleButton(Messages.getString("ImageUploaderDialog.2"));
        this.tbtnFloorPlan = new POSToggleButton(Messages.getString("ImageUploaderDialog.3"));
        this.tbtnProducts = new POSToggleButton(Messages.getString("ImageUploaderDialog.4"));
        this.tbtnPeople = new POSToggleButton(Messages.getString("ImageUploaderDialog.5"));
        buttonGroup.add(this.tbtnUnlisted);
        buttonGroup.add(this.tbtnFloorPlan);
        buttonGroup.add(this.tbtnProducts);
        buttonGroup.add(this.tbtnPeople);
        jPanel.add(this.tbtnUnlisted);
        jPanel.add(this.tbtnFloorPlan);
        jPanel.add(this.tbtnProducts);
        jPanel.add(this.tbtnPeople);
        this.tbtnProducts.setEnabled(true);
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.setBorder(new EmptyBorder(20, 5, 20, 5));
        jPanel2.add((Component)jPanel, "North");
        this.lblImagePreview = new JLabel();
        this.lblDescription = new JLabel(Messages.getString("ImageUploaderDialog.6"));
        this.tfDescription = new POSTextField(50);
        this.b = new JPanel(new FlowLayout());
        this.b.add((Component)this.lblImagePreview, "center");
        JScrollPane jScrollPane = new JScrollPane(this.b, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(350, 220));
        jScrollPane.setVisible(true);
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        jPanel3.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)this.lblDescription, "West");
        jPanel3.add((Component)this.tfDescription, "Center");
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[grow][grow][grow]", ""));
        this.e = new JProgressBar();
        this.e.setBounds(40, 40, 160, 30);
        this.e.setValue(0);
        this.e.setMinimum(0);
        this.e.setStringPainted(true);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.g = new PosButton(Messages.getString("ImageUploaderDialog.11"));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!ImageUploaderDialog.this.d) {
                        ImageUploaderDialog.this.selectImage();
                    } else {
                        ImageUploaderDialog.this.selectBulkImage();
                    }
                }
                catch (PosException posException) {
                    JOptionPane.showMessageDialog(null, posException.getMessage(), Messages.getString("MessageDialog.0"), 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, Messages.getString("ImageUploaderDialog.13"), Messages.getString("MessageDialog.0"), 0);
                }
            }
        });
        PosButton posButton = new PosButton(Messages.getString("ImageUploaderDialog.15"));
        posButton.setPreferredSize(PosUIManager.getSize(100, 0));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.doOk();
                ImageUploaderDialog.this.setCanceled(false);
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("ImageUploaderDialog.16"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageUploaderDialog.this.setCanceled(true);
                ImageUploaderDialog.this.dispose();
            }
        });
        this.f = new JLabel(Messages.getString("ImageUploaderDialog.17"));
        this.f.setVisible(false);
        jPanel4.add((Component)this.g, "");
        jPanel4.add((Component)this.f, "left,split 2");
        jPanel4.add((Component)this.e, "");
        jPanel4.add((Component)posButton, "growy,right,skip 2, split 2");
        jPanel4.add((Component)posButton2, "");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void doOk() {
        if (!this.d) {
            this.b();
            ImageResourceDAO.getInstance().saveOrUpdate(this.imgResource);
        } else {
            this.doSaveMultipleImage();
        }
        this.dispose();
    }

    private void b() {
        try {
            if (this.imgResource == null) {
                this.imgResource = new ImageResource();
            }
            this.imgResource.setDescription(this.tfDescription.getText());
            File file = (File)this.lblImagePreview.getClientProperty("image");
            if (file != null) {
                this.imgResource.setImageBytes(FileUtils.readFileToByteArray((File)file));
            }
            if (this.tbtnUnlisted.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
            } else if (this.tbtnFloorPlan.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
            } else if (this.tbtnPeople.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
            } else if (this.tbtnProducts.isSelected()) {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            } else {
                this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
            }
        }
        catch (Exception exception) {
            PosLog.error(ImageUploaderDialog.class, exception.getMessage(), exception);
        }
    }

    public void doSaveMultipleImage() {
        try {
            ArrayList<ImageResource> arrayList = new ArrayList<ImageResource>();
            for (File file : this.c) {
                this.imgResource = new ImageResource();
                if (file != null) {
                    this.imgResource.setImageBytes(FileUtils.readFileToByteArray((File)file));
                }
                if (this.tbtnUnlisted.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.UNLISTED.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.UNLISTED;
                } else if (this.tbtnFloorPlan.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.FLOORPLAN.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.FLOORPLAN;
                } else if (this.tbtnPeople.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PEOPLE.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.PEOPLE;
                } else if (this.tbtnProducts.isSelected()) {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                } else {
                    this.imgResource.setImageCategoryNum(ImageResource.IMAGE_CATEGORY.PRODUCTS.getType());
                    this.imageType = ImageResource.IMAGE_CATEGORY.PRODUCTS;
                }
                arrayList.add(this.imgResource);
            }
            ImageResourceDAO.getInstance().saveOrUpdate(arrayList);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void selectBulkImage() throws Exception {
        block7: {
            Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
            this.h = LAST_USED_FOLDER != null ? new POSFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
            this.h.setMultiSelectionEnabled(true);
            this.h.setFileSelectionMode(2);
            this.h.setAcceptAllFileFilterUsed(false);
            int n = this.h.showOpenDialog(this);
            this.c = new ArrayList();
            if (n == 0) {
                File[] fileArray;
                for (File file : fileArray = this.h.getSelectedFiles()) {
                    if (file.isDirectory()) {
                        File[] fileArray2 = file.listFiles();
                        for (int i = 0; i < fileArray2.length; ++i) {
                            if (fileArray2[i].isDirectory()) {
                                this.a(fileArray2[i]);
                                continue;
                            }
                            this.a(fileArray2[i]);
                        }
                        continue;
                    }
                    this.a(file);
                }
                break block7;
            }
            return;
        }
    }

    public void showImages() {
        if (!this.d) {
            this.e.setVisible(false);
            return;
        }
        this.g.setVisible(false);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ImageUploaderDialog.this.a) {
                        return;
                    }
                    int n = 1;
                    ImageUploaderDialog.this.e.setMaximum(ImageUploaderDialog.this.c.size());
                    ImageUploaderDialog.this.f.setVisible(true);
                    for (File file : ImageUploaderDialog.this.c) {
                        JLabel jLabel = new JLabel();
                        BufferedImage bufferedImage = ImageIO.read(file);
                        jLabel.putClientProperty("image", file);
                        ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(500, 500, 1));
                        jLabel.setIcon(imageIcon);
                        ImageUploaderDialog.this.b.add(jLabel);
                        ImageUploaderDialog.this.b.revalidate();
                        ImageUploaderDialog.this.b.repaint();
                        Thread.sleep(500L);
                        ImageUploaderDialog.this.e.setValue(n);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception);
                }
            }
        });
    }

    private void a(File file) {
        String string = this.a(file.toString());
        if (this.c().contains(string.trim().toLowerCase())) {
            this.c.add(file);
        }
    }

    private String a(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        int n2 = string2.indexOf(46, n = string2.lastIndexOf(92) + 1);
        return n2 == -1 ? "" : string2.substring(n2 + 1);
    }

    private List<String> c() {
        return Arrays.asList("jpg", "jpeg", "png", "gif");
    }

    public void selectImage() throws Exception {
        block7: {
            Preferences preferences = Preferences.userRoot().node(this.getClass().getName());
            this.h = LAST_USED_FOLDER != null ? new POSFileChooser(preferences.get(LAST_USED_FOLDER, new File(".").getAbsolutePath())) : new POSFileChooser();
            this.h.setMultiSelectionEnabled(false);
            this.h.setFileSelectionMode(0);
            int n = this.h.showOpenDialog(this);
            if (n != 0) break block7;
            this.imageFile = this.h.getSelectedFile();
            preferences.put(LAST_USED_FOLDER, this.imageFile.getPath());
            byte[] byArray = FileUtils.readFileToByteArray((File)this.imageFile);
            int n2 = byArray.length / 1024;
            BufferedImage bufferedImage = ImageIO.read(this.imageFile);
            if (n2 > 500) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ImageUploaderDialog.29"), Messages.getString("CONFIRM")) != 0) {
                    byArray = null;
                    throw new PosException(Messages.getString("ImageUploaderDialog.31"));
                }
                bufferedImage = this.a(bufferedImage);
                this.imageFile = new File("saved.png");
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", this.imageFile);
                }
                catch (IOException iOException) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), iOException.getMessage());
                }
                byArray = FileUtils.readFileToByteArray((File)this.imageFile);
                n2 = byArray.length / 1024;
                if (n2 > 500) {
                    throw new PosException(Messages.getString("ImageUploaderDialog.0"));
                }
            }
            this.lblImagePreview.setIcon(new ImageIcon(bufferedImage));
            this.lblImagePreview.putClientProperty("image", this.imageFile);
            this.lblImagePreview.setText("");
        }
    }

    private BufferedImage a(Image image) {
        int n;
        int n2;
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        if (n4 > n3) {
            n2 = 500;
            n = n3 * n2 / n4;
        } else {
            n = 500;
            n2 = n4 * n / n3;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image, 0, 0, n2, n, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void d() {
        if (this.imgResource != null && this.imgResource.getImageCategory() != null) {
            this.imageType = this.imgResource.getImageCategory();
        }
        if (this.imageType == ImageResource.IMAGE_CATEGORY.UNLISTED) {
            this.tbtnUnlisted.setSelected(true);
        } else if (this.imageType == ImageResource.IMAGE_CATEGORY.FLOORPLAN) {
            this.tbtnFloorPlan.setSelected(true);
        } else if (this.imageType == ImageResource.IMAGE_CATEGORY.PRODUCTS) {
            this.tbtnProducts.setSelected(true);
        } else if (this.imageType == ImageResource.IMAGE_CATEGORY.PEOPLE) {
            this.tbtnPeople.setSelected(true);
        } else {
            this.tbtnProducts.setSelected(true);
        }
        if (this.imgResource == null) {
            return;
        }
        ImageIcon imageIcon = this.imgResource.getImageIcon();
        if (imageIcon == null) {
            return;
        }
        this.lblImagePreview.setText("");
        this.lblImagePreview.setIcon(imageIcon);
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        File file = new File("saved.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), iOException.getMessage());
        }
        this.lblImagePreview.putClientProperty("image", file);
        if (this.imgResource.getDescription() != null) {
            this.tfDescription.setText(this.imgResource.getDescription());
        }
    }

    public File getSelectedImageFile() {
        return this.imageFile;
    }

    public List<File> getSelectedImageFiles() {
        return this.c;
    }

    @Override
    public void open() {
        this.showImages();
        super.open();
    }

    public void setDescriptionVisible(boolean bl) {
        this.lblDescription.setVisible(bl);
        this.tfDescription.setVisible(bl);
    }
}

