/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.POSFileChooser;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderTypeForm
extends BeanEditor
implements ItemListener {
    private FixedLengthTextField c;
    private JCheckBox d;
    private JCheckBox e;
    private JCheckBox f;
    private JCheckBox g;
    private JCheckBox h;
    private JCheckBox i;
    private JCheckBox j;
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JCheckBox n;
    private JCheckBox o;
    private JCheckBox p;
    private JCheckBox q;
    private JCheckBox r;
    private IntegerTextField s;
    private JLabel t;
    private JButton u = new JButton(Messages.getString("OrderTypeForm.15"));
    private JButton v = new JButton(Messages.getString("OrderTypeForm.16"));
    private JCheckBox w;
    private Log x = LogFactory.getLog(OrderTypeForm.class);
    JList<String> a;
    DefaultListModel<String> b;
    private JCheckBox y;
    private JCheckBox z;
    private CheckBoxList<Department> A = new CheckBoxList();
    private CheckBoxList<TerminalType> B = new CheckBoxList();
    private CheckBoxList<MenuCategory> C = new CheckBoxList();
    private ArrayList<Department> D;
    private List<Department> E;
    private JTabbedPane F;
    private JComboBox G;
    private JComboBox H;
    private JLabel I;
    private JLabel J;
    private JComboBox K;
    private List<TerminalType> L;
    private List<MenuCategory> M;
    private ArrayList<TerminalType> N;
    private ArrayList<MenuCategory> O;
    private ButtonGroup P;
    private JRadioButton Q;
    private JRadioButton R;
    private JRadioButton S;
    private JRadioButton T;
    private JRadioButton U;
    private JCheckBox V;

    public OrderTypeForm() throws Exception {
        this(new OrderType());
        this.a();
    }

    public OrderTypeForm(OrderType orderType) throws Exception {
        this.b();
        this.setBean(orderType);
        this.a();
    }

    @Override
    public String getDisplayText() {
        OrderType orderType = (OrderType)this.getBean();
        if (orderType.getId() == null) {
            return POSConstants.ORDER_TYPE;
        }
        return POSConstants.ORDER_TYPE;
    }

    private void a() {
        this.R.addItemListener(this);
        this.S.addItemListener(this);
    }

    private void b() {
        this.setLayout(new BorderLayout());
        this.F = new JTabbedPane();
        this.F.setPreferredSize(new Dimension(750, 470));
        this.c();
        this.d();
        this.e();
        this.add(this.F);
    }

    private void c() {
        TransparentPanel transparentPanel = new TransparentPanel();
        JLabel jLabel = new JLabel(POSConstants.NAME + ":");
        this.c = new FixedLengthTextField();
        this.c.setLength(120);
        JLabel jLabel2 = new JLabel(Messages.getString("OrderTypeForm.19"));
        this.s = new IntegerTextField();
        JLabel jLabel3 = new JLabel(Messages.getString("OrderTypeForm.20"));
        this.K = new JComboBox();
        this.R = new JRadioButton(Messages.getString("OrderTypeForm.21"));
        this.T = new JRadioButton(Messages.getString("OrderTypeForm.24"));
        this.S = new JRadioButton(Messages.getString("OrderTypeForm.25"));
        this.Q = new JRadioButton(Messages.getString("OrderTypeForm.28"));
        this.Q.addItemListener(this);
        this.U = new JRadioButton(Messages.getString("OrderTypeForm.29"));
        this.U.setSelected(true);
        this.P = new ButtonGroup();
        this.P.add(this.R);
        this.P.add(this.T);
        this.P.add(this.S);
        this.P.add(this.Q);
        this.P.add(this.U);
        this.d = new JCheckBox(POSConstants.ENABLED);
        this.e = new JCheckBox(Messages.getString("OrderTypeForm.1"));
        this.f = new JCheckBox(Messages.getString("OrderTypeForm.2"));
        this.g = new JCheckBox(Messages.getString("OrderTypeForm.3"));
        this.h = new JCheckBox(Messages.getString("OrderTypeForm.4"));
        this.i = new JCheckBox(Messages.getString("OrderTypeForm.5"));
        this.j = new JCheckBox(Messages.getString("OrderTypeForm.6"));
        this.k = new JCheckBox(Messages.getString("OrderTypeForm.10"));
        this.l = new JCheckBox(Messages.getString("OrderTypeForm.11"));
        this.m = new JCheckBox(Messages.getString("ENABLE_SEAT"));
        this.n = new JCheckBox(Messages.getString("OrderTypeForm.12"));
        this.V = new JCheckBox(Messages.getString("OrderTypeForm.34"));
        this.o = new JCheckBox(Messages.getString("OrderTypeForm.13"));
        this.p = new JCheckBox(Messages.getString("OrderTypeForm.0"));
        this.q = new JCheckBox(Messages.getString("OrderTypeForm.17"));
        this.r = new JCheckBox(Messages.getString("OrderTypeForm.18"));
        this.y = new JCheckBox(Messages.getString("ENABLE_REORDER"));
        this.z = new JCheckBox(Messages.getString("ENABLE_COURSE"));
        this.e.addItemListener(this);
        this.I = new JLabel(Messages.getString("OrderTypeForm.36"));
        this.J = new JLabel(Messages.getString("OrderTypeForm.37"));
        this.G = new JComboBox();
        this.H = new JComboBox();
        transparentPanel.setLayout((LayoutManager)new MigLayout("hidemode 3", "[][grow][grow]", ""));
        transparentPanel.add((Component)jLabel, "align trailing,gaptop 9");
        transparentPanel.add((Component)this.c, "growx,wrap");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0"));
        TitledBorder titledBorder = new TitledBorder(Messages.getString("OrderTypeForm.39"));
        JScrollPane jScrollPane = new JScrollPane(this.A);
        jScrollPane.setBorder(titledBorder);
        jPanel.add((Component)jScrollPane, "w 200!,h 150!, wrap,growx,gapright 30");
        transparentPanel.add((Component)jLabel2, "trailing");
        transparentPanel.add((Component)this.s, "growx, wrap");
        transparentPanel.add((Component)jLabel3, "trailing");
        transparentPanel.add((Component)this.K, "growx, wrap");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0"));
        jPanel2.add(this.R);
        jPanel2.add(this.T);
        jPanel2.add(this.S);
        jPanel2.add(this.Q);
        jPanel2.add(this.U);
        transparentPanel.add((Component)jPanel2, "skip 1, growx,wrap");
        transparentPanel.add((Component)this.d, "skip 1, wrap");
        transparentPanel.add((Component)this.e, "skip 1, wrap");
        transparentPanel.add((Component)this.f, "skip 1, wrap");
        transparentPanel.add((Component)this.g, "skip 1,wrap");
        TitledBorder titledBorder2 = new TitledBorder(Messages.getString("OrderTypeForm.44"));
        JScrollPane jScrollPane2 = new JScrollPane(this.B);
        jScrollPane2.setBorder(titledBorder2);
        jPanel.add((Component)jScrollPane2, "w 200!,h 150!, wrap,growx,gapright 30");
        transparentPanel.add((Component)this.i, "skip 1, wrap");
        transparentPanel.add((Component)this.h, "skip 1, wrap");
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        transparentPanel.add((Component)this.j, "skip 1, wrap");
        if (orderServiceExtension != null) {
            transparentPanel.add((Component)this.q, "skip 1, wrap");
            transparentPanel.add((Component)this.r, "skip 1, wrap");
        }
        transparentPanel.add((Component)this.k, "skip 1,wrap");
        transparentPanel.add((Component)this.l, "skip 1, wrap");
        transparentPanel.add((Component)this.z, "skip 1, wrap");
        transparentPanel.add((Component)this.m, "skip 1,wrap");
        TitledBorder titledBorder3 = new TitledBorder(Messages.getString("OrderTypeForm.46"));
        JScrollPane jScrollPane3 = new JScrollPane(this.C);
        jScrollPane3.setBorder(titledBorder3);
        jPanel.add((Component)jScrollPane3, "w 200!,h 150!,growx,gapright 30");
        transparentPanel.add((Component)jPanel, "east");
        transparentPanel.add((Component)this.n, "skip 1,wrap");
        transparentPanel.add((Component)this.o, "skip 1, wrap");
        transparentPanel.add((Component)this.I, "gapleft 20, skip 1, split 2");
        transparentPanel.add((Component)this.G, "gapleft 20, wrap");
        transparentPanel.add((Component)this.J, "gapleft 20, skip 1, split 2");
        transparentPanel.add((Component)this.H, "gapleft 35, skip 1, wrap");
        transparentPanel.add((Component)this.p, "skip 1, wrap");
        transparentPanel.add((Component)this.y, "skip 1, wrap");
        transparentPanel.add((Component)this.V, "skip 1, wrap");
        this.o.addItemListener(this);
        this.I.setVisible(false);
        this.J.setVisible(false);
        this.G.setVisible(false);
        this.H.setVisible(false);
        transparentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane4 = new JScrollPane(transparentPanel);
        jScrollPane4.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane4.setBorder(null);
        this.F.add(Messages.getString("OrderTypeForm.32"), jScrollPane4);
    }

    private void d() {
        this.E = DepartmentDAO.getInstance().findAll();
        if (this.E == null) {
            this.E = new ArrayList<Department>();
        }
        this.A.setModel(this.E);
        this.L = TerminalTypeDAO.getInstance().findAll();
        if (this.L == null) {
            this.L = new ArrayList<TerminalType>();
        }
        this.B.setModel(this.L);
        this.M = MenuCategoryDAO.getInstance().findAll();
        if (this.M == null) {
            this.M = new ArrayList<MenuCategory>();
        }
        this.C.setModel(this.M);
        ArrayList<TaxGroup> arrayList = new ArrayList<TaxGroup>();
        arrayList.add(null);
        arrayList.addAll(TaxGroupDAO.getInstance().findAll());
        this.K.setModel(new ComboBoxModel(arrayList));
        this.G.setModel(new ComboBoxModel(arrayList));
        this.H.setModel(new ComboBoxModel(arrayList));
    }

    private void e() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 10", "[][]100[][][][]", "[][][center][][][]"));
        JLabel jLabel = new JLabel(Messages.getString("MenuItemForm.28"));
        jLabel.setHorizontalAlignment(11);
        jPanel.add((Component)jLabel, "cell 0 0,right");
        this.t = new JLabel("");
        this.t.setHorizontalAlignment(0);
        this.t.setBorder(new EtchedBorder(1, null, null));
        this.t.setPreferredSize(new Dimension(200, 200));
        jPanel.add((Component)this.t, "cell 1 0");
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderTypeForm.this.doSelectImageFile();
            }
        });
        JButton jButton2 = new JButton(Messages.getString("MenuItemForm.34"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderTypeForm.this.doClearImage();
            }
        });
        jPanel.add((Component)jButton, "cell 1 0");
        jPanel.add((Component)jButton2, "cell  1 0");
        JLabel jLabel2 = new JLabel(Messages.getString("OrderTypeForm.22"));
        this.v.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("OrderTypeForm.23"), Color.WHITE);
                if (color != null) {
                    OrderTypeForm.this.v.setBackground(color);
                    OrderTypeForm.this.u.setBackground(color);
                }
            }
        });
        this.v.setPreferredSize(new Dimension(228, 40));
        jPanel.add((Component)jLabel2, "cell 0 2");
        jPanel.add((Component)this.v, "cell 1 2 ,grow");
        JLabel jLabel3 = new JLabel(Messages.getString("OrderTypeForm.26"));
        this.u.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("OrderTypeForm.27"), Color.WHITE);
                if (color != null) {
                    OrderTypeForm.this.u.setForeground(color);
                }
            }
        });
        this.u.setPreferredSize(new Dimension(228, 40));
        jPanel.add((Component)jLabel3, "cell 0 3");
        jPanel.add((Component)this.u, "cell 1 3 ,grow");
        this.w = new JCheckBox(Messages.getString("OrderTypeForm.30"));
        jPanel.add((Component)this.w, "cell 1 4");
        this.F.add(Messages.getString("OrderTypeForm.33"), jPanel);
    }

    protected void doClearImage() {
        this.t.setIcon(null);
        this.t.putClientProperty("image", null);
    }

    @Override
    protected void updateView() {
        OrderType orderType = (OrderType)this.getBean();
        if (orderType == null) {
            this.c.setText("");
            this.d.setSelected(false);
            return;
        }
        this.c.setText(orderType.getName());
        this.s.setText(String.valueOf(orderType.getSortOrder()));
        if (orderType.getId() == null) {
            this.d.setSelected(true);
        } else {
            Color color;
            OrderTypeDAO.getInstance().initialize(orderType);
            this.d.setSelected(orderType.isEnabled());
            this.e.setSelected(orderType.isShowTableSelection());
            this.f.setSelected(orderType.isShowGuestSelection());
            this.g.setSelected(orderType.isShouldPrintToKitchen());
            this.i.setSelected(orderType.isPrepaid());
            this.h.setSelected(orderType.isCloseOnPaid());
            this.j.setSelected(orderType.isRequiredCustomerData());
            this.k.setSelected(orderType.isShowInLoginScreen());
            this.l.setSelected(orderType.isConsolidateItemsInReceipt());
            this.m.setSelected(orderType.isAllowSeatBasedOrder());
            this.n.setSelected(orderType.isHideItemWithEmptyInventory());
            this.o.setSelected(orderType.isHasForHereAndToGo());
            this.p.setSelected(orderType.isPreAuthCreditCard());
            this.y.setSelected(orderType.isEnableReorder());
            this.z.setSelected(orderType.isEnableCourse());
            Color color2 = orderType.getTextColor();
            if (color2 != null) {
                this.u.setForeground(color2);
            }
            if ((color = orderType.getButtonColor()) != null) {
                this.v.setBackground(color);
                this.u.setBackground(color);
            }
            this.w.setSelected(orderType.isShowImageOnly());
            this.R.setSelected(orderType.isDelivery());
            this.S.setSelected(orderType.isPickup());
            this.T.setSelected(orderType.isRetailOrder());
            this.Q.setSelected(orderType.isBarTab());
            this.q.setSelected(orderType.isRequiredDeliveryData());
            this.r.setSelected(orderType.isAssignDriver());
            this.V.setSelected(orderType.isServiceChargeApplicable());
            ImageIcon imageIcon = POSUtil.convertToBigButtonImage(orderType.getImage());
            if (imageIcon != null) {
                this.t.setIcon(imageIcon);
                this.t.putClientProperty("image", this.a(imageIcon));
            }
            this.D = new ArrayList<Department>(orderType.getDepartments());
            this.A.selectItems(this.D);
            this.N = new ArrayList<TerminalType>(orderType.getTerminalTypes());
            this.B.selectItems(this.N);
            this.O = new ArrayList<MenuCategory>(orderType.getCategories());
            this.C.selectItems(this.O);
            this.K.setSelectedItem(orderType.getDefaultTaxGroup());
            this.G.setSelectedItem(orderType.getForHereTaxGroup());
            this.H.setSelectedItem(orderType.getToGoTaxGroup());
        }
    }

    private File a(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        File file = new File("saved.png");
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            PosLog.error(this.getClass(), iOException);
        }
        return file;
    }

    @Override
    protected boolean updateModel() {
        try {
            OrderType orderType = (OrderType)this.getBean();
            if (orderType == null) {
                return false;
            }
            String string = this.c.getText();
            GenericDAO.getInstance().checkIdOrNameExists(orderType.getId(), string, OrderType.class);
            orderType.setName(string);
            orderType.setEnabled(this.d.isSelected());
            orderType.setShowTableSelection(this.e.isSelected());
            orderType.setShowGuestSelection(this.f.isSelected());
            orderType.setShouldPrintToKitchen(this.g.isSelected());
            orderType.setPrepaid(this.i.isSelected());
            orderType.setCloseOnPaid(this.h.isSelected());
            orderType.setDelivery(this.R.isSelected());
            orderType.setPickup(this.S.isSelected());
            orderType.setRetailOrder(this.T.isSelected());
            orderType.setBarTab(this.Q.isSelected());
            orderType.setRequiredCustomerData(this.j.isSelected());
            orderType.setRequiredDeliveryData(this.q.isSelected());
            orderType.setAssignDriver(this.r.isSelected());
            orderType.setShowInLoginScreen(this.k.isSelected());
            orderType.setConsolidateItemsInReceipt(this.l.isSelected());
            orderType.setAllowSeatBasedOrder(this.m.isSelected());
            orderType.setHideItemWithEmptyInventory(this.n.isSelected());
            orderType.setHasForHereAndToGo(this.o.isSelected());
            orderType.setPreAuthCreditCard(this.p.isSelected());
            orderType.setSortOrder(this.s.getInteger());
            orderType.setTextColorCode(this.u.getForeground().getRGB());
            orderType.setButtonColorCode(this.v.getBackground().getRGB());
            orderType.setShowImageOnly(this.w.isSelected());
            orderType.setEnableReorder(this.y.isSelected());
            orderType.setEnableCourse(this.z.isSelected());
            orderType.setServiceChargeApplicable(this.V.isSelected());
            File file = (File)this.t.getClientProperty("image");
            if (file != null) {
                orderType.setImageData(POSUtil.convertImageToBlob(file, 400));
            } else {
                orderType.setImageData(null);
            }
            orderType.setDefaultTaxGroup((TaxGroup)this.K.getSelectedItem());
            if (this.o.isSelected()) {
                orderType.setForHereTaxGroup((TaxGroup)this.G.getSelectedItem());
                orderType.setToGoTaxGroup((TaxGroup)this.H.getSelectedItem());
            } else {
                orderType.setForHereTaxGroup(null);
                orderType.setToGoTaxGroup(null);
            }
        }
        catch (PosException posException) {
            throw posException;
        }
        catch (Exception exception) {
            throw new PosException(exception);
        }
        return true;
    }

    @Override
    public boolean save() {
        OrderType orderType = null;
        try {
            if (!this.updateModel()) {
                return false;
            }
            orderType = (OrderType)this.getBean();
            orderType.setDepartments(POSUtil.copySelectedValues(orderType.getDepartments(), this.A.getCheckedValuesAsSet()));
            orderType.setTerminalTypes(POSUtil.copySelectedValues(orderType.getTerminalTypes(), this.B.getCheckedValuesAsSet()));
            orderType.setCategories(POSUtil.copySelectedValues(orderType.getCategories(), this.C.getCheckedValuesAsSet()));
            OrderTypeDAO.getInstance().saveOrUpdate(orderType);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalConfigurationView.40"));
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
            if (orderType != null) {
                orderType.setId(null);
            }
            return false;
        }
        catch (Exception exception) {
            MessageDialog.showError(exception);
            return false;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        JToggleButton jToggleButton = (JToggleButton)itemEvent.getSource();
        if (jToggleButton == this.R) {
            if (this.R.isSelected()) {
                this.j.setSelected(true);
                this.q.setSelected(true);
                this.r.setSelected(true);
            }
        } else if (jToggleButton == this.S) {
            if (this.S.isSelected()) {
                this.j.setSelected(true);
            }
        } else if (jToggleButton == this.o) {
            if (this.o.isSelected()) {
                this.I.setVisible(true);
                this.J.setVisible(true);
                this.G.setVisible(true);
                this.H.setVisible(true);
            } else {
                this.I.setVisible(false);
                this.J.setVisible(false);
                this.G.setVisible(false);
                this.H.setVisible(false);
            }
        } else if (jToggleButton == this.Q) {
            if (this.Q.isSelected() && !this.e.isSelected()) {
                this.e.setSelected(this.Q.isSelected());
            }
        } else if (jToggleButton == this.e && this.Q.isSelected() && !this.e.isSelected()) {
            this.P.clearSelection();
        }
    }

    protected void doSelectImageFile() {
        POSFileChooser pOSFileChooser = new POSFileChooser();
        pOSFileChooser.setMultiSelectionEnabled(false);
        pOSFileChooser.setAcceptAllFileFilterUsed(false);
        pOSFileChooser.setFileSelectionMode(0);
        int n = pOSFileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (n == 0) {
            File file = pOSFileChooser.getSelectedFile();
            long l = file.length();
            if (l >= 0xA00000L) {
                POSMessageDialog.showError(Messages.getString("OrderTypeForm.40"));
                this.doSelectImageFile();
            }
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                ImageIcon imageIcon = POSUtil.convertToBigButtonImage(new ImageIcon(bufferedImage));
                this.t.putClientProperty("image", file);
                this.t.setIcon(imageIcon);
            }
            catch (Exception exception) {
                this.x.error((Object)exception);
            }
        }
    }
}

