/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.IconFactory;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.TicketViewerTableCellRenderer;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TicketViewerTable
extends JTable
implements ComponentListener {
    private TicketViewerTableModel a = new TicketViewerTableModel(this);
    private final DefaultListSelectionModel b;
    private final TicketViewerTableCellRenderer c;
    public int rowTobeSelectedOnResize = -1;
    private boolean d;
    private ArrayList<TicketEditListener> e;

    public TicketViewerTable() {
        this((Ticket)null);
        this.addComponentListener(this);
    }

    public TicketViewerTable(Ticket ticket) {
        this(ticket, 15, 2);
    }

    public TicketViewerTable(Ticket ticket, int n, int n2) {
        this.setModel(this.a);
        this.b = new DefaultListSelectionModel();
        this.b.setSelectionMode(0);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setSelectionModel(this.b);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setAutoscrolls(true);
        this.setShowGrid(true);
        this.setBorder(null);
        this.setFocusable(false);
        this.c = new TicketViewerTableCellRenderer(n, n2);
        this.b();
        this.setTicket(ticket);
        this.e = new ArrayList();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (this.d && n2 == 0 && this.a.get(n) instanceof TicketItemDiscount) {
            return super.getCellRenderer(n, n2);
        }
        return this.c;
    }

    public TicketViewerTableCellRenderer getRenderer() {
        return this.c;
    }

    private boolean a() {
        return this.getTicket() == null || this.getTicket().getTicketItems() == null;
    }

    public void scrollUp() {
        int n;
        if (this.a()) {
            return;
        }
        int n2 = n = this.getSelectedRow() == -1 ? this.getRowCount() : this.getSelectedRow();
        if (n == 0) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n - 1, 0, true);
        this.scrollRectToVisible(rectangle);
        rectangle = this.getCellRect(--n, 0, true);
        this.scrollRectToVisible(rectangle);
        this.b.addSelectionInterval(n, n);
    }

    public void scrollUpTen() {
        if (this.a()) {
            return;
        }
        int n = this.getSelectedRow();
        if (n == 0) {
            return;
        }
        n = n - 10 < 0 ? 0 : (n -= 10);
        this.b.addSelectionInterval(n, n);
        Rectangle rectangle = this.getCellRect(n, 0, false);
        this.scrollRectToVisible(rectangle);
    }

    public void scrollDown() {
        if (this.a()) {
            return;
        }
        int n = this.getSelectedRow();
        if (n >= this.a.getItemCount() - 1) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n + 1, 0, true);
        this.scrollRectToVisible(rectangle);
        rectangle = this.getCellRect(++n, 0, true);
        this.scrollRectToVisible(rectangle);
        this.b.addSelectionInterval(n, n);
    }

    public void scrollDownTen() {
        if (this.a()) {
            return;
        }
        int n = this.getSelectedRow();
        n = n > this.a.getItemCount() - 9 ? this.a.getRowCount() - 2 : (n += 9);
        Rectangle rectangle = this.getCellRect(n + 1, 0, true);
        this.scrollRectToVisible(rectangle);
        rectangle = this.getCellRect(++n, 0, true);
        this.scrollRectToVisible(rectangle);
        this.b.addSelectionInterval(n, n);
    }

    public void scrollLast() {
        Rectangle rectangle = this.getCellRect(this.getRowCount() - 1, 0, true);
        this.scrollRectToVisible(rectangle);
    }

    public void increaseItemAmount(TicketItem ticketItem) {
        double d = ticketItem.getQuantity();
        ticketItem.setQuantity(d += 1.0);
        this.fireTicketItemUpdated(this.getTicket(), ticketItem);
        this.repaint();
    }

    public boolean increaseFractionalUnit(double d) {
        int n = this.getSelectedRow();
        if (n < 0) {
            return false;
        }
        if (n >= this.a.getItemCount()) {
            return false;
        }
        Object object = this.a.get(n);
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            ticketItem.setQuantity(d);
            return true;
        }
        return false;
    }

    public boolean increaseItemAmount() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return false;
        }
        if (n >= this.a.getItemCount()) {
            return false;
        }
        ITicketItem iTicketItem = (ITicketItem)this.a.get(n);
        if (iTicketItem.isPrintedToKitchen().booleanValue()) {
            return false;
        }
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            double d = ticketItem.getQuantity();
            ticketItem.setQuantity(d += 1.0);
            if (ticketItem.isHasModifiers().booleanValue()) {
                List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
                for (TicketItemModifier ticketItemModifier : list) {
                    ticketItemModifier.setItemQuantity(ticketItemModifier.getItemQuantity() + 1.0);
                }
            }
            return true;
        }
        return false;
    }

    public boolean decreaseItemAmount() {
        int n = this.getSelectedRow();
        if (n < 0) {
            return false;
        }
        if (n >= this.a.getItemCount()) {
            return false;
        }
        ITicketItem iTicketItem = (ITicketItem)this.a.get(n);
        if (iTicketItem.isPrintedToKitchen().booleanValue()) {
            return false;
        }
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            double d = ticketItem.getQuantity();
            if (d <= 1.0) {
                return false;
            }
            ticketItem.setQuantity(d -= 1.0);
            this.fireTicketItemUpdated(this.getTicket(), ticketItem);
            if (ticketItem.isHasModifiers().booleanValue()) {
                List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
                for (TicketItemModifier ticketItemModifier : list) {
                    ticketItemModifier.setItemQuantity(ticketItemModifier.getItemQuantity() - 1.0);
                }
            }
            return true;
        }
        return false;
    }

    public void setTicket(Ticket ticket) {
        this.a.setTicket(ticket);
        this.rowTobeSelectedOnResize = -1;
        Rectangle rectangle = this.getCellRect(0, 0, true);
        this.scrollRectToVisible(rectangle);
        this.b.addSelectionInterval(0, 0);
    }

    public Ticket getTicket() {
        return this.a.getTicket();
    }

    public void addTicketItem(TicketItem ticketItem) {
        ticketItem.setTicket(this.getTicket());
        this.rowTobeSelectedOnResize = this.a.addTicketItem(ticketItem);
        this.fireTicketItemUpdated(this.getTicket(), ticketItem);
    }

    public void addTicketDiscount(TicketDiscount ticketDiscount) {
        this.a.addTicketDiscount(ticketDiscount);
    }

    public Object deleteSelectedItem() {
        int n = this.getSelectedRow();
        Object object = this.a.delete(n);
        this.rowTobeSelectedOnResize = -1;
        if (object instanceof TicketItem) {
            this.fireTicketItemUpdated(this.getTicket(), (TicketItem)object);
        }
        return object;
    }

    public boolean containsTicketItem(TicketItem ticketItem) {
        return this.a.containsTicketItem(ticketItem);
    }

    public void delete(int n) {
        this.a.delete(n);
    }

    public ITicketItem get(int n) {
        return (ITicketItem)this.a.get(n);
    }

    public ITicketItem getSelected() {
        int n = this.getSelectedRow();
        return (ITicketItem)this.a.get(n);
    }

    public void addAllTicketItem(TicketItem ticketItem) {
        this.a.addAllTicketItem(ticketItem);
    }

    public void removeModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        this.a.removeModifier(ticketItem, ticketItemModifier);
    }

    public void updateView() {
        int n = this.getSelectedRow();
        this.a.update();
        try {
            this.getSelectionModel().setSelectionInterval(n, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getActualRowCount() {
        return this.a.getActualRowCount();
    }

    public void selectLast() {
        int n = this.getActualRowCount() - 1;
        this.b.addSelectionInterval(n, n);
        Rectangle rectangle = this.getCellRect(n, 0, true);
        this.scrollRectToVisible(rectangle);
    }

    public void selectRow(int n) {
        if (n < 0 || n >= this.getActualRowCount()) {
            n = 0;
        }
        Rectangle rectangle = this.getCellRect(n, 0, true);
        this.scrollRectToVisible(rectangle);
        this.b.addSelectionInterval(n, n);
    }

    @Override
    public TicketViewerTableModel getModel() {
        return this.a;
    }

    private List<TicketItem> a(TicketViewerTableModel ticketViewerTableModel) {
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        for (int i = 0; i <= ticketViewerTableModel.getRowCount(); ++i) {
            Object object = ticketViewerTableModel.get(i);
            if (!(object instanceof TicketItem)) continue;
            TicketItem ticketItem = (TicketItem)object;
            arrayList.add(ticketItem);
        }
        return arrayList;
    }

    public List<TicketItem> getTicketItems() {
        return this.a(this.a);
    }

    public TicketItem getTicketItem() {
        return (TicketItem)this.getSelected();
    }

    public void setModel(TicketViewerTableModel ticketViewerTableModel) {
        super.setModel(ticketViewerTableModel);
        this.a = ticketViewerTableModel;
        this.revalidate();
    }

    private void b() {
        this.setAutoResizeMode(4);
        this.a(1, PosUIManager.getSize(80));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    @Override
    protected void resizeAndRepaint() {
        if (this.getIgnoreRepaint()) {
            return;
        }
        super.resizeAndRepaint();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.rowTobeSelectedOnResize != -1) {
            this.selectRow(this.rowTobeSelectedOnResize);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void setVisibleDeleteButton(int n) {
        this.d = true;
        this.a.setEditable(this.d);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                ITicketItem iTicketItem = (ITicketItem)TicketViewerTable.this.a.get(n);
                if (iTicketItem instanceof TicketItemDiscount) {
                    TicketViewerTable.this.a.delete(n);
                    TicketViewerTable.this.fireDataRemoved();
                }
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this, abstractAction, n){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JPanel jPanel = (JPanel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                int n3 = PosUIManager.getSize(15);
                int n4 = PosUIManager.getSize(2);
                ITicketItem iTicketItem = (ITicketItem)TicketViewerTable.this.a.get(n);
                PosButton posButton = (PosButton)jPanel.getComponent(0);
                posButton.setOpaque(false);
                posButton.setBorder(new EmptyBorder(n3, n4, n3, n4));
                if (iTicketItem instanceof TicketItemDiscount) {
                    posButton.setIcon(IconFactory.getIcon("/ui_icons/", "delete-icon.png"));
                } else {
                    posButton.setIcon(null);
                }
                jTable.setRowHeight(n, jTable.getRowHeight(0));
                return jPanel;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        buttonColumn.showColumnValueInLabel(true);
    }

    public void addTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.e.add(ticketEditListener);
    }

    public void removeTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.e.remove(ticketEditListener);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener ticketEditListener : this.e) {
            ticketEditListener.itemAdded(ticket, ticketItem);
        }
    }

    public void fireDataRemoved() {
        for (TicketEditListener ticketEditListener : this.e) {
            ticketEditListener.itemRemoved(null);
        }
    }
}

