/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.main.Application;
import com.floreantpos.model.GuestCheckPrint;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.GuestCheckPrintDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.ui.views.TicketReceiptView;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;

public class OrderInfoView
extends JPanel {
    private List<Ticket> a;
    private JPanel b;

    public OrderInfoView(List<Ticket> list) throws Exception {
        this.a = list;
        this.createUI();
    }

    public void setTickets(List<Ticket> list) {
        this.a = list;
    }

    public void createUI() throws Exception {
        this.b = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        PosScrollPane posScrollPane = new PosScrollPane(this.b);
        posScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.createReport();
        this.setLayout(new BorderLayout());
        this.add(posScrollPane);
    }

    public void createReport() throws Exception {
        for (int i = 0; i < this.a.size(); ++i) {
            Ticket ticket = this.a.get(i);
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.createPrint(ticket, hashMap, null);
            TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
            this.b.add(ticketReceiptView.getReportPanel());
        }
    }

    public void createReport(PosTransaction posTransaction) throws Exception {
        JasperPrint jasperPrint = ReceiptPrintService.getTransactionReceipt(posTransaction);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        this.b.add(ticketReceiptView.getReportPanel());
    }

    public void print() throws Exception {
        for (Ticket ticket : this.a) {
            ReceiptPrintService.printTicket(ticket);
        }
    }

    public void printCopy(String string) throws Exception {
        for (Ticket ticket : this.a) {
            this.a(ticket);
            ReceiptPrintService.printTicket(ticket, string);
        }
    }

    public List<Ticket> getTickets() {
        return this.a;
    }

    public JPanel getReportPanel() {
        return this.b;
    }

    private void a(Ticket ticket) {
        GuestCheckPrint guestCheckPrint = new GuestCheckPrint();
        guestCheckPrint.setTicketId(ticket.getId());
        guestCheckPrint.setPrintTime(new Date());
        guestCheckPrint.setTicketTotal(ticket.getTotalAmountWithTips());
        guestCheckPrint.setUser(Application.getCurrentUser());
        Terminal terminal = Application.getInstance().getTerminal();
        String string = "";
        if (!terminal.isShowTableNumber()) {
            string = ticket.getTableNames();
        } else {
            List<Integer> list = ticket.getTableNumbers();
            if (list != null && list.size() > 0) {
                int n = 0;
                for (Integer n2 : list) {
                    string = string + n2;
                    if (n < list.size() - 1) {
                        string = string + ", ";
                    }
                    ++n;
                }
            }
        }
        guestCheckPrint.setTableNo(string);
        GuestCheckPrintDAO.getInstance().saveOrUpdate(guestCheckPrint);
    }
}

