/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.VoidTicketItemAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemSearchDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.CookingInstructionSelectionView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class TicketView
extends JPanel {
    private final Vector<OrderListener> a = new Vector();
    private Ticket b;
    private final PosButton c = new PosButton(IconFactory.getIcon("/ui_icons/", "page-up.png"));
    private final PosButton d = new PosButton(IconFactory.getIcon("/ui_icons/", "page-down.png"));
    private final PosButton e = new PosButton();
    private final PosButton f = new PosButton(IconFactory.getIcon("/ui_icons/", "edit.png"));
    private final PosButton g = new PosButton(IconFactory.getIcon("/ui_icons/", "add-multiple.png"));
    private PosButton h;
    private final PosButton i = new PosButton();
    private TransparentPanel j;
    private JScrollPane k;
    private PosButton l;
    private TicketViewerTable m;
    private ItemSearchDialog n = new ItemSearchDialog(Application.getPosWindow());
    private JPanel o;
    private JTextField p;
    private final PosButton q = new PosButton(IconFactory.getIcon("/ui_icons/", "cooking-instruction.png"));
    private final TitledBorder r = new TitledBorder("");
    private final Border s = new CompoundBorder(this.r, new EmptyBorder(2, 2, 2, 2));
    private boolean t;
    private boolean u;
    public static final String VIEW_NAME = "TICKET_VIEW";

    public TicketView() {
        this.a();
    }

    private void a() {
        this.r.setTitleJustification(2);
        this.setBorder(this.s);
        this.setLayout(new BorderLayout(5, 5));
        this.o = new JPanel();
        this.j = new TransparentPanel();
        this.h = new PosButton();
        this.m = new TicketViewerTable();
        this.k = new PosScrollPane(this.m);
        this.k.setHorizontalScrollBarPolicy(31);
        this.k.setVerticalScrollBarPolicy(21);
        this.k.setPreferredSize(PosUIManager.getSize(180, 200));
        this.f.setEnabled(false);
        this.q.setEnabled(false);
        this.c();
        this.d();
        this.b();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add(this.k);
        this.add((Component)this.o, "North");
        this.add(jPanel);
        this.add((Component)this.j, "East");
        this.m.getRenderer().setInTicketScreen(true);
        this.m.getSelectionModel().addListSelectionListener(new TicketItemSelectionListener());
        this.setPreferredSize(PosUIManager.getSize(320, 463));
    }

    private void b() {
        this.o.setLayout(new BorderLayout(5, 5));
        PosButton posButton = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        posButton.setPreferredSize(PosUIManager.getSize(50, 40));
        this.p = new JTextField();
        this.p.requestFocusInWindow();
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TicketView.this.p.getText();
                if (string.equals("")) {
                    POSMessageDialog.showMessage(Messages.getString("TicketView.5"));
                    return;
                }
                MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemByBarcodeOrSKU(string);
                if (menuItem != null) {
                    OrderView.getInstance().getOrderController().itemSelected(menuItem);
                }
                TicketView.this.p.setText("");
            }
        });
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.n.setTitle(Messages.getString("TicketView.7"));
                TicketView.this.n.updateFilterPanel(TicketView.this.b.getOrderType());
                TicketView.this.n.pack();
                TicketView.this.n.openFullScreen();
                if (TicketView.this.n.isCanceled()) {
                    return;
                }
                TicketView.this.p.requestFocus();
                if (TicketView.this.n.getMenuItem() == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.8"));
                    return;
                }
                OrderView.getInstance().getOrderController().itemSelected(TicketView.this.n.getMenuItem());
            }
        });
        this.o.add(this.p);
        this.o.add((Component)posButton, "East");
    }

    private void c() {
        this.l = new PosButton(POSConstants.TOTAL.toUpperCase());
        this.l.setFont(this.l.getFont().deriveFont(1));
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.g();
            }
        });
        this.add((Component)this.l, "South");
    }

    private void d() {
        this.j.setLayout((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0", "sg, fill", ""));
        this.i.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.k();
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.l();
            }
        });
        this.h.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.j();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.m();
            }
        });
        this.e.setText("");
        this.e.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png"));
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.h();
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.i();
            }
        });
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.e();
            }
        });
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.doAddCookingInstruction();
            }
        });
        this.j.add((Component)this.c, "grow, wrap");
        this.j.add((Component)this.i, "grow, wrap");
        this.j.add((Component)this.g, "grow, wrap");
        this.j.add((Component)this.e, "grow, wrap");
        this.j.add((Component)this.f, "grow, wrap");
        this.j.add((Component)this.q, "grow, wrap");
        this.j.add((Component)this.h, "grow, wrap");
        this.j.add((Component)this.d, "grow");
        this.j.setPreferredSize(PosUIManager.getSize(50, 0));
    }

    private void e() {
        ITicketItem iTicketItem = this.m.getSelected();
        if (iTicketItem == null) {
            return;
        }
        if (!(iTicketItem instanceof TicketItem) || ((TicketItem)iTicketItem).isTreatAsSeat().booleanValue()) {
            return;
        }
        TicketItem ticketItem = (TicketItem)iTicketItem;
        OrderView.getInstance().getOrderController().doEditTicketItemQuantity(ticketItem);
        this.updateView();
        int n = this.m.getSelectedRow();
        this.m.getModel().fireTableRowsUpdated(n, n);
        this.m.fireTicketItemUpdated(this.getTicket(), ticketItem);
    }

    public synchronized void doFinishOrder() {
        this.saveTicketIfNeeded();
        this.sendTicketToKitchen();
        this.a(false);
    }

    public synchronized void sendTicketToKitchenByOption(RefreshableView refreshableView) {
        if (this.b.getTicketItems() == null || this.b.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        OrderController.saveOrder(this.b);
        if (this.b.getOrderType().isShouldPrintToKitchen().booleanValue()) {
            if (this.b.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.b, true);
                POSMessageDialog.showMessage(Messages.getString("TicketView.32"));
            } else {
                POSMessageDialog.showMessage(Messages.getString("TicketView.33"));
            }
        }
        this.setAllowToLogOut(false);
    }

    public synchronized void sendTicketToKitchen() {
        if (this.b.getOrderType().isShouldPrintToKitchen().booleanValue() && this.b.needsKitchenPrint()) {
            ReceiptPrintService.printToKitchen(this.b);
            this.setCancelable(false);
            this.setAllowToLogOut(false);
        }
    }

    public synchronized void doHoldOrder() {
        this.f();
        OrderController.saveOrder(this.b);
        this.a(false);
    }

    public void saveTicketIfNeeded() {
        try {
            this.f();
            OrderController.saveOrder(this.b);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(boolean bl) {
        DataChangeListener dataChangeListener = RootView.getInstance().getHomeView().getDataChangeListener();
        if (dataChangeListener != null) {
            if (bl) {
                dataChangeListener.dataChangeCanceled(this.b);
            } else {
                dataChangeListener.dataChanged(this.b);
            }
        }
        RootView.getInstance().showDefaultView();
    }

    public void doCancelOrder() {
        this.a(true);
    }

    private synchronized void f() {
        if (this.b.getTicketItems() == null || this.b.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        this.b.calculatePrice();
    }

    private void g() {
        try {
            this.firePayOrderSelected();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("OrderView.0"));
            return;
        }
    }

    private void h() {
        ITicketItem iTicketItem = this.m.getSelected();
        if (iTicketItem == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        TicketItem ticketItem = (TicketItem)iTicketItem;
        if (iTicketItem instanceof TicketItem) {
            bl = ticketItem.getInventoryAdjustQty() > 0.0;
            bl2 = ticketItem.isSaved();
        }
        if (bl2 || iTicketItem.isPrintedToKitchen().booleanValue() || bl) {
            VoidTicketItemAction voidTicketItemAction = new VoidTicketItemAction(this.b, ticketItem);
            voidTicketItemAction.actionPerformed(null);
            if (voidTicketItemAction.isDataChanged()) {
                this.m.updateView();
                this.updateView();
            }
        } else {
            this.m.deleteSelectedItem();
            this.updateView();
        }
        OrderView.getInstance().getOrderController().fireTicketItemUpdated(this.b, ticketItem);
    }

    private boolean a(TicketItem ticketItem) {
        double d = 0.0;
        for (TicketItem ticketItem2 : this.b.getTicketItems()) {
            String string;
            String string2;
            if (ticketItem2.isTreatAsSeat().booleanValue() || !(string2 = ticketItem.getMenuItemId().equals("0") ? ticketItem.getName() : ticketItem.getMenuItemId()).equals(string = ticketItem2.getMenuItemId().equals("0") ? ticketItem2.getName() : ticketItem2.getMenuItemId())) continue;
            d += ticketItem2.getQuantity().doubleValue();
        }
        return d <= 0.0;
    }

    private void i() {
        ITicketItem iTicketItem = this.m.getSelected();
        if (iTicketItem == null) {
            return;
        }
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                if (!OrderView.getInstance().updateSeat(ticketItem)) {
                    return;
                }
            } else if (ticketItem.isComboItem().booleanValue()) {
                ComboTicketItemSelectionDialog comboTicketItemSelectionDialog = new ComboTicketItemSelectionDialog(ticketItem.getMenuItem(), ticketItem);
                comboTicketItemSelectionDialog.setTitle(Messages.getString("TicketView.47"));
                comboTicketItemSelectionDialog.setSize(PosUIManager.getSize(800, 600));
                comboTicketItemSelectionDialog.open();
                if (comboTicketItemSelectionDialog.isCanceled()) {
                    return;
                }
            } else {
                OrderController.openModifierDialog(iTicketItem);
            }
            OrderView.getInstance().getOrderController().fireTicketItemUpdated(this.b, ticketItem);
        } else {
            OrderController.openModifierDialog(iTicketItem);
        }
        this.m.rowTobeSelectedOnResize = -1;
        this.updateView();
    }

    private void j() {
        this.m.scrollDown();
    }

    private void k() {
        this.m.scrollUp();
    }

    private void l() {
        this.m.scrollUpTen();
    }

    private void m() {
        this.m.scrollDownTen();
    }

    public Ticket getTicket() {
        return this.b;
    }

    public void setTicket(Ticket ticket) {
        this.b = ticket;
        this.m.setTicket(ticket);
        this.updateView();
        this.setCancelable(true);
        this.setAllowToLogOut(true);
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.m.addTicketItem(ticketItem);
        this.updateView();
    }

    public void removeModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        ticketItemModifier.setItemQuantity(0.0);
        this.m.removeModifier(ticketItem, ticketItemModifier);
    }

    public void selectRow(int n) {
        this.m.selectRow(n);
    }

    public void updateView() {
        if (this.b == null) {
            this.l.setText(POSConstants.TOTAL.toUpperCase() + " " + CurrencyUtil.getCurrencySymbol() + "0.00");
            this.r.setTitle(this.b.getOrderType().toString() + "[New Ticket]");
            return;
        }
        this.b.calculatePrice();
        if (this.b.getDueAmount() < 0.0) {
            String string = NumberUtil.formatNumber(this.b.getDueAmount(), true);
            String string2 = Messages.getString("TicketView.48") + CurrencyUtil.getCurrencySymbol() + string.replaceFirst("-", "");
            this.l.setText(string2);
        } else {
            String string = NumberUtil.formatNumber(this.b.getDueAmount(), true);
            this.l.setText(Messages.getString("TicketView.51") + CurrencyUtil.getCurrencySymbol() + string);
        }
        this.updateTicketTitle();
        this.a(this.m.getSelected());
    }

    public void updateTicketTitle() {
        String string = this.b.getOrderType().toString();
        if (this.b.getId() == null) {
            this.r.setTitle(string + " [New Ticket]");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = Messages.getString("TicketView.37");
            stringBuilder.append(string);
            stringBuilder.append(" [ " + string2 + " " + this.b.getTokenNo() + " ]");
            this.r.setTitle(stringBuilder.toString());
        }
        this.repaint();
    }

    public void addOrderListener(OrderListener orderListener) {
        this.a.add(orderListener);
    }

    public void removeOrderListener(OrderListener orderListener) {
        this.a.remove(orderListener);
    }

    public void firePayOrderSelected() {
        for (OrderListener orderListener : this.a) {
            orderListener.payOrderSelected(this.getTicket());
        }
    }

    public void setControlsVisible(boolean bl) {
        this.e.setEnabled(bl);
    }

    public TicketViewerTable getTicketViewerTable() {
        return this.m;
    }

    public void setEnableActionButtons(boolean bl) {
        this.q.setEnabled(bl);
        this.g.setEnabled(bl);
        this.f.setEnabled(bl);
        this.e.setEnabled(bl);
    }

    private String a(ITicketItem iTicketItem, String string) {
        String string2;
        String string3;
        double d;
        String string4 = iTicketItem.getNameDisplay();
        string4 = string4.length() > 10 ? iTicketItem.getNameDisplay().substring(0, 10) : iTicketItem.getNameDisplay();
        String string5 = String.format("%-10s %9s", string4, NumberUtil.formatNumber(d = iTicketItem.getSubTotalAmountDisplay() == null ? 0.0 : iTicketItem.getSubTotalAmountDisplay(), true));
        if (string5.length() > 20) {
            string5 = string5.substring(0, 20);
        }
        if ((string3 = String.format("%-8s %11s", string2 = Messages.getString("TicketView.29") + CurrencyUtil.getCurrencySymbol(), string)).length() > 20) {
            string3 = string3.substring(0, 20);
        }
        return string5 + string3;
    }

    public boolean isCancelable() {
        return this.t;
    }

    public void setCancelable(boolean bl) {
        this.t = bl;
    }

    public boolean isAllowToLogOut() {
        return this.u;
    }

    public void setAllowToLogOut(boolean bl) {
        this.u = bl;
    }

    public boolean isStockAvailable(MenuItem menuItem, TicketItem ticketItem, double d) {
        if (!menuItem.isDisableWhenStockAmountIsZero().booleanValue()) {
            return true;
        }
        List<TicketItem> list = this.m.getTicketItems();
        if (menuItem.isFractionalUnit().booleanValue()) {
            if (list == null || list.isEmpty()) {
                return !(menuItem.getAvailableUnit() < ticketItem.getQuantity());
            }
            double d2 = 0.0;
            for (TicketItem ticketItem2 : list) {
                if (!menuItem.getName().equals(ticketItem2.getName())) continue;
                d2 += ticketItem2.getQuantity().doubleValue();
                if (!(menuItem.getAvailableUnit() < d2)) continue;
                return false;
            }
            if (d != -1.0) {
                d2 -= ticketItem.getQuantity().doubleValue();
                d2 += d;
            } else {
                d2 += ticketItem.getQuantity().doubleValue();
            }
            return !(menuItem.getAvailableUnit() < d2);
        }
        if (list == null || list.isEmpty()) {
            return !(menuItem.getAvailableUnit() < ticketItem.getQuantity());
        }
        int n = 0;
        for (TicketItem ticketItem3 : list) {
            if (!ticketItem3.getName().equals(menuItem.getName())) continue;
            n = (int)((double)n + ticketItem3.getQuantity());
            if (!(menuItem.getAvailableUnit() <= (double)n)) continue;
            return false;
        }
        return true;
    }

    protected void doAddCookingInstruction() {
        try {
            ITicketItem iTicketItem = this.m.getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (ticketItem.isPrintedToKitchen().booleanValue()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.21"));
                return;
            }
            CookingInstructionSelectionView cookingInstructionSelectionView = new CookingInstructionSelectionView();
            cookingInstructionSelectionView.setSize(PosUIManager.getSize(820, 600));
            cookingInstructionSelectionView.setLocationRelativeTo(Application.getPosWindow());
            cookingInstructionSelectionView.setVisible(true);
            if (cookingInstructionSelectionView.isCanceled()) {
                return;
            }
            List<TicketItemCookingInstruction> list = cookingInstructionSelectionView.getTicketItemCookingInstructions();
            ticketItem.addCookingInstructions(list);
            this.m.updateView();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    public void showSettleButton(boolean bl) {
        this.l.setVisible(bl);
        this.f.setVisible(bl);
        this.q.setVisible(bl);
    }

    private void a(Object object) {
        if (TerminalConfig.isActiveCustomerDisplay()) {
            TicketItem ticketItem = null;
            if (object instanceof TicketItemModifier) {
                ticketItem = ((TicketItemModifier)object).getTicketItem();
            } else if (object instanceof TicketItem) {
                ticketItem = (TicketItem)object;
            }
            if (ticketItem != null) {
                String string = this.a(ticketItem, NumberUtil.formatNumber(this.b.getTotalAmountWithTips(), true));
                DrawerUtil.setItemDisplay(TerminalConfig.getCustomerDisplayPort(), string);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.p.getParent() == null) {
                this.o.add(this.p);
            }
            this.p.requestFocus();
        } else {
            this.o.remove(this.p);
        }
    }

    private class TicketItemSelectionListener
    implements ListSelectionListener {
        private TicketItemSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ITicketItem iTicketItem = TicketView.this.m.getSelected();
            if (!(iTicketItem instanceof ITicketItem)) {
                return;
            }
            TicketView.this.setEnableActionButtons(true);
            ITicketItem iTicketItem2 = iTicketItem;
            if (iTicketItem instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                if (ticketItem.isVoided().booleanValue()) {
                    TicketView.this.setEnableActionButtons(false);
                } else if (!ticketItem.isHasModifiers().booleanValue() && !ticketItem.isComboItem().booleanValue()) {
                    TicketView.this.f.setEnabled(false);
                }
            }
            if (iTicketItem2.isPrintedToKitchen().booleanValue()) {
                TicketView.this.q.setEnabled(false);
                TicketView.this.g.setEnabled(false);
                TicketView.this.f.setEnabled(false);
                if (iTicketItem instanceof TicketItemModifier) {
                    TicketView.this.e.setEnabled(false);
                }
            } else if (iTicketItem instanceof TicketItemModifier) {
                TicketView.this.f.setEnabled(true);
                TicketView.this.e.setEnabled(false);
                TicketView.this.q.setEnabled(false);
                TicketView.this.g.setEnabled(false);
            }
            if (TicketView.this.b.isSourceOnline()) {
                TicketView.this.setEnableActionButtons(false);
            }
            TicketView.this.a(iTicketItem);
        }
    }
}

