/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;

public class PizzaModifierView
extends SelectionView
implements ModifierGroupSelectionListener {
    private ModifierSelectionListener a;
    private PosButton b = new PosButton(POSConstants.CLEAR);
    private Multiplier c;
    private MultiplierButton d;
    private ModifierGroupView e;
    private PizzaModifierSelectionDialog f;
    private MenuItemModifierSpec g;
    private TitledBorder h;

    public PizzaModifierView(Ticket ticket, TicketItem ticketItem, MenuItem menuItem, PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        super(POSConstants.MODIFIERS, new FlowLayout(), PosUIManager.getSize(120), PosUIManager.getSize(80));
        ModifierSelectionModel modifierSelectionModel = new ModifierSelectionModel(ticket, ticketItem, menuItem);
        this.f = pizzaModifierSelectionDialog;
        this.setBorder(null);
        this.h = new TitledBorder(null, Messages.getString("PizzaModifierView.0"), 2, 2);
        this.selectionButtonsPanel.setBorder(this.h);
        this.e = new ModifierGroupView(modifierSelectionModel);
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.add((Component)this.e, "East");
        this.a();
        this.e.addModifierGroupSelectionListener(this);
        this.e.selectFirst();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,center, gap 0, ins 0"));
        LineBorder lineBorder = new LineBorder(Color.lightGray, 1, true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 5, 0), lineBorder);
        jPanel.setBorder(compoundBorder);
        jPanel.setOpaque(true);
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        if (list != null) {
            for (Multiplier multiplier : list) {
                MultiplierButton multiplierButton = new MultiplierButton(multiplier);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.c = multiplier;
                    this.d = multiplierButton;
                    multiplierButton.setSelected(true);
                }
                jPanel.add((Component)multiplierButton, "grow");
                buttonGroup.add(multiplierButton);
            }
        }
        this.actionButtonPanel.add((Component)jPanel, "newline,span");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractButton createItemButton(Object object) {
        ModifierButton modifierButton;
        Session session = null;
        try {
            ModifierButton modifierButton2;
            MenuModifier menuModifier = (MenuModifier)object;
            session = MenuModifierDAO.getInstance().createNewSession();
            session.refresh((Object)menuModifier);
            menuModifier.setMenuItemModifierGroup(this.g);
            modifierButton = modifierButton2 = new ModifierButton(menuModifier, this.c, this.f.getSelectedSize());
        }
        catch (Throwable throwable) {
            MenuModifierDAO.getInstance().closeSession(session);
            throw throwable;
        }
        MenuModifierDAO.getInstance().closeSession(session);
        return modifierButton;
    }

    public void addModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a = modifierSelectionListener;
    }

    public void removeModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a = null;
    }

    public void updateView() {
        if (this.g == null) {
            return;
        }
        this.b();
        try {
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(MenuItemModifierPageDAO.getInstance().getRowCount(this.g.getId()));
            MenuItemModifierPageDAO.getInstance().loadItems(this.g, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, posException);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel paginatedListModel) {
        super.setDataModel(paginatedListModel);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.populateItems();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(0);
        this.setButtonSize(new Dimension(menuItemModifierPage.getButtonWidth(), menuItemModifierPage.getButtonHeight()));
        Integer n = menuItemModifierPage.getCols();
        MigLayout migLayout = new MigLayout("center,wrap " + n);
        if (menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int i = 0; i < menuItemModifierPage.getRows(); ++i) {
            for (int j = 0; j < menuItemModifierPage.getCols(); ++j) {
                MenuItemModifierPageItem menuItemModifierPageItem;
                String string = String.format("cell %s %s", j, i);
                if (!menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
                    string = string + String.format(", w %s!, h %s!", menuItemModifierPage.getButtonWidth(), menuItemModifierPage.getButtonHeight());
                }
                if ((menuItemModifierPageItem = menuItemModifierPage.getItemForCell(j, i)) == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), string);
                    continue;
                }
                AbstractButton abstractButton = this.createItemButton(menuItemModifierPageItem.getMenuModifier());
                if (abstractButton == null) continue;
                this.selectionButtonsPanel.add((Component)abstractButton, string);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    private void b() {
        String string = this.g.getName();
        String string2 = this.g.getInstruction();
        int n = this.g.getMinQuantity();
        int n2 = this.g.getMaxQuantity();
        this.h.setTitle(string + Messages.getString("ModifierView.2") + n + Messages.getString("ModifierView.3") + n2 + (string2 == null ? "" : " " + string2));
    }

    public void setActionButtonsVisible(boolean bl) {
        this.b.setVisible(bl);
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuItemModifierSpec) {
        if (menuItemModifierSpec == null) {
            return;
        }
        if (this.g != null && menuItemModifierSpec.getId().equals(this.g.getId())) {
            return;
        }
        this.g = menuItemModifierSpec;
        this.updateView();
    }

    public ModifierGroupView getModifierGroupView() {
        return this.e;
    }

    public Multiplier getSelectedMultiplier() {
        return this.c;
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.g, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.g, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier b;

        public MultiplierButton(Multiplier multiplier) {
            Integer n;
            this.b = multiplier;
            this.setText(multiplier.getId());
            Integer n2 = multiplier.getButtonColor();
            if (n2 != null) {
                this.setBackground(new Color(n2));
            }
            if ((n = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(n));
            }
            this.setBorder(null);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PizzaModifierView.this.c = this.b;
            PizzaModifierView.this.updateView();
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private MenuModifier b;

        public ModifierButton(MenuModifier menuModifier, Multiplier multiplier, MenuItemSize menuItemSize) {
            this.b = menuModifier;
            this.setText("<html><center>" + menuModifier.getDisplayName() + "<br/>" + menuModifier.getPriceForSizeAndMultiplier(menuItemSize, true, multiplier) + "</center></html>");
            if (menuModifier.getButtonColor() != null) {
                this.setBackground(new Color(menuModifier.getButtonColor()));
            }
            if (menuModifier.getTextColor() != null) {
                this.setForeground(new Color(menuModifier.getTextColor()));
            }
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PizzaModifierView.this.a.modifierSelected(this.b, PizzaModifierView.this.c);
            if (PizzaModifierView.this.c == null) {
                PizzaModifierView.this.c = PizzaModifierView.this.d.getMultiplier();
            }
        }
    }
}

