/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiscountUtil {
    public static Double calculateDiscountAmount(TicketItemDiscount ticketItemDiscount, double d) {
        TicketItem ticketItem = ticketItemDiscount.getTicketItem();
        if (ticketItemDiscount.getType() == 2) {
            return ticketItemDiscount.getValue();
        }
        if (ticketItemDiscount.getMinimumAmount() > 1.0) {
            double d2 = ticketItemDiscount.getMinimumAmount();
            double d3 = ticketItem.getQuantity();
            switch (ticketItemDiscount.getType()) {
                case 0: {
                    return Math.floor(d3 / d2) * ticketItemDiscount.getValue();
                }
                case 1: {
                    return Math.floor(d3 / d2) * (d / d3 * ticketItemDiscount.getValue() / 100.0);
                }
            }
        }
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return ticketItemDiscount.getValue();
            }
            case 1: {
                return d * ticketItemDiscount.getValue() / 100.0;
            }
        }
        return 0.0;
    }

    public static BigDecimal calculateDiscountAmount(TicketItemDiscount ticketItemDiscount, BigDecimal bigDecimal) {
        TicketItem ticketItem = ticketItemDiscount.getTicketItem();
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(ticketItemDiscount.getValue());
        BigDecimal bigDecimal3 = bigDecimal2.divide(NumberUtil.convertToBigDecimal("100.0"), 4, RoundingMode.FLOOR);
        if (ticketItemDiscount.getType() == 2) {
            return bigDecimal2;
        }
        if (ticketItemDiscount.getMinimumAmount() > 1.0) {
            BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(ticketItemDiscount.getMinimumAmount());
            BigDecimal bigDecimal5 = NumberUtil.convertToBigDecimal(ticketItem.getQuantity());
            switch (ticketItemDiscount.getType()) {
                case 0: {
                    return bigDecimal5.divide(bigDecimal4, 4, RoundingMode.FLOOR).multiply(bigDecimal2);
                }
                case 1: {
                    BigDecimal bigDecimal6 = bigDecimal5.divide(bigDecimal4, 4, RoundingMode.FLOOR);
                    BigDecimal bigDecimal7 = bigDecimal.divide(bigDecimal5, 4, RoundingMode.FLOOR);
                    return bigDecimal6.multiply(bigDecimal7).multiply(bigDecimal3);
                }
            }
        }
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return bigDecimal2;
            }
            case 1: {
                return bigDecimal.multiply(bigDecimal3);
            }
        }
        return new BigDecimal("0");
    }

    public static Double calculateDiscountAmount(double d, TicketDiscount ticketDiscount) {
        switch (ticketDiscount.getType()) {
            case 0: 
            case 2: {
                return ticketDiscount.getValue();
            }
            case 1: {
                return d * ticketDiscount.getValue() / 100.0;
            }
        }
        return d * ticketDiscount.getValue() / 100.0;
    }

    public static TicketItemDiscount getMaxDiscount(List<TicketItemDiscount> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        TicketItemDiscount ticketItemDiscount = Collections.max(list, new Comparator<TicketItemDiscount>(){

            @Override
            public int compare(TicketItemDiscount ticketItemDiscount, TicketItemDiscount ticketItemDiscount2) {
                return (int)(ticketItemDiscount.getSubTotalAmountDisplay() - ticketItemDiscount2.getSubTotalAmountDisplay());
            }
        });
        return ticketItemDiscount;
    }

    public static TicketDiscount getMaxDiscount(List<TicketDiscount> list, final double d) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        TicketDiscount ticketDiscount = Collections.max(list, new Comparator<TicketDiscount>(){

            @Override
            public int compare(TicketDiscount ticketDiscount, TicketDiscount ticketDiscount2) {
                return (int)(DiscountUtil.calculateDiscountAmount(d, ticketDiscount) - DiscountUtil.calculateDiscountAmount(d, ticketDiscount2));
            }
        });
        return ticketDiscount;
    }

    public static Double calculateRepriceDiscount(Ticket ticket, double d) {
        Double d2 = ticket.getTotalAmount();
        Double d3 = ticket.getTaxAmount();
        if (d2 == 0.0) {
            return 0.0;
        }
        double d4 = d * d3 / d2;
        Double d5 = ticket.getSubtotalAmount() - ticket.getItemDiscountAmount() - (d - d4);
        return d5;
    }
}

