/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OroMqttMessagePublisher {
    public static void publishDrawerClosed(CashDrawer cashDrawer) {
    }

    public static void publishDrawerOpened(CashDrawer cashDrawer) {
    }

    public static void pulishDrawers(List<CashDrawer> list) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null && list.size() > 0) {
                for (CashDrawer cashDrawer : list) {
                    arrayList.add(cashDrawer.getId());
                }
                String string = OroMqttMessagePublisher.convertCashDrawersToJson(list);
                OroMqttClient.getInstance().publishOnThread("public", string);
            }
        }
        catch (Exception exception) {
            PosLog.error(OroMqttMessagePublisher.class, exception);
        }
    }

    public static String convertCashDrawersToJson(List<CashDrawer> list) throws Exception {
        PosResponse posResponse = new PosResponse();
        posResponse.setResponseCode(1);
        posResponse.setRequest(Messages.getString("OroMqttMessagePublisher.0"));
        posResponse.setMsg((list.size() == 1 ? Messages.getString("OroMqttMessagePublisher.1") : list.size() + Messages.getString("OroMqttMessagePublisher.2")) + Messages.getString("OroMqttMessagePublisher.3"));
        posResponse.setDeviceId(TerminalUtil.getSystemUID());
        posResponse.setData(list);
        posResponse.setOutletId(Application.getInstance().getCurrentTerminalOutletId());
        return ServiceUtils.getAsJsonString(posResponse);
    }

    public static void publishTicket(final String string) {
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                Ticket ticket = TicketDAO.getInstance().loadFullTicket(string);
                arrayList.add(ticket);
                OroMqttMessagePublisher.publishTickets(arrayList);
            }
        }).start();
    }

    public static void publishTickets(List<Ticket> list) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Set<PosTransaction> set = null;
            if (list != null && list.size() > 0) {
                for (Ticket ticket : list) {
                    set = ticket.getTransactions();
                    if (set != null) {
                        for (PosTransaction posTransaction : set) {
                            arrayList2.add(posTransaction.getId());
                        }
                    }
                    ticket.setProperties(null);
                    ticket.setDiscounts(null);
                    ticket.setTransactions(null);
                    arrayList.add(ticket.getId());
                }
                String string = ServiceUtils.createPosResponseAsString(list, true);
                OroMqttClient.getInstance().publishData("public", string, true);
            }
        }
        catch (Exception exception) {
            PosLog.error(OroMqttMessagePublisher.class, exception);
        }
    }
}

