/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.MergeTicketDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.util.List;

public class MergeTicketsAction
extends PosAction {
    public MergeTicketsAction() {
        super(Messages.getString("MergeTicketsAction.0"));
    }

    @Override
    public void execute() {
        try {
            StyledTicketSelectionDialog styledTicketSelectionDialog = new StyledTicketSelectionDialog();
            styledTicketSelectionDialog.setMerge(true);
            styledTicketSelectionDialog.setRequiredNumber(2);
            styledTicketSelectionDialog.openFullScreen();
            if (styledTicketSelectionDialog.isCanceled()) {
                return;
            }
            List<Ticket> list = styledTicketSelectionDialog.getSelectedTickets();
            if (list.size() <= 0) {
                return;
            }
            MergeTicketDialog mergeTicketDialog = new MergeTicketDialog(list, styledTicketSelectionDialog.getMainTicket());
            mergeTicketDialog.setTitle(Messages.getString("MergeTicketsAction.1"));
            mergeTicketDialog.setSize(PosUIManager.getSize(750, 600));
            mergeTicketDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            mergeTicketDialog.setVisible(true);
            if (mergeTicketDialog.isCanceled()) {
                return;
            }
            Ticket ticket = mergeTicketDialog.getMainTicket();
            this.a(ticket, list);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MergeTicketsAction.2") + ticket.getTokenNo());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(Ticket ticket, List<Ticket> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tickets: ");
        Object object = list.iterator();
        while (object.hasNext()) {
            Ticket ticket2 = object.next();
            stringBuilder.append(ticket2.getId());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 255) {
            object = ((String)object).substring(0, 255);
        }
        ActionHistoryDAO.saveHistory(ticket, "Merge ticket", (String)object);
    }
}

