/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.CourseExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class CourseExplorerAction
extends AbstractAction {
    public CourseExplorerAction() {
        super(POSConstants.COURSE);
    }

    public CourseExplorerAction(String string) {
        super(string);
    }

    public CourseExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            CourseExplorer courseExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.COURSE);
            if (n == -1) {
                courseExplorer = new CourseExplorer();
                jTabbedPane.addTab(POSConstants.COURSE, courseExplorer);
            } else {
                courseExplorer = (CourseExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(courseExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

