/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.actions.DataImportAction;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class DataImportDialog
extends OkCancelOptionDialog
implements ProgressObserver {
    private Elements a;
    private JTabbedPane b;
    private File c;
    private JLabel d;
    private JPanel e;

    public DataImportDialog(File file) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.c = file;
        this.setTitle(Messages.getString("DataImportDialog.0"));
        this.setOkButtonText(Messages.getString("DataImportDialog.0"));
        this.setCaption(Messages.getString("DataImportDialog.2"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        this.b = new JTabbedPane();
        jPanel.add(this.b);
        this.e = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.d = new JLabel(Messages.getString("DataImportDialog.4"));
        this.e.add((Component)this.d, "grow,span,wrap");
        this.e.setVisible(false);
        jPanel.add((Component)this.e, "South");
    }

    protected void showImportedItems() {
        try {
            this.e.setVisible(true);
            this.progress(0, Messages.getString("DataImportDialog.6"));
            this.a = DataImportAction.importMenuItemsFromFile(this.c);
            this.progress(100, Messages.getString("DataImportDialog.7"));
            this.e.setVisible(false);
            String[] stringArray = new String[]{"name", "translatedName", "price", "availableUnit", "unitOnHand", "visible", "taxGroup", "sortOrder", "buttonColor", "textColor", "image"};
            Integer[] integerArray = new Integer[]{200, 180, 90, 70};
            Integer[] integerArray2 = new Integer[]{0, 1, 2, 3, 4, 7};
            this.b.addTab(POSConstants.MENU_ITEMS, new ElementTab(MenuItem.class, this.a.getMenuItems(), stringArray, integerArray, integerArray2));
            integerArray2 = new Integer[]{0, 1, 4};
            String[] stringArray2 = new String[]{"name", "translatedName", "visible", "parent", "sortOrder", "buttonColor", "textColor"};
            this.b.addTab(POSConstants.MENU_GROUPS, new ElementTab(MenuGroup.class, this.a.getMenuGroups(), stringArray2, null, integerArray2));
            integerArray2 = new Integer[]{0, 1, 4};
            String[] stringArray3 = new String[]{"name", "translatedName", "beverage", "visible", "sortOrder", "buttonColor", "textColor"};
            this.b.addTab(POSConstants.MENU_CATEGORIES, new ElementTab(MenuCategory.class, this.a.getMenuCategories(), stringArray3, null, integerArray2));
            integerArray2 = new Integer[]{0, 1};
            String[] stringArray4 = new String[]{"name", "translatedName", "modifiers"};
            this.b.addTab(POSConstants.MODIFIER_GROUPS, new ElementTab(ModifierGroup.class, this.a.getModifierGroups(), stringArray4, null, integerArray2));
            integerArray2 = new Integer[]{0, 1, 2};
            String[] stringArray5 = new String[]{"name", "translatedName", "price", "sortOrder", "buttonColor", "textColor"};
            this.b.addTab(POSConstants.MENU_MODIFIERS, new ElementTab(MenuModifier.class, this.a.getMenuModifiers(), stringArray5, null, integerArray2));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void doOk() {
        this.e.setVisible(true);
        this.progress(0, Messages.getString("DataImportDialog.42"));
        new Thread(){

            @Override
            public void run() {
                DataImportDialog.this.doImport();
            }
        }.start();
    }

    protected void doImport() {
        try {
            this.getButtonPanel().getComponent(0).setEnabled(false);
            DataImportAction.saveImportedMenuItems(this.a, this);
            this.progress(100, Messages.getString("DataImportDialog.43"));
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("DataImportAction.1"));
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception);
            this.progress(0, Messages.getString("DataImportDialog.44"));
        }
        finally {
            this.getButtonPanel().getComponent(0).setEnabled(true);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new Thread(){

                @Override
                public void run() {
                    DataImportDialog.this.showImportedItems();
                }
            }.start();
        }
        super.setVisible(bl);
    }

    @Override
    public void progress(int n, String string) {
        this.d.setText(string);
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public Component getParentComponent() {
        return POSUtil.getFocusedWindow();
    }

    @Override
    public void progress(String string) {
        this.d.setText(Messages.getString("DataImportDialog.48") + string);
    }

    private class ElementTab<E>
    extends JPanel {
        private PosTable b;
        private BeanTableModel<E> c;

        public ElementTab(Class clazz, List list, String[] stringArray) {
            this(clazz, list, stringArray, null);
        }

        public ElementTab(Class clazz, List list, String[] stringArray, Integer[] integerArray) {
            this(clazz, list, stringArray, integerArray, null);
        }

        public ElementTab(Class clazz, List list, String[] stringArray, Integer[] integerArray, Integer[] integerArray2) {
            this.c = new BeanTableModel(clazz, 20);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    BeanTableModel.EditMode editMode = BeanTableModel.EditMode.NON_EDITABLE;
                    if (integerArray2 != null && integerArray2.length > i && integerArray2[i] == i) {
                        editMode = BeanTableModel.EditMode.EDITABLE;
                    }
                    this.c.addColumn(this.a(stringArray[i]), stringArray[i], editMode);
                }
            }
            this.c.addRows(list);
            this.b = new PosTable();
            this.b.setRowHeight(PosUIManager.getSize(30));
            this.b.setSelectionMode(0);
            this.b.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.b.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
            this.b.setModel(this.c);
            this.setLayout(new BorderLayout(5, 5));
            this.add(new JScrollPane((Component)((Object)this.b)));
            if (integerArray != null) {
                this.resizeColumnWidth((JTable)((Object)this.b), integerArray);
            }
        }

        public void resizeColumnWidth(JTable jTable, Integer[] integerArray) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < jTable.getColumnCount() && integerArray.length != i; ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth(integerArray[i]);
            }
        }

        private String a(String string) {
            StringBuilder stringBuilder = new StringBuilder(string);
            Pattern pattern = Pattern.compile("[A-Z]");
            Matcher matcher = pattern.matcher(string);
            int n = 0;
            while (matcher.find()) {
                if (matcher.start() == 0) continue;
                stringBuilder = stringBuilder.insert(matcher.start() + n, " ");
                ++n;
            }
            return stringBuilder.toString().toUpperCase();
        }
    }
}

