/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.PayrollReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class PayrollReportAction
extends AbstractAction {
    public PayrollReportAction() {
        super(POSConstants.PAYROLL_REPORT);
    }

    public PayrollReportAction(String string) {
        super(string);
    }

    public PayrollReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            PayrollReportView payrollReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.PAYROLL_REPORT);
            if (n == -1) {
                payrollReportView = new PayrollReportView();
                jTabbedPane.addTab(POSConstants.PAYROLL_REPORT, payrollReportView);
            } else {
                payrollReportView = (PayrollReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(payrollReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

