/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ComboGroupItemSelectionDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class ComboGroupTreeExplorer
extends JPanel {
    private JXTreeTable a;
    private MenuItem b;
    private List<ComboGroup> c;
    private ComboGroupTreeTableModel d;
    private DefaultMutableTreeTableNode e;

    public ComboGroupTreeExplorer() {
        this.setPreferredSize(PosUIManager.getSize(0, 300));
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 0 0 0 0"));
        this.add(jPanel);
        this.a = new JXTreeTable(){

            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                ComboGroupTreeExplorer.this.a.editCellAt(n, n2);
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)ComboGroupTreeExplorer.this.a.getCellEditor(n, n2);
                if (defaultCellEditor.getComponent() instanceof DoubleTextField) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                }
            }

            public void setValueAt(Object object, int n, int n2) {
                try {
                    TreePath treePath = ComboGroupTreeExplorer.this.a.getPathForRow(n);
                    DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
                    TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                    if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem && treeTableNode.getUserObject() instanceof ComboGroup) {
                        ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                        MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
                        double d = Double.valueOf((String)object);
                        comboGroup.addItemPrice(menuItem.getId(), d);
                    }
                }
                catch (Exception exception) {
                    PosLog.error(((Object)((Object)this)).getClass(), exception);
                }
            }
        };
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setRootVisible(false);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.setSelectionMode(0);
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        jPanel.add((Component)new JScrollPane((Component)this.a), "grow");
        this.add((Component)this.b(), "South");
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(""));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.setActionCommand(POSConstants.ADD);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (POSConstants.ADD.equals(string)) {
                    ComboGroupTreeExplorer.this.addNewComboGroup();
                } else if (POSConstants.EDIT.equals(string)) {
                    ComboGroupTreeExplorer.this.editComboGroup();
                } else if (POSConstants.DELETE.equals(string)) {
                    ComboGroupTreeExplorer.this.deleteComboGroup();
                }
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        jButton3.addActionListener(actionListener);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    protected void addNewComboGroup() {
        try {
            ComboGroup comboGroup3;
            ComboGroup comboGroup2 = new ComboGroup();
            ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.b, comboGroup2);
            comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
            comboGroupItemSelectionDialog.open();
            if (comboGroupItemSelectionDialog.isCanceled()) {
                return;
            }
            if (this.c == null) {
                this.c = new ArrayList<ComboGroup>();
            }
            if (this.c.size() > 0) {
                for (ComboGroup comboGroup3 : this.c) {
                    if (!this.a(comboGroup3, comboGroup2.getItems())) continue;
                    return;
                }
            }
            this.c.add(comboGroup2);
            MutableTreeTableNode mutableTreeTableNode = (MutableTreeTableNode)this.d.getRoot();
            comboGroup3 = new DefaultMutableTreeTableNode((Object)comboGroup2);
            this.a((DefaultMutableTreeTableNode)comboGroup3);
            this.d.insertNodeInto((MutableTreeTableNode)comboGroup3, mutableTreeTableNode, mutableTreeTableNode.getChildCount());
            this.a.expandAll();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a(ComboGroup comboGroup, List<MenuItem> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        List<MenuItem> list2 = comboGroup.getItems();
        if (list2 == null || list2.isEmpty()) {
            return false;
        }
        for (MenuItem menuItem : list2) {
            if (menuItem == null || StringUtils.isEmpty((CharSequence)menuItem.getId())) continue;
            for (MenuItem menuItem2 : list) {
                if (menuItem2 == null || !StringUtils.isNotEmpty((CharSequence)menuItem2.getId()) || !menuItem.getId().equals(menuItem2.getId())) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.18"));
                return true;
            }
        }
        return false;
    }

    protected void editComboGroup() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
                ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.b, comboGroup, true);
                comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
                comboGroupItemSelectionDialog.open();
                if (comboGroupItemSelectionDialog.isCanceled()) {
                    return;
                }
                if (this.c != null && this.c.size() > 0) {
                    for (ComboGroup comboGroup2 : this.c) {
                        if (comboGroup2.getId().equals(comboGroup.getId()) || !this.a(comboGroup2, comboGroup.getItems())) continue;
                        return;
                    }
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.b, comboGroup, true);
                comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
                comboGroupItemSelectionDialog.open();
                if (comboGroupItemSelectionDialog.isCanceled()) {
                    return;
                }
            }
            this.c();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE);
        }
    }

    protected void deleteComboGroup() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            TreePath treePath = this.a.getPathForRow(n);
            DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)treePath.getLastPathComponent();
            if (ConfirmDeleteDialog.showMessage(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
                MutableTreeTableNode mutableTreeTableNode = this.findTreeNodeForTree((MutableTreeTableNode)this.d.getRoot(), comboGroup.getId());
                if (mutableTreeTableNode.getParent() != null) {
                    this.c.remove(comboGroup);
                    this.d.removeNodeFromParent(mutableTreeTableNode);
                }
            } else if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
                TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                if (comboGroup != null) {
                    comboGroup.getItems().remove(menuItem);
                    this.c();
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE);
        }
    }

    public MutableTreeTableNode findTreeNodeForTree(MutableTreeTableNode mutableTreeTableNode, String string) {
        if (((DefaultMutableTreeTableNode)mutableTreeTableNode).getUserObject() instanceof ComboGroup) {
            ComboGroup comboGroup = (ComboGroup)mutableTreeTableNode.getUserObject();
            if (string.equals(comboGroup.getId())) {
                return mutableTreeTableNode;
            }
            Enumeration enumeration = mutableTreeTableNode.children();
            while (enumeration.hasMoreElements()) {
                MutableTreeTableNode mutableTreeTableNode2 = (MutableTreeTableNode)enumeration.nextElement();
                MutableTreeTableNode mutableTreeTableNode3 = this.findTreeNodeForTree(mutableTreeTableNode2, string);
                if (mutableTreeTableNode3 == null) continue;
                return mutableTreeTableNode3;
            }
        }
        return null;
    }

    private void c() throws Exception {
        this.a.removeAll();
        ComboGroup comboGroup = new ComboGroup();
        comboGroup.setId("0");
        comboGroup.setName("Root");
        this.e = new DefaultMutableTreeTableNode((Object)comboGroup);
        this.e.setUserObject((Object)comboGroup);
        if (this.c != null) {
            for (ComboGroup serializable2 : this.c) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = new DefaultMutableTreeTableNode((Object)serializable2);
                this.e.add((MutableTreeTableNode)defaultMutableTreeTableNode);
                this.a(defaultMutableTreeTableNode);
            }
        }
        this.d = new ComboGroupTreeTableModel(this.e);
        this.a.setTreeTableModel((TreeTableModel)this.d);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleTextField);
        defaultCellEditor.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(4), (TableCellEditor)defaultCellEditor);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.expandAll();
    }

    private void a(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
        ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
        if (comboGroup == null) {
            return;
        }
        defaultMutableTreeTableNode.setAllowsChildren(true);
        List<MenuItem> list = comboGroup.getItems();
        for (MenuItem menuItem : list) {
            DefaultMutableTreeTableNode defaultMutableTreeTableNode2 = new DefaultMutableTreeTableNode((Object)menuItem);
            defaultMutableTreeTableNode.add((MutableTreeTableNode)defaultMutableTreeTableNode2);
        }
    }

    public void setComboGroups(List<ComboGroup> list) {
        try {
            this.c = list;
            this.c();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public void setMenuItem(MenuItem menuItem) {
        this.b = menuItem;
        this.setComboGroups(menuItem.getComboGroups());
    }

    public List<ComboGroup> getGroups() {
        return this.c;
    }

    class ComboGroupTreeTableModel
    extends DefaultTreeTableModel {
        String a;
        private final String[] c;

        public ComboGroupTreeTableModel(DefaultMutableTreeTableNode defaultMutableTreeTableNode) {
            super((TreeTableNode)defaultMutableTreeTableNode);
            this.a = " (" + CurrencyUtil.getCurrencySymbol() + ")";
            this.c = new String[]{Messages.getString("ComboGroupTreeExplorer.0"), Messages.getString("ComboGroupTreeExplorer.1"), Messages.getString("ComboGroupTreeExplorer.2"), Messages.getString("ComboGroupTreeExplorer.4"), Messages.getString("ComboGroupTreeExplorer.5") + this.a, Messages.getString("ComboGroupTreeExplorer.13") + this.a};
        }

        public void setRoot(TreeTableNode treeTableNode) {
            super.setRoot(treeTableNode);
        }

        public int getColumnCount() {
            return this.c.length;
        }

        public String getColumnName(int n) {
            return this.c[n];
        }

        public boolean isCellEditable(Object object, int n) {
            if (object instanceof DefaultMutableTreeTableNode) {
                if (((DefaultMutableTreeTableNode)object).getUserObject() instanceof ComboGroup) {
                    if (n == 5) {
                        return false;
                    }
                } else if (((DefaultMutableTreeTableNode)object).getUserObject() instanceof MenuItem && n == 5) {
                    return true;
                }
            }
            return false;
        }

        public Object getValueAt(Object object, int n) {
            if (object instanceof DefaultMutableTreeTableNode) {
                DefaultMutableTreeTableNode defaultMutableTreeTableNode = (DefaultMutableTreeTableNode)object;
                if (defaultMutableTreeTableNode.getUserObject() instanceof ComboGroup) {
                    ComboGroup comboGroup = (ComboGroup)defaultMutableTreeTableNode.getUserObject();
                    if (comboGroup == null) {
                        return "";
                    }
                    switch (n) {
                        case 0: {
                            return comboGroup.getName();
                        }
                        case 2: {
                            return comboGroup.getMinQuantity();
                        }
                        case 3: {
                            return comboGroup.getMaxQuantity();
                        }
                    }
                } else if (defaultMutableTreeTableNode.getUserObject() instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)defaultMutableTreeTableNode.getUserObject();
                    if (menuItem == null) {
                        return "";
                    }
                    switch (n) {
                        case 1: {
                            return menuItem.getName();
                        }
                        case 4: {
                            return menuItem.getPrice();
                        }
                        case 5: {
                            TreeTableNode treeTableNode = defaultMutableTreeTableNode.getParent();
                            if (treeTableNode.getUserObject() instanceof ComboGroup) {
                                ComboGroup comboGroup = (ComboGroup)treeTableNode.getUserObject();
                                double d = comboGroup.getItemPrice(menuItem.getId());
                                return NumberUtil.roundToTwoDigit(d);
                            }
                            return NumberUtil.roundToTwoDigit(0.0);
                        }
                    }
                }
            }
            return null;
        }
    }
}

