/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config;

import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.PosGiftCardPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.util.AESencrp;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GiftCardConfig {
    private static final String a = "GiftCardMerchantPass";
    private static final String b = "GiftCardMerchantAccount";
    private static final String c = "CARD_READER";

    public static boolean isSwipeCardSupported() {
        return AppConfig.getBoolean("support-swipe-card", true);
    }

    public static void setSwipeCardSupported(boolean bl) {
        AppConfig.put("support-swipe-card", bl);
    }

    public static boolean isManualEntrySupported() {
        return AppConfig.getBoolean("support-card-manual-entry", true);
    }

    public static void setManualEntrySupported(boolean bl) {
        AppConfig.put("support-card-manual-entry", bl);
    }

    public static boolean isExtTerminalSupported() {
        return AppConfig.getBoolean("support-ext-terminal", true);
    }

    public static void setExtTerminalSupported(boolean bl) {
        AppConfig.put("support-ext-terminal", bl);
    }

    public static void setCardReader(CardReader cardReader) {
        if (cardReader == null) {
            AppConfig.put(c, "");
            return;
        }
        AppConfig.put(c, cardReader.name());
    }

    public static CardReader getCardReader() {
        String string = AppConfig.getString(c, "SWIPE");
        return CardReader.fromString(string);
    }

    public static void setMerchantAccount(String string) {
        AppConfig.put(b, string);
    }

    public static String getMerchantAccount() {
        return AppConfig.getString(b, null);
    }

    public static void setMerchantPass(String string) {
        try {
            if (StringUtils.isEmpty((String)string)) {
                AppConfig.put(a, "");
                return;
            }
            AppConfig.put(a, AESencrp.encrypt(string));
        }
        catch (Exception exception) {
            PosLog.error(GiftCardConfig.class, exception);
        }
    }

    public static String getMerchantPass() throws Exception {
        String string = AppConfig.getString(a);
        try {
            if (StringUtils.isNotEmpty((String)string)) {
                return AESencrp.decrypt(string);
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }

    public static void setPaymentGateway(GiftCardPaymentPlugin giftCardPaymentPlugin) {
        AppConfig.put("payment-gateway-id", giftCardPaymentPlugin.getId());
    }

    public static GiftCardPaymentPlugin getPaymentGateway() {
        String string = AppConfig.getString("payment-gateway-id", PosGiftCardPlugin.ID);
        List<FloreantPlugin> list = ExtensionManager.getPlugins(GiftCardPaymentPlugin.class);
        for (FloreantPlugin floreantPlugin : list) {
            if (!string.equals(floreantPlugin.getId())) continue;
            return (GiftCardPaymentPlugin)floreantPlugin;
        }
        return new PosGiftCardPlugin();
    }
}

