/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseBookingInfo;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import liquibase.util.StringUtils;
import org.apache.commons.lang.SerializationUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"userName", "customer", "user"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class BookingInfo
extends BaseBookingInfo
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String STATUS_CANCEL = "cancel";
    public static final String STATUS_CLOSE = "close";
    public static final String STATUS_NO_APR = "no appear";
    public static final String STATUS_SEAT = "seat";
    public static final String STATUS_DELAY = "delay";
    public static final String STATUS_OPEN = "open";
    public static final String STATUS_CONFIRM = "confirm";
    public static final String STATUS_EXPIRED = "expired";
    private transient JsonObject propertiesContainer;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    @XmlTransient
    private String customerName;
    @XmlTransient
    private String customerPhone;
    @XmlTransient
    private String bookedTableNumbers;
    @XmlTransient
    private Customer customer;
    @XmlTransient
    private User user;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public BookingInfo() {
    }

    public BookingInfo(String string) {
        super(string);
    }

    @Override
    public String toString() {
        return this.getId().toString();
    }

    public void setUser(User user) {
        this.setUserId(user == null ? null : user.getId());
        this.user = user;
    }

    public User getUser() {
        String string = this.getUserId();
        if (string == null) {
            return null;
        }
        if (this.user != null && string.equals(this.user.getId())) {
            return this.user;
        }
        return DataProvider.get().getUserById(string);
    }

    public void setCustomer(Customer customer) {
        if (customer == null) {
            this.setCustomerId(null);
        } else {
            this.setCustomerId(customer.getId());
        }
        this.customer = customer;
    }

    @XmlTransient
    public Customer getCustomer() {
        String string = this.getCustomerId();
        if (string == null) {
            return null;
        }
        if (this.customer != null && string.equals(this.customer.getId())) {
            return this.customer;
        }
        return DataProvider.get().getCustomer(string);
    }

    public String getCustomerName() {
        Customer customer = this.getCustomer();
        if (customer == null) {
            return this.customerName;
        }
        if (StringUtils.isNotEmpty((String)customer.getFirstName())) {
            this.customerName = customer.getFirstName() + " ";
        }
        if (StringUtils.isNotEmpty((String)customer.getLastName())) {
            this.customerName = this.customerName + customer.getLastName();
        }
        return this.customerName;
    }

    public void setCustomerName(String string) {
        this.customerName = string;
    }

    public String getCustomerPhone() {
        Customer customer = this.getCustomer();
        if (customer == null) {
            return this.customerPhone;
        }
        if (StringUtils.isNotEmpty((String)customer.getMobileNo())) {
            this.customerPhone = customer.getMobileNo() + " ";
        }
        return this.customerPhone;
    }

    public void setCustomerPhone(String string) {
        this.customerPhone = string;
    }

    public String getBookedTableNumbers() {
        if (this.bookedTableNumbers != null) {
            return this.bookedTableNumbers;
        }
        List<ShopTable> list = this.getTables();
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string = "";
        Iterator<ShopTable> iterator = list.iterator();
        while (iterator.hasNext()) {
            ShopTable shopTable = iterator.next();
            string = string + shopTable.getTableNumber();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string;
    }

    public void setBookedTableNumbers(String string) {
        this.bookedTableNumbers = string;
    }

    public BookingInfo clone(BookingInfo bookingInfo) {
        return (BookingInfo)SerializationUtils.clone((Serializable)bookingInfo);
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
    }

    public String getProperty(String string) {
        JsonElement jsonElement;
        if (this.propertiesContainer == null) {
            return null;
        }
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    public void removeProperty(String string) {
        if (this.propertiesContainer != null) {
            this.propertiesContainer.remove(string);
        }
    }
}

