/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.dao.BaseCustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PaginationSupport;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CustomerDAO
extends BaseCustomerDAO {
    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)Customer.PROP_ID);
    }

    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByMobileLoyalityName(String string, PaginatedTableModel paginatedTableModel) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_MOBILE_NO, (String)string, (MatchMode)MatchMode.ANYWHERE));
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE));
                disjunction.add((Criterion)Restrictions.like((String)Customer.PROP_EMAIL, (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            criteria.add((Criterion)disjunction);
            criteria.setFirstResult(0);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            paginatedTableModel.setNumRows(paginatedTableModel.getPageSize());
            paginatedTableModel.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(String string) {
        Session session;
        block5: {
            Criteria criteria;
            block4: {
                int n;
                session = null;
                criteria = null;
                try {
                    if (!StringUtils.isEmpty((String)string)) break block4;
                    n = 0;
                }
                catch (Throwable throwable) {
                    this.closeSession(session);
                    throw throwable;
                }
                this.closeSession(session);
                return n;
            }
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + string + "%")));
            disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + string + "%")));
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list == null) break block5;
            int n = list.size();
            this.closeSession(session);
            return n;
        }
        int n = 0;
        this.closeSession(session);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(String string, String string2, String string3) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + string + "%")));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (Object)("%" + string2 + "%")));
            }
            if (StringUtils.isNotEmpty((String)string3)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + string3 + "%")));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            if (list != null) {
                int n = list.size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findBy(String string, String string2, String string3) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (Object)("%" + string + "%")));
            }
            if (StringUtils.isNotEmpty((String)string2)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_LOYALTY_NO, (Object)("%" + string2 + "%")));
            }
            if (StringUtils.isNotEmpty((String)string3)) {
                disjunction.add(Restrictions.ilike((String)Customer.PROP_NAME, (Object)("%" + string3 + "%")));
            }
            criteria.add((Criterion)disjunction);
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public void findBy(String string, PaginationSupport paginationSupport) {
        this.findByPhoneOrName(string, paginationSupport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByPhoneOrName(String string, PaginationSupport paginationSupport) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_MOBILE_NO, (String)string, (MatchMode)MatchMode.ANYWHERE)));
            }
            criteria.add((Criterion)disjunction);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            paginationSupport.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(paginationSupport.getCurrentRowIndex());
            criteria.setMaxResults(paginationSupport.getPageSize());
            criteria.addOrder(Order.asc((String)Customer.PROP_FIRST_NAME).ignoreCase());
            paginationSupport.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findByMobileNumber(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_MOBILE_NO, (Object)string));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Customer> findByName(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)Customer.PROP_FIRST_NAME, (String)(string + "%".trim()), (MatchMode)MatchMode.ANYWHERE));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findByNameOrEmail(Pagination pagination, String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Disjunction disjunction = Restrictions.disjunction();
            if (StringUtils.isNotEmpty((String)string)) {
                disjunction.add((Criterion)Restrictions.or((Criterion)Restrictions.ilike((String)Customer.PROP_NAME, (String)string, (MatchMode)MatchMode.ANYWHERE), (Criterion)Restrictions.ilike((String)Customer.PROP_EMAIL, (String)string, (MatchMode)MatchMode.ANYWHERE)));
            }
            criteria.add((Criterion)disjunction);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            pagination.setNumRows(number.intValue());
            criteria.setProjection(null);
            criteria.setFirstResult(pagination.getCurrentRowIndex());
            criteria.setMaxResults(pagination.getPageSize());
            pagination.setRows(criteria.list());
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer findById(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_ID, (Object)string));
            Customer customer = (Customer)criteria.uniqueResult();
            return customer;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer findByPhoneOrEmail(String string, String string2) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)string2));
            } else {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)Customer.PROP_MOBILE_NO, (Object)string), (Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)string2)));
            }
            List list = criteria.list();
            if (list.size() > 0) {
                Customer customer = (Customer)list.get(0);
                return customer;
            }
            Customer customer = null;
            return customer;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    public boolean deleteAll(List<Customer> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            String string = "update DELIVERY_ADDRESS set CUSTOMER_ID = null";
            String string2 = "update TABLE_BOOKING_INFO set customer_id = null";
            String string3 = "update TICKET_ITEM_SEAT set MEMBER_ID = null";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            SQLQuery sQLQuery2 = session.createSQLQuery(string2);
            SQLQuery sQLQuery3 = session.createSQLQuery(string3);
            sQLQuery.executeUpdate();
            sQLQuery2.executeUpdate();
            sQLQuery3.executeUpdate();
            for (Customer customer : list) {
                session.delete((Object)customer);
            }
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(CustomerDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.list();
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfCustomers(CustomerGroup customerGroup) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "customer");
            criteria.setProjection(Projections.rowCount());
            if (customerGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_CUSTOMER_GROUP_ID, (Object)customerGroup.getId()));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(PaginatedTableModel paginatedTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            criteria.addOrder(Order.asc((String)Customer.PROP_FIRST_NAME).ignoreCase());
            paginatedTableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(CustomerGroup customerGroup, PaginatedListModel paginatedListModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass(), "customer");
            criteria.addOrder(Order.asc((String)Customer.PROP_NAME).ignoreCase());
            if (customerGroup != null) {
                criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_CUSTOMER_GROUP_ID, (Object)customerGroup.getId()));
            }
            criteria.setFirstResult(paginatedListModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedListModel.getPageSize());
            paginatedListModel.setData(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            Number number;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)MenuModifier.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                int n = number.intValue();
                return n;
            }
        }
        finally {
            this.closeSession(session);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCustomers(String string, BeanTableModel<Customer> beanTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)Customer.PROP_NAME).ignoreCase());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add(Restrictions.ilike((String)Customer.PROP_NAME, (String)string, (MatchMode)MatchMode.START));
            }
            criteria.setFirstResult(beanTableModel.getCurrentRowIndex());
            criteria.setMaxResults(beanTableModel.getPageSize());
            beanTableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Customer initialize(Customer customer) {
        if (customer == null || customer.getId() == null) {
            return customer;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)customer);
            Hibernate.initialize(customer.getDeliveryAddresses());
            Hibernate.initialize(customer.getDeliveryInstructions());
            Customer customer2 = customer;
            return customer2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateCustomers(List<Customer> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Customer customer : list) {
                Customer customer2 = this.findById(customer.getId());
                if (customer2 == null) {
                    customer.setUpdateLastUpdateTime(bl);
                    customer.setUpdateSyncTime(bl2);
                    this.save(customer, session);
                    continue;
                }
                if (!BaseDataServiceDao.get().shouldSave(customer.getLastUpdateTime(), customer2.getLastUpdateTime())) {
                    PosLog.info(this.getClass(), customer.getName() + " already updated");
                    continue;
                }
                String string = customer2.getId();
                long l = customer2.getVersion();
                PropertyUtils.copyProperties((Object)customer2, (Object)customer);
                customer2.setId(string);
                customer2.setVersion(l);
                customer2.setUpdateLastUpdateTime(bl);
                customer2.setUpdateSyncTime(bl2);
                this.update(customer2, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public Customer findByEmail(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)string));
            List list = criteria.list();
            if (list != null && list.size() > 0) {
                Customer customer = (Customer)list.get(0);
                return customer;
            }
            Customer customer = null;
            return customer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExist(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)string));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmailExistExceptCustomer(String string, Customer customer) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Customer.PROP_EMAIL, (Object)string));
            criteria.add((Criterion)Restrictions.ne((String)Customer.PROP_ID, (Object)customer.getId()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }
}

