/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.BaseMultiplierDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class MultiplierDAO
extends BaseMultiplierDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    public List<Multiplier> findAll() {
        try {
            Session session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)Multiplier.PROP_SORT_ORDER));
            return criteria.list();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdateMultipliers(List<Multiplier> list) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Multiplier multiplier : list) {
                session.saveOrUpdate((Object)multiplier);
            }
            transaction.commit();
        }
    }

    public Multiplier getDefaultMutltiplier() {
        try {
            Session session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_DEFAULT_MULTIPLIER, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list != null && !list.isEmpty()) {
                return (Multiplier)list.get(0);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nameExists(String string) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Multiplier.PROP_ID, (Object)string).ignoreCase());
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = number.intValue() > 0;
            return bl;
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMultiplier(Multiplier multiplier) {
        Transaction transaction = null;
        try (Session session = null;){
            session = this.createNewSession();
            transaction = session.beginTransaction();
            String string = "delete from MODIFIER_MULTIPLIER_PRICE where MULTIPLIER_ID='%s'";
            string = String.format(string, multiplier.getId());
            SQLQuery sQLQuery = session.createSQLQuery(string);
            sQLQuery.executeUpdate();
            session.delete((Object)multiplier);
            transaction.commit();
        }
    }

    public void saveOrUpdateMultiplierList(List<Multiplier> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Multiplier multiplier : list) {
                Multiplier multiplier2 = this.get(multiplier.getId());
                if (multiplier2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(multiplier.getLastUpdateTime(), multiplier2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), multiplier.getId() + " already updated");
                        continue;
                    }
                    long l = multiplier2.getVersion();
                    PropertyUtils.copyProperties((Object)multiplier2, (Object)multiplier);
                    multiplier2.setVersion(l);
                    multiplier2.setUpdateLastUpdateTime(bl);
                    multiplier2.setUpdateSyncTime(bl2);
                    this.update(multiplier2, session);
                    continue;
                }
                multiplier.setUpdateLastUpdateTime(bl);
                multiplier.setUpdateSyncTime(bl2);
                this.save(multiplier, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

