/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.BaseTicketItemDAO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.AggregateProjection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class TicketItemDAO
extends BaseTicketItemDAO {
    public boolean deleteTicketItemWithTicket(Integer n) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(TicketItem.class);
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_MENU_ITEM_ID, (Object)n));
            List list = criteria.list();
            if (list == null || list.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            for (TicketItem ticketItem : list) {
                ticketItem.setTicket(null);
                super.delete(ticketItem, session);
            }
            boolean bl = true;
            return bl;
        }
    }

    public Double getItemsCountWithinHour(Session session, Integer n) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            calendar.add(10, -(n == null ? 24 : n));
            Date date2 = calendar.getTime();
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date2, (Object)date));
            criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            AggregateProjection aggregateProjection = Projections.sum((String)TicketItem.PROP_QUANTITY);
            projectionList.add((Projection)aggregateProjection);
            criteria.setProjection((Projection)projectionList);
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                return number.doubleValue();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        return 0.0;
    }

    public List<TicketItem> findTicketItemWithinDate(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl) {
        try (Session session = this.createNewSession();){
            List list2;
            MenuGroup menuGroup2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null) {
                for (MenuGroup menuGroup2 : list) {
                    arrayList.add(menuGroup2.getId());
                }
            }
            Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date, (Object)date2));
            criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_TERMINAL_ID), (Object)terminal.getId()));
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)TicketItem.PROP_GROUP_ID, arrayList));
            }
            if (bl != null) {
                criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_INVENTORY_ITEM, (Object)bl));
            }
            menuGroup2 = Projections.projectionList();
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_NAME), TicketItem.PROP_NAME);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_UNIT_NAME), TicketItem.PROP_UNIT_NAME);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_UNIT_PRICE), TicketItem.PROP_UNIT_PRICE);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_UNIT_PRICE), TicketItem.PROP_ADJUSTED_UNIT_PRICE);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_UNIT_COST), TicketItem.PROP_UNIT_COST);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_GROUP_NAME), TicketItem.PROP_GROUP_NAME);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_MENU_ITEM_ID), TicketItem.PROP_MENU_ITEM_ID);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_QUANTITY), TicketItem.PROP_QUANTITY);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_SERVICE_CHARGE), TicketItem.PROP_SERVICE_CHARGE);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_DISCOUNT), TicketItem.PROP_ADJUSTED_DISCOUNT);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS), TicketItem.PROP_ADJUSTED_DISCOUNT_WITHOUT_MODIFIERS);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS), TicketItem.PROP_ADJUSTED_SUBTOTAL_WITHOUT_MODIFIERS);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_SUBTOTAL), TicketItem.PROP_ADJUSTED_SUBTOTAL);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_TOTAL_WITHOUT_MODIFIERS), TicketItem.PROP_ADJUSTED_TOTAL_WITHOUT_MODIFIERS);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_TOTAL), TicketItem.PROP_ADJUSTED_TOTAL);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_TAX), TicketItem.PROP_ADJUSTED_TAX);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_ADJUSTED_TAX_WITHOUT_MODIFIERS), TicketItem.PROP_ADJUSTED_TAX_WITHOUT_MODIFIERS);
            menuGroup2.add((Projection)Projections.property((String)TicketItem.PROP_TAX_INCLUDED), TicketItem.PROP_TAX_INCLUDED);
            criteria.setProjection((Projection)menuGroup2);
            criteria.setResultTransformer(Transformers.aliasToBean(TicketItem.class));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_GROUP_NAME));
            criteria.addOrder(Order.asc((String)TicketItem.PROP_NAME));
            List list3 = list2 = criteria.list();
            return list3;
        }
    }

    public List<TicketItemModifier> findTicketItemModifierWithinDate(Date date, Date date2, Terminal terminal, List<MenuGroup> list, Boolean bl) {
        try (Session session = this.createNewSession();){
            List list2;
            MenuGroup menuGroup2;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null) {
                for (MenuGroup menuGroup2 : list) {
                    arrayList.add(menuGroup2.getId());
                }
            }
            Criteria criteria = session.createCriteria(TicketItemModifier.class).createAlias(TicketItemModifier.PROP_TICKET_ITEM, "ticketItem").createAlias("ticketItem." + TicketItem.PROP_TICKET, "ticket");
            criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date, (Object)date2));
            if (bl != null) {
                criteria.add((Criterion)Restrictions.eq((String)("ticketItem." + TicketItem.PROP_INVENTORY_ITEM), (Object)bl));
            }
            if (!arrayList.isEmpty()) {
                criteria.add(Restrictions.in((String)("ticketItem." + TicketItem.PROP_GROUP_ID), arrayList));
            }
            menuGroup2 = Projections.projectionList();
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ITEM_ID), TicketItemModifier.PROP_ITEM_ID);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_NAME), TicketItemModifier.PROP_NAME);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_MODIFIER_TYPE), TicketItemModifier.PROP_MODIFIER_TYPE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_UNIT_PRICE), TicketItemModifier.PROP_UNIT_PRICE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ITEM_QUANTITY), TicketItemModifier.PROP_ITEM_QUANTITY);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_SERVICE_CHARGE), TicketItemModifier.PROP_SERVICE_CHARGE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE), TicketItemModifier.PROP_ADJUSTED_UNIT_PRICE);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_DISCOUNT), TicketItemModifier.PROP_ADJUSTED_DISCOUNT);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_SUBTOTAL), TicketItemModifier.PROP_ADJUSTED_SUBTOTAL);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_TOTAL), TicketItemModifier.PROP_ADJUSTED_TOTAL);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_ADJUSTED_TAX), TicketItemModifier.PROP_ADJUSTED_TAX);
            menuGroup2.add((Projection)Projections.property((String)TicketItemModifier.PROP_TAX_INCLUDED), TicketItemModifier.PROP_TAX_INCLUDED);
            menuGroup2.add((Projection)Projections.property((String)("ticketItem." + TicketItem.PROP_QUANTITY)), "ticketItemQuantity");
            criteria.setProjection((Projection)menuGroup2);
            criteria.setResultTransformer(Transformers.aliasToBean(TicketItemModifier.class));
            criteria.addOrder(Order.asc((String)TicketItemModifier.PROP_NAME));
            List list3 = list2 = criteria.list();
            return list3;
        }
    }

    public List<TicketItem> findTicketItemWithinDateForDashboard(Date date, Date date2, Integer n, Boolean bl, Session session) {
        Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "ticket");
        criteria.add(Restrictions.between((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date, (Object)date2));
        criteria.add(Restrictions.eqOrIsNull((String)TicketItem.PROP_VOIDED, (Object)false));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)TicketItem.PROP_NAME), TicketItem.PROP_NAME);
        projectionList.add((Projection)Projections.property((String)TicketItem.PROP_QUANTITY), TicketItem.PROP_QUANTITY);
        criteria.setProjection((Projection)projectionList);
        criteria.setMaxResults(n == null ? 20 : n);
        criteria.setResultTransformer(Transformers.aliasToBean(TicketItem.class));
        if (bl != null) {
            if (bl.booleanValue()) {
                criteria.addOrder(Order.asc((String)TicketItem.PROP_QUANTITY));
            } else {
                criteria.addOrder(Order.desc((String)TicketItem.PROP_QUANTITY));
            }
        }
        return criteria.list();
    }
}

