/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.util;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DateUtil {
    private static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("hh:mm a");
    private static final SimpleDateFormat giftCardDateFormat = new SimpleDateFormat("MM/dd/YYYY");
    private static final DateFormat localeFormat = DateFormat.getDateInstance(3);
    private static SimpleDateFormat monthDateFormat = new SimpleDateFormat("MMM dd");

    public static String formatDateAsLocale(Date date) {
        String string = localeFormat.format(date);
        return string;
    }

    public static String formatReportDateAsString(Date date) {
        return DateUtil.formatDateWithTime(date);
    }

    public static String formatDateAsString(Date date) {
        return DateUtil.formatDateWithTime(date);
    }

    public static String formatDateAsUTCString(Date date) {
        String string = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " hh:mm a");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(date);
    }

    public static Date parseByFullDate(String string) throws Exception {
        return DateUtil.formatDateWithTimeAndSec(string);
    }

    public static String formatFullDateAsString(Date date) {
        return DateUtil.formatDate(date);
    }

    public static Date parseBySortDate(String string) throws Exception {
        return DateUtil.formatDate(string);
    }

    public static Date startOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date == null ? new Date() : date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date startOfDayInUTC(Date date) {
        return DateUtil.toUTC(DateUtil.startOfDay(date));
    }

    public static Date endOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date == null ? new Date() : date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfDayInUTC(Date date) {
        return DateUtil.toUTC(DateUtil.endOfDay(date));
    }

    public static Date toUTC(Date date) {
        int n = TimeZone.getDefault().getRawOffset();
        return new Date(date.getTime() - (long)n);
    }

    public static Date startOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(5, 1);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(5, calendar.getActualMaximum(5));
        return new Date(calendar.getTimeInMillis());
    }

    public static Date copyTime(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        calendar.setTime(date);
        calendar.set(11, n);
        calendar.set(12, n2);
        return calendar.getTime();
    }

    public static boolean between(Date date, Date date2, Date date3) {
        if (date == null || date2 == null) {
            return false;
        }
        return !(!date3.equals(date) && !date3.after(date) || !date3.equals(date2) && !date3.before(date2));
    }

    public static String formatSmall(Date date) {
        return DateUtil.formatDate(date);
    }

    public static String getReportDate() {
        return DateUtil.formatDateWithTimeAndSec(new Date());
    }

    public static boolean isToday(Date date) {
        return DateUtil.isSameDay(date, Calendar.getInstance().getTime());
    }

    public static boolean isToday(Calendar calendar) {
        return DateUtil.isSameDay(calendar, Calendar.getInstance());
    }

    public static String formatAsTodayDate(Date date) {
        String string = dateFormat1.format(date);
        return Messages.getString("DateUtil.2") + " " + string;
    }

    public static String formatFullDateAndTimeAsString(Date date) {
        String string = date == null ? "" : DateUtil.formatDateWithTimeAndSec(date);
        return string;
    }

    public static String formatFullDateAndTimeWithoutYearAsString(Date date) {
        return DateUtil.formatDateWithTimeAndSec(date);
    }

    public static boolean isSameDay(Date date, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtil.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static String getOnlyFormattedTime(Date date) {
        String string = dateFormat1.format(date);
        return string;
    }

    public static String getOnlyFormattedDate(Date date) {
        return DateUtil.formatDateWithTime(date);
    }

    public static String getElapsedTime(Date date, Date date2) {
        DateTime dateTime = new DateTime((Object)date);
        DateTime dateTime2 = new DateTime((Object)date2);
        Interval interval = new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
        long l = interval.toDuration().getStandardDays();
        long l2 = interval.toDuration().getStandardHours();
        long l3 = interval.toDuration().getStandardMinutes();
        long l4 = interval.toDuration().getStandardSeconds();
        String string = l + "d, ";
        String string2 = (l2 %= 24L) + "hr, ";
        String string3 = (l3 %= 60L) + "mn";
        String string4 = (l4 %= 60L) + "secs";
        String string5 = "";
        String string6 = string + string2 + string3 + string5;
        String string7 = string2 + string3 + string5;
        String string8 = string3 + string5;
        String string9 = string4 + string5;
        if (l != 0L) {
            return string6;
        }
        if (l2 != 0L) {
            return string7;
        }
        if (l3 != 0L) {
            return string8;
        }
        if (l4 != 0L) {
            return string9;
        }
        return "not printed yet";
    }

    public static Calendar getLocalTimeCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getServerTimeCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(StoreDAO.getServerTimestamp());
        return calendar;
    }

    public static Date getGmtTime() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT")).getTime();
    }

    public static Calendar getGmtCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public static String getStoreDateFormat() {
        Store store = DataProvider.get().getStore();
        return store.getDateFormat();
    }

    public static SimpleDateFormat getSimpleDateFormat() {
        Store store = DataProvider.get().getStore();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(store.getDateFormat());
        return simpleDateFormat;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = DateUtil.getSimpleDateFormat();
        return simpleDateFormat.format(date);
    }

    public static Date formatDate(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = DateUtil.getSimpleDateFormat();
        return simpleDateFormat.parse(string);
    }

    public static String parseStringDateToString(String string, String string2) throws Exception {
        String string3 = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string);
        Date date = simpleDateFormat2.parse(string2);
        return simpleDateFormat.format(date);
    }

    public static String formatDateWithTime(Date date) {
        String string = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " hh:mm a");
        return simpleDateFormat.format(date);
    }

    public static Date formatDateWithTime(String string) throws ParseException {
        String string2 = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2 + " hh:mm a");
        return simpleDateFormat.parse(string);
    }

    public static String formatDateWithTimeAndSec(Date date) {
        String string = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " hh:mm:ss a");
        return simpleDateFormat.format(date);
    }

    public static Date formatDateWithTimeAndSec(String string) throws ParseException {
        String string2 = DateUtil.getStoreDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2 + " hh:mm:ss a");
        return simpleDateFormat.parse(string);
    }

    public static Date formatDateWithDefaultTimeAndSec(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yy hh:mm:ss a");
        return simpleDateFormat.parse(string);
    }

    public static String formatDateWithDefaultTimeAndSec(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yy hh:mm:ss a");
        return simpleDateFormat.format(date);
    }

    public static String formatAsDefaultMonthDate(Date date) {
        return monthDateFormat.format(date);
    }

    public static String formatAsGiftCardDateFormat(Date date) {
        return giftCardDateFormat.format(date);
    }

    public static Date parseByGiftCardDateFormat(String string) throws ParseException {
        return giftCardDateFormat.parse(string);
    }

    public static String formatDateWithBrowserTimeOffset(Date date, int n) {
        String string = DataProvider.get().getStore().getDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string + " hh:mm:ss a");
        if (n == 0) {
            return simpleDateFormat.format(date);
        }
        String[] stringArray = TimeZone.getAvailableIDs(n);
        String string2 = null;
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if (StringUtils.isNotEmpty(string2)) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string2));
        }
        return simpleDateFormat.format(date);
    }

    public static Date formatDateWithBrowserTimeOffset(String string, int n) {
        try {
            String string2 = DataProvider.get().getStore().getDateFormat();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2 + " hh:mm:ss a");
            if (n == 0) {
                return simpleDateFormat.parse(string);
            }
            String[] stringArray = TimeZone.getAvailableIDs(n);
            String string3 = null;
            if (stringArray.length > 0) {
                string3 = stringArray[0];
            }
            if (StringUtils.isNotEmpty(string3)) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            PosLog.error(DateUtil.class, exception);
            return null;
        }
    }

    public static String formatDateWithBrowserTimeOffsetWithoutSec(Date date, int n) {
        String string = DataProvider.get().getStore().getDateFormat();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        if (n == 0) {
            return simpleDateFormat.format(date);
        }
        String[] stringArray = TimeZone.getAvailableIDs(n);
        String string2 = null;
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if (StringUtils.isNotEmpty(string2)) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string2));
        }
        return simpleDateFormat.format(date);
    }
}

