/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CardReportModel
extends ListTableModel<PosTransaction> {
    public CardReportModel(List<PosTransaction> list) {
        super(new String[]{"ticketId", "paymentType", "cardType", "member", "cardReader", "date", "server", "authCode", "tips", "total", "tenderAmount", "transactionType", "customPaymentName", "customPaymentRef", "customPaymentFieldName", "captured", "authorizable", "cardNumber", "cardAuthCode", "cardTransactionID", "cardMarchantGateway", "giftCertNumber", "giftCertFaceValue", "giftCertPaidAmnt", "giftCertCashBackAmnt", "terminalID", "payoutReasonID", "payoutRecepientID"}, list);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = (PosTransaction)this.getRowData(n);
        switch (n2) {
            case 0: {
                return String.valueOf(posTransaction.getTicket().getId());
            }
            case 1: {
                String string;
                PaymentType paymentType = posTransaction.getPaymentType();
                if (paymentType == null) {
                    return null;
                }
                String string2 = paymentType.equals((Object)PaymentType.CUSTOM_PAYMENT) ? (StringUtils.isEmpty((String)(string = posTransaction.getCustomPaymentName())) ? null : string) : paymentType.getDisplayString();
                return string2;
            }
            case 2: {
                String string = posTransaction.getCardType();
                if (string == null) {
                    return "";
                }
                return string;
            }
            case 3: {
                if (posTransaction.getCustomerId() != null) {
                    String string = posTransaction.getCustomerId();
                    Customer customer = CustomerDAO.getInstance().get(string);
                    if (customer != null) {
                        return customer.getName();
                    }
                }
                return "";
            }
            case 4: {
                if (posTransaction instanceof CustomPaymentTransaction) {
                    return ((CustomPaymentTransaction)posTransaction).getCustomPaymentName();
                }
                String string = posTransaction.getCardReader() == null ? "" : posTransaction.getCardReader();
                return string;
            }
            case 5: {
                return DateUtil.formatDateWithTime(posTransaction.getTransactionTime());
            }
            case 6: {
                User user = posTransaction.getTicket().getOwner();
                if (user == null) {
                    return "";
                }
                return user.getFullName();
            }
            case 7: {
                return posTransaction.getCardAuthCode() != null ? posTransaction.getCardAuthCode() : "";
            }
            case 8: {
                return NumberUtil.formatNumber(posTransaction.getTipsAmount());
            }
            case 9: {
                return NumberUtil.formatNumber(posTransaction.getAmount());
            }
            case 10: {
                return posTransaction.getTransactionType();
            }
            case 11: {
                if (posTransaction instanceof CustomPaymentTransaction) {
                    return ((CustomPaymentTransaction)posTransaction).getCustomPaymentName();
                }
                return null;
            }
            case 12: {
                if (posTransaction instanceof CustomPaymentTransaction) {
                    return ((CustomPaymentTransaction)posTransaction).getCustomPaymentRef();
                }
                return null;
            }
            case 13: {
                if (posTransaction instanceof CustomPaymentTransaction) {
                    return ((CustomPaymentTransaction)posTransaction).getCustomPaymentFieldName();
                }
                return null;
            }
            case 14: {
                return posTransaction.isCaptured();
            }
            case 15: {
                return posTransaction.isAuthorizable();
            }
            case 16: {
                return posTransaction.getCardNumber();
            }
            case 17: {
                return posTransaction.getCardAuthCode();
            }
            case 18: {
                return posTransaction.getCardTransactionId();
            }
            case 19: {
                return posTransaction.getCardMerchantGateway();
            }
            case 20: {
                return posTransaction.getGiftCertNumber();
            }
            case 21: {
                return posTransaction.getGiftCertFaceValue();
            }
            case 22: {
                return posTransaction.getGiftCertPaidAmount();
            }
            case 23: {
                return posTransaction.getGiftCertCashBackAmount();
            }
            case 24: {
                return posTransaction.getTerminal().getId();
            }
            case 25: {
                return "";
            }
            case 26: {
                return "";
            }
        }
        return null;
    }
}

