/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.PaymentReceivedReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class PaymentReceivedReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private JComboBox f;

    public PaymentReceivedReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() throws Exception {
        List<PosTransaction> list;
        Date date;
        Date date2 = this.b.getDate();
        if (date2.after(date = this.c.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        date2 = calendar.getTime();
        calendar.clear();
        calendar2.setTime(date);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        date = calendar.getTime();
        Object object = this.f.getSelectedItem();
        User user = null;
        if (object instanceof User) {
            user = (User)object;
        }
        if ((list = PosTransactionDAO.getInstance().findCreditTransactions(date2, date, user)) == null || list.size() < 1) {
            this.d.removeAll();
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("PaymentReceivedReportView.0"));
            return;
        }
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("payment_receive_report"));
        HashMap hashMap = new HashMap();
        ReportUtil.populateRestaurantProperties(hashMap);
        ReportUtil.populateReportTime(hashMap, date2, date);
        ReportUtil.populateReportFooter(hashMap);
        this.a(hashMap);
        PaymentReceivedReportModel paymentReceivedReportModel = new PaymentReceivedReportModel();
        paymentReceivedReportModel.setRows(list);
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)paymentReceivedReportModel));
        JRViewer jRViewer = new JRViewer(jasperPrint);
        this.d.removeAll();
        this.d.add((Component)jRViewer);
        this.d.revalidate();
    }

    private void a(HashMap hashMap) {
        hashMap.put("reportTitle", Messages.getString("PaymentReceivedReportView.2"));
        hashMap.put("totalMsg", Messages.getString("PaymentReceivedReportView.13"));
        hashMap.put("totalAmount", Messages.getString("PaymentReceivedReportView.15") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("colUser", POSConstants.USER);
        hashMap.put("colTime", POSConstants.TIME);
        hashMap.put("colTrans", Messages.getString("TransCount"));
        hashMap.put("colPType", Messages.getString("SettleTicketDialog.9"));
        hashMap.put("colTicket", Messages.getString("TicketCount"));
    }

    private void b() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PaymentReceivedReportView.this.a();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.f = new JComboBox();
        UserDAO userDAO = new UserDAO();
        List<User> list = userDAO.findActiveUsersForPayroll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.f.setModel(new DefaultComboBoxModel(vector));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.e;
    }
}

