/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseAddress;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.ext.KitchenStickerPaperSize;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.EscPosPrintService;
import com.floreantpos.print.JasperPrintService;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.KitchenStickerModel;
import com.floreantpos.report.LabelPrinterTableModel;
import com.floreantpos.report.OrderDataSource;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PrintServiceUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.webservice.PosWebService;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import us.fatehi.magnetictrack.bankcard.BankCardMagneticTrack;

public class ReceiptPrintService {
    public static final String ADDITIONAL_ORDER_INFO = "additionalOrderInfo";
    public static final String SPLIT_TICKET_ID = "splitTicketId";
    public static final String PREVIOUS_DUE = "previousDue";
    public static final String PREVIOUS_DUE_TEXT = "previousDueText";
    public static final String CASH_REFUND = "cashRefund";
    public static final String CASH_REFUND_TEXT = "cashRefundText";
    public static final String TICKET_HEADER = "ticketHeader";
    public static final String TAX_BREAKDOWN_TEXT = "taxBreakdownText";
    public static final String IS_SHOW_TAX_BREAKDOWN = "isShowTaxBreakdown";
    public static final String SHOW_TIPS_BLOCK = "showTipsBlock";
    public static final String SHOW_TIPS = "showTips";
    public static final String STORE_LOGO_IMAGE = "storeLogoIcon";
    public static final String STORE_LOGO_ICON = "storeLogoIcon";
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String ADDITIONAL_PAYMENT_PROPERTIES = "additionalPaymentProperties";
    public static final String APPROVAL_CODE = "approvalCode";
    public static final String CARD_PAYMENT = "cardPayment";
    public static final String CHANGED_AMOUNT = "changedAmount";
    public static final String COPY_TYPE = "copyType";
    public static final String BOTTOM_MESSAGE = "bottomMessage";
    public static final String FOOTER_MESSAGE = "footerMessage";
    public static final String GRAND_SUBTOTAL = "grandSubtotal";
    public static final String DUE_AMOUNT = "dueAmount";
    public static final String REFUND_AMOUNT = "refundAmount";
    public static final String REFUND_AMOUNT_TEXT = "refundAmountText";
    public static final String TENDER_AMOUNT = "tenderAmount";
    public static final String TENDER_AMOUNT_TEXT = "tenderAmountText";
    public static final String PAID_AMOUNT = "paidAmount";
    public static final String NET_AMOUNT = "netAmount";
    public static final String FEE_AMOUNT = "feeAmount";
    public static final String FEE_AMOUNT_TEXT = "feeAmountText";
    public static final String CHANGE_AMOUNT_TEXT = "changeAmountText";
    public static final String DUE_AMOUNT_TEXT = "dueAmountText";
    public static final String PAID_AMOUNT_TEXT = "paidAmountText";
    public static final String NET_AMOUNT_TEXT = "netAmountText";
    public static final String TIPS_TEXT = "tipsText";
    public static final String DELIVERY_CHARGE_TEXT = "deliveryChargeText";
    public static final String SERVICE_CHARGE_TEXT = "serviceChargeText";
    public static final String TAX_TEXT = "taxText";
    public static final String DISCOUNT_TEXT = "discountText";
    public static final String TOTAL_TEXT = "totalText";
    private static final String a = "data";
    private static final String b = "title";
    public static final String ORDER_ = "ORDER-";
    public static final String PROP_PRINTER_NAME = "printerName";
    public static final String TIP_AMOUNT = "tipAmount";
    public static final String SERVICE_CHARGE = "serviceCharge";
    public static final String DELIVERY_CHARGE = "deliveryCharge";
    public static final String TAX_AMOUNT = "taxAmount";
    public static final String DISCOUNT_AMOUNT = "discountAmount";
    public static final String HEADER_LINE1 = "headerLine1";
    private static final String c = "reportDate";
    private static final String d = "showFooter";
    public static final String SHOW_HEADER_SEPARATOR = "showHeaderSeparator";
    private static final String e = "showSubtotal";
    private static final String f = "receiptType";
    private static final String g = "subTotalText";
    private static final String h = "quantityText";
    private static final String i = "itemText";
    public static final String CUSTOMER_COPY = "Customer Copy";
    public static final String DRIVER_COPY = "Driver Copy";
    public static final String CENTER = "center";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String OROPOS_PDF_PRINTER = Messages.getString("ReceiptPrintService.11");
    private static File j;
    private static Log k;

    public static void printGenericReport(String string, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(b, string);
        hashMap.put(a, string2);
        ReceiptPrintService.getJasperPrintService().printGenericReport(hashMap);
    }

    public static void testPrinter(String string, String string2, String string3) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put(b, string2);
        hashMap.put(a, string3);
        ReceiptPrintService.getJasperPrintService().testPrinter(hashMap, string);
    }

    public static void printTicket(Ticket ticket) {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        ReceiptPrintService.printTicket(ticket, ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null));
    }

    public static void printTicket(Ticket ticket, String string) {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        hashMap.put(COPY_TYPE, string);
        hashMap.put(CARD_PAYMENT, true);
        ReceiptPrintService.printTicket(ticket, hashMap);
    }

    public static void printTicket(Ticket ticket, HashMap hashMap) {
        try {
            boolean bl;
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            boolean bl2 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
            if (bl) {
                paymentGatewayPlugin.printTicket(ticket);
                return;
            }
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            if (list == null) {
                return;
            }
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                k.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
                ReceiptPrintService.a(hashMap, string);
                ReceiptPrintService.a(string).printTicket(ticket, hashMap, string);
            }
            ReceiptPrintService.d(ticket);
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printTicket(Ticket ticket, Terminal terminal) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            for (TerminalPrinters serializable : list) {
                int n = serializable.getVirtualPrinter().getType();
                if (n != 1) continue;
                Printer printer = new Printer(serializable.getVirtualPrinter(), serializable.getPrinterName());
                arrayList.add(printer);
            }
            for (Printer printer : arrayList) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                ReceiptPrintService.a(hashMap, string);
                ReceiptPrintService.a(string).printTicket(ticket, hashMap, string);
            }
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printTransaction(PosTransaction posTransaction, boolean bl) {
        ReceiptPrintService.printTransaction(posTransaction, false, bl);
    }

    public static void printTransaction(PosTransaction posTransaction, boolean bl, boolean bl2) {
        try {
            Ticket ticket = posTransaction.getTicket();
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal()) {
                paymentGatewayPlugin.printTransaction(posTransaction, bl, bl2);
                return;
            }
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            if (posTransaction != null && posTransaction.isCard()) {
                hashMap.put(CARD_PAYMENT, true);
                hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.7"));
                ReceiptPrintService.printTransaction(posTransaction, hashMap);
                if (bl2) {
                    hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.8"));
                    ReceiptPrintService.printTransaction(posTransaction, hashMap);
                }
            } else {
                ReceiptPrintService.printTransaction(posTransaction, hashMap);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void printTransaction(PosTransaction posTransaction, HashMap hashMap) {
        try {
            boolean bl;
            Ticket ticket = posTransaction.getTicket();
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            boolean bl2 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
            if (bl) {
                paymentGatewayPlugin.printTransaction(posTransaction, false, false);
                return;
            }
            List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer printer : list) {
                String string = printer.getDeviceName();
                if (string == null) continue;
                k.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), string, ticket.getTotalAmount()));
                ReceiptPrintService.a(hashMap, string);
                ReceiptPrintService.a(string).printTransaction(ticket, hashMap, posTransaction, string);
            }
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printTransaction(PosTransaction posTransaction) {
        boolean bl;
        Ticket ticket = posTransaction.getTicket();
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl2 = posTransaction.getPaymentType().equals((Object)PaymentType.CASH);
        boolean bl3 = bl = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
        if (bl && bl2) {
            return;
        }
        if (bl) {
            paymentGatewayPlugin.printTransaction(posTransaction, false, false);
            return;
        }
        String string = Application.getPrinters().getReceiptPrinter();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
        if (posTransaction != null && posTransaction.isCard()) {
            hashMap.put(CARD_PAYMENT, true);
            hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.4"));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
            hashMap.put(COPY_TYPE, Messages.getString("ReceiptPrintService.5"));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        } else if (posTransaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
            hashMap.put(ADDITIONAL_PAYMENT_PROPERTIES, ReceiptPrintService.a(posTransaction.getTicket()));
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        } else {
            ReceiptPrintService.printTransaction(posTransaction, hashMap);
        }
    }

    public static void printRefundTicket(Ticket ticket, List<PosTransaction> list) {
        try {
            if (list == null || list.isEmpty()) {
                return;
            }
            double d = 0.0;
            if (list != null) {
                for (PosTransaction serializable2 : list) {
                    if (!(serializable2 instanceof RefundTransaction) && !serializable2.isVoided().booleanValue()) continue;
                    d += serializable2.getAmount().doubleValue();
                }
            }
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            hashMap.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.1"));
            hashMap.put(REFUND_AMOUNT, NumberUtil.formatNumber(d));
            hashMap.put(CASH_REFUND_TEXT, Messages.getString("ReceiptPrintService.2"));
            hashMap.put(CASH_REFUND, NumberUtil.formatNumber(d));
            String string = DataProvider.get().getPrinters().getReceiptPrinter();
            ReceiptPrintService.a(string).printRefundTicket(ticket, hashMap, string);
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printRefundTicket(Ticket ticket, RefundTransaction refundTransaction) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, refundTransaction);
            hashMap.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.1"));
            hashMap.put(REFUND_AMOUNT, NumberUtil.formatNumber(refundTransaction.getAmount()));
            hashMap.put(CASH_REFUND_TEXT, Messages.getString("ReceiptPrintService.2"));
            hashMap.put(CASH_REFUND, NumberUtil.formatNumber(refundTransaction.getAmount()));
            String string = DataProvider.get().getPrinters().getReceiptPrinter();
            ReceiptPrintService.a(string).printRefundTicket(ticket, hashMap, string);
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static void printVoidTicket(Ticket ticket) {
        try {
            Object object;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** VOID RECEIPT ***", true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            String string = "";
            if (ticket.getTransactions() != null) {
                object = ticket.getTransactions();
                double d = 0.0;
                if (object != null) {
                    Iterator<PosTransaction> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        PosTransaction posTransaction = iterator.next();
                        if (!(posTransaction instanceof RefundTransaction) && !posTransaction.isVoided().booleanValue()) continue;
                        d += posTransaction.getAmount().doubleValue();
                    }
                }
                d = NumberUtil.roundToTwoDigit(d);
            }
            hashMap.put(ADDITIONAL_PROPERTIES, "<html><b>" + string + "</b></html>");
            hashMap.put(ADDITIONAL_PAYMENT_PROPERTIES, "");
            object = DataProvider.get().getPrinters().getReceiptPrinter();
            ReceiptPrintService.a((String)object).printVoidTicket(ticket, hashMap, (String)object);
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static JasperPrint createPurchaseOrderPrint(PurchaseOrder purchaseOrder) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        HashMap hashMap = ReceiptPrintService.populatePurchaseOrderProperties(purchaseOrder, ticketPrintProperties, null);
        hashMap.put(COPY_TYPE, "");
        OrderDataSource orderDataSource = new OrderDataSource(purchaseOrder);
        String string = "order_receipt";
        hashMap.put(PREVIOUS_DUE_TEXT, "Previous Due  ");
        hashMap.put(PREVIOUS_DUE, "");
        return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)orderDataSource));
    }

    public static JasperPrint createPurchaseOrderItemsBarcodePrint(List<LabelItem> list) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        LabelPrinterTableModel labelPrinterTableModel = new LabelPrinterTableModel(list);
        String string = "barcode_report";
        return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(string), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)labelPrinterTableModel));
    }

    public static JasperPrint printKitchenStickerItems(List<KitchenStickerModel.KitchenSticker> list) throws Exception {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            KitchenStickerModel kitchenStickerModel = new KitchenStickerModel(list);
            String string = "kitchenStickerReport";
            KitchenStickerPaperSize kitchenStickerPaperSize = ReceiptPrintService.c("kitchen.sticker.paper_size");
            return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(kitchenStickerPaperSize.getReportNameAccording2Size(string)), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenStickerModel));
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception.getMessage(), exception);
            return null;
        }
    }

    public static byte[] createPDFStream(Ticket ticket) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
            return null;
        }
    }

    public static byte[] createPDFStream(PosTransaction posTransaction) {
        try {
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            Ticket ticket = posTransaction.getTicket();
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
            return null;
        }
    }

    public static JasperPrintService getJasperPrintService() {
        return new JasperPrintService();
    }

    private static ReceiptPrintServiceProvider a() {
        return ReceiptPrintService.a(null);
    }

    private static ReceiptPrintServiceProvider a(String string) {
        if (string != null && string.equals(OROPOS_PDF_PRINTER)) {
            return new JasperPrintService();
        }
        return ReceiptPrintServiceProvider.get();
    }

    private static String a(Ticket ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<br/>");
        Customer customer = CustomerDAO.getInstance().findById(ticket.getCustomerId());
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("ReceiptPrintService.25"));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("ReceiptPrintService.26") + customer.getId());
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("NAME") + customer.getName());
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, Messages.getString("Balance") + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberAcceptNegative(customer.getBalance()));
        ReceiptPrintService.b(stringBuilder);
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static void a(StringBuilder stringBuilder) {
        stringBuilder.append("<div>");
    }

    private static void b(StringBuilder stringBuilder) {
        stringBuilder.append("</div>\n");
    }

    private static void a(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<span>" + string + "</span>");
    }

    public static HashMap populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction) {
        return ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction, false);
    }

    public static HashMap populateTicketProperties(Ticket ticket, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction, boolean bl) {
        boolean bl2;
        CharSequence charSequence;
        Serializable serializable;
        Object object;
        Application.getInstance().refreshStore();
        Store store = Application.getInstance().getStore();
        String string = "";
        OrderType orderType = ticket.getOrderType();
        String string2 = "";
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (orderType != null) {
            string2 = orderType.getId();
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (bl) {
            string3 = ReceiptUtil.getReceiptSection(store, "kitchen.header", string2);
            string6 = ReceiptUtil.getReceiptSection(store, "kitchen.order.info", string2);
            string = ReceiptUtil.getReceiptSection(store, "kitchen.order.extrainfo1", string2);
            string4 = ReceiptUtil.getReceiptSection(store, "kitchen.footer", string2);
            string5 = ReceiptUtil.getReceiptSection(store, "kitchen.bottom", string2);
        } else {
            string3 = ReceiptUtil.getReceiptSection(store, "ticket.header", string2);
            string6 = ReceiptUtil.getReceiptSection(store, "ticket.order.info", string2);
            string = ReceiptUtil.getReceiptSection(store, "ticket.order.extrainfo1", string2);
            string4 = ReceiptUtil.getReceiptSection(store, "ticket.footer", string2);
            string5 = ReceiptUtil.getReceiptSection(store, "ticket.bottom", string2);
            ReceiptPrintService.a(hashMap, DataProvider.get().getPrinters().getReceiptPrinter());
        }
        if (ReceiptPrintService.a() instanceof EscPosPrintService) {
            hashMap.put(ReceiptParam.STORE_LOGO.getParamName(), " ");
        }
        boolean bl3 = Boolean.valueOf(ReceiptUtil.getReceiptSection(store, bl ? "kitchen.header.logo.show" : "ticket.header.logo.show", string2));
        double d = ticket.getTotalAmount();
        double d2 = 0.0;
        String string7 = CurrencyUtil.getCurrencySymbol();
        hashMap.put(ReceiptParam.STORE_NAME.getParamName(), store.getName());
        hashMap.put(ReceiptParam.STORE_ADDRESS1.getParamName(), store.getAddressLine1());
        hashMap.put(ReceiptParam.STORE_ADDRESS2.getParamName(), store.getAddressLine2());
        hashMap.put(ReceiptParam.STORE_ADDRESS3.getParamName(), store.getAddressLine3());
        hashMap.put(ReceiptParam.STORE_PHONE_NO.getParamName(), store.getTelephone());
        hashMap.put(ReceiptParam.CURRENCY_SYMBOL.getParamName(), string7);
        hashMap.put(ReceiptParam.TICKET_ID.getParamName(), ticket.getId());
        hashMap.put(ReceiptParam.TICKET_SHORT_ID.getParamName(), ticket.getShortId());
        hashMap.put(ReceiptParam.ORDER_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate()));
        hashMap.put(ReceiptParam.TOKEN_NO.getParamName(), "" + ticket.getTokenNo());
        if (ticket.getOrderType().isDelivery().booleanValue() || ticket.getOrderType().isPickup().booleanValue()) {
            if (ticket.isCustomerWillPickup().booleanValue()) {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "PICKUP");
            } else {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "DELIVERY");
            }
            hashMap.put(ReceiptParam.DELIVERY_ADDRESS.getParamName(), ticket.getDeliveryAddress() + ticket.getExtraDeliveryInfo());
            if (ticket.getDeliveryDate() != null) {
                hashMap.put(ReceiptParam.DELIVERY_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getDeliveryDate()));
            }
        } else if (orderType.isHasForHereAndToGo().booleanValue()) {
            SubOrderType subOrderType = ticket.getSubOrderType();
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), subOrderType != null ? subOrderType.getDisplayString() : ticket.getOrderType());
        } else {
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType());
        }
        hashMap.put(ReceiptParam.TERMINAL_ID.getParamName(), ticket.getTerminal().getId());
        hashMap.put(ReceiptParam.TERMINAL_NAME.getParamName(), ticket.getTerminal().getName());
        hashMap.put(ReceiptParam.SERVER_NAME.getParamName(), ticket.getOwner().getFullName());
        hashMap.put(ReceiptParam.SERVER_ID.getParamName(), ticket.getOwner().getId());
        hashMap.put(ReceiptParam.GUEST_COUNT.getParamName(), ticket.getNumberOfGuests().toString());
        int n = POSUtil.parseInteger(ticket.getProperty("printCount"));
        if (n > 0) {
            hashMap.put(ReceiptParam.PRINT_COUNT.getParamName(), n);
        }
        hashMap.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getTableNameDisplay());
        if (ticket.getCustomer() != null) {
            object = ticket.getCustomer();
            hashMap.put(ReceiptParam.CUSTOMER_NAME.getParamName(), ((Customer)object).getName());
            hashMap.put(ReceiptParam.CUSTOMER_ID.getParamName(), ((BaseCustomer)object).getMemberId() != null ? ((BaseCustomer)object).getMemberId() : "");
            hashMap.put(ReceiptParam.CUSTOMER_PHONE.getParamName(), ((BaseCustomer)object).getMobileNo());
            hashMap.put(ReceiptParam.CUSTOMER_SIGNATURE.getParamName(), ((BaseCustomer)object).getSignatureImageId());
        }
        if (ticket.getSalesArea() != null) {
            object = ticket.getSalesArea();
            hashMap.put(ReceiptParam.SALES_AREA.getParamName(), ((BaseSalesArea)object).getName());
        }
        if (ticket.getTransactions() != null) {
            object = PosTransactionDAO.getInstance().findLastTxPaymentTypeName(ticket);
            hashMap.put(ReceiptParam.PAYMENT_TYPE.getParamName(), object);
        }
        if (ticket.getAssignedDriver() != null) {
            object = ticket.getAssignedDriver();
            hashMap.put(ReceiptParam.DRIVER_NAME.getParamName(), ((User)object).getFullName());
            hashMap.put(ReceiptParam.DRIVER_ID.getParamName(), ((BaseUser)object).getId());
        }
        if (string3.contains((CharSequence)(object = ReceiptParam.BARCODE.getParamName())) || string6.contains((CharSequence)object) || string.contains((CharSequence)object) || string4.contains((CharSequence)object) || string5.contains((CharSequence)object)) {
            hashMap.put(object, String.valueOf(ticket.getId()));
        }
        hashMap.put(ReceiptParam.RECEIPT_TYPE.getParamName(), ticketPrintProperties.getReceiptTypeName());
        String string8 = ticket.getProperty("SPLIT_TICKET");
        if (StringUtils.isNotEmpty((String)string8)) {
            hashMap.put(SPLIT_TICKET_ID, string8);
        }
        hashMap.put(ReceiptParam.PRINT_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(new Date()));
        hashMap.put(i, POSConstants.RECEIPT_REPORT_ITEM_LABEL);
        hashMap.put(h, POSConstants.RECEIPT_REPORT_QUANTITY_LABEL);
        hashMap.put(g, POSConstants.RECEIPT_REPORT_SUBTOTAL_LABEL);
        hashMap.put(e, ticketPrintProperties.isShowSubtotal());
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(d, ticketPrintProperties.isShowFooter());
        String string9 = ReceiptPrintService.a(hashMap, string6);
        if (ticket.isVoided().booleanValue()) {
            string9 = string9 + Messages.getString("ReceiptPrintService.16") + "<br>";
        }
        hashMap.put(TICKET_HEADER, string9);
        hashMap.put(ADDITIONAL_ORDER_INFO, ReceiptPrintService.a(hashMap, string));
        hashMap.put(HEADER_LINE1, ReceiptPrintService.a(hashMap, string3));
        if (ticketPrintProperties.isShowFooter()) {
            StringBuilder stringBuilder;
            Comparable<Double> comparable;
            if (ticket.getDiscountAmount() > 0.0) {
                hashMap.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(ticket.getDiscountAmount()));
            }
            if (ticket.getTaxAmount() != 0.0) {
                hashMap.put(TAX_AMOUNT, NumberUtil.formatNumber(ticket.getTaxAmount(), true));
            }
            if (ticket.getServiceCharge() != 0.0) {
                hashMap.put(SERVICE_CHARGE, NumberUtil.formatNumberAcceptNegative(ticket.getServiceCharge()));
            }
            if (ticket.getDeliveryCharge() > 0.0) {
                hashMap.put(DELIVERY_CHARGE, NumberUtil.formatNumberAcceptNegative(ticket.getDeliveryCharge()));
            }
            if (ticket.getGratuity() != null) {
                d2 = ticket.getGratuity().getAmount();
                hashMap.put(TIP_AMOUNT, NumberUtil.formatNumber(d2));
            }
            hashMap.put(TOTAL_TEXT, POSConstants.SUBTOTAL + string7);
            hashMap.put(DISCOUNT_TEXT, POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + string7);
            hashMap.put(TAX_TEXT, POSConstants.RECEIPT_REPORT_TAX_LABEL + string7);
            hashMap.put(SERVICE_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + string7);
            hashMap.put(DELIVERY_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL + string7);
            hashMap.put(TIPS_TEXT, POSConstants.RECEIPT_REPORT_TIPS_LABEL + string7);
            hashMap.put(NET_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_TOTAL_LABEL + string7);
            hashMap.put(PAID_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + string7);
            hashMap.put(DUE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + string7);
            hashMap.put(CHANGE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string7);
            hashMap.put(FEE_AMOUNT_TEXT, POSConstants.FEE_AMOUNT + string7);
            if (ticket.getFeeAmount() > 0.0) {
                hashMap.put(FEE_AMOUNT, NumberUtil.formatNumber(ticket.getFeeAmount()));
            }
            hashMap.put(NET_AMOUNT, NumberUtil.formatNumber(d, true));
            hashMap.put(PAID_AMOUNT, NumberUtil.formatNumber(ticket.getPaidAmount()));
            serializable = ticket.getRefundAmount();
            if (posTransaction != null) {
                comparable = posTransaction.getTenderAmount();
                hashMap.put(TENDER_AMOUNT_TEXT, POSConstants.RECEIPT_TENDERED_AMOUNT_LABEL + string7);
                hashMap.put(TENDER_AMOUNT, NumberUtil.formatNumber((Double)comparable, true));
            }
            if ((Double)serializable > 0.0) {
                hashMap.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.40") + string7);
                hashMap.put(REFUND_AMOUNT, NumberUtil.formatNumber((Double)serializable));
            }
            hashMap.put(DUE_AMOUNT, NumberUtil.formatNumber(ticket.getDueAmount() - ticket.getGratuityAmount()));
            hashMap.put(GRAND_SUBTOTAL, NumberUtil.formatNumber(ticket.getSubtotalAmount(), true));
            hashMap.put(FOOTER_MESSAGE, ReceiptPrintService.a(hashMap, string4));
            hashMap.put(BOTTOM_MESSAGE, ReceiptPrintService.a(hashMap, string5));
            hashMap.put(COPY_TYPE, ticketPrintProperties.getReceiptCopyType());
            if (ticket.isRefunded().booleanValue()) {
                ReceiptPrintService.a(posTransaction, ticket.getTransactions(), hashMap);
            }
            if (posTransaction != null) {
                double d3 = posTransaction.getTenderAmount() - posTransaction.getAmount();
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                hashMap.put(CHANGED_AMOUNT, NumberUtil.formatNumber(d3));
                if (posTransaction.isCard()) {
                    if (!orderType.isRetailOrder().booleanValue()) {
                        hashMap.put(CARD_PAYMENT, true);
                    }
                    if (StringUtils.isEmpty((String)(charSequence = CardConfig.getPaymentGateway().getProcessor().getCardInformationForReceipt(posTransaction)))) {
                        charSequence = ReceiptPrintService.a(posTransaction);
                    }
                    hashMap.put(APPROVAL_CODE, charSequence);
                }
                if (posTransaction instanceof CustomerAccountTransaction && !orderType.isRetailOrder().booleanValue()) {
                    hashMap.put(CARD_PAYMENT, true);
                }
            }
            comparable = null;
            if (StringUtils.isEmpty((String)string8)) {
                comparable = ReceiptPrintService.c(ticket);
            }
            if (comparable != null) {
                hashMap.put(ADDITIONAL_PAYMENT_PROPERTIES, ((StringBuilder)comparable).toString());
            }
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue() && posTransaction != null && (stringBuilder = ReceiptPrintService.a(ticket, posTransaction, ticketPrintProperties)) != null) {
                hashMap.put(ADDITIONAL_PROPERTIES, stringBuilder.toString());
            }
        }
        if (bl3 && (serializable = store.getStoreLogo()) != null) {
            hashMap.put("storeLogoIcon", ((ImageIcon)serializable).getImage());
        }
        boolean bl4 = bl2 = store.getProperty(string2 + "." + "receipt.show_tips_suggestion") == null ? false : Boolean.valueOf(store.getProperty(string2 + "." + "receipt.show_tips_suggestion"));
        if (bl2) {
            hashMap.put(SHOW_TIPS, ReceiptPrintService.b(ticket));
        }
        boolean bl5 = store.getProperty(string2 + "." + "receipt.show_tips_block") == null ? false : Boolean.valueOf(store.getProperty(string2 + "." + "receipt.show_tips_block"));
        hashMap.put(SHOW_TIPS_BLOCK, bl5);
        boolean bl6 = store.getProperty(string2 + "." + "receipt.show_tax_breakdown") == null ? false : Boolean.valueOf(store.getProperty(string2 + "." + "receipt.show_tax_breakdown"));
        hashMap.put(IS_SHOW_TAX_BREAKDOWN, bl6);
        if (bl6 && (charSequence = ReceiptPrintService.getTaxBreakdown(ticket)) != null) {
            hashMap.put(TAX_BREAKDOWN_TEXT, charSequence.toString());
        }
        return hashMap;
    }

    private static void a(HashMap hashMap, String string) {
        if (string != null && string.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            hashMap.put("IS_IGNORE_PAGINATION", false);
        }
    }

    public static void setPaginationProperty(HashMap hashMap, String string, boolean bl) {
        if (string != null && string.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            hashMap.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            hashMap.put("IS_IGNORE_PAGINATION", bl);
        }
    }

    private static String a(Map map, String string) {
        ReceiptParam[] receiptParamArray;
        if (string == null) {
            return "";
        }
        for (ReceiptParam receiptParam : receiptParamArray = ReceiptParam.values()) {
            String string2;
            String string3 = receiptParam.getParamName();
            Object v = map.get(string3);
            if (v == null || StringUtils.isEmpty((String)v.toString()) || v.toString().equals("[]")) {
                string2 = "<" + receiptParam.getParamName() + ">.*</" + receiptParam.getParamName() + ">";
                string = string.replaceAll("<br>" + string2, "");
                string = string.replaceAll(string2, "");
                continue;
            }
            string2 = v.toString();
            try {
                string = string.replaceAll("\\$" + string3, string2);
            }
            catch (Exception exception) {
                string = string.replaceAll("\\$" + string3, "\\" + string2);
            }
        }
        String string4 = ReceiptPrintService.b(string);
        return string4;
    }

    private static String b(String string) {
        Pattern pattern = Pattern.compile("\\{\\{(\\d+)\\}\\}");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                int n = Integer.parseInt(string2);
                String string3 = "";
                for (int i = 0; i < n; ++i) {
                    string3 = string3 + " ";
                }
                matcher.appendReplacement(stringBuffer, string3);
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static void a(PosTransaction posTransaction, Set<PosTransaction> set, HashMap hashMap) {
        if (set == null) {
            return;
        }
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
        ticketPrintProperties.setPrintCookingInstructions(false);
        double d = 0.0;
        for (PosTransaction posTransaction2 : set) {
            if (!(posTransaction2 instanceof RefundTransaction) && !posTransaction2.isVoided().booleanValue()) continue;
            d += posTransaction2.getAmount().doubleValue();
        }
        Object object = "";
        object = posTransaction != null ? "<br>" + (Object)((Object)posTransaction.getPaymentType()) + Messages.getString("ReceiptPrintService.66") + CurrencyUtil.getCurrencySymbol() + " " + posTransaction.getAmount() : "<br>" + Messages.getString("ReceiptPrintService.68") + CurrencyUtil.getCurrencySymbol() + " " + NumberUtil.formatNumber(d);
        hashMap.put(ADDITIONAL_PROPERTIES, "<html><b>" + (String)object + "</b></html>");
    }

    public static HashMap populatePurchaseOrderProperties(PurchaseOrder purchaseOrder, TicketPrintProperties ticketPrintProperties, PosTransaction posTransaction) {
        Object object;
        String string;
        CharSequence charSequence;
        Store store = StoreDAO.getRestaurant();
        double d = purchaseOrder.getTotalAmount();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ReceiptPrintService.a(hashMap, DataProvider.get().getPrinters().getReceiptPrinter());
        String string2 = CurrencyUtil.getCurrencySymbol();
        ImageIcon imageIcon = IconFactory.getIcon("/icons/", "header_logo.png");
        if (imageIcon != null) {
            hashMap.put("logo", imageIcon.getImage());
        }
        hashMap.put("currencySymbol", string2);
        hashMap.put("nameText", "Vendor: ");
        hashMap.put("addressText", "Address: ");
        hashMap.put("slNoText", "Sl. No.");
        hashMap.put(i, "Description");
        hashMap.put(h, "Quantity");
        hashMap.put("priceText", "Unit Cost (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("unitText", "Unit");
        hashMap.put(g, "Amount (" + CurrencyUtil.getCurrencySymbol() + ")");
        hashMap.put("note", Messages.getString("ReceiptPrintService.75"));
        hashMap.put("shipDateTxt", Messages.getString("ReceiptPrintService.76"));
        String string3 = purchaseOrder.getShipDate() != null ? DateUtil.formatFullDateAndTimeAsString(purchaseOrder.getShipDate()) : null;
        hashMap.put("shipDate", string3);
        hashMap.put("signature1", "Signature");
        hashMap.put("signature2", "Verified By");
        InventoryVendor inventoryVendor = purchaseOrder.getVendor();
        if (inventoryVendor != null) {
            charSequence = inventoryVendor.getName();
            string = inventoryVendor.getAddress();
            object = inventoryVendor.getPhone();
            hashMap.put("customerName", charSequence);
            String string4 = "";
            if (string != null && !string.isEmpty()) {
                string4 = string4 + string;
            }
            if (object != null && !((String)object).isEmpty()) {
                string4 = string4 + ", Cell:" + (String)object;
            }
            hashMap.put("customerAddress", StringUtils.isNotEmpty((String)string4) ? string4 : null);
        }
        hashMap.put(f, ticketPrintProperties.getReceiptTypeName());
        hashMap.put(e, ticketPrintProperties.isShowSubtotal());
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(d, ticketPrintProperties.isShowFooter());
        hashMap.put(c, POSConstants.RECEIPT_REPORT_DATE_LABEL + DateUtil.formatFullDateAndTimeAsString(new Date()));
        charSequence = ReceiptPrintService.a(purchaseOrder, ticketPrintProperties);
        hashMap.put("ticketHeader2", ((StringBuilder)charSequence).toString());
        hashMap.put("ticketHeader3", "Purchase Order");
        string = purchaseOrder.getInvoiceNumber() != null ? Messages.getString("ReceiptPrintService.77") + purchaseOrder.getInvoiceNumber() : null;
        hashMap.put("invoiceNumber", string);
        hashMap.put(HEADER_LINE1, store.getName());
        hashMap.put("headerLine9", store.getTelephone());
        object = store.getAddress();
        if (object != null) {
            hashMap.put("headerLine2", ((BaseAddress)object).getAddressLine());
            hashMap.put("headerLine3", ((BaseAddress)object).getAddressLine2());
            hashMap.put("headerLine4", ((BaseAddress)object).getStreet());
            hashMap.put("headerLine5", ((BaseAddress)object).getCity());
            hashMap.put("headerLine6", ((BaseAddress)object).getState());
            hashMap.put("headerLine7", ((BaseAddress)object).getZipCode());
            hashMap.put("headerLine8", ((BaseAddress)object).getCountry());
        } else {
            hashMap.put("headerLine2", store.getAddressLine1());
            hashMap.put("headerLine3", store.getAddressLine2());
            hashMap.put("headerLine4", store.getAddressLine3());
            hashMap.put("headerLine6", store.getZipCode());
        }
        if (ticketPrintProperties.isShowFooter()) {
            if (purchaseOrder.getDiscountAmount() > 0.0) {
                hashMap.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(purchaseOrder.getDiscountAmount()));
            }
            if (purchaseOrder.getTaxAmount() > 0.0) {
                hashMap.put(TAX_AMOUNT, NumberUtil.formatNumber(purchaseOrder.getTaxAmount()));
            }
            hashMap.put(TOTAL_TEXT, POSConstants.RECEIPT_REPORT_TOTAL_LABEL + string2);
            hashMap.put(DISCOUNT_TEXT, POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + string2);
            hashMap.put(TAX_TEXT, POSConstants.RECEIPT_REPORT_TAX_LABEL + string2);
            hashMap.put(SERVICE_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + string2);
            hashMap.put(TIPS_TEXT, POSConstants.RECEIPT_REPORT_TIPS_LABEL + string2);
            hashMap.put(NET_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_NETAMOUNT_LABEL + string2);
            hashMap.put(PAID_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + string2);
            hashMap.put(DUE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + string2);
            hashMap.put(CHANGE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + string2);
            hashMap.put(NET_AMOUNT, NumberUtil.formatNumber(d));
            hashMap.put(PAID_AMOUNT, NumberUtil.formatNumber(purchaseOrder.getPaidAmount()));
            hashMap.put(DUE_AMOUNT, NumberUtil.formatNumber(purchaseOrder.getDueAmount()));
            hashMap.put(GRAND_SUBTOTAL, NumberUtil.formatNumber(purchaseOrder.getSubtotalAmount()));
            hashMap.put(FOOTER_MESSAGE, store.getTicketFooterMessage());
            hashMap.put(COPY_TYPE, ticketPrintProperties.getReceiptCopyType());
            if (posTransaction != null) {
                double d2 = posTransaction.getTenderAmount() - posTransaction.getAmount();
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                hashMap.put(CHANGED_AMOUNT, NumberUtil.formatNumber(d2));
                if (posTransaction.isCard()) {
                    hashMap.put(CARD_PAYMENT, true);
                    if (StringUtils.isNotEmpty((String)posTransaction.getCardTrack())) {
                        BankCardMagneticTrack bankCardMagneticTrack = BankCardMagneticTrack.from((String)posTransaction.getCardTrack());
                        String string5 = posTransaction.getCardType();
                        string5 = string5 + "<br/>APPROVAL: " + posTransaction.getCardAuthCode();
                        try {
                            string5 = string5 + "<br/>ACCT: " + ReceiptPrintService.a(bankCardMagneticTrack);
                            string5 = string5 + "<br/>EXP: " + bankCardMagneticTrack.getTrack1().getExpirationDate();
                            string5 = string5 + "<br/>CARDHOLDER: " + bankCardMagneticTrack.getTrack1().getName();
                        }
                        catch (Exception exception) {
                            k.error((Object)exception);
                        }
                        hashMap.put(APPROVAL_CODE, string5);
                    } else {
                        String string6 = "APPROVAL: " + posTransaction.getCardAuthCode();
                        string6 = string6 + "<br/>Card processed in ext. device.";
                        hashMap.put(APPROVAL_CODE, string6);
                    }
                }
            }
            String string7 = "<html>";
            string7 = string7 + "</html>";
            hashMap.put(ADDITIONAL_PROPERTIES, string7);
        }
        return hashMap;
    }

    private static String b(Ticket ticket) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        double d = ticket.getTotalAmountWithTips();
        String string = ReceiptUtil.getReceiptSection(DataProvider.get().getStore(), "tips_suggestion", ticket.getOrderType().getId());
        if (string == null) {
            string = "[{\"percentage\":25,\"sortOrder\":1},{\"percentage\":20,\"sortOrder\":2},{\"percentage\":18,\"sortOrder\":3},{\"percentage\":15,\"sortOrder\":4}]";
        }
        JSONArray jSONArray = new JSONArray(string);
        ReceiptPrintService.a(stringBuilder);
        for (int i = 0; i < jSONArray.length(); ++i) {
            Object object = jSONArray.get(i);
            if (object == null) continue;
            JSONObject jSONObject = new JSONObject(object.toString());
            double d2 = jSONObject.getDouble("percentage");
            ReceiptPrintService.a(stringBuilder, "<br>" + NumberUtil.trimDecilamIfNotNeeded(d2) + "% " + Messages.getString("ReceiptPrintService.99") + NumberUtil.formatNumber(d * d2 / 100.0));
        }
        ReceiptPrintService.b(stringBuilder);
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    private static StringBuilder a(PurchaseOrder purchaseOrder, TicketPrintProperties ticketPrintProperties) {
        String string = " ";
        if (purchaseOrder.getOrderId() != null) {
            string = purchaseOrder.getOrderId();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        InventoryLocation inventoryLocation = purchaseOrder.getInventoryLocation();
        String string2 = "";
        String string3 = "";
        if (inventoryLocation != null) {
            string2 = inventoryLocation.getName();
            string3 = inventoryLocation.getAddress();
        }
        if (purchaseOrder.getVarificationDate() != null) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Date: " + DateUtil.formatFullDateAndTimeAsString(purchaseOrder.getVarificationDate()));
            ReceiptPrintService.b(stringBuilder);
        }
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "Purchase Order #" + string);
        ReceiptPrintService.b(stringBuilder);
        if (StringUtils.isNotEmpty((String)string2)) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Inventory Location: " + string2);
            ReceiptPrintService.b(stringBuilder);
        }
        if (StringUtils.isNotEmpty((String)string3)) {
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, "Inventory Location Address: " + string3);
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</html>");
        return stringBuilder;
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket) {
        Object object;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List<TicketItem> list = ticket.getTicketItems();
        ArrayList<TicketItemTax> arrayList = new ArrayList<TicketItemTax>();
        for (TicketItem object2 : list) {
            for (TicketItemTax ticketItemTax : object2.getTaxes()) {
                string = ticketItemTax.getName();
                object = (Double)hashMap.get(string);
                if (object == null) {
                    object = 0.0;
                }
                object = (Double)object + ticketItemTax.getTaxAmount();
                hashMap.put(string, object);
                arrayList.add(ticketItemTax);
            }
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        String string2 = CurrencyUtil.getCurrencySymbol();
        if (ReceiptPrintServiceProvider.get() instanceof JasperPrintService) {
            stringBuilder.append("<html><table>");
            for (Map.Entry entry : hashMap.entrySet()) {
                String string3 = NumberUtil.formatNumber((Double)entry.getValue());
                string = (String)entry.getKey();
                int n = 24;
                int n2 = (int)(Math.log10((Double)entry.getValue()) + 1.0);
                n = n2 > 2 ? ++n : (n2 > 1 ? (n += 2) : (n += 3));
                ReceiptPrintService.a(stringBuilder);
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string + (String)string2, n, RIGHT));
                ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string3, n, RIGHT));
                ReceiptPrintService.b(stringBuilder);
            }
            stringBuilder.append("</table></html>");
        } else {
            int n = NumberUtil.formatNumber(ticket.getSubtotalAmount()).length() + 2;
            for (Map.Entry entry : hashMap.entrySet()) {
                string = NumberUtil.formatNumber((Double)entry.getValue());
                object = (String)entry.getKey();
                stringBuilder.append(ReceiptPrintService.getHtmlText((String)object + (String)string2, 42 - n, RIGHT) + ReceiptPrintService.getHtmlText(string, n, RIGHT));
            }
        }
        return stringBuilder;
    }

    private static StringBuilder a(Ticket ticket, PosTransaction posTransaction, TicketPrintProperties ticketPrintProperties) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        String string = "------------------------------------";
        ReceiptPrintService.a(stringBuilder);
        String string2 = " ";
        ReceiptPrintService.a(stringBuilder, string2);
        ReceiptPrintService.b(stringBuilder);
        String string3 = ticket.getProperty("GROUP_SETTLE_TICKETS");
        if (string3 == null) {
            string3 = "";
        }
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string3 + "<b>\nCurrency breakdown</b>");
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("", 10, RIGHT));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Paid", 15, RIGHT));
        ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText("Cashback", 15, RIGHT));
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        int n = 0;
        for (Currency currency : CurrencyUtil.getAllCurrency()) {
            if (currency == null) continue;
            String string4 = currency.getName();
            String string5 = currency.getId() + "_TENDERED";
            String string6 = currency.getId() + "_CASH_BACK";
            String string7 = posTransaction.getProperty(string5);
            String string8 = posTransaction.getProperty(string6);
            if (string7 == null) {
                string7 = "0";
            }
            if (string8 == null) {
                string8 = "0";
            }
            Double d = Double.valueOf(string7);
            Double d2 = Double.valueOf(string8);
            if (d == 0.0 && d2 == 0.0) continue;
            ReceiptPrintService.a(stringBuilder);
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string4, 10, RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(d), 15, RIGHT));
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(decimalFormat.format(d2), 15, RIGHT));
            ReceiptPrintService.b(stringBuilder);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    private static StringBuilder c(Ticket ticket) {
        Set<PosTransaction> set = ticket.getTransactions();
        if (set == null || set.size() <= 1) {
            return null;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(set);
        Collections.sort(arrayList, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getTransactionTime().compareTo(posTransaction2.getTransactionTime());
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><table>");
        ReceiptPrintService.a(stringBuilder);
        String string = " ";
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.a(stringBuilder, string);
        ReceiptPrintService.b(stringBuilder);
        ReceiptPrintService.a(stringBuilder);
        ReceiptPrintService.a(stringBuilder, "Settlements:");
        ReceiptPrintService.b(stringBuilder);
        String string2 = "";
        String string3 = "";
        for (PosTransaction posTransaction : arrayList) {
            ReceiptPrintService.a(stringBuilder);
            string2 = posTransaction.isVoided() != false ? "<strike>" : "";
            string3 = posTransaction.isVoided() != false ? "</strike>" : "";
            ReceiptPrintService.a(stringBuilder, string2 + ReceiptPrintService.getHtmlText(posTransaction.getPaymentType().getDisplayString(), 10, LEFT) + string3);
            ReceiptPrintService.a(stringBuilder, string2 + ReceiptPrintService.getHtmlText(posTransaction.getTipsAmount() > 0.0 ? NumberUtil.formatNumber(posTransaction.getTipsAmount()) : "", 10, RIGHT) + string3);
            Double d = posTransaction.getAmount();
            ReceiptPrintService.a(stringBuilder, ReceiptPrintService.getHtmlText(string2 + NumberUtil.formatNumberAcceptNegative(posTransaction instanceof RefundTransaction ? -d.doubleValue() : d), 10, RIGHT) + string3);
            ReceiptPrintService.b(stringBuilder);
        }
        stringBuilder.append("</table></html>");
        return stringBuilder;
    }

    public static String getHtmlText(String string, int n, String string2) {
        block5: {
            String string3;
            block6: {
                block4: {
                    if (string.length() > 30) {
                        string = string.substring(0, 30);
                    }
                    string3 = " ";
                    if (!string2.equals(CENTER)) break block4;
                    int n2 = (n - string.length()) / 2;
                    for (int i = 1; i < n2; ++i) {
                        string = string3 + string + string3;
                    }
                    break block5;
                }
                if (!string2.equals(RIGHT)) break block6;
                int n3 = n - string.length();
                for (int i = 1; i < n3; ++i) {
                    string = string3 + string;
                }
                break block5;
            }
            if (!string2.equals(LEFT)) break block5;
            int n4 = n - string.length();
            for (int i = 1; i < n4; ++i) {
                string = string + string3;
            }
        }
        return string;
    }

    public static void printVoidKitchenTicket(String string, KitchenTicket kitchenTicket, String string2) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(HEADER_LINE1, Application.getInstance().getStore().getName());
        hashMap.put(CARD_PAYMENT, true);
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        hashMap.put(ReceiptParam.TICKET_ID.getParamName(), POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + kitchenTicket.getTicketId());
        if (kitchenTicket.getTableNumbers() != null && kitchenTicket.getTableNumbers().size() > 0) {
            hashMap.put(ReceiptParam.TABLE_NO.getParamName(), POSConstants.RECEIPT_REPORT_TABLE_NO_LABEL + kitchenTicket.getTableNumbers());
        }
        if (StringUtils.isNotEmpty((String)kitchenTicket.getCustomerName())) {
            hashMap.put("customer", Messages.getString("ReceiptPrintService.0") + kitchenTicket.getCustomerName());
        }
        hashMap.put(ReceiptParam.SERVER_NAME.getParamName(), POSConstants.RECEIPT_REPORT_SERVER_LABEL + kitchenTicket.getServerName());
        hashMap.put(c, Messages.getString("ReceiptPrintService.119") + DateUtil.getReportDate());
        hashMap.put(TICKET_HEADER, Messages.getString("ReceiptPrintService.12"));
        String string3 = kitchenTicket.getOrderType().toString();
        if (StringUtils.isNotEmpty((String)string3)) {
            string3 = string3.replaceAll("_", " ");
        }
        hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "** VOID **");
        hashMap.put(PROP_PRINTER_NAME, Messages.getString("ReceiptPrintService.14") + string);
        ReceiptPrintService.getJasperPrintService().printVoidKitchenTicket(kitchenTicket, hashMap, string, string2);
    }

    public static void printToKitchen(Ticket ticket) {
        ReceiptPrintService.printToKitchen(ticket, true);
    }

    public static void printToKitchen(Ticket ticket, boolean bl) {
        ReceiptPrintService.printToKitchen(ticket, bl, true);
    }

    public static void printToKitchen(Ticket ticket, boolean bl, boolean bl2) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, bl);
            ReceiptPrintService.a(ticket, list, bl2);
            if (PosWebService.get().isCloudConfigured()) {
                String string = ServiceUtils.convertKitTicketsToJsonString(list);
                PosLog.debug(ReceiptPrintService.class, string);
                OroMqttClient.getInstance().publishData("public", string, true);
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND-KIT-DIS-UPDATE", "3");
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static void printCourseItemsToKitchen(Ticket ticket, List<TicketItem> list, boolean bl) {
        try {
            if (ticket == null && list == null) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, bl, list);
            ReceiptPrintService.a(ticket, list2, bl);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseOrganizeTableView.0") + " " + POSConstants.COURSE + " " + list.get(0).getCourseName());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static void printItemsToKitchen(Ticket ticket, List<TicketItem> list) {
        try {
            if (ticket == null && list == null) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, true, list);
            ReceiptPrintService.a(ticket, list2, true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private static void a(Ticket ticket, List<KitchenTicket> list, boolean bl) throws Exception {
        for (KitchenTicket kitchenTicket : list) {
            kitchenTicket.setParentTicket(ticket);
            Printer printer = kitchenTicket.getPrinter();
            String string = printer.getDeviceName();
            if (printer.getVirtualPrinter().getType() == 2 && string != null) {
                k.info((Object)("Printing to kitchen using printer: " + string));
                HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, string, printer.getVirtualPrinter().getName(), false);
                ReceiptPrintService.a(string).printKitchenTicket(kitchenTicket, hashMap, ticket, printer.getVirtualPrinter().getName(), string);
                continue;
            }
            if (printer.getVirtualPrinter().getType() == 6 && string != null) {
                k.info((Object)("Printing to sticker using printer: " + string));
                ReceiptPrintService.a(kitchenTicket, string);
                continue;
            }
            if (!bl || printer.getVirtualPrinter().getType() != 4) continue;
            TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
        }
        if (bl) {
            ticket.clearDeletedItems();
            TicketDAO.getInstance().saveOrUpdate(ticket);
        }
    }

    public static void doPrintKitchenStickers(Ticket ticket) {
        try {
            List<Printer> list = DataProvider.get().getPrinters().getStickerPrinters();
            if (list.isEmpty()) {
                return;
            }
            List<KitchenTicket> list2 = KitchenTicket.fromTicket(ticket, true);
            for (KitchenTicket kitchenTicket : list2) {
                Printer printer = kitchenTicket.getPrinter();
                String string = printer.getDeviceName();
                kitchenTicket.setParentTicket(ticket);
                if (printer.getVirtualPrinter().getType() != 6 || string == null) continue;
                ReceiptPrintService.a(kitchenTicket, string);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private static void a(KitchenTicket kitchenTicket, String string) {
        try {
            List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
            ArrayList<KitchenStickerModel.KitchenSticker> arrayList = new ArrayList<KitchenStickerModel.KitchenSticker>();
            int n = 0;
            int n2 = ReceiptPrintService.a(list);
            for (KitchenTicketItem kitchenTicketItem : list) {
                if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
                int n3 = 0;
                while ((double)n3 < kitchenTicketItem.getQuantity()) {
                    KitchenStickerModel.KitchenSticker kitchenSticker = new KitchenStickerModel.KitchenSticker();
                    kitchenSticker.setToken(kitchenTicket.getTokenNo());
                    kitchenSticker.setCustomerName(ReceiptPrintService.a(kitchenTicket));
                    String string2 = kitchenTicketItem.getMenuItemName();
                    if (StringUtils.isNotEmpty((String)string2)) {
                        string2 = kitchenTicketItem.getQuantity() > 1.0 ? string2.substring(string2.indexOf(32) + 1) : string2;
                    }
                    kitchenSticker.setItemName(string2);
                    kitchenSticker.setModifiers(kitchenTicket.getModifiersForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setCookingInstructions(kitchenTicket.getCookingInstructionForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setTime(Messages.getString("ReceiptPrintService.102") + DateUtil.formatDateWithTime(new Date()));
                    if (kitchenTicket.getOrderType() != null) {
                        kitchenSticker.setOrderType(kitchenTicket.getOrderType().getName());
                    }
                    kitchenSticker.setItemCount(Messages.getString("ReceiptPrintService.103") + (n + 1) + Messages.getString("ReceiptPrintService.104") + n2);
                    arrayList.add(kitchenSticker);
                    ++n;
                    ++n3;
                }
            }
            JasperPrint jasperPrint = ReceiptPrintService.printKitchenStickerItems(arrayList);
            jasperPrint.setName("Kitchen_Sticker_" + kitchenTicket.getTokenNo());
            jasperPrint.setProperty(PROP_PRINTER_NAME, string);
            JasperPrintService.printQuitely(jasperPrint);
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception.getMessage(), exception);
        }
    }

    private static String a(KitchenTicket kitchenTicket) {
        Ticket ticket = kitchenTicket.getParentTicket();
        if (ticket == null) {
            return null;
        }
        Customer customer = ticket.getCustomer();
        String string = ticket.getNote();
        String string2 = "";
        if (customer != null) {
            string2 = customer.getName();
        }
        if (StringUtils.isNotBlank((String)string)) {
            string2 = StringUtils.isNotBlank((String)string2) ? string2 + "/" + string : string;
        }
        return string2;
    }

    private static int a(List<KitchenTicketItem> list) {
        int n = 0;
        for (KitchenTicketItem kitchenTicketItem : list) {
            if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
            n = (int)((double)n + kitchenTicketItem.getQuantity());
        }
        return n;
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean bl) {
        return ReceiptPrintService.getKitchenJasperPrint(ticket, bl, false);
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean bl, boolean bl2) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, bl);
            for (KitchenTicket kitchenTicket : list) {
                kitchenTicket.setParentTicket(ticket);
                Printer printer = kitchenTicket.getPrinter();
                String string = printer.getDeviceName();
                if (string == null) continue;
                HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, string, printer.getVirtualPrinter().getName(), bl2);
                JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createKitchenPrint(hashMap, printer.getVirtualPrinter().getName(), kitchenTicket, string, bl2);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, string);
                return jasperPrint;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        return null;
    }

    public static void printVoidItemsToKitchen(Ticket ticket) {
        try {
            Serializable serializable;
            Object object;
            Comparable comparable22;
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                return;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Comparable comparable22 : ticket.getTicketItems()) {
                VoidItem voidItem = comparable22.getVoidItem();
                if (voidItem == null) continue;
                if (voidItem.getVoidedModifiers() != null) {
                    arrayList.addAll(voidItem.getVoidedModifiers());
                }
                arrayList.add(voidItem);
            }
            HashMap hashMap = new HashMap();
            comparable22 = StoreDAO.getServerTimestamp();
            for (VoidItem comparable3 : arrayList) {
                if (comparable3.isCooked() || (object = ReceiptPrintService.getPrinters((PrinterGroup)(serializable = comparable3.getPrinterGroup()))) == null) continue;
                Iterator<Printer> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Printer printer = iterator.next();
                    KitchenTicket kitchenTicket = (KitchenTicket)hashMap.get(printer);
                    if (kitchenTicket == null) {
                        kitchenTicket = new KitchenTicket();
                        kitchenTicket.setPrinterGroup((PrinterGroup)serializable);
                        kitchenTicket.setTicketId(ticket.getId());
                        kitchenTicket.setTokenNo(ticket.getTokenNo());
                        kitchenTicket.setCreateDate((Date)comparable22);
                        kitchenTicket.setOrderType(ticket.getOrderType());
                        if (ticket.getTableNumbers() != null) {
                            kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                        }
                        kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                        kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                        if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                            kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                        }
                        kitchenTicket.setPrinter(printer);
                        hashMap.put(printer, kitchenTicket);
                    }
                    KitchenTicketItem kitchenTicketItem = new KitchenTicketItem();
                    kitchenTicketItem.setTicketItemId(comparable3.getId());
                    kitchenTicketItem.setMenuItemCode(String.valueOf(comparable3.getMenuItemId()));
                    kitchenTicketItem.setMenuItemName(comparable3.getMenuItemName());
                    kitchenTicketItem.setQuantity(comparable3.getQuantity());
                    kitchenTicketItem.setUnitName("");
                    kitchenTicketItem.setMenuItemGroupName("VOID");
                    kitchenTicketItem.setSortOrder(10001);
                    kitchenTicketItem.setStatus(KitchenStatus.VOID.name());
                    kitchenTicketItem.setKitchenTicket(kitchenTicket);
                    kitchenTicket.addToticketItems(kitchenTicketItem);
                }
            }
            for (KitchenTicket kitchenTicket : hashMap.values()) {
                serializable = kitchenTicket.getPrinter();
                object = ((Printer)serializable).getDeviceName();
                ReceiptPrintService.printVoidKitchenTicket(((Printer)serializable).getVirtualPrinter().getName(), kitchenTicket, (String)object);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public static List<Printer> getPrinters(PrinterGroup printerGroup) {
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        if (printerGroup == null) {
            printerGroup = PrinterGroupDAO.getInstance().getDefaultPrinterGroup();
        }
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        if (printerGroup == null) {
            arrayList.addAll(posPrinters.getKitchenPrinters());
            return arrayList;
        }
        List<String> list = printerGroup.getPrinterNames();
        List<Printer> list2 = posPrinters.getKitchenPrinters();
        for (Printer printer : list2) {
            if (!list.contains(printer.getVirtualPrinter().getName())) continue;
            arrayList.add(printer);
        }
        if (arrayList.isEmpty() && PrintServiceUtil.getFallBackPrinter() != null) {
            arrayList.add(PrintServiceUtil.getFallBackPrinter());
        }
        return arrayList;
    }

    public static Log getLogger() {
        return k;
    }

    public static File getPdfPrinterDir() {
        return j;
    }

    private static String a(BankCardMagneticTrack bankCardMagneticTrack) {
        String string = "";
        try {
            if (bankCardMagneticTrack.getTrack1().hasPrimaryAccountNumber()) {
                string = bankCardMagneticTrack.getTrack1().getPrimaryAccountNumber().getAccountNumber();
                string = "************" + string.substring(12);
            } else if (bankCardMagneticTrack.getTrack2().hasPrimaryAccountNumber()) {
                string = bankCardMagneticTrack.getTrack2().getPrimaryAccountNumber().getAccountNumber();
                string = "************" + string.substring(12);
            }
        }
        catch (Exception exception) {
            k.error((Object)exception);
        }
        return string;
    }

    private static String a(PosTransaction posTransaction) {
        String string = "<br>";
        String string2 = string + Messages.getString("ReceiptPrintService.15") + " ------------------------";
        string2 = string2 + string + Messages.getString("ReceiptPrintService.17") + posTransaction.getCardReader();
        string2 = string2 + string + Messages.getString("ReceiptPrintService.20") + posTransaction.getCardType();
        try {
            String string3 = posTransaction.getCardNumber();
            if (posTransaction.getCardNumber() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.21") + " **** **** **** " + string3.substring(string3.length() - 4, string3.length());
            }
            if (posTransaction.getCardHolderName() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.23") + posTransaction.getCardHolderName();
            }
            if (posTransaction.getCardTransactionId() != null) {
                string2 = string2 + string + Messages.getString("ReceiptPrintService.24") + posTransaction.getCardTransactionId();
            }
            string2 = string2 + string + Messages.getString("ReceiptPrintService.29") + posTransaction.getCardAuthCode();
        }
        catch (Exception exception) {
            k.error((Object)exception);
        }
        return string2;
    }

    public static void printCloudTicket(Ticket ticket, Terminal terminal, PosTransaction posTransaction) {
        try {
            Printer printer;
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            List<TerminalPrinters> list = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            for (TerminalPrinters serializable : list) {
                int n = serializable.getVirtualPrinter().getType();
                if (n != 1) continue;
                printer = new Printer(serializable.getVirtualPrinter(), serializable.getPrinterName());
                arrayList.add(printer);
            }
            if (arrayList == null || arrayList.isEmpty()) {
                JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
                jasperPrint.setName(ORDER_ + ticket.getId());
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                JasperPrintService.printQuitely(jasperPrint);
            } else {
                for (Printer printer2 : arrayList) {
                    String string = printer2.getDeviceName();
                    if (string == null) continue;
                    printer = ReceiptPrintService.getJasperPrintService().createPrint(ticket, hashMap, null);
                    printer.setName(ORDER_ + ticket.getId() + string);
                    printer.setProperty(PROP_PRINTER_NAME, string);
                    JasperPrintService.printQuitely((JasperPrint)printer);
                }
            }
        }
        catch (Exception exception) {
            k.error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    public static ReciptPaperSize getReceiptPaperSize(String string) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string2 = terminal.getProperty(string);
        ReciptPaperSize reciptPaperSize = ReciptPaperSize.Eighty;
        try {
            if (StringUtils.isNotEmpty((String)string2)) {
                reciptPaperSize = ReciptPaperSize.valueOf(string2);
            }
        }
        catch (Exception exception) {
            reciptPaperSize = ReciptPaperSize.Eighty;
        }
        return reciptPaperSize;
    }

    private static KitchenStickerPaperSize c(String string) {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string2 = terminal.getProperty(string);
        KitchenStickerPaperSize kitchenStickerPaperSize = KitchenStickerPaperSize.FiftyOneMM;
        try {
            if (StringUtils.isNotEmpty((String)string2)) {
                kitchenStickerPaperSize = KitchenStickerPaperSize.fromName(string2);
            }
        }
        catch (Exception exception) {
            kitchenStickerPaperSize = KitchenStickerPaperSize.FiftyOneMM;
        }
        return kitchenStickerPaperSize;
    }

    public static boolean hasNoReceiptPrinters() {
        boolean bl;
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        boolean bl2 = paymentGatewayPlugin != null && paymentGatewayPlugin.printUsingThisTerminal();
        List<Printer> list = DataProvider.get().getPrinters().getReceiptPrinters();
        boolean bl3 = bl = list == null || list.isEmpty() || list.size() == 0;
        return bl && !bl2;
    }

    public static boolean hasNoKitchenReceiptPrinters() {
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        return posPrinters == null || posPrinters.getKitchenPrinters() == null || posPrinters.getKitchenPrinters().size() == 0 && posPrinters.getStickerPrinters().size() == 0 && !posPrinters.isPrintToKds();
    }

    public static HashMap populateKitchenTicketProperties(KitchenTicket kitchenTicket, String string, String string2, boolean bl) {
        OrderType orderType;
        String string3;
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap hashMap = ReceiptPrintService.populateTicketProperties(kitchenTicket.getParentTicket(), ticketPrintProperties, null, true);
        ReceiptPrintService.setPaginationProperty(hashMap, string, bl);
        if (ReceiptPrintService.b(kitchenTicket)) {
            hashMap.put(HEADER_LINE1, "**");
        }
        if (StringUtils.isNotEmpty((String)(string3 = kitchenTicket.getOrderType().toString()))) {
            string3 = string3.replaceAll("_", " ");
        }
        if ((orderType = kitchenTicket.getOrderType()).isDelivery().booleanValue() || orderType.isPickup().booleanValue()) {
            if (kitchenTicket.getParentTicket().isCustomerWillPickup().booleanValue()) {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "*" + Messages.getString("PICKUP") + "*");
            } else {
                hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "*" + Messages.getString("DELIVERY") + "*");
            }
        } else {
            hashMap.put(ReceiptParam.ORDER_TYPE.getParamName(), "* " + string3 + " *");
        }
        hashMap.put(PROP_PRINTER_NAME, "Printer Name : " + string2);
        return hashMap;
    }

    private static boolean b(KitchenTicket kitchenTicket) {
        for (KitchenTicketItem kitchenTicketItem : kitchenTicket.getTicketItems()) {
            if (kitchenTicketItem.isVoided().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        JasperPrintService.printQuitely(jasperPrint);
    }

    private static void d(Ticket ticket) {
        String string = "Ticket is printed at %s. Total: %s";
        string = String.format(string, new Date(), ticket.getTotalAmount());
        ActionHistoryDAO.saveHistory(ticket, "Print receipt", string);
    }

    static {
        k = LogFactory.getLog(ReceiptPrintService.class);
        String string = System.getProperty("user.home");
        j = new File(string, "oropos-pdf-print");
        if (!j.exists()) {
            j.mkdirs();
        }
    }
}

