/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import org.apache.commons.lang3.StringUtils;

public class PaymentReceivedReportModel
extends ListTableModel {
    public PaymentReceivedReportModel() {
        super(new String[]{"user", "transTime", "transNo", "ticket", "transType", "total", "memberName"});
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
        switch (n2) {
            case 0: {
                User user = posTransaction.getUser();
                return user.getFullName();
            }
            case 1: {
                return DateUtil.formatFullDateAndTimeWithoutYearAsString(posTransaction.getTransactionTime());
            }
            case 2: {
                return posTransaction.getId();
            }
            case 3: {
                Ticket ticket = posTransaction.getTicket();
                if (ticket == null) {
                    return "";
                }
                return posTransaction.getTicket().getId();
            }
            case 4: {
                String string;
                PaymentType paymentType = posTransaction.getPaymentType();
                if (paymentType == null) {
                    return null;
                }
                String string2 = paymentType.equals((Object)PaymentType.CUSTOM_PAYMENT) ? (StringUtils.isEmpty((CharSequence)(string = posTransaction.getCustomPaymentName())) ? null : string) : paymentType.getDisplayString();
                return string2;
            }
            case 5: {
                return posTransaction.getAmount();
            }
            case 6: {
                if (posTransaction.getTicket().getCustomer() != null) {
                    return posTransaction.getTicket().getCustomer().getName();
                }
                return "";
            }
        }
        return null;
    }
}

