/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import java.awt.Color;
import java.util.Date;
import javax.swing.BorderFactory;
import org.apache.commons.lang.StringUtils;

public class ShopTableButton
extends PosButton {
    private ShopTable e;
    private User f;
    private Ticket g;
    int a;
    int b;

    public ShopTableButton(ShopTable shopTable) {
        this.e = shopTable;
        this.putClientProperty("Plastic.is3D", false);
        this.setBorder(BorderFactory.createLineBorder(new Color(150, 0, 0, 127), 1, true));
        this.setBounds(shopTable.getX(), shopTable.getY(), TerminalConfig.getFloorButtonWidth(), TerminalConfig.getFloorButtonHeight());
        this.setBackground(shopTable.getFloor().getForegroundColor());
        this.update();
    }

    public int getId() {
        return this.e.getId();
    }

    public void setShopTable(ShopTable shopTable) {
        this.e = shopTable;
    }

    public ShopTable getShopTable() {
        return this.e;
    }

    public String getTicketId() {
        return this.e.getTicketId();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShopTableButton)) {
            return false;
        }
        ShopTableButton shopTableButton = (ShopTableButton)object;
        return this.e.equals(shopTableButton.e);
    }

    public int hashCode() {
        return this.e.hashCode();
    }

    @Override
    public String toString() {
        return this.e.toString();
    }

    public void update() {
        this.update(DataProvider.get().getStore());
    }

    public void update(Store store) {
        int n;
        Comparable<StringBuilder> comparable;
        String string;
        int n2 = PosUIManager.getSize(store.getTablePrimaryFontSize());
        int n3 = PosUIManager.getSize(store.getTableSecondaryFontSize());
        Color color = store.getTableSeatForeColor();
        Color color2 = store.getTableSeatBGColor();
        Color color3 = store.getTableServingForeColor();
        Color color4 = store.getTableServingBGColor();
        Color color5 = store.getTableBookForeColor();
        Color color6 = store.getTableBookBGColor();
        Color color7 = store.getTableFreeForeColor();
        Color color8 = store.getTableFreeBGColor();
        this.setBackground(color8);
        this.setForeground(color7);
        String string2 = "<html><center>";
        if (this.e.getCurrentBookingId() != null && store.isShowResIdOnTable() && StringUtils.isNotEmpty((String)(string = this.e.getProperty("RES_NO")))) {
            string = string.substring(4, string.length());
            comparable = new StringBuilder(string);
            comparable.insert(2, '-');
            n = 0;
            int n4 = 0;
            if (!this.e.getTableStatus().equals((Object)TableStatus.Serving)) {
                n = 16;
                n4 = 15;
            }
            string2 = string2 + "<div style='font-size:" + n3 + "px; margin-top:-" + PosUIManager.getSize(n) + "; padding-bottom: " + PosUIManager.getSize(n4) + "'>R# " + comparable.toString() + "</div>";
        }
        string2 = string2 + "<div style='font-size:" + n2 + "px; font-weight: bold;'>" + this.e.getTableNumber() + "</div>";
        if (!store.isShowTableNumberOnTable() && StringUtils.isNotBlank((String)this.e.getName())) {
            string2 = "<html><center><div style='font-size:" + n2 + "px;'>" + this.e.getName() + "</div>";
        }
        if (StringUtils.isNotEmpty((String)(string = this.e.getTicketId())) && store.isShowTokenNumberOnTable()) {
            string2 = string2 + "<div style='font-size:" + n3 + "px;'>Token#: " + this.e.getTicketShortId() + "</div>";
        }
        if (this.e.getTableStatus().equals((Object)TableStatus.Booked)) {
            if (store.isShowTableStatusOnTable()) {
                string2 = string2 + "<div style='font-size:" + n3 + "px;'>" + POSConstants.BOOKED + "</div>";
            }
            this.setEnabled(true);
            this.setOpaque(true);
            this.setBackground(color6);
            this.setForeground(color5);
        } else if (this.e.getTableStatus().equals((Object)TableStatus.Seat)) {
            if (store.isShowTableStatusOnTable()) {
                string2 = string2 + "<div style='font-size:" + n3 + "px;'>" + POSConstants.SEAT + "</div>";
            }
            this.setEnabled(true);
            this.setOpaque(true);
            this.setBackground(color2);
            this.setForeground(color);
        } else if (this.e.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (store.isShowTableStatusOnTable()) {
                string2 = string2 + "<div style='font-size:" + n3 + "px;'>" + POSConstants.SERVING + "</div>";
            }
            this.setBackground(color4);
            this.setForeground(color3);
        }
        if (string != null && StringUtils.isNotEmpty((String)this.e.getUserId())) {
            if (store.isShowServerNameOnTable()) {
                string2 = string2 + "<div style='font-size:" + n3 + "px;'>Serv: " + this.e.getUserName() + "</div>";
            }
            if (!Application.getCurrentUser().getId().equals(this.e.getUserId())) {
                if (this.e.getShopTableStatus().hasMultipleTickets()) {
                    this.setBackground(color2 != null ? color2 : new Color(255, 102, 102));
                    this.setForeground(color != null ? color : Color.BLACK);
                } else {
                    this.setBackground(new Color(139, 0, 139));
                    this.setForeground(Color.WHITE);
                }
            }
        }
        if (this.e.getTableStatus().equals((Object)TableStatus.Booked) && StringUtils.isNotEmpty((String)this.e.getCustomerName()) && store.isShowCustomerNameOnTable()) {
            string2 = string2 + "<div style='font-size:" + n3 + "px;'>Cust: " + this.e.getCustomerName() + "</div>";
        }
        if ((comparable = this.e.getTicketCreateTime()) != null && !this.e.isShowStatus()) {
            string2 = string2 + "<div style='font-size:" + n3 + "px;'>" + DateUtil.getElapsedTime((Date)comparable, new Date()) + "</div>";
        } else if (this.e.isShowStatus()) {
            n = this.e.getCapacity() - this.e.getGuestNumber();
            string2 = string2 + "<div style='font-size:" + n3 + "px;'>Avail Cap: " + n + "</div>";
            string2 = string2 + "<div style='font-size:" + n3 + "px;'>" + Messages.getString("ShopTableButton.32") + this.e.getCapacity() + "</div>";
        }
        string2 = string2 + "</center></html>";
        this.setText(string2);
        this.setBounds(this.e.getX(), this.e.getY(), PosUIManager.getSize(store.getTableBtnWidth()), PosUIManager.getSize(store.getTableBtnHeight()));
    }

    public void setUser(User user) {
        if (user != null) {
            this.f = user;
        }
    }

    public User getUser() {
        return this.f;
    }

    public boolean hasUserAccess() {
        String string;
        if (this.e.getShopTableStatus().hasMultipleTickets()) {
            return true;
        }
        if (this.f == null) {
            return true;
        }
        User user = Application.getCurrentUser();
        String string2 = user.getId();
        if (string2.equals(string = this.f.getId())) {
            return true;
        }
        if (user.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || user.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String string3 = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string3)) {
            return false;
        }
        String string4 = UserDAO.getInstance().findUserBySecretKey(string3).getId();
        if (string4.equals(this.f.getId())) {
            POSMessageDialog.showError(Application.getPosWindow(), "Incorrect password");
            return false;
        }
        return true;
    }

    public void initializeUser() {
        String string = this.e.getUserId();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (this.f != null && this.f.getId().equals(string)) {
            return;
        }
        this.f = UserDAO.getInstance().get(this.e.getUserId());
    }

    public void initializeTicket() {
        String string = this.e.getTicketId();
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (this.e.getTicketId() == null) {
            return;
        }
        if (this.g != null && this.g.getId().equals(string)) {
            return;
        }
        this.g = TicketService.getTicket(this.e.getTicketId());
    }

    public Ticket getTicket() {
        return this.g;
    }

    public void setTicket(Ticket ticket) {
        this.g = ticket;
    }
}

