/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class NumberSelectionDialog2
extends OkCancelOptionDialog {
    private int a;
    private JTextField b;
    private boolean c;
    private PosButton d;
    private PosButton e;
    private int f;

    public NumberSelectionDialog2() {
        this(8);
    }

    public NumberSelectionDialog2(int n) {
        super(POSUtil.getFocusedWindow());
        this.f = n;
        this.a();
    }

    public NumberSelectionDialog2(boolean bl) {
        super(POSUtil.getFocusedWindow());
        this.f = 8;
        this.setFloatingPoint(bl);
        this.a();
    }

    private void a() {
        this.setResizable(false);
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 0));
        this.b = this.isFloatingPoint(true) ? new DoubleTextField(10, this.f) : new IntegerTextField(10, this.f);
        this.b.setHorizontalAlignment(11);
        this.b.setFont(this.b.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.b.setFocusable(true);
        this.b.setBackground(Color.WHITE);
        jPanel2.add((Component)this.b, "Center");
        this.d = new PosButton("+");
        this.d.setFont(new Font("Arial", 0, 30));
        this.d.setFocusable(false);
        jPanel2.add((Component)this.d, "East");
        this.d.setPreferredSize(PosUIManager.getSize(60, 60));
        this.e = new PosButton("-");
        this.e.setPreferredSize(PosUIManager.getSize(60, 60));
        this.e.setFont(new Font("Arial", 1, 30));
        this.e.setFocusable(false);
        jPanel2.add((Component)this.e, "West");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        NumericKeypad numericKeypad = new NumericKeypad();
        jPanel3.add((Component)numericKeypad, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.b.requestFocus();
        this.setControlButtonsVisible(true);
        this.buttonAction();
        this.setDefaultCloseOperation(2);
    }

    @Override
    public void doOk() {
        if (!this.a(this.b.getText())) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void buttonAction() {
        try {
            this.d.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d;
                    String string = NumberSelectionDialog2.this.b.getText();
                    if (StringUtils.isNotEmpty((String)string) && ((d = Double.parseDouble(string)) == Math.floor(d) || !Double.isInfinite(d))) {
                        NumberSelectionDialog2.this.b.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                    }
                }
            });
            this.e.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d;
                    String string = NumberSelectionDialog2.this.b.getText();
                    if (StringUtils.isNotEmpty((String)string) && ((d = Double.parseDouble(string)) == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                        NumberSelectionDialog2.this.b.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                    }
                }
            });
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    public void setControlButtonsVisible(boolean bl) {
        this.d.setVisible(bl);
        this.e.setVisible(bl);
    }

    private boolean a(String string) {
        if (this.isFloatingPoint(false)) {
            try {
                Double.parseDouble(string);
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            Long.parseLong(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String string) {
        super.setCaption(string);
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    public double getValue() {
        return Double.parseDouble(this.b.getText());
    }

    public void setValue(double d) {
        if (d == 0.0) {
            if (this.c) {
                this.b.setText("0");
                this.b.selectAll();
            } else {
                this.b.setText("");
            }
        } else if (this.isFloatingPoint(true)) {
            this.b.setText(String.valueOf(d));
        } else {
            this.b.setText(String.valueOf((int)d));
        }
        this.b.selectAll();
    }

    public boolean isFloatingPoint(boolean bl) {
        return this.c;
    }

    public void setFloatingPoint(boolean bl) {
        this.c = bl;
    }

    public int getDefaultValue() {
        return this.a;
    }

    public void setDefaultValue(int n) {
        this.a = n;
        this.b.setText(String.valueOf(n));
    }

    public static long takeIntInput(String string) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(false);
        numberSelectionDialog2.setTitle(string);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return -1L;
        }
        return (long)numberSelectionDialog2.getValue();
    }

    public static long takeIntInput(String string, double d) {
        return NumberSelectionDialog2.takeIntInput(string, null, d);
    }

    public static long takeIntInput(String string, String string2, double d) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(false);
        numberSelectionDialog2.setTitle(string);
        if (StringUtils.isNotEmpty((String)string2)) {
            numberSelectionDialog2.setCaption(string2);
        }
        numberSelectionDialog2.setValue(d);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return -1L;
        }
        return (long)numberSelectionDialog2.getValue();
    }

    public static double takeDoubleInput(String string, String string2, double d) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(true);
        numberSelectionDialog2.setValue(d);
        numberSelectionDialog2.setTitle(string);
        numberSelectionDialog2.setDialogTitle(string2);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return Double.NaN;
        }
        return numberSelectionDialog2.getValue();
    }

    public static double takeDoubleInput(String string, double d) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(true);
        numberSelectionDialog2.setTitle(string);
        numberSelectionDialog2.setValue(d);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return -1.0;
        }
        return numberSelectionDialog2.getValue();
    }

    public static double show(Component component, String string, double d) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(true);
        numberSelectionDialog2.setTitle(string);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.setLocationRelativeTo(component);
        numberSelectionDialog2.setValue(d);
        numberSelectionDialog2.setVisible(true);
        if (numberSelectionDialog2.isCanceled()) {
            return Double.NaN;
        }
        return numberSelectionDialog2.getValue();
    }

    public static double takeDoubleInput(String string, double d, boolean bl) {
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(true);
        numberSelectionDialog2.setTitle(AppProperties.getAppName());
        numberSelectionDialog2.setCaption(string);
        numberSelectionDialog2.setValue(d);
        numberSelectionDialog2.setFloatingPoint(bl);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return -1.0;
        }
        return numberSelectionDialog2.getValue();
    }

    public void setUtilityButtonsVisible(boolean bl) {
        this.d.setVisible(bl);
        this.e.setVisible(bl);
    }
}

