/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.service.ExcelImporterService;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import liquibase.util.file.FilenameUtils;
import net.miginfocom.swing.MigLayout;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.exception.ConstraintViolationException;

public class ExcelImportViewDialog
extends POSDialog {
    private TitlePanel a;
    private JPanel b;
    private String c;
    private JTabbedPane d;
    private ItemContainer e;
    private ItemContainer f;
    private List<Object> g;
    private ItemContainer h;
    private ItemContainer i;

    public ExcelImportViewDialog(String string) throws Exception {
        this.c = string;
        this.a();
        this.h();
    }

    private void a() {
        this.setTitle(VersionInfo.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.d = new JTabbedPane();
        this.e = new ItemContainer(this.d());
        this.f = new ItemContainer(this.c());
        this.h = new ItemContainer(this.d());
        this.i = new ItemContainer(this.c());
        this.d.addTab(Messages.getString("ExcelImportViewDialog.0"), this.e);
        this.d.addTab(Messages.getString("ExcelImportViewDialog.1"), this.f);
        this.d.addTab(Messages.getString("ExcelImportViewDialog.2"), this.h);
        this.d.addTab(Messages.getString("ExcelImportViewDialog.3"), this.i);
        this.add((Component)this.a, "North");
        this.add((Component)this.d, "Center");
        this.b = this.f();
        this.add((Component)this.b, "South");
    }

    private void b() {
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(1);
        this.h.c.getColumnModel().getColumn(6).setCellEditor(defaultCellEditor);
        this.h.c.getColumnModel().getColumn(7).setCellEditor(defaultCellEditor);
        this.h.c.getColumnModel().getColumn(6).setCellRenderer(new DefaultTableCellRenderer(){
            private Color b = null;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (ExcelImportViewDialog.this.g != null) {
                    for (Object e : ExcelImportViewDialog.this.g) {
                        if (!(e instanceof MenuItem)) continue;
                        arrayList.add(((MenuItem)e).getSku());
                    }
                }
                if (this.b == null) {
                    this.b = this.getForeground();
                }
                if (object instanceof String) {
                    String string = (String)object;
                    defaultTableCellRenderer.setText(string);
                    int n3 = Collections.frequency(arrayList, string);
                    boolean bl3 = MenuItemDAO.getInstance().hasByBarcodeOrSKU(null, string);
                    if (n3 > 1 || bl3) {
                        defaultTableCellRenderer.setForeground(Color.RED);
                    } else {
                        defaultTableCellRenderer.setForeground(this.b);
                    }
                }
                ExcelImportViewDialog.this.h.c.repaint();
                return defaultTableCellRenderer;
            }
        });
        this.h.c.getColumnModel().getColumn(7).setCellRenderer(new DefaultTableCellRenderer(){
            private Color b = null;

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (ExcelImportViewDialog.this.g != null) {
                    for (Object e : ExcelImportViewDialog.this.g) {
                        if (!(e instanceof MenuItem)) continue;
                        arrayList.add(((MenuItem)e).getBarcode());
                    }
                }
                if (this.b == null) {
                    this.b = this.getForeground();
                }
                if (object instanceof String) {
                    String string = (String)object;
                    defaultTableCellRenderer.setText(string);
                    int n3 = Collections.frequency(arrayList, string);
                    boolean bl3 = MenuItemDAO.getInstance().hasByBarcodeOrSKU(string, null);
                    if (n3 > 1 || bl3) {
                        defaultTableCellRenderer.setForeground(Color.RED);
                    } else {
                        defaultTableCellRenderer.setForeground(this.b);
                    }
                }
                ExcelImportViewDialog.this.h.c.repaint();
                return defaultTableCellRenderer;
            }
        });
    }

    private BeanTableModel c() {
        BeanTableModel beanTableModel = new BeanTableModel(MenuModifier.class);
        beanTableModel.addColumn(POSConstants.NAME, MenuModifier.PROP_NAME);
        beanTableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuModifier.PROP_PRICE);
        beanTableModel.addColumn(POSConstants.ACTIVE, MenuModifier.PROP_ENABLE);
        beanTableModel.addColumn(POSConstants.PIZZA_MODIFIER, MenuModifier.PROP_PIZZA_MODIFIER);
        return beanTableModel;
    }

    private BeanTableModel d() {
        BeanTableModel<MenuItem> beanTableModel = new BeanTableModel<MenuItem>(MenuItem.class){
            private static final long b = 1L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 6 || n2 == 7;
            }
        };
        beanTableModel.addColumn(POSConstants.CATEGORY, MenuItem.PROP_MENU_CATEGORY_NAME);
        beanTableModel.addColumn(POSConstants.GROUP, MenuItem.PROP_MENU_GROUP_NAME);
        beanTableModel.addColumn(POSConstants.NAME, MenuItem.PROP_NAME);
        beanTableModel.addColumn(POSConstants.DESCRIPTION, MenuItem.PROP_DESCRIPTION);
        beanTableModel.addColumn(POSConstants.PRICE + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuItem.PROP_PRICE);
        beanTableModel.addColumn(POSConstants.COST, MenuItem.PROP_COST);
        beanTableModel.addColumn(POSConstants.SKU, MenuItem.PROP_SKU);
        beanTableModel.addColumn(POSConstants.BARCODE, MenuItem.PROP_BARCODE);
        beanTableModel.addColumn(POSConstants.ACTIVE, MenuItem.PROP_VISIBLE);
        beanTableModel.addColumn(POSConstants.FRACTIONAL_UNIT, MenuItem.PROP_FRACTIONAL_UNIT);
        beanTableModel.addColumn(POSConstants.INVENTORY_ITEM, MenuItem.PROP_INVENTORY_ITEM);
        beanTableModel.addColumn(POSConstants.ALLOW_PRICE_OVERRIDE, MenuItem.PROP_EDITABLE_PRICE);
        return beanTableModel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.e().get(i));
        }
    }

    private List e() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(90);
        arrayList.add(90);
        arrayList.add(130);
        arrayList.add(130);
        arrayList.add(90);
        arrayList.add(80);
        arrayList.add(110);
        arrayList.add(80);
        arrayList.add(80);
        arrayList.add(100);
        arrayList.add(105);
        arrayList.add(95);
        return arrayList;
    }

    private JPanel f() {
        JButton jButton = new JButton(POSConstants.DELETE);
        jButton.setText(Messages.getString("MenuItemExplorer.19"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.g();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.setCanceled(false);
                    ExcelImportViewDialog.this.doSave();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.CANCEL);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        JButton jButton4 = new JButton(Messages.getString("ExcelImportViewDialog.5"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExcelImportViewDialog.this.m();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        jPanel.add(jButton4);
        jPanel.add(jButton2);
        jPanel.add(jButton);
        jPanel.add(jButton3);
        return jPanel;
    }

    protected void doSave() {
        try {
            List<Object> list = this.getItemsList();
            if (list == null || list.isEmpty()) {
                POSMessageDialog.showError(Messages.getString("DataImortedFailed"));
                return;
            }
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (Object iterator : list) {
                if (!(iterator instanceof MenuItem)) continue;
                arrayList.add((MenuItem)iterator);
            }
            boolean bl = this.i();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ExcelImportViewDialog.4"));
                return;
            }
            for (Object object : list) {
                if (object instanceof MenuItem) {
                    MenuItemDAO.getInstance().saveOrUpdate((MenuItem)object);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                MenuModifierDAO.getInstance().saveOrUpdate((MenuModifier)object);
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImportedSuccessFully"));
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void g() {
        try {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            int n = this.d.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.d.getComponentAt(n);
            JTable jTable = itemContainer.c;
            BeanTableModel beanTableModel = itemContainer.b;
            int[] nArray = jTable.getSelectedRows();
            if (nArray.length <= 0) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                beanTableModel.removeRow(nArray[i] - i);
            }
            this.a(beanTableModel.getRowCount());
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ExcelImportViewDialog.7"));
            return;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void h() throws Exception {
        String string = FilenameUtils.getExtension((String)this.c);
        if (string.equals("xlsx")) {
            this.g = this.k();
            if (this.g == null) {
                return;
            }
            this.j();
            this.a(this.g.size());
            this.b();
        } else if (string.equals("xls")) {
            this.g = this.l();
            if (this.g == null) {
                return;
            }
            this.j();
            this.a(this.g.size());
            this.b();
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectAnExcelFile"));
            return;
        }
    }

    private boolean i() {
        List<Object> list = this.getItemsList();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (Object object : list) {
            Comparable comparable;
            if (object instanceof MenuItem) {
                comparable = (MenuItem)object;
                boolean bl = MenuItemDAO.getInstance().hasByBarcodeOrSKU(((BaseMenuItem)comparable).getBarcode(), ((MenuItem)comparable).getSku());
                if (!bl) continue;
                return true;
            }
            if (!(object instanceof MenuModifier) || ((BaseMenuModifier)(comparable = (MenuModifier)object)).getId() == null) continue;
            return true;
        }
        return false;
    }

    private void j() {
        try {
            this.e.b.removeAll();
            this.h.b.removeAll();
            this.f.b.removeAll();
            this.i.b.removeAll();
            for (Object object : this.g) {
                Comparable comparable;
                if (object instanceof MenuItem) {
                    comparable = (MenuItem)object;
                    boolean bl = MenuItemDAO.getInstance().hasByBarcodeOrSKU(((BaseMenuItem)comparable).getBarcode(), ((MenuItem)comparable).getSku());
                    if (bl) {
                        this.h.b.addRow(comparable);
                        continue;
                    }
                    this.e.b.addRow(comparable);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                comparable = (MenuModifier)object;
                if (((BaseMenuModifier)comparable).getId() != null) {
                    this.i.b.addRow(comparable);
                    continue;
                }
                this.f.b.addRow(comparable);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void a(int n) {
        this.a.setTitle(Messages.getString("ExcelImportViewDialog.11") + n + Messages.getString("ExcelImportViewDialog.12"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> k() throws Exception {
        XSSFWorkbook xSSFWorkbook = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.c);
            xSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
            ExcelImporterService.getInstance().doImportMenuItemFromXLSX(arrayList, menuCategory, menuGroup, xSSFWorkbook.getSheetAt(0));
            ExcelImporterService.getInstance().doImportMenuModifierFromXLSX(arrayList, modifierGroup, xSSFWorkbook.getSheetAt(1));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InvalidExcel"), exception);
            List<Object> list = null;
            return list;
        }
        finally {
            if (xSSFWorkbook != null) {
                xSSFWorkbook.close();
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> l() throws Exception {
        HSSFWorkbook hSSFWorkbook = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.c);
            hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
            ExcelImporterService.getInstance().doImportMenuItemFromXLS(arrayList, menuCategory, menuGroup, hSSFWorkbook.getSheetAt(0));
            ExcelImporterService.getInstance().doImportMenuModifierFromXLS(arrayList, modifierGroup, hSSFWorkbook.getSheetAt(1));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InvalidExcel"), exception);
            List<Object> list = null;
            return list;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (hSSFWorkbook != null) {
                hSSFWorkbook.close();
            }
        }
        return arrayList;
    }

    public List<Object> getItemsList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = this.d.getTabCount();
        for (int i = 0; i < n; ++i) {
            ItemContainer itemContainer = (ItemContainer)this.d.getComponentAt(i);
            arrayList.addAll(itemContainer.b.getRows());
        }
        return arrayList;
    }

    private void m() {
        try {
            int n = this.d.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.d.getComponentAt(n);
            JTable jTable = itemContainer.c;
            jTable.selectAll();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    class ItemContainer
    extends JPanel {
        private BeanTableModel b;
        private JTable c;

        public ItemContainer(BeanTableModel beanTableModel) {
            this.b = beanTableModel;
            this.a();
        }

        private void a() {
            this.setLayout(new BorderLayout());
            this.c = new JTable(this.b);
            this.c.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.c.setSelectionMode(2);
            this.c.setRowHeight(PosUIManager.getSize(50));
            ExcelImportViewDialog.this.resizeColumnWidth(this.c);
            this.add(new JScrollPane(this.c));
        }
    }
}

