/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class SeatSelectionDialog
extends POSDialog
implements ActionListener {
    private TitlePanel a;
    private ShopSeat b;
    private JLayeredPane c = new JLayeredPane();
    private SeatMemberInfoView d;
    private List<ShopTable> e;
    private Map<Integer, TableButton> f = new HashMap<Integer, TableButton>();
    private Map<ShopSeat, SeatButton> g = new HashMap<ShopSeat, SeatButton>();
    private Map<ShopSeat, TicketItemSeat> h = new HashMap<ShopSeat, TicketItemSeat>();
    private PosButton i;
    private PosButton j;
    private TicketItemSeat k;
    private Ticket l;
    private TicketItemSeat m;
    private boolean n;
    private boolean o = SystemProperties.isSeatCustomerEnable();

    public SeatSelectionDialog(Ticket ticket) {
        this.l = ticket;
        this.n = false;
        this.a();
        this.b();
        this.a(this.e.get(0));
        TableButton tableButton = this.f.get(this.e.get(0).getId());
        if (tableButton != null) {
            tableButton.setSelected(true);
        }
    }

    public SeatSelectionDialog(Ticket ticket, TicketItemSeat ticketItemSeat) {
        this.l = ticket;
        this.n = true;
        this.a();
        this.b();
        this.i.setVisible(true);
        this.a(this.e.get(0));
        TableButton tableButton = this.f.get(this.e.get(0).getId());
        if (tableButton != null) {
            tableButton.setSelected(true);
        }
        try {
            this.m = ticketItemSeat;
            this.k = (TicketItemSeat)CopyUtil.deepCopy(ticketItemSeat);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        if (ticketItemSeat != null) {
            SeatButton seatButton = this.g.get(ticketItemSeat.getShopSeat());
            if (seatButton != null) {
                this.b = seatButton.getSeat();
                this.b.setMember(ticketItemSeat.getMember());
                tableButton = this.f.get(this.b.getTableId());
                if (tableButton != null) {
                    tableButton.setSelected(true);
                    if (this.b.getTableId() != null) {
                        this.a(this.b.getShopTable());
                    }
                }
                this.d.rendererMemberInfo(this.b);
            }
        } else {
            this.j.setSelected(true);
            this.j.setBackground(Color.red);
            tableButton = this.f.get(this.e.get(0).getId());
            if (tableButton != null) {
                tableButton.setSelected(true);
            }
            this.a(this.e.get(0));
            this.d.rendererMemberInfo(this.b);
        }
    }

    private void a() {
        Set<ShopSeat> set;
        this.e = this.l.getTables();
        List<TicketItem> list = this.l.getTicketItems();
        for (ShopTable comparable : this.e) {
            set = comparable.getSeats();
            if (set == null) continue;
            for (ShopSeat shopSeat : set) {
                shopSeat.setMember(null);
                SeatButton seatButton = new SeatButton(shopSeat);
                this.g.put(shopSeat, seatButton);
            }
        }
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.isTreatAsSeat().booleanValue() || (set = ticketItem.getSeat()) == null) continue;
                this.h.put(((TicketItemSeat)((Object)set)).getShopSeat(), (TicketItemSeat)((Object)set));
                SeatButton seatButton = this.g.get(((TicketItemSeat)((Object)set)).getShopSeat());
                if (seatButton == null) continue;
                seatButton.getSeat().setMember(((TicketItemSeat)((Object)set)).getMember());
            }
        }
    }

    private void b() {
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.a = new TitlePanel();
        this.add((Component)this.a, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.j = new PosButton(Messages.getString("SeatSelectionDialog.2"));
        this.j.setActionCommand("Shared");
        this.j.addActionListener(this);
        jPanel2.add(this.j);
        this.i = new PosButton(Messages.getString("SeatSelectionDialog.1"));
        this.i.setFocusable(false);
        this.i.setVisible(false);
        this.i.addActionListener(this);
        jPanel2.add(this.i);
        PosButton posButton = new PosButton(Messages.getString("SeatSelectionDialog.5"));
        posButton.setActionCommand("Cancel");
        posButton.setFocusable(false);
        posButton.addActionListener(this);
        jPanel2.add(posButton);
        jPanel.add((Component)new JSeparator(0), "North");
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "South");
        this.c();
    }

    private void c() {
        Serializable serializable2;
        this.c.setPreferredSize(new Dimension(400, 390));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.c);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1", "sg,fill", ""));
        if (this.e != null && this.e.size() > 0) {
            serializable2 = new ButtonGroup();
            for (ShopTable serializable3 : this.e) {
                TableButton tableButton = new TableButton(serializable3);
                tableButton.setPreferredSize(new Dimension(90, 70));
                tableButton.setForeground(new Color(76, 52, 47));
                tableButton.setBackground(new Color(147, 187, 70));
                ((ButtonGroup)serializable2).add(tableButton);
                jPanel2.add(tableButton);
                this.f.put(serializable3.getId(), tableButton);
            }
        }
        if (this.e != null && this.e.size() > 1) {
            jPanel.add((Component)jPanel2, "West");
        }
        this.d = new SeatMemberInfoView(this.l);
        this.d.setPreferredSize(PosUIManager.getSize(300, 390));
        serializable2 = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5), BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.7")));
        this.d.setBorder((Border)((Object)serializable2));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10), BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.3")));
        PosScrollPane posScrollPane = new PosScrollPane(jPanel, 20, 30);
        posScrollPane.getHorizontalScrollBar().setPreferredSize(PosUIManager.getSize(40, 40));
        posScrollPane.setAutoscrolls(true);
        posScrollPane.setBorder(compoundBorder);
        this.add((Component)posScrollPane, "Center");
        if (SystemProperties.isSeatCustomerEnable()) {
            this.add((Component)this.d, "West");
        }
    }

    private void a(ShopTable shopTable) {
        this.c.removeAll();
        if (shopTable == null) {
            return;
        }
        ShopTableButton shopTableButton = new ShopTableButton(this.c, shopTable);
        shopTableButton.drawShape(shopTable.getStateTableType());
        this.c.add((Component)shopTableButton, Float.valueOf(0.5f));
        ButtonGroup buttonGroup = new ButtonGroup();
        Set<ShopSeat> set = shopTable.getSeats();
        if (set != null) {
            SeatButton seatButton;
            for (ShopSeat comparable : set) {
                seatButton = new SeatButton(comparable);
                this.c.add(seatButton);
                buttonGroup.add(seatButton);
                this.g.put(comparable, seatButton);
            }
            if (this.l.getTicketItems() != null) {
                for (TicketItemSeat ticketItemSeat : this.h.values()) {
                    seatButton = this.g.get(ticketItemSeat.getShopSeat());
                    if (seatButton == null) continue;
                    seatButton.setBackground(Color.red);
                }
                this.d();
            }
        }
        this.c.moveToBack(shopTableButton);
        this.c.revalidate();
        this.c.repaint();
    }

    private void d() {
        SeatButton seatButton;
        if (this.b != null && (seatButton = this.g.get(this.b)) != null) {
            seatButton.setSelected(true);
            seatButton.setBackground(Color.green);
        }
    }

    private void e() {
        if (this.l.getTicketItems() != null) {
            Set<ShopSeat> set = this.g.keySet();
            for (ShopSeat shopSeat : set) {
                TicketItemSeat ticketItemSeat = this.h.get(shopSeat);
                if (ticketItemSeat == null) continue;
                ticketItemSeat.setMember(shopSeat.getMember());
            }
            if (this.b != null) {
                SeatSelectionDialog.setCustomerForShopSeat(this.l, this.b, this.b.getMember());
            }
        }
        if (this.k != null && this.k.getSeatId().intern() != this.b.getId().intern()) {
            this.k.setMember(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("Shared".equalsIgnoreCase(string)) {
            this.b = null;
        } else {
            if ("Cancel".equalsIgnoreCase(string)) {
                this.setCanceled(true);
                this.dispose();
                return;
            }
            this.e();
        }
        this.f();
    }

    private void f() {
        if (this.m != null) {
            try {
                PropertyUtils.copyProperties((Object)this.m, (Object)this.k);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    private Customer a(ShopSeat shopSeat) {
        List<TicketItem> list = this.l.getTicketItems();
        for (TicketItem ticketItem : list) {
            Customer customer;
            TicketItemSeat ticketItemSeat;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null || !ticketItemSeat.getSeatId().equals(shopSeat.getId()) || (customer = ticketItemSeat.getMember()) == null) continue;
            return customer;
        }
        return null;
    }

    public static void setCustomerForShopSeat(Ticket ticket, ShopSeat shopSeat, Customer customer) {
        if (ticket == null) {
            return;
        }
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            TicketItemSeat ticketItemSeat;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null || !ticketItemSeat.getSeatId().equals(shopSeat.getId())) continue;
            ticketItemSeat.setMember(customer);
        }
    }

    public ShopSeat getSeat() {
        return this.b;
    }

    public class ShopTableButton
    extends JLabel {
        private JLayeredPane b;
        private ShopTable c;
        private int d;

        public ShopTableButton(JLayeredPane jLayeredPane, ShopTable shopTable) {
            this.b = jLayeredPane;
            this.c = shopTable;
            this.setText(shopTable.getId() + "");
            this.setBackground(Color.WHITE);
            Integer n = shopTable.getWidth();
            Integer n2 = shopTable.getHeight();
            if (n == null || n == 0) {
                n = TerminalConfig.getFloorButtonWidth();
            }
            if (n2 == null || n2 == 0) {
                n2 = TerminalConfig.getFloorButtonHeight();
            }
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setBounds(this.b.getPreferredSize().width / 2 - n / 2, this.b.getPreferredSize().height / 2 - n2 / 2, n, n2);
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize() + 10));
        }

        public void drawShape(int n) {
            this.d = n;
            this.repaint();
        }

        @Override
        public void paintAll(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getBackground());
            if (this.d == 2) {
                graphics2D.fillOval(10, 10, this.getSize().width - 20, this.getSize().height - 20);
            } else if (this.d == 1) {
                graphics2D.fillRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 20, 20);
            } else if (this.d != 3) {
                graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(6.0f));
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.d == 2) {
                graphics2D.drawOval(10, 10, n - 20, n2 - 20);
            } else if (this.d == 1) {
                graphics2D.drawRoundRect(2, 2, n - 4, n2 - 4, 20, 20);
            } else if (this.d == 3) {
                int n3 = n / 2;
                int n4 = (int)Math.sqrt(n * n + n * n);
                int n5 = n4 - n;
                int n6 = n4 - n;
                graphics2D.rotate(Math.toRadians(45.0), n3, 0.0);
                graphics2D.drawRoundRect(n3 + 2, 4, n - n5, n - n6, 20, 20);
            } else {
                graphics2D.drawRect(0, 0, n, n2);
            }
        }

        public ShopTable getTable() {
            return this.c;
        }
    }

    class TableButton
    extends POSToggleButton
    implements ActionListener {
        ShopTable a;
        int b;
        int c;

        public TableButton(ShopTable shopTable) {
            this.a = shopTable;
            this.setText(shopTable.getTableNumber() + "");
            this.setBounds(shopTable.getX(), shopTable.getY(), shopTable.getWidth(), shopTable.getHeight());
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addActionListener(this);
        }

        public ShopTable getTable() {
            return this.a;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SeatSelectionDialog.this.a(this.a);
        }
    }

    class SeatMemberInfoView
    extends JPanel {
        private JLabel b;
        private JLabel c;
        private JLabel d;
        private JLabel e;
        private byte[] f;
        private JLabel g;
        private JPanel h;
        private JPanel i;
        private Ticket j;
        private Customer k;
        private ShopSeat l;
        private PosButton m;
        private PosButton n;

        public SeatMemberInfoView(Ticket ticket) {
            this.j = ticket;
            this.a();
            this.updateView();
        }

        private void a() {
            this.setLayout(new BorderLayout());
            this.h = new JPanel();
            this.h.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3"));
            this.b = new JLabel();
            this.c = new JLabel();
            this.d = new JLabel(Messages.getString("MemeberName"));
            this.g = new JLabel(Messages.getString("MemberID"));
            Font font = new Font(this.b.getFont().getName(), 1, this.b.getFont().getSize());
            this.b.setFont(font);
            this.c.setFont(font);
            this.h.add((Component)this.g, "grow");
            this.h.add((Component)this.b, "grow,h 25!,wrap");
            this.h.add((Component)this.d, "grow");
            this.h.add((Component)this.c, "grow,w 200!");
            this.n = new PosButton(Messages.getString("ClearSeatSelection"));
            this.n.addActionListener(actionEvent -> this.b());
            this.add((Component)this.n, "South");
            this.c();
            this.add(this.h);
        }

        private void b() {
            Serializable serializable;
            if (SeatSelectionDialog.this.k == null && SeatSelectionDialog.this.b != null) {
                serializable = (SeatButton)SeatSelectionDialog.this.g.get(SeatSelectionDialog.this.b);
                SeatSelectionDialog.this.b.setMember(null);
                if (serializable != null) {
                    ((SeatButton)serializable).updateSeatInfo(SeatSelectionDialog.this.b);
                    ((JComponent)serializable).setBackground(Color.WHITE);
                    ((AbstractButton)serializable).setSelected(false);
                }
                SeatSelectionDialog.this.d.a(false);
            }
            if (SeatSelectionDialog.this.k == null) {
                SeatSelectionDialog.this.d.a(true);
                return;
            }
            if (SeatSelectionDialog.this.k.getMember() == null) {
                SeatSelectionDialog.this.d.a(true);
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoNeedToClear"));
                return;
            }
            serializable = SeatSelectionDialog.this.k.getShopSeat();
            SeatButton seatButton = (SeatButton)SeatSelectionDialog.this.g.get(serializable);
            SeatSelectionDialog.this.k.setMember(null);
            SeatSelectionDialog.this.b.setMember(null);
            ((ShopSeat)serializable).setMember(null);
            if (seatButton != null) {
                seatButton.updateSeatInfo((ShopSeat)serializable);
                seatButton.setBackground(Color.WHITE);
                seatButton.setSelected(false);
            }
            SeatSelectionDialog.this.d.a(true);
        }

        public void rendererMemberInfo(ShopSeat shopSeat) {
            this.l = shopSeat;
            if (shopSeat != null) {
                this.k = shopSeat.getMember();
            }
            this.updateView();
        }

        private void c() {
            this.i = new JPanel((LayoutManager)new MigLayout());
            this.i.setBackground(Color.white);
            this.e = new JLabel("");
            this.e.setIconTextGap(0);
            this.e.setHorizontalAlignment(0);
            this.i.add((Component)this.e, "wrap,center");
            this.m = new PosButton(Messages.getString("SelectMember"));
            this.m.setFocusable(false);
            this.m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(SeatMemberInfoView.this.j.getOrderType());
                    customerSelectorDialog.setCreateNewTicket(false);
                    if (SeatMemberInfoView.this.j != null) {
                        customerSelectorDialog.setTicket(SeatMemberInfoView.this.j);
                    }
                    customerSelectorDialog.openUndecoratedFullScreen();
                    if (customerSelectorDialog.isCanceled()) {
                        return;
                    }
                    SeatMemberInfoView.this.k = customerSelectorDialog.getSelectedCustomer();
                    if (SeatMemberInfoView.this.l != null) {
                        SeatMemberInfoView.this.l.setMember(SeatMemberInfoView.this.k);
                    }
                    SeatMemberInfoView.this.updateView();
                }
            });
            this.i.add((Component)this.m, "h 40!,center");
            this.h.add((Component)this.i, "skip 1,newline");
            this.d();
        }

        private void a(Customer customer) {
            if (customer != null) {
                ImageIcon imageIcon = IconFactory.getIconFromImageResource(customer.getImageId(), 150, 150);
                if (imageIcon != null) {
                    this.e.setIcon(imageIcon);
                } else {
                    this.d();
                }
            }
        }

        private void d() {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/images/generic-profile-pic-v2.png");
                this.f = IOUtils.toByteArray((InputStream)inputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                this.e.setIcon(new ImageIcon(this.f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void a(boolean bl) {
            if (bl) {
                this.b.setText("");
                this.c.setText("");
            }
        }

        protected void updateView() {
            Customer customer;
            if (this.k != null) {
                this.b.setText(this.k.getMemberId());
                this.c.setText(this.k.getName());
                this.a(this.k);
            } else if (!SeatSelectionDialog.this.n && (customer = this.j.getCustomer()) != null) {
                this.b.setText(customer.getMemberId());
                this.c.setText(customer.getName());
                this.a(customer);
            }
        }

        public Customer getMember() {
            return this.k;
        }

        public String getCustomerName() {
            return this.c.getText();
        }

        public void setMember(Customer customer) {
            this.k = customer;
            this.updateView();
        }

        public void disableMemberSelection() {
            this.m.setEnabled(false);
        }

        public void enableMemberSelection() {
            this.m.setEnabled(true);
        }
    }

    class SeatButton
    extends POSToggleButton
    implements ActionListener {
        ShopSeat a;
        int b;
        int c;

        public SeatButton(ShopSeat shopSeat) {
            this.setBounds(shopSeat.getPosX(), shopSeat.getPosY(), 70, 70);
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addActionListener(this);
            this.updateSeatInfo(shopSeat);
        }

        public void updateSeatInfo(ShopSeat shopSeat) {
            this.a = shopSeat;
            Customer customer = shopSeat.getMember();
            String string = "";
            if (customer != null) {
                string = "<br><font size=\"2\">" + customer.getName() + "</font>";
            }
            if (SeatSelectionDialog.this.o) {
                this.setText("<html><center>" + shopSeat.getSeatNumber() + string + "</center></html>");
            } else {
                this.setText("<html><center>" + shopSeat.getSeatNumber() + "</center></html>");
            }
        }

        public ShopSeat getSeat() {
            return this.a;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Customer customer = null;
            SeatButton seatButton = null;
            if (SeatSelectionDialog.this.b != null) {
                seatButton = (SeatButton)SeatSelectionDialog.this.g.get(SeatSelectionDialog.this.b);
            }
            SeatSelectionDialog.this.b = this.a;
            if (SeatSelectionDialog.this.k == null) {
                Customer customer2 = SeatSelectionDialog.this.b.getMember();
                if (customer2 == null) {
                    customer2 = SeatSelectionDialog.this.a(SeatSelectionDialog.this.b);
                }
                Customer customer3 = SeatSelectionDialog.this.d.getMember();
                if (customer2 != null && customer3 != null && !customer2.equals(customer3)) {
                    if (SeatSelectionDialog.this.b.getMember() != null) {
                        this.a(customer2, customer3);
                        return;
                    }
                    SeatSelectionDialog.this.b.setMember(customer3);
                    SeatSelectionDialog.setCustomerForShopSeat(SeatSelectionDialog.this.l, SeatSelectionDialog.this.b, customer3);
                } else if (customer3 != null) {
                    SeatSelectionDialog.this.b.setMember(customer3);
                } else if (customer3 == null && StringUtils.isNotBlank((String)SeatSelectionDialog.this.d.getCustomerName())) {
                    SeatSelectionDialog.this.b.setMember(SeatSelectionDialog.this.l.getCustomer());
                }
                SeatSelectionDialog.this.setCanceled(false);
                SeatSelectionDialog.this.dispose();
            } else if (SeatSelectionDialog.this.k != null && SeatSelectionDialog.this.b != null) {
                if (customer == null) {
                    customer = SeatSelectionDialog.this.a(SeatSelectionDialog.this.b);
                }
                if (seatButton != null) {
                    if (SeatSelectionDialog.this.b != null && SeatSelectionDialog.this.b.getMember() != null) {
                        Customer customer4;
                        Customer customer5 = SeatSelectionDialog.this.b.getMember();
                        if (customer5.equals(customer4 = SeatSelectionDialog.this.d.getMember())) {
                            this.setSelected(false);
                            seatButton.setSelected(true);
                            SeatSelectionDialog.this.b = seatButton.getSeat();
                            return;
                        }
                        this.a(customer5, customer4);
                        this.setSelected(false);
                        seatButton.setSelected(true);
                        SeatSelectionDialog.this.b = seatButton.getSeat();
                        return;
                    }
                    ShopSeat shopSeat = seatButton.getSeat();
                    shopSeat.setMember(null);
                    if (SeatSelectionDialog.this.k != null) {
                        customer = SeatSelectionDialog.this.k.getMember();
                        SeatSelectionDialog.this.k.setShopSeat(this.a);
                    }
                    seatButton.updateSeatInfo(shopSeat);
                    seatButton.setBackground(Color.WHITE);
                }
                SeatSelectionDialog.this.b.setMember(customer);
                this.updateSeatInfo(SeatSelectionDialog.this.b);
                SeatSelectionDialog.this.d();
                SeatSelectionDialog.this.d.rendererMemberInfo(SeatSelectionDialog.this.b);
            } else {
                SeatSelectionDialog.this.d.rendererMemberInfo(this.a);
            }
        }

        private void a(Customer customer, Customer customer2) {
            if (customer == null) {
                return;
            }
            if (customer2 == null) {
                String string = Messages.getString("SeatSelectionDialog.100");
                String string2 = String.format(string, SeatSelectionDialog.this.b.getSeatNumber(), customer.getName());
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string2);
                return;
            }
            String string = Messages.getString("SeatSelectionDialog.10");
            String string3 = String.format(string, SeatSelectionDialog.this.b.getSeatNumber(), customer.getName(), customer2.getName());
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string3);
        }
    }
}

