/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.SystemProperties;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.ShopSeatForm;
import com.floreantpos.ui.floorplan.ShopTableStyledButton;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class ShopTableForm
extends BeanEditor<ShopTable>
implements RefreshableView {
    private FixedLengthTextField a;
    private IntegerTextField b;
    private IntegerTextField c;
    private IntegerTextField d;
    private FixedLengthTextField e;
    private JCheckBox f;
    private CheckBoxList g;
    private JPanel h;
    private JRadioButton i;
    private JRadioButton j;
    private JButton k;
    private int l;
    private String m;
    private Integer n;
    private Integer o;
    private String p;
    private List<ShopTableType> q;
    private int r;
    private boolean s;
    private boolean t;
    private JLayeredPane u = new JLayeredPane();
    private JScrollPane v;
    private JPanel w;
    private IntegerTextField x;
    private IntegerTextField y;
    private Integer z = 0;
    private ShapeButton A;
    private ShapeButton B;
    private ShapeButton C;
    private ShapeButton D;
    private JComboBox E;
    private JPanel F;
    private JButton G;

    public ShopTableForm() {
        Object object;
        this.setLayout((LayoutManager)new MigLayout("fill,ins 0", "[35%][65%]", ""));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0 5 5 5 5", "[][grow]", "[][][][][][][][]"));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.19")));
        this.g = new CheckBoxList();
        this.g.setModel(ShopTableTypeDAO.getInstance().findAll());
        JScrollPane jScrollPane = new JScrollPane(this.g);
        jScrollPane.setPreferredSize(new Dimension(0, 350));
        JLabel jLabel = new JLabel(Messages.getString("ShopTableForm.0"));
        jPanel.add((Component)jLabel, "cell 0 0,alignx trailing,aligny center");
        this.E = new JComboBox();
        this.d = new IntegerTextField(6);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ShopTableForm.this.doGenerateDefaultSeats();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        };
        this.G = new JButton("...");
        this.G.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableForm.this.a();
            }
        });
        jPanel.add((Component)this.d, "cell 1 0,growx,aligny top");
        JLabel jLabel2 = new JLabel(Messages.getString("ShopTableForm.33"));
        jPanel.add((Component)jLabel2, "cell 0 1,alignx trailing, wrap");
        this.e = new FixedLengthTextField(20);
        jPanel.add((Component)this.e, "cell 1 1,growx, wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("ShopTableForm.2"));
        jPanel.add((Component)jLabel3, "cell 0 2,alignx trailing");
        this.a = new FixedLengthTextField();
        jPanel.add((Component)this.a, "cell 1 2,growx");
        JLabel jLabel4 = new JLabel("Min Capacity");
        jPanel.add((Component)jLabel4, "cell 0 3,alignx trailing");
        this.b = new IntegerTextField(6);
        jPanel.add((Component)this.b, "flowx,grow,cell 1 3");
        JLabel jLabel5 = new JLabel(Messages.getString("ShopTableForm.3"));
        this.F = new JPanel((LayoutManager)new MigLayout("fill,ins 5,wrap 5"));
        this.F.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.3")));
        this.c = new IntegerTextField(6);
        this.c.addFocusListener(focusListener);
        this.F.add((Component)this.c, "flowx,grow,span 5");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableForm.this.c.setText(actionEvent.getActionCommand());
                try {
                    ShopTableForm.this.e();
                    ShopTableForm.this.d();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        Dimension dimension = PosUIManager.getSize(40, 40);
        Font font = new Font(null, 0, 16);
        for (int i = 1; i < 11; ++i) {
            object = new PosButton("" + i);
            ((JComponent)object).setPreferredSize(dimension);
            ((AbstractButton)object).addActionListener(actionListener);
            ((JComponent)object).setFont(font);
            this.F.add((Component)object, "gap 0,grow");
        }
        jPanel.add((Component)this.F, "cell 1 5,growx");
        this.f = new JCheckBox(Messages.getString("ShopTableForm.32"));
        jPanel.add((Component)this.f, "cell 1 6, grow");
        this.h = new JPanel();
        this.h.setBorder(new TitledBorder(null, Messages.getString("ShopTableForm.4"), 4, 2, null, null));
        jPanel.add((Component)this.h, "cell 1 7,grow");
        this.h.setLayout(new FlowLayout(0, 5, 5));
        this.i = new JRadioButton(Messages.getString("ShopTableForm.5"));
        this.h.add(this.i);
        this.j = new JRadioButton(Messages.getString("ShopTableForm.9"));
        this.h.add(this.j);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        jPanel.add((Component)new JLabel(), "grow,span");
        object = (FloorLayoutPlugin)ExtensionManager.getPlugin(FloorLayoutPlugin.class);
        if (object != null) {
            this.k = new JButton(Messages.getString("ShopTableForm.40"));
            jPanel.add((Component)new JLabel(Messages.getString("ShopTableForm.10")), "cell 0 8");
            jPanel.add((Component)jScrollPane, "cell 1 8,wrap,grow");
            jPanel.add((Component)this.k, "cell 1 9");
            this.k.addActionListener(new ActionListener((FloorLayoutPlugin)object){
                final /* synthetic */ FloorLayoutPlugin a;
                {
                    this.a = floorLayoutPlugin;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog(this.a.getBeanEditor());
                    beanEditorDialog.open();
                    ShopTableForm.this.g.setModel(ShopTableTypeDAO.getInstance().findAll());
                }
            });
        }
        if (SystemProperties.isForeTees()) {
            jPanel.add((Component)new JLabel(Messages.getString("ShopTableForm.37")), "cell 0 10");
            jPanel.add((Component)this.E, "cell 1 10,split 2,growx");
            jPanel.add((Component)this.G, "");
        }
        this.add((Component)jPanel, "growx,aligny top");
        this.b();
        this.E.setModel(new ComboBoxModel(SalesAreaDAO.getInstance().findAll()));
        this.E.setSelectedItem(null);
    }

    protected void doGenerateDefaultSeats() {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            shopTable.setId(this.d.getInteger());
            shopTable.setSeats(null);
            this.e();
            this.d();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void a() {
        SalesArea salesArea = new SalesArea();
        SalesAreaEntryForm salesAreaEntryForm = new SalesAreaEntryForm(salesArea);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)salesAreaEntryForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        SalesArea salesArea2 = (SalesArea)salesAreaEntryForm.getBean();
        this.E.addItem(salesArea2);
        this.E.setSelectedItem(salesArea2);
    }

    private void b() {
        this.w = new JPanel(new BorderLayout());
        this.c();
        this.u.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ShopTableForm.this.a(mouseEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.u);
        this.v = new JScrollPane(jPanel);
        this.v.setBorder(BorderFactory.createBevelBorder(1));
        this.u.setBackground(Color.white);
        this.u.setOpaque(true);
        this.w.add((Component)this.v, "Center");
        this.add((Component)this.w, "grow");
    }

    private void c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 0 0 5 0"));
        this.A = new ShapeButton(2);
        this.B = new ShapeButton(0);
        this.C = new ShapeButton(1);
        this.D = new ShapeButton(3);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ShopTable shopTable = (ShopTable)ShopTableForm.this.getBean();
                    if (shopTable == null) {
                        return;
                    }
                    ShopTableForm.this.z = Integer.valueOf(actionEvent.getActionCommand());
                    if (ShopTableForm.this.z == 3) {
                        shopTable.setHeight(ShopTableForm.this.x.getInteger() - 30);
                        ShopTableForm.this.y.setText(String.valueOf(ShopTableForm.this.x.getInteger() - 30));
                        ShopTableForm.this.y.setEditable(false);
                    } else {
                        ShopTableForm.this.y.setEditable(true);
                    }
                    shopTable.setStateTableType(ShopTableForm.this.z);
                    ShopTableForm.this.d();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        this.A.addActionListener(actionListener);
        this.B.addActionListener(actionListener);
        this.C.addActionListener(actionListener);
        this.D.addActionListener(actionListener);
        this.x = new IntegerTextField(3);
        this.y = new IntegerTextField(3);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                try {
                    ShopTable shopTable = (ShopTable)ShopTableForm.this.getBean();
                    if (shopTable == null) {
                        return;
                    }
                    if (ShopTableForm.this.x.getInteger() > 250 || ShopTableForm.this.y.getInteger() > 250) {
                        ShopTableForm.this.x.setText("250");
                        ShopTableForm.this.y.setText("250");
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Size limit is 250");
                        return;
                    }
                    if (ShopTableForm.this.z == 3) {
                        ShopTableForm.this.y.setText(String.valueOf(ShopTableForm.this.x.getInteger() - 30));
                        shopTable.setHeight(ShopTableForm.this.x.getInteger() - 30);
                        ShopTableForm.this.y.setEditable(false);
                    } else {
                        ShopTableForm.this.y.setEditable(true);
                    }
                    shopTable.setWidth(ShopTableForm.this.x.getInteger());
                    shopTable.setHeight(ShopTableForm.this.y.getInteger());
                    ShopTableForm.this.d();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }
        };
        this.x.addFocusListener(focusListener);
        this.y.addFocusListener(focusListener);
        jPanel.add(this.B);
        jPanel.add(this.C);
        jPanel.add(this.A);
        jPanel.add(this.D);
        jPanel.add(new JLabel("Width"));
        jPanel.add((Component)this.x, "width 40!");
        jPanel.add(new JLabel("Height"));
        jPanel.add((Component)this.y, "width 40!");
        this.w.add((Component)jPanel, "North");
    }

    private void d() throws Exception {
        this.u.removeAll();
        ShopTable shopTable = (ShopTable)this.getBean();
        if (shopTable == null) {
            return;
        }
        this.u.setPreferredSize(new Dimension(400, 390));
        ShopTableStyledButton shopTableStyledButton = new ShopTableStyledButton(this.u, shopTable);
        shopTableStyledButton.drawShape(shopTable.getStateTableType());
        this.u.add((Component)shopTableStyledButton, Float.valueOf(0.5f));
        ShopTableDAO.getInstance().initializeSeats(shopTable);
        Set<ShopSeat> set = shopTable.getSeats();
        if (set != null) {
            for (ShopSeat shopSeat : set) {
                SeatButton seatButton = new SeatButton(shopSeat);
                seatButton.setEnabled(this.t);
                this.u.add(seatButton);
            }
        }
        this.u.moveToBack(shopTableStyledButton);
        this.u.revalidate();
        this.u.repaint();
    }

    private void a(MouseEvent mouseEvent) {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            if (!this.t) {
                return;
            }
            if (shopTable == null) {
                return;
            }
            if (shopTable.getSeats() != null && shopTable.getCapacity() <= shopTable.getSeats().size()) {
                POSMessageDialog.showMessage(this, Messages.getString("ShopTableForm.52"));
                return;
            }
            ShopSeatForm shopSeatForm = new ShopSeatForm(shopTable);
            shopSeatForm.setFieldsEditable(true);
            shopSeatForm.createNew();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(shopSeatForm);
            beanEditorDialog.setTitle("Enter seat number");
            beanEditorDialog.pack();
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ShopSeat shopSeat = shopSeatForm.getSeat();
            shopSeat.setTableId(shopTable.getId());
            shopSeat.setPosX(mouseEvent.getX() - 20);
            shopSeat.setPosY(mouseEvent.getY() - 20);
            shopTable.addToseats(shopSeat);
            SeatButton seatButton = new SeatButton(shopSeat);
            this.u.add(seatButton);
            this.u.moveToFront(seatButton);
            this.u.revalidate();
            this.u.repaint();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), exception.getMessage(), exception);
        }
    }

    public ShopTable getTable() {
        return (ShopTable)this.getBean();
    }

    @Override
    public void createNew() {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            ShopTable shopTable2 = new ShopTable();
            this.setBean(shopTable2);
            int n = ShopTableDAO.getInstance().getNextTableNumber() + 1;
            this.d.setEditable(true);
            this.d.setText(String.valueOf(n));
            this.c.setText(this.isDuplicateOn() ? String.valueOf(shopTable.getCapacity()) : "4");
            this.a.setText("");
            this.e.setText("");
            this.x.setText(this.isDuplicateOn() ? String.valueOf(shopTable.getWidth()) : "230");
            this.y.setText(this.isDuplicateOn() ? String.valueOf(shopTable.getHeight()) : "130");
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.18")));
            shopTable2.setId(this.d.getInteger());
            shopTable2.setCapacity(this.isDuplicateOn() ? shopTable.getCapacity() : 4);
            shopTable2.setStateTableType(this.z);
            shopTable2.setWidth(this.isDuplicateOn() ? shopTable.getWidth() : 230);
            shopTable2.setHeight(this.isDuplicateOn() ? shopTable.getHeight() : 130);
            this.t = true;
            if (this.isDuplicateOn()) {
                this.a(shopTable, shopTable2);
                shopTable2.setSalesAreaId(shopTable.getSalesAreaId());
            } else {
                this.e();
            }
            this.d();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    private void a(ShopTable shopTable, ShopTable shopTable2) {
        Set<ShopSeat> set = shopTable.getSeats();
        if (set == null) {
            return;
        }
        if (shopTable2.getSeats() == null) {
            shopTable2.setSeats(new HashSet<ShopSeat>());
        }
        shopTable2.getSeats().clear();
        for (ShopSeat shopSeat : set) {
            ShopSeat shopSeat2 = new ShopSeat();
            Date date = new Date();
            shopSeat2.setLastSyncTime(date);
            shopSeat2.setLastUpdateTime(date);
            shopSeat2.setSeatNumber(shopSeat.getSeatNumber());
            shopSeat2.setPosX(shopSeat.getPosX());
            shopSeat2.setPosY(shopSeat.getPosY());
            shopSeat2.setDisable(shopSeat.isDisable());
            shopSeat2.setTableId(shopTable2.getId());
            shopSeat2.setProperties(shopSeat.getProperties());
            shopTable2.getSeats().add(shopSeat2);
        }
        shopTable2.setStateTableType(shopTable.getStateTableType());
    }

    @Override
    public void cancel() {
        ShopTable shopTable = (ShopTable)this.getBean();
        if (shopTable != null) {
            this.setBean(ShopTableDAO.getInstance().get(shopTable.getId()));
        }
        this.t = false;
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.46")));
    }

    @Override
    public void clearFields() {
        this.d.setText("");
        this.c.setText("");
        this.a.setText("");
        this.e.setText("");
        this.g.unCheckAll();
        this.i.setSelected(false);
        this.j.setSelected(false);
    }

    @Override
    public boolean delete() {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            if (shopTable == null) {
                return false;
            }
            shopTable = ShopTableDAO.getInstance().get(shopTable.getId());
            TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
            if (tableStatus.equals((Object)TableStatus.Booked) || tableStatus.equals((Object)TableStatus.Serving)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ShopTableForm.100"));
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.14"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return false;
            }
            List<BookingInfo> list = BookingInfoDAO.getInstance().findAll();
            block2: for (BookingInfo bookingInfo : list) {
                List<ShopTable> list2 = bookingInfo.getTables();
                for (ShopTable shopTable2 : list2) {
                    if (!shopTable2.getId().equals(shopTable.getId())) continue;
                    list2.remove(shopTable2);
                    bookingInfo.setTables(list2);
                    BookingInfoDAO.getInstance().saveOrUpdate(bookingInfo);
                    continue block2;
                }
            }
            shopTable.setFloor(null);
            shopTable.setSeats(null);
            ShopTableDAO.getInstance().delete(shopTable);
            this.c.setText("");
            this.a.setText("");
            this.e.setText("");
            this.d.setText("");
            this.g.unCheckAll();
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    public boolean deleteAllTables() {
        try {
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.20"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return false;
            }
            boolean bl = ShopTableDAO.getInstance().deleteAllTables();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.19"));
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.20"));
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
        this.d.setText("");
        this.c.setText("");
        this.a.setText("");
        this.e.setText("");
        this.g.unCheckAll();
        return true;
    }

    public void setFieldsEditable(boolean bl) {
        this.e.setEditable(bl);
        this.a.setEditable(bl);
        this.c.setEditable(bl);
        this.f.setEnabled(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        try {
            this.g.setEnabled(bl);
            this.g.clearSelection();
            this.d.setEnabled(bl);
            this.e.setEnabled(bl);
            this.a.setEnabled(bl);
            this.c.setEnabled(bl);
            this.b.setEnabled(bl);
            this.E.setEnabled(bl);
            this.G.setEnabled(bl);
            this.f.setEnabled(bl);
            for (Component component : this.F.getComponents()) {
                component.setEnabled(bl);
            }
            if (this.k != null) {
                this.k.setEnabled(bl);
            }
            this.i.setEnabled(bl);
            this.j.setEnabled(bl);
            this.t = bl;
            this.x.setEnabled(bl);
            this.y.setEnabled(bl);
            this.B.setEnabled(bl);
            this.A.setEnabled(bl);
            this.C.setEnabled(bl);
            this.D.setEnabled(bl);
            this.d();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public void setOnlyStatusEnable() {
        this.d.setEditable(false);
        this.e.setEditable(false);
        this.a.setEditable(false);
        this.c.setEditable(false);
        this.w.setVisible(false);
        this.g.setEnabled(false);
        if (this.k != null) {
            this.k.setVisible(false);
        }
        this.i.setEnabled(true);
        this.j.setEnabled(true);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ShopTable shopTable = (ShopTable)this.getBean();
            ShopTableDAO.getInstance().saveOrUpdate(shopTable);
            ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException | StaleStateException throwable) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        return false;
    }

    @Override
    protected void updateView() {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            if (shopTable == null) {
                return;
            }
            ShopTableDAO.getInstance().initializeTypes(shopTable);
            Integer n = shopTable.getWidth();
            Integer n2 = shopTable.getHeight();
            if (n == null || n == 0) {
                n = TerminalConfig.getFloorButtonWidth();
            }
            if (n2 == null || n2 == 0) {
                n2 = TerminalConfig.getFloorButtonHeight();
            }
            this.x.setText(String.valueOf(n));
            this.y.setText(String.valueOf(n2));
            this.z = shopTable.getStateTableType();
            this.g.setModel(ShopTableTypeDAO.getInstance().findAll());
            this.g.selectItems(shopTable.getTypes());
            this.d.setText(String.valueOf(shopTable.getTableNumber()));
            this.e.setText(shopTable.getName());
            this.a.setText(shopTable.getDescription());
            this.c.setText(String.valueOf(shopTable.getCapacity()));
            this.b.setText(String.valueOf(shopTable.getMinCapacity()));
            this.f.setSelected(shopTable.isReservable());
            this.i.setSelected(true);
            TableStatus tableStatus = shopTable.getTableStatus();
            if (tableStatus == TableStatus.Disable) {
                this.j.setSelected(true);
            }
            this.E.setSelectedItem(shopTable.getSalesArea());
            this.r = shopTable.getTableNumber() != null ? shopTable.getTableNumber() : 0;
            if (!this.isDuplicateOn()) {
                List list = this.g.getCheckedValues();
                this.q = list;
                this.o = shopTable.getMinCapacity();
                this.n = shopTable.getCapacity();
                this.p = shopTable.getDescription();
                this.m = shopTable.getName();
            }
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.46")));
            this.d();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        ShopTable shopTable = (ShopTable)this.getBean();
        if (shopTable == null) {
            shopTable = new ShopTable();
            this.setBean(shopTable, false);
        }
        if (!this.isDuplicateOn() && this.d.getInteger() == 0) {
            POSMessageDialog.showError(null, Messages.getString("ShopTableForm.57"));
            return false;
        }
        Set<ShopSeat> set = shopTable.getSeats();
        ShopTable shopTable2 = ShopTableDAO.getInstance().get(this.d.getInteger());
        if (shopTable2 != null && this.r != shopTable2.getId()) {
            if (shopTable2.isDeleted().booleanValue()) {
                if (set != null && set.size() > 0) {
                    for (ShopSeat object : set) {
                        object.setServing(Boolean.FALSE);
                        object.setBooked(Boolean.FALSE);
                        object.setStatus(null);
                        object.setTableId(shopTable2.getId());
                    }
                }
                shopTable = shopTable2;
                shopTable.setTableStatus(TableStatus.Available);
                this.setBean(shopTable, false);
                shopTable.setDeleted(false);
                shopTable.setSeats(set);
            } else {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.58"));
                return false;
            }
        }
        shopTable.setWidth(this.x.getInteger());
        shopTable.setHeight(this.y.getInteger());
        if (this.isDuplicateOn()) {
            if (shopTable.getId() == null) {
                int n = ShopTableDAO.getInstance().getNextTableNumber() + 1;
                shopTable.setId(n);
            }
            shopTable.setTypes(this.q);
            shopTable.setCapacity(this.n);
            shopTable.setMinCapacity(this.o);
            shopTable.setDescription(this.p);
            shopTable.setName(this.m);
            this.setDuplicate(false);
        } else {
            Comparable comparable;
            shopTable.setId(this.d.getInteger());
            shopTable.setStateTableType(this.z);
            shopTable.setName(this.e.getText());
            shopTable.setDescription(this.a.getText());
            shopTable.setCapacity(this.c.getInteger());
            shopTable.setMinCapacity(this.b.getInteger());
            shopTable.setReservable(this.f.isSelected());
            List list = this.g.getCheckedValues();
            shopTable.setTypes(list);
            TableStatus tableStatus = shopTable.getShopTableStatus().getTableStatus();
            if (tableStatus != null) {
                comparable = shopTable.getShopTableStatus();
                if (this.j.isSelected()) {
                    if (tableStatus.equals((Object)TableStatus.Booked) || tableStatus.equals((Object)TableStatus.Serving)) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), (Object)((Object)tableStatus) + Messages.getString("ShopTableForm.29"));
                        return false;
                    }
                    ((ShopTableStatus)comparable).setTableStatus(TableStatus.Disable);
                } else if (tableStatus.equals((Object)TableStatus.Disable)) {
                    shopTable.setTableStatus(TableStatus.Available);
                } else {
                    shopTable.setTableStatus(tableStatus);
                }
                shopTable.setShopTableStatus((ShopTableStatus)comparable);
            }
            comparable = (SalesArea)this.E.getSelectedItem();
            shopTable.setSalesArea((SalesArea)comparable);
        }
        this.setNewTable(shopTable.getId());
        return true;
    }

    private void e() {
        ShopTable shopTable = (ShopTable)this.getBean();
        int n = 0;
        int n2 = this.c.getInteger();
        if (shopTable.getSeats() != null) {
            ArrayList<ShopSeat> arrayList = new ArrayList<ShopSeat>(shopTable.getSeats());
            Collections.sort(arrayList, new Comparator<ShopSeat>(){

                @Override
                public int compare(ShopSeat shopSeat, ShopSeat shopSeat2) {
                    return shopSeat.getSeatNumber() - shopSeat2.getSeatNumber();
                }
            });
            n = arrayList.size();
            if (n2 < n) {
                int n3 = 1;
                for (ShopSeat shopSeat : arrayList) {
                    if (n3 > n2) {
                        shopTable.getSeats().remove(shopSeat);
                    }
                    ++n3;
                }
                return;
            }
        }
        for (int i = n; i < n2; ++i) {
            ShopSeat shopSeat = new ShopSeat(shopTable, i + 1, this.f().get(i), this.g().get(i));
            shopTable.addToseats(shopSeat);
            if (i == 9) break;
        }
    }

    @Override
    public void edit() {
        ShopTable shopTable = (ShopTable)this.getBean();
        ShopTableDAO.getInstance().refresh(shopTable);
        this.setBean(shopTable);
        this.t = true;
        this.d.setEditable(false);
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.17")));
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("ShopTableForm.18");
    }

    public void setTableTypeCBoxListEnable(boolean bl) {
        this.g.setEnabled(bl);
    }

    public boolean isDuplicateOn() {
        return this.s;
    }

    public void setDuplicate(boolean bl) {
        this.s = bl;
    }

    public int getNewTable() {
        return this.l;
    }

    public void setNewTable(int n) {
        this.l = n;
    }

    private List<Integer> f() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(89);
        arrayList.add(163);
        arrayList.add(237);
        arrayList.add(319);
        arrayList.add(319);
        arrayList.add(239);
        arrayList.add(166);
        arrayList.add(93);
        arrayList.add(12);
        arrayList.add(11);
        return arrayList;
    }

    private List<Integer> g() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(52);
        arrayList.add(52);
        arrayList.add(52);
        arrayList.add(122);
        arrayList.add(194);
        arrayList.add(268);
        arrayList.add(268);
        arrayList.add(268);
        arrayList.add(196);
        arrayList.add(124);
        return arrayList;
    }

    @Override
    public void refresh() {
        ShopTableDAO.getInstance().refresh(this.getBean());
        this.updateView();
    }

    class ShapeButton
    extends PosButton {
        int a;

        public ShapeButton(int n) {
            this.a = n;
            this.setActionCommand(String.valueOf(n));
            this.setPreferredSize(new Dimension(30, 30));
            this.setOpaque(true);
            this.setBackground(Color.white);
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(2.0f));
            if (this.a == 2) {
                graphics2D.drawOval(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            } else if (this.a == 1) {
                graphics2D.drawRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 5, 5);
            } else if (this.a == 3) {
                graphics2D.rotate(Math.toRadians(45.0));
                graphics2D.drawRect(10, -10, this.getSize().width - 10, this.getSize().height - 10);
            } else {
                graphics2D.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            }
        }
    }

    class SeatButton
    extends PosButton
    implements MouseListener,
    MouseMotionListener {
        ShopSeat a;
        int b;
        int e;

        public SeatButton(ShopSeat shopSeat) {
            this.a = shopSeat;
            this.setText(shopSeat.getSeatNumber() + "");
            this.setBounds(shopSeat.getPosX(), shopSeat.getPosY(), 70, 70);
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public ShopSeat getSeat() {
            return this.a;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!ShopTableForm.this.t) {
                return;
            }
            try {
                int n = mouseEvent.getX() - this.b + this.getLocation().x;
                int n2 = mouseEvent.getY() - this.e + this.getLocation().y;
                int n3 = ((ShopTableForm)ShopTableForm.this).u.getBounds().width - 40;
                int n4 = ((ShopTableForm)ShopTableForm.this).u.getBounds().height - 40;
                if (n < 0 || n > n3) {
                    return;
                }
                if (n2 < 0 || n2 > n4) {
                    return;
                }
                this.a.setPosX(n);
                this.a.setPosY(n2);
                this.setLocation(n, n2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("FloorView.24"));
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                if (!ShopTableForm.this.t) {
                    return;
                }
                ShopSeatForm shopSeatForm = new ShopSeatForm((ShopTable)ShopTableForm.this.getBean());
                shopSeatForm.setBean(this.a);
                final BeanEditorDialog beanEditorDialog = new BeanEditorDialog(shopSeatForm);
                beanEditorDialog.setTitle(Messages.getString("ShopTableForm.30"));
                PosButton posButton = new PosButton(POSConstants.DELETE);
                posButton.setPreferredSize(new Dimension(100, 60));
                posButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            int n = POSMessageDialog.showYesNoQuestionDialog(SeatButton.this.getParent(), Messages.getString("ShopTableForm.31"), POSConstants.CONFIRM);
                            if (n != 0) {
                                return;
                            }
                            ((ShopTable)ShopTableForm.this.getBean()).getSeats().remove(SeatButton.this.a);
                            beanEditorDialog.dispose();
                            ShopTableForm.this.d();
                        }
                        catch (Exception exception) {
                            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                        }
                    }
                });
                TransparentPanel transparentPanel = beanEditorDialog.getButtonPanel();
                Component[] componentArray = transparentPanel.getComponents();
                transparentPanel.removeAll();
                transparentPanel.add(posButton);
                for (Component component : componentArray) {
                    transparentPanel.add(component);
                }
                beanEditorDialog.pack();
                beanEditorDialog.open();
                if (!beanEditorDialog.isCanceled()) {
                    ShopTableForm.this.d();
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.b = mouseEvent.getX();
            this.e = mouseEvent.getY();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

