/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.ListTableModel;
import java.util.List;

public class CourseOrganizeTableModel
extends ListTableModel<ITicketItem> {
    protected String[] columnNames = new String[]{Messages.getString("TicketViewerTableModel.0")};

    public void setItems(List<ITicketItem> list) {
        if (list == null) {
            super.setRows(null);
            return;
        }
        this.setRows(list);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ITicketItem iTicketItem = (ITicketItem)this.getRowData(n);
        if (iTicketItem == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                TicketItem ticketItem;
                String string = iTicketItem.getNameDisplay();
                String string2 = "";
                if (iTicketItem instanceof TicketItem && (ticketItem = (TicketItem)iTicketItem).getSeat() != null) {
                    string2 = "[S." + ticketItem.getSeat().getSeatNumber() + "]  ";
                }
                return string2 + string;
            }
            case 1: {
                return iTicketItem.getSubTotalAmountDisplay();
            }
        }
        return null;
    }

    public Object delete(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return null;
        }
        Object e = this.getRowData(n);
        super.deleteItem(n);
        this.fireTableRowsDeleted(n, n);
        return e;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void update() {
        this.fireTableDataChanged();
    }

    public void insertRow(int n, Object object) {
        ITicketItem iTicketItem = (ITicketItem)object;
        this.getRows().add(n, iTicketItem);
        this.fireTableDataChanged();
    }
}

