/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.main.Application;
import com.floreantpos.model.GuestCheckPrint;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.GuestCheckPrintDAO;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosScrollPane;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class OrderInfoView
extends JPanel {
    private List<Ticket> a;
    private JPanel b;

    public OrderInfoView(List<Ticket> list) throws Exception {
        this.a = list;
        this.createUI();
    }

    public void setTickets(List<Ticket> list) {
        this.a = list;
    }

    public void createUI() throws Exception {
        this.b = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        PosScrollPane posScrollPane = new PosScrollPane(this.b);
        posScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.createReport();
        this.setLayout(new BorderLayout());
        this.add(posScrollPane);
    }

    public void createReport() throws Exception {
        for (int i = 0; i < this.a.size(); ++i) {
            Ticket ticket = this.a.get(i);
            ReceiptPrintServiceProvider.get().rendererTicketReceipt(ticket, this.b);
        }
    }

    public void createReport(PosTransaction posTransaction) throws Exception {
        ReceiptPrintServiceProvider.get().rendererPosTransactionReceipt(posTransaction, this.b);
    }

    public void print() throws Exception {
        for (Ticket ticket : this.a) {
            ReceiptPrintService.printTicket(ticket);
        }
    }

    public void printCopy(String string) throws Exception {
        for (Ticket ticket : this.a) {
            this.a(ticket);
            ReceiptPrintService.printTicket(ticket, string);
        }
    }

    public List<Ticket> getTickets() {
        return this.a;
    }

    public JPanel getReportPanel() {
        return this.b;
    }

    private void a(Ticket ticket) {
        GuestCheckPrint guestCheckPrint = new GuestCheckPrint();
        guestCheckPrint.setTicketId(ticket.getId());
        guestCheckPrint.setPrintTime(new Date());
        guestCheckPrint.setTicketTotal(ticket.getTotalAmountWithTips());
        guestCheckPrint.setUser(Application.getCurrentUser());
        guestCheckPrint.setTableNo(ticket.getTableNameDisplay());
        GuestCheckPrintDAO.getInstance().saveOrUpdate(guestCheckPrint);
    }
}

