/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketTransferView
extends TransparentPanel
implements ActionListener {
    private PosButton a;
    private PosButton b;
    private PosButton c;
    private PosButton d;
    private JScrollPane e;
    private JTextField f;
    private JTextField g;
    private JTextField h;
    private JTextField i;
    private JLabel j;
    private TicketViewerTable k;
    private int l = 1;
    protected int splitNumber;
    private List<Integer> m;
    private List<Ticket> n;
    private Ticket o;
    private TicketTransferView p;
    private ButtonGroup q;
    private ArrayList<POSToggleButton> r;
    private final String s = "ticket";
    private POSToggleButton t;
    private ORIENTATION u;

    public TicketTransferView(List<Ticket> list, ORIENTATION oRIENTATION) {
        this.n = list;
        this.u = oRIENTATION;
        this.a();
        this.setOpaque(true);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(null, "*", 2, 0));
        this.add((Component)this.b(), "North");
        this.add((Component)this.c(), "Center");
        this.add((Component)this.e(), "East");
        this.add((Component)this.d(), "South");
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout());
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout());
        this.q = new ButtonGroup();
        this.r = new ArrayList();
        for (Ticket ticket : this.n) {
            POSToggleButton pOSToggleButton = new POSToggleButton(Messages.getString("TicketTransferView.2") + ticket.getTokenNo());
            pOSToggleButton.putClientProperty("ticket", ticket);
            pOSToggleButton.addActionListener(this);
            this.r.add(pOSToggleButton);
            this.q.add(pOSToggleButton);
            jPanel2.add(pOSToggleButton);
        }
        jPanel3.add(new JLabel(Messages.getString("TicketTransferView.0")));
        this.j = new JLabel();
        jPanel3.add(this.j);
        jPanel.add((Component)jPanel2, "wrap");
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel c() {
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        transparentPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.e = new JScrollPane();
        this.k = new TicketViewerTable();
        this.e.setHorizontalScrollBarPolicy(31);
        this.e.setVerticalScrollBarPolicy(21);
        this.e.setViewportView(this.k);
        transparentPanel.add((Component)this.e, "Center");
        return transparentPanel;
    }

    private JPanel d() {
        int n = PosUIManager.getSize(60) + 10;
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,right,inset 5 5 5 " + n + " "));
        JLabel jLabel = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel jLabel2 = new JLabel(POSConstants.TOTAL + ":");
        JLabel jLabel3 = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel jLabel4 = new JLabel(POSConstants.TAX + ":");
        jLabel.setHorizontalAlignment(4);
        jLabel2.setHorizontalAlignment(4);
        jLabel3.setHorizontalAlignment(4);
        jLabel4.setHorizontalAlignment(4);
        this.g = new JTextField();
        this.g.setHorizontalAlignment(11);
        this.g.setColumns(10);
        this.h = new JTextField();
        this.h.setHorizontalAlignment(11);
        this.h.setColumns(10);
        this.f = new JTextField();
        this.f.setHorizontalAlignment(11);
        this.f.setColumns(10);
        this.i = new JTextField();
        this.i.setHorizontalAlignment(11);
        this.i.setColumns(10);
        this.g.setEditable(false);
        this.i.setEditable(false);
        this.f.setEditable(false);
        this.h.setEditable(false);
        transparentPanel.add(jLabel);
        transparentPanel.add(this.g);
        transparentPanel.add(jLabel3);
        transparentPanel.add(this.f);
        transparentPanel.add(jLabel4);
        transparentPanel.add(this.h);
        transparentPanel.add(jLabel2);
        transparentPanel.add(this.i);
        return transparentPanel;
    }

    private JPanel e() {
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 1,fill,hidemode 3,inset 1"));
        this.b = new PosButton();
        this.b.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.b.setPreferredSize(PosUIManager.getSize(60, 50));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketTransferView.this.b(actionEvent);
            }
        });
        transparentPanel.add((Component)this.b, "grow");
        this.a = new PosButton();
        this.a.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.a.setPreferredSize(PosUIManager.getSize(60, 50));
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketTransferView.this.a(actionEvent);
            }
        });
        transparentPanel.add((Component)this.a, "grow");
        this.c = new PosButton();
        this.c.setPreferredSize(PosUIManager.getSize(60, 50));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketTransferView.this.f();
            }
        });
        transparentPanel.add((Component)this.c, "grow");
        this.d = new PosButton(">>>");
        this.d.setFont(new Font("Tahoma", 1, 18));
        this.d.setPreferredSize(PosUIManager.getSize(60, 50));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketTransferView.this.g();
            }
        });
        transparentPanel.add((Component)this.d, "grow");
        if (this.u.equals((Object)ORIENTATION.LEFT)) {
            this.c.setIcon(IconFactory.getIcon("next.png"));
            this.d.setText(">>>");
        } else {
            this.c.setIcon(IconFactory.getIcon("previous.png"));
            this.d.setText("<<<");
        }
        return transparentPanel;
    }

    private void f() {
        try {
            int n = this.k.getSelectedRow();
            ITicketItem iTicketItem = this.k.get(n);
            if (iTicketItem instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                double d = ticketItem.getQuantity();
                this.transferTicketItem(ticketItem, d);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() {
        try {
            List<TicketItem> list = this.k.getTicketItems();
            for (TicketItem ticketItem : list) {
                this.transferTicketItem(ticketItem, ticketItem.getQuantity());
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void transferTicketItem(TicketItem ticketItem, Double d) {
        TicketItem ticketItem2 = ticketItem.clone();
        ticketItem2.setId(null);
        ticketItem2.setVersion(0L);
        double d2 = NumberUtil.roundToTwoDigit(ticketItem.getQuantity());
        if (Double.isInfinite(d)) {
            return;
        }
        if (d % 1.0 != 0.0) {
            ticketItem2.setFractionalUnit(true);
        }
        d = NumberUtil.roundToTwoDigit(d);
        this.p.addTicketItem(ticketItem2);
        this.p.updateView();
        if (d2 > d) {
            double d3 = ticketItem.getQuantity();
            ticketItem.setQuantity(d3 - d);
            if (ticketItem.getQuantity() % 1.0 != 0.0) {
                ticketItem.setFractionalUnit(true);
            }
        } else {
            this.k.delete(ticketItem.getTableRowNum());
        }
        this.o.getTicketItems().remove(ticketItem);
        this.updateView();
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.i().addTicketItem(ticketItem);
    }

    public List<Integer> getViewNumbers() {
        return this.m;
    }

    private void a(ActionEvent actionEvent) {
        this.k.scrollDown();
    }

    private void b(ActionEvent actionEvent) {
        this.k.scrollUp();
    }

    public void updateModel() {
        this.o.calculatePrice();
    }

    public void updateView() {
        if (this.o == null || this.o.getTicketItems() == null || this.o.getTicketItems().size() <= 0) {
            this.g.setText("");
            this.f.setText("");
            this.h.setText("");
            this.i.setText("");
            return;
        }
        this.o.calculatePrice();
        this.g.setText(NumberUtil.formatNumber(this.o.getSubtotalAmount()));
        this.f.setText(NumberUtil.formatNumber(this.o.getDiscountAmount()));
        this.h.setText(NumberUtil.formatNumber(this.o.getTaxAmount()));
        this.i.setText(NumberUtil.formatNumber(this.o.getTotalAmountWithTips()));
        this.h();
    }

    private void h() {
        String string = this.o.getProperty("CUSTOMER_NAME");
        String string2 = this.o.getProperty("CUSTOMER_LAST_NAME");
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)string)) {
            stringBuilder.append(string);
        }
        if (StringUtils.isNotBlank((String)string2)) {
            stringBuilder.append(" ").append(string2);
        }
        this.j.setText(stringBuilder.toString());
    }

    public Ticket getTicket() {
        return this.o;
    }

    public TicketTransferView getOtherTicketView() {
        return this.p;
    }

    public void setOtherTicketView(TicketTransferView ticketTransferView) {
        this.p = ticketTransferView;
    }

    public int getViewNumber() {
        return this.l;
    }

    private TicketViewerTable i() {
        return this.k;
    }

    public void setSelectTicketButton(int n) {
        this.t = this.r.get(n);
        this.t.setSelected(true);
        this.o = (Ticket)this.t.getClientProperty("ticket");
        this.k.setTicket(this.o);
        this.updateView();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
            if (pOSToggleButton.isSelected()) {
                Ticket ticket = (Ticket)pOSToggleButton.getClientProperty("ticket");
                if (this.p.getTicket() != null && this.p.getTicket().equals(ticket)) {
                    pOSToggleButton.setSelected(false);
                    this.t.setSelected(true);
                    return;
                }
                this.t = (POSToggleButton)actionEvent.getSource();
                this.setCurrentTicket(ticket);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void setCurrentTicket(Ticket ticket) {
        this.o = ticket;
        this.k.setTicket(ticket);
        this.updateView();
    }

    public List<Ticket> getTickets() {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        for (POSToggleButton pOSToggleButton : this.r) {
            arrayList.add((Ticket)pOSToggleButton.getClientProperty("ticket"));
        }
        return arrayList;
    }

    public static enum ORIENTATION {
        LEFT,
        RIGHT;

    }
}

