/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SeatSelectionAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MiscTicketItemDialog;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.dialog.SalesAreaSelectionDialog;
import com.floreantpos.ui.order.CourseOrganizeDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class OrderView
extends ViewPanel
implements RefreshableView,
DataChangeListener,
TicketEditListener,
PaymentListener {
    private HashMap<String, JComponent> a = new HashMap();
    public static final String VIEW_NAME = "ORDER_VIEW";
    private static OrderView b;
    private Ticket c;
    private CategoryView d = new CategoryView();
    private GroupView e = new GroupView();
    private MenuItemView f = new MenuItemView();
    private TicketView g = new TicketView();
    private TransparentPanel h = new TransparentPanel(new BorderLayout(5, 5));
    private JPanel i = new JPanel(new BorderLayout());
    private JPanel j = this.f();
    private OrderController k = new OrderController(this);
    private JPanel l = new JPanel((LayoutManager)new MigLayout("fill, ins 2, hidemode 3", "fill", "fill"));
    private PosButton m = new PosButton(POSConstants.HOLD_BUTTON_TEXT);
    private PosButton n = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton o = new PosButton(POSConstants.SEND_TO_KITCHEN);
    private PosButton p = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
    private PosButton q = new PosButton(POSConstants.GUEST_NO_BUTTON_TEXT);
    private PosButton r = new PosButton(Messages.getString("OrderView.7"));
    private PosButton s = new PosButton(POSConstants.MISC_BUTTON_TEXT);
    private PosButton t = new PosButton(POSConstants.ORDER_TYPE_BUTTON_TEXT);
    private PosButton u = new PosButton(POSConstants.TABLE_NO_BUTTON_TEXT);
    private PosButton v = new PosButton(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
    private PosButton w = new PosButton(Messages.getString("OrderView.1"));
    private PosButton x = new PosButton("<html><center>" + POSConstants.ORGANIZE_COURSE + "</center></html>");
    private PosButton y = new PosButton(Messages.getString("OrderView.25"));
    private PosButton z = new PosButton(Messages.getString("OrderView.2"));
    private PosButton A = new PosButton(Messages.getString("OrderView.5"));
    private SeatSelectionAction B = new SeatSelectionAction();
    private PosButton C = new PosButton(Messages.getString("TicketView.43"));
    private boolean D;
    private boolean E;
    private JTextField F;
    private JTextField G;
    private JTextField H;
    private JTextField I;
    private JTextField J;
    private JTextField K;
    private PaymentView L;

    private OrderView() {
        this.a();
        this.g.getTicketViewerTable().addTicketUpdateListener(this);
        this.k.addTicketUpdateListener(this);
    }

    public void addView(String string, JComponent jComponent) {
        JComponent jComponent2 = this.a.get(string);
        if (jComponent2 != null) {
            return;
        }
        this.h.add((Component)jComponent, string);
    }

    private void a() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(2, 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.g);
        jPanel.add((Component)this.j, "South");
        this.i.add(jPanel);
        this.h.setOpaque(false);
        this.h.setBorder(null);
        this.h.add((Component)this.e, "North");
        this.h.add(this.f);
        this.c();
        this.t.setVisible(false);
        this.showView("VIEW_EMPTY");
    }

    private void b() {
        ITicketItem iTicketItem = this.g.getTicketViewerTable().getSelected();
        if (iTicketItem == null) {
            this.C.setEnabled(false);
        } else {
            this.C.setEnabled(iTicketItem.canAddDiscount());
        }
    }

    private void c() {
        this.g.getTicketViewerTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    OrderView.this.b();
                }
            }
        });
        this.A.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doAddSalesArea();
            }
        });
        this.n.addActionListener(actionEvent -> this.n());
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OrderView.this.g.isCancelable()) {
                    OrderView.this.g.doCancelOrder();
                    OrderView.this.k.fireTicketEditingFinish(OrderView.this.c);
                    return;
                }
                int n = POSMessageDialog.showYesNoQuestionDialog(null, Messages.getString("OrderView.4"), Messages.getString("CONFIRM"));
                if (n != 0) {
                    return;
                }
                VoidTicketAction voidTicketAction = new VoidTicketAction(OrderView.this.c);
                voidTicketAction.execute();
                if (OrderView.this.c.isVoided().booleanValue()) {
                    OrderView.this.g.doCancelOrder();
                    OrderView.this.g.setAllowToLogOut(true);
                }
                OrderView.this.k.fireTicketEditingFinish(OrderView.this.c);
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.m();
            }
        });
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.l();
            }
        });
        this.x.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.e();
            }
        });
        this.t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.v.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doAddEditCustomer();
            }
        });
        this.y.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.d();
            }
        });
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doInsertMisc(actionEvent);
            }
        });
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.btnCustomerNumberActionPerformed();
            }
        });
        this.B.setSource(this.r);
        this.r.setAction(this.B);
        this.u.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doSetTables();
            }
        });
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doHoldOrder();
            }
        });
        this.C.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.addDiscount();
            }
        });
        this.z.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrderView.this.doShowDeliveryDialog();
            }
        });
        this.l.add(this.t);
        this.l.add(this.v);
        this.l.add(this.y);
        this.l.add(this.z);
        this.l.add(this.u);
        this.l.add(this.q);
        this.l.add(this.r);
        this.l.add(this.A);
        this.l.add(this.x);
        this.l.add(this.s);
        this.l.add(this.m);
        this.l.add(this.o);
        this.l.add(this.w);
        this.l.add(this.p);
        this.l.add(this.n);
        this.z.setVisible(false);
    }

    private void d() {
        String string = this.c.getNote();
        NotesDialog notesDialog = new NotesDialog();
        notesDialog.setTitle(VersionInfo.getAppName());
        notesDialog.setCaption(Messages.getString("OrderView.104"));
        notesDialog.setNote(string);
        notesDialog.setSize(PosUIManager.getSize(900, 500));
        notesDialog.open();
        if (notesDialog.isCanceled()) {
            return;
        }
        string = notesDialog.getNote();
        if (notesDialog.getNote() != null) {
            this.c.setNote(string);
        }
    }

    private void e() {
        if (DataProvider.get().getCourses().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.15"));
            return;
        }
        CourseOrganizeDialog courseOrganizeDialog = new CourseOrganizeDialog(this.c);
        courseOrganizeDialog.openFullScreen();
        if (courseOrganizeDialog.isCanceled()) {
            return;
        }
        this.g.getTicketViewerTable().updateView();
    }

    private JPanel f() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.F = new JTextField(10);
        this.F.setHorizontalAlignment(11);
        this.F.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.G = new JTextField(10);
        this.G.setHorizontalAlignment(11);
        this.G.setEditable(false);
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("Delivery Charge: " + CurrencyUtil.getCurrencySymbol());
        this.H = new JTextField(10);
        this.H.setHorizontalAlignment(11);
        this.H.setEditable(false);
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.I = new JTextField(10);
        this.I.setEditable(false);
        this.I.setHorizontalAlignment(11);
        JLabel jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.J = new JTextField(10);
        this.J.setEditable(false);
        this.J.setHorizontalAlignment(11);
        JLabel jLabel6 = new JLabel();
        jLabel6.setFont(jLabel6.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        jLabel6.setHorizontalAlignment(4);
        jLabel6.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.K = new JTextField(10);
        this.K.setFont(this.K.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.K.setHorizontalAlignment(11);
        this.K.setEditable(false);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 2 2 3 2,alignx trailing,fill", "[grow]2[]", ""));
        transparentPanel.add((Component)jLabel, "growx,aligny center");
        transparentPanel.add((Component)this.F, "growx,aligny center");
        transparentPanel.add((Component)jLabel2, "newline,growx,aligny center");
        transparentPanel.add((Component)this.G, "growx,aligny center");
        transparentPanel.add((Component)jLabel4, "newline,growx,aligny center");
        transparentPanel.add((Component)this.I, "growx,aligny center");
        transparentPanel.add((Component)jLabel5, "newline,growx,aligny center");
        transparentPanel.add((Component)this.J, "growx,aligny center");
        transparentPanel.add((Component)jLabel6, "newline,growx,aligny center");
        transparentPanel.add((Component)this.K, "growx,aligny center");
        return transparentPanel;
    }

    public void updateTicketSummeryView() {
        Ticket ticket = this.g.getTicket();
        if (ticket == null) {
            this.F.setText("");
            this.G.setText("");
            this.H.setText("");
            this.I.setText("");
            this.K.setText("");
            this.J.setText("");
            return;
        }
        this.F.setText(NumberUtil.formatNumber(ticket.getSubtotalAmount()));
        this.G.setText(NumberUtil.formatNumber(ticket.getDiscountAmount()));
        this.H.setText(NumberUtil.formatNumber(ticket.getDeliveryCharge()));
        if (Application.getInstance().isPriceIncludesTax()) {
            this.I.setText(Messages.getString("TicketView.35"));
        } else {
            this.I.setText(NumberUtil.formatNumber(ticket.getTaxAmount()));
        }
        if (ticket.getGratuity() != null) {
            this.J.setText(NumberUtil.formatNumber(ticket.getGratuity().getAmount()));
        } else {
            this.J.setText("0.00");
        }
        this.K.setText(NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
    }

    protected void doShowDeliveryDialog() {
        try {
            Customer customer = CustomerDAO.getInstance().findById(this.c.getCustomerId());
            OrderServiceFactory.getOrderService().showDeliveryInfo(this.c, this.c.getOrderType(), customer);
            if (this.g != null) {
                this.g.updateView();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doSetTables() {
        try {
            Object object;
            int n;
            boolean bl;
            TableSelectorDialog tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(this.c.getOrderType());
            tableSelectorDialog.setTitle(Messages.getString("OrderView.18"));
            tableSelectorDialog.getTableSelector().setTicketTransferMode(true);
            tableSelectorDialog.setCreateNewTicket(false);
            this.c.setShouldUpdateTableStatus(true);
            if (this.c != null) {
                tableSelectorDialog.setTicket(this.c);
            }
            tableSelectorDialog.openUndecoratedFullScreen();
            if (tableSelectorDialog.isCanceled()) {
                return;
            }
            List<ShopTable> list = tableSelectorDialog.getSelectedTables();
            if (list.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.6"));
                return;
            }
            boolean bl2 = bl = this.c.getId() == null && TicketDAO.getInstance().isNewTicket(this.c.getId());
            if (!bl && (n = POSMessageDialog.showYesNoQuestionDialog(this, (String)(object = Messages.getString("OrderView.19")), Messages.getString("CONFIRM"))) != 0) {
                return;
            }
            object = new ArrayList();
            for (ShopTable shopTable : list) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    this.c.setSalesArea(salesArea);
                    this.c.setSalesAreaId(salesArea.getId());
                }
                object.add(shopTable.getId());
            }
            if (!bl) {
                ShopTableDAO.getInstance().transferTickets(this.c, (List<Integer>)object);
            } else {
                this.c.setTableNumbers((List<Integer>)object);
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddSalesArea() {
        try {
            SalesAreaSelectionDialog salesAreaSelectionDialog = new SalesAreaSelectionDialog();
            salesAreaSelectionDialog.open();
            if (salesAreaSelectionDialog.isCanceled()) {
                return;
            }
            SalesArea salesArea = salesAreaSelectionDialog.getSelectedSalesArea();
            this.setFocusable(true);
            this.c.setSalesArea(salesArea);
            this.c.setSalesAreaId(salesArea.getId());
            this.A.setText("<html><center>SALES AREA<br/>" + salesArea.getName() + "</center></html>");
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void btnCustomerNumberActionPerformed() {
        try {
            Ticket ticket = this.c;
            int n = ticket.getNumberOfGuests();
            NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2(5);
            numberSelectionDialog2.setTitle(POSConstants.NUMBER_OF_GUESTS);
            numberSelectionDialog2.setValue(n);
            numberSelectionDialog2.pack();
            numberSelectionDialog2.open();
            if (numberSelectionDialog2.isCanceled()) {
                return;
            }
            n = (int)numberSelectionDialog2.getValue();
            if (n == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
                return;
            }
            ticket.setNumberOfGuests(n);
            this.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doInsertMisc(ActionEvent actionEvent) {
        try {
            MiscTicketItemDialog miscTicketItemDialog = new MiscTicketItemDialog();
            miscTicketItemDialog.setOrderType(this.c.getOrderType());
            miscTicketItemDialog.pack();
            miscTicketItemDialog.open();
            if (!miscTicketItemDialog.isCanceled()) {
                TicketItem ticketItem = miscTicketItemDialog.getTicketItem();
                ticketItem.setTicket(this.c);
                ticketItem.calculatePrice();
                this.g.addTicketItem(ticketItem);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void doAddEditCustomer() {
        try {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.c.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (this.c != null) {
                customerSelectorDialog.setTicket(this.c);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (!customerSelectorDialog.isCanceled()) {
                Customer customer = customerSelectorDialog.getSelectedCustomer();
                this.c.setCustomer(customer);
                if (customer != null) {
                    String string = "<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + customer.getName() + "</center></html>";
                    this.v.setText(string);
                }
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    protected void addDiscount() {
        try {
            ITicketItem iTicketItem = this.g.getTicketViewerTable().getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TicketView.20"));
                return;
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void updateView() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (this.c != null) {
            Object object;
            Object object2;
            List<Integer> list;
            OrderType orderType = this.c.getOrderType();
            if (orderType.isPrepaid().booleanValue()) {
                this.n.setVisible(false);
            } else {
                this.n.setVisible(true);
            }
            if (!orderType.isShouldPrintToKitchen().booleanValue()) {
                this.o.setEnabled(false);
            } else {
                this.o.setEnabled(true);
            }
            if (!orderType.isAllowSeatBasedOrder().booleanValue()) {
                this.r.setVisible(false);
            } else {
                this.r.setVisible(true);
                list = null;
                object2 = this.B.getLastSeat(this.c);
                if (object2 instanceof Integer) {
                    list = (Integer)object2;
                    this.r.putClientProperty("SEAT_NO", list);
                } else if (object2 instanceof TicketItemSeat) {
                    object = (TicketItemSeat)this.B.getLastSeat(this.c);
                    this.r.putClientProperty("SEAT_NO", object);
                }
            }
            if (!orderType.isShowTableSelection().booleanValue()) {
                this.q.setVisible(false);
                this.u.setVisible(false);
            } else {
                this.q.setVisible(true);
                this.u.setVisible(true);
                if (!terminal.isShowTableNumber()) {
                    this.u.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.c.getTableNames() + "</center><html/>");
                } else {
                    list = this.c.getTableNumbers();
                    if (list != null) {
                        this.u.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.c.getTableNameDisplay() + "</center><html/>");
                    } else {
                        this.u.setText(Messages.getString("OrderView.26"));
                    }
                }
                this.q.setText(Messages.getString("OrderView.27") + ": " + String.valueOf(this.c.getNumberOfGuests()));
            }
            if (orderType.isEnableReorder().booleanValue()) {
                this.w.setVisible(true);
            } else {
                this.w.setVisible(false);
            }
            this.x.setVisible(orderType.isEnableCourse());
            list = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (list != null && orderType.isDelivery().booleanValue() && orderType.isRequiredCustomerData().booleanValue()) {
                this.z.setVisible(true);
            }
            if (orderType.isRetailOrder().booleanValue()) {
                this.g.updateView();
                this.updateTicketSummeryView();
                this.L.setTicket(this.c);
                this.g();
            }
            if (this.c.getSalesArea() != null) {
                if (this.c.getSalesArea() != null) {
                    object2 = this.c.getSalesArea().toString();
                    this.A.setText("<html><center>" + Messages.getString("OrderView.38") + "<br>" + (String)object2 + "</center><html/>");
                }
            } else if (this.c.getId() != null) {
                this.A.setText(Messages.getString("OrderView.41"));
            } else {
                object2 = terminal.getSalesArea();
                if (object2 != null) {
                    object = ((SalesArea)object2).toString();
                    this.A.setText("<html><center>" + Messages.getString("OrderView.42") + "<br>" + (String)object + "</center><html/>");
                }
                if (terminal.isFixedSalesArea().booleanValue()) {
                    this.A.setEnabled(false);
                } else {
                    this.A.setEnabled(true);
                }
            }
            if (this.c.getCustomer() != null) {
                this.v.setText("<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + this.c.getCustomer().getName());
            } else {
                this.v.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
            }
        }
    }

    public void showView(String string) {
    }

    public CategoryView getCategoryView() {
        return this.d;
    }

    public void setCategoryView(CategoryView categoryView) {
        this.d = categoryView;
    }

    public GroupView getGroupView() {
        return this.e;
    }

    public void setGroupView(GroupView groupView) {
        this.e = groupView;
    }

    public MenuItemView getItemView() {
        return this.f;
    }

    public void setItemView(MenuItemView menuItemView) {
        this.f = menuItemView;
    }

    public TicketView getTicketView() {
        return this.g;
    }

    public void setTicketView(TicketView ticketView) {
        this.g = ticketView;
    }

    public OrderController getOrderController() {
        return this.k;
    }

    public Ticket getCurrentTicket() {
        return this.c;
    }

    private void a(OrderType orderType) {
        if (orderType.isRetailOrder().booleanValue()) {
            this.i();
        } else {
            this.j();
        }
        this.revalidate();
        this.repaint();
    }

    private void g() {
        this.n.setVisible(false);
        this.p.setVisible(false);
        this.z.setVisible(false);
        this.C.setVisible(false);
        this.q.setVisible(false);
        this.t.setVisible(false);
        this.w.setVisible(false);
        this.A.setVisible(false);
        this.r.setVisible(false);
        this.u.setVisible(false);
        this.o.setVisible(false);
    }

    private void h() {
        this.n.setVisible(true);
        this.p.setVisible(true);
        this.C.setVisible(true);
        this.q.setVisible(true);
        this.m.setVisible(true);
        this.s.setVisible(true);
        this.A.setVisible(true);
        this.r.setVisible(true);
        this.o.setVisible(true);
        this.u.setVisible(true);
    }

    private void i() {
        this.removeAll();
        if (this.L == null) {
            SettleTicketProcessor settleTicketProcessor = new SettleTicketProcessor(null, this);
            settleTicketProcessor.addPaymentListener(this);
            this.L = new PaymentView(settleTicketProcessor, this);
        }
        this.g.showSettleButton(false);
        this.j.setVisible(true);
        this.i.add((Component)this.l, "South");
        this.add((Component)this.i, "Center");
        this.add((Component)this.L, "East");
    }

    private void j() {
        this.removeAll();
        this.h();
        this.j.setVisible(false);
        this.g.showSettleButton(true);
        boolean bl = DataProvider.get().getStore().getBooleanProperty("order_view.ticket_on_right", false);
        if (!bl) {
            this.add((Component)this.d, "East");
            this.add((Component)this.i, "West");
        } else {
            this.add((Component)this.d, "West");
            this.add((Component)this.i, "East");
        }
        this.add((Component)this.h, "Center");
        this.add((Component)this.l, "South");
    }

    public void setCurrentTicket(Ticket ticket) {
        if (this.c != null && ticket != null) {
            OrderType orderType = this.c.getOrderType();
            OrderType orderType2 = ticket.getOrderType();
            if (orderType2 == null) {
                throw new PosException(Messages.getString("OrderView.55"));
            }
            if (orderType != null && !orderType.equals(orderType2)) {
                this.c = ticket;
                this.a(orderType2);
            }
        } else if (this.c == null && ticket != null) {
            OrderType orderType = ticket.getOrderType();
            if (orderType == null) {
                throw new PosException(Messages.getString("OrderView.55"));
            }
            this.a(orderType);
        }
        this.c = ticket;
        this.g.setTicket(ticket);
        if (this.L != null) {
            this.L.setTicket(ticket);
        }
        this.updateView();
        this.k.fireTicketEditingStart(ticket);
    }

    public static synchronized OrderView getInstance() {
        if (b == null) {
            b = new OrderView();
        }
        return b;
    }

    public void resetView() {
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.k();
            this.g.setVisible(true);
        } else {
            this.g.setVisible(false);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), Messages.getString("OrderView.48"));
            }
        }
        this.setReturnMode(false);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    private void k() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderView.this.d.initialize();
                }
                catch (Throwable throwable) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
    }

    public void doHoldOrder() {
        try {
            if (this.c.getOrderType().isShowTableSelection().booleanValue() && this.c.getOrderType().isRequiredCustomerData().booleanValue()) {
                String string = PasswordEntryDialog.show(POSUtil.getFocusedWindow(), Messages.getString("OrderView.9"));
                if (StringUtils.isEmpty((String)string)) {
                    return;
                }
                User user = UserDAO.getInstance().findUserBySecretKey(string);
                if (user == null) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.10"));
                    return;
                }
            }
            if (this.g.getTicket().getTicketItems() == null || this.g.getTicket().getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            this.g.doHoldOrder();
            this.g.setAllowToLogOut(true);
            this.k.fireTicketEditingFinish(this.c);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void l() {
        try {
            List<TicketItem> list;
            Ticket ticket = this.g.getTicket();
            Ticket ticket2 = ticket.clone(ticket);
            List<TicketItem> list2 = ticket2.getTicketItems();
            if (list2 == null || list2.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            Object object = list2.iterator();
            while (object.hasNext()) {
                list = object.next();
                if (((BaseTicketItem)((Object)list)).isPrintedToKitchen().booleanValue()) continue;
                object.remove();
            }
            if (ticket2.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("OrderView.49"));
                return;
            }
            object = new ReorderDialog(ticket2);
            ((Dialog)object).setTitle(Messages.getString("OrderView.51"));
            ((JDialog)object).setDefaultCloseOperation(2);
            ((Dialog)object).setResizable(false);
            ((POSDialog)object).openFullScreen();
            if (!((POSDialog)object).isCanceled()) {
                list = ((ReorderDialog)object).getTicketItems();
                if (list == null) {
                    return;
                }
                for (TicketItem ticketItem : list) {
                    this.g.addTicketItem(ticketItem);
                }
                OrderController.saveOrder(this.g.getTicket());
                this.g.sendTicketToKitchen();
                this.g.getTicketViewerTable().repaint();
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void m() {
        try {
            Ticket ticket = this.getCurrentTicket();
            if (ticket.getTicketItems() == null || ticket.getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SendToKitchenAction.4"));
                return;
            }
            OrderController.saveOrder(ticket);
            new SendToKitchenAction(this).actionPerformed(null);
            this.g.updateTicketTitle();
            this.g.getTicketViewerTable().updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket ticket = this.getCurrentTicket();
        if (ticket.getOrderType() != null && ticket.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            return this.B.getSelectedSeatNumber();
        }
        return null;
    }

    public boolean updateSeat(TicketItem ticketItem) {
        return this.B.updateSeatNumber(ticketItem);
    }

    public boolean is_86Mode() {
        return this.D;
    }

    public void set_86Mode(boolean bl) {
        this.D = bl;
    }

    @Override
    public void paymentDone() {
        this.g.doFinishOrder();
        this.updateView();
    }

    @Override
    public void paymentCanceled() {
        if (this.c == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.c.getId()) && this.c.getDueAmount() > 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderView.53"));
            return;
        }
        if (StringUtils.isNotEmpty((String)this.c.getId())) {
            TicketDAO.getInstance().delete(this.c);
        }
        this.c.getTicketItems().clear();
        this.g.doCancelOrder();
        this.updateView();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
    }

    public PaymentView getPaymentView() {
        return this.L;
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem iTicketItem) {
        if (ticket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.L.updateView();
        }
    }

    @Override
    public void itemRemoved(ITicketItem iTicketItem) {
        if (this.c.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.L.updateView();
        }
    }

    public boolean isReturnMode() {
        return this.E;
    }

    public void setReturnMode(boolean bl) {
        this.E = bl;
    }

    @Override
    public void refresh() {
        if (this.c != null && this.c.getId() != null) {
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.c.getId());
            this.setCurrentTicket(ticket);
        } else {
            this.setCurrentTicket(this.c);
        }
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    @Override
    public Object getSelectedData() {
        return this.getCurrentTicket();
    }

    @Override
    public void dataSetUpdated() {
    }

    @Override
    public void dataChangeCanceled(Object object) {
    }

    private void n() {
        try {
            List<TicketItem> list = this.g.getTicket().getTicketItems();
            if (list == null || list.size() == 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            this.g.doFinishOrder();
            this.k.fireTicketEditingFinish(this.c);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

