/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.ITicketList;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;

public class NewBarTabAction
extends AbstractAction
implements CardInputListener {
    public static final String BARTAB_TRANSACTION_ID = "bartab.transaction.id";
    private Component a;
    private PaymentType b;
    private OrderType c;
    private List<ShopTable> d;

    public NewBarTabAction(OrderType orderType, List list, Component component) {
        this.c = orderType;
        this.d = list;
        this.a = component;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = Messages.getString("NewBarTabAction.11");
        int n = POSMessageDialog.showYesNoQuestionDialog(this.a, string, Messages.getString("NewBarTabAction.4"));
        if (n != 0) {
            Ticket ticket = this.a();
            this.a(ticket);
            return;
        }
        String string2 = CurrencyUtil.getCurrencySymbol();
        string = string2 + CardConfig.getBartabLimit() + Messages.getString("NewBarTabAction.3");
        n = POSMessageDialog.showYesNoQuestionDialog(this.a, string, Messages.getString("NewBarTabAction.4"));
        if (n != 0) {
            return;
        }
        try {
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (this.b == null) {
                this.b = PaymentType.CREDIT_CARD;
            }
            if (!paymentGatewayPlugin.shouldShowCardInputProcessor()) {
                PosTransaction posTransaction = this.b.createTransaction();
                Ticket ticket = this.a();
                if (ticket == null) {
                    return;
                }
                posTransaction.setTicket(ticket);
                posTransaction.setAuthorizable(false);
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setTenderAmount(CardConfig.getBartabLimit());
                posTransaction.setAmount(CardConfig.getBartabLimit());
                paymentGatewayPlugin.getProcessor().preAuth(posTransaction);
                this.a(posTransaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case SWIPE: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, PaymentType.CREDIT_CARD);
                    swipeCardDialog.pack();
                    swipeCardDialog.open();
                    break;
                }
                case MANUAL: {
                    ManualCardEntryDialog manualCardEntryDialog = new ManualCardEntryDialog(this, PaymentType.CREDIT_CARD);
                    manualCardEntryDialog.pack();
                    manualCardEntryDialog.open();
                    break;
                }
                case EXTERNAL_TERMINAL: {
                    AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this, PaymentType.CREDIT_CARD);
                    authorizationCodeDialog.pack();
                    authorizationCodeDialog.open();
                    break;
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private Ticket a() {
        Object object;
        Ticket ticket = new Ticket();
        if (this.d != null && !this.d.isEmpty()) {
            for (ShopTable comparable2 : this.d) {
                ticket.addTable(comparable2.getTableNumber());
            }
        } else {
            object = PosOptionPane.showInputDialog(Messages.getString("NewBarTabAction.12"));
            if (StringUtils.isEmpty((String)object)) {
                return null;
            }
            ticket.addProperty("CUSTOMER_NAME", (String)object);
        }
        object = Application.getInstance();
        ticket.setPriceIncludesTax(((Application)object).isPriceIncludesTax());
        ticket.setOrderType(this.c);
        ticket.setTerminal(((Application)object).getTerminal());
        ticket.setOwner(Application.getCurrentUser());
        ticket.setShift(ShiftUtil.getCurrentShift());
        Calendar calendar = Calendar.getInstance();
        ticket.setCreateDate(calendar.getTime());
        ticket.setCreationHour(calendar.get(11));
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardInputted(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) {
        BusyDialog busyDialog = new BusyDialog(Application.getPosWindow());
        try {
            busyDialog.setVisible(true);
            PosTransaction posTransaction = this.b.createTransaction();
            Ticket ticket = this.a();
            if (ticket == null) {
                return;
            }
            posTransaction.setTicket(ticket);
            posTransaction.setAuthorizable(false);
            posTransaction.setTenderAmount(CardConfig.getBartabLimit());
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
            if (cardInputProcessor instanceof SwipeCardDialog) {
                SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
                String string2 = swipeCardDialog.getCardString();
                if (StringUtils.isEmpty((String)string2) || string2.length() < 16) {
                    throw new RuntimeException(Messages.getString("SettleTicketDialog.16"));
                }
                posTransaction.setCardType(paymentType.getDisplayString());
                posTransaction.setCardTrack(string2);
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setCardReader(CardReader.SWIPE.name());
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(posTransaction);
                } else {
                    cardProcessor.chargeAmount(posTransaction);
                }
                this.a(posTransaction);
            } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
                ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                posTransaction.setCardReader(CardReader.MANUAL.name());
                posTransaction.setCardNumber(manualCardEntryDialog.getCardNo());
                posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
                posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
                cardProcessor.preAuth(posTransaction);
                this.a(posTransaction);
            } else if (cardInputProcessor instanceof AuthorizationCodeDialog) {
                PosTransaction posTransaction2 = this.b.createTransaction();
                posTransaction2.setTicket(ticket);
                AuthorizationCodeDialog authorizationCodeDialog = (AuthorizationCodeDialog)cardInputProcessor;
                String string3 = authorizationCodeDialog.getAuthorizationCode();
                if (StringUtils.isEmpty((String)string3)) {
                    throw new PosException(Messages.getString("SettleTicketDialog.17"));
                }
                posTransaction2.setCardType(this.b.getDisplayString());
                posTransaction2.setCaptured(false);
                posTransaction2.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
                posTransaction2.setCardAuthCode(string3);
                this.a(posTransaction2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
        finally {
            busyDialog.setVisible(false);
        }
    }

    private void a(PosTransaction posTransaction) {
        try {
            PosTransactionService posTransactionService = PosTransactionService.getInstance();
            Ticket ticket = posTransaction.getTicket();
            posTransactionService.bookBartabTicket(ticket, posTransaction, false);
            ticket.addProperty(BARTAB_TRANSACTION_ID, String.valueOf(posTransaction.getId()));
            TicketDAO.getInstance().saveOrUpdate(ticket);
            ShopTableDAO.getInstance().occupyTables(ticket);
            POSMessageDialog.showMessage(Messages.getString("NewBarTabAction.5") + ticket.getId());
            if (this.a instanceof ITicketList) {
                ((ITicketList)((Object)this.a)).updateTicketList();
            }
            this.a(ticket);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() != null) {
            ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        }
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
    }
}

