/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceRuleForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class PriceRuleExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<PriceRule> b = new BeanTableModel(PriceRule.class);

    public PriceRuleExplorer() {
        this.b.addColumn(POSConstants.NAME, PriceRule.PROP_NAME);
        this.b.addColumn(POSConstants.DESCRIPTION, PriceRule.PROP_DESCRIPTION);
        this.b.addColumn(Messages.getString("PriceRuleExplorer.0"), PriceRule.PROP_CODE);
        this.b.addColumn(Messages.getString("PriceRuleExplorer.1"), "department");
        this.b.addColumn(Messages.getString("PriceRuleExplorer.3"), "salesArea");
        this.b.addColumn(Messages.getString("PriceRuleExplorer.5"), "orderType");
        this.b.addColumn(Messages.getString("PriceRuleExplorer.7"), "customerGroup");
        this.b.addColumn(Messages.getString("PriceRuleExplorer.9"), "priceShift");
        this.b.addColumn(Messages.getString("PriceRuleExplorer.11"), "priceTable");
        this.b.addColumn(Messages.getString("PriceRuleExplorer.13"), PriceRule.PROP_ACTIVE);
        this.b.addRows(PriceRuleDAO.getInstance().findAll());
        this.a = new JXTable(this.b);
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PriceRuleExplorer.this.editSelectedRow(false);
                }
            }
        });
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.a();
    }

    private void a() {
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PriceRuleForm priceRuleForm = new PriceRuleForm(new PriceRule());
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)priceRuleForm);
                    beanEditorDialog.openWithScale(400, 500);
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    PriceRule priceRule = (PriceRule)priceRuleForm.getBean();
                    PriceRuleExplorer.this.b.addRow(priceRule);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PriceRuleExplorer.this.editSelectedRow(false);
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PriceRuleExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    n = PriceRuleExplorer.this.a.convertRowIndexToModel(n);
                    PriceRule priceRule = (PriceRule)PriceRuleExplorer.this.b.getRow(n);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    PriceRuleDAO priceRuleDAO = new PriceRuleDAO();
                    priceRuleDAO.delete(priceRule);
                    PriceRuleExplorer.this.b.removeRow(n);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    public void editSelectedRow(boolean bl) {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            PriceRule priceRule = this.b.getRow(n);
            PriceRuleForm priceRuleForm = new PriceRuleForm(priceRule);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)priceRuleForm);
            beanEditorDialog.openWithScale(400, 500);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }
}

