/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.PrintServiceComboRenderer;
import com.floreantpos.config.ui.VirtualPrinterConfigDialog;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.print.PrinterType;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AddPrinterDialog
extends POSDialog {
    private static final String a = Messages.getString("AddPrinterDialog.1");
    private Printer b;
    private VirtualPrinter c;
    private FixedLengthTextField d;
    private JComboBox e;
    private JComboBox f;
    private JCheckBox g;
    public TitlePanel titlePanel;
    private JRadioButton h;
    private JRadioButton i;
    private JRadioButton j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private FixedLengthTextField o;
    private FixedLengthTextField p;
    private FixedLengthTextField q;
    private TerminalPrinters r;
    private IntegerTextField s;
    private JComboBox t;
    private JButton u;
    private JLabel v;
    private JButton w;

    public AddPrinterDialog() throws HeadlessException {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.setTitle(Messages.getString("AddPrinterDialog.0"));
        this.setMinimumSize(new Dimension(500, 200));
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    @Override
    public void initUI() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[][grow]", ""));
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle("Printer Type:");
        this.add((Component)this.titlePanel, "North");
        this.s = new IntegerTextField(5);
        this.u = new JButton("Test");
        this.u.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterDialog.this.a(false);
            }
        });
        JLabel jLabel = new JLabel("Virtual Printer Name:");
        jPanel.add((Component)jLabel, "alignx trailing");
        this.l = new JLabel("IP Address:");
        this.m = new JLabel("Port:");
        this.o = new FixedLengthTextField();
        this.p = new FixedLengthTextField();
        this.n = new JLabel("Serial Port:");
        this.q = new FixedLengthTextField();
        this.d = new FixedLengthTextField(20);
        this.h = new JRadioButton(PrinterType.LOCAL.getName());
        this.i = new JRadioButton(PrinterType.NETWORK.getName());
        this.j = new JRadioButton(PrinterType.SERIAL.getName());
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterDialog.this.c();
            }
        };
        this.h.addActionListener(actionListener);
        this.i.addActionListener(actionListener);
        this.j.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.h);
        buttonGroup.add(this.i);
        buttonGroup.add(this.j);
        this.e = new JComboBox();
        this.e.setEnabled(false);
        List<VirtualPrinter> list = VirtualPrinterDAO.getInstance().findAll();
        this.e.setModel(new DefaultComboBoxModel<VirtualPrinter>(list.toArray(new VirtualPrinter[0])));
        jPanel.add((Component)this.d, "growx");
        JButton jButton = new JButton(Messages.getString("NEW"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterDialog.this.doAddNewVirtualPrinter();
            }
        });
        this.t = new JComboBox();
        this.t.addItem("Standard");
        this.t.addItem("EscPOS");
        this.t.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                AddPrinterDialog.this.a();
            }
        });
        jPanel.add((Component)new JLabel("Print System:"), "alignx trailing");
        jPanel.add((Component)this.t, "growx,split 4");
        jPanel.add((Component)this.h, "right");
        jPanel.add(this.i);
        jPanel.add(this.j);
        this.k = new JLabel(Messages.getString("AddPrinterDialog.9") + ":");
        this.f = new JComboBox();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(a);
        arrayList.add(ReceiptPrintService.OROPOS_PDF_PRINTER);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        this.f.addItem(null);
        for (int i = 0; i < printServiceArray.length; ++i) {
            arrayList.add(printServiceArray[i]);
        }
        this.f.setModel(new ComboBoxModel(arrayList));
        this.f.setRenderer(new PrintServiceComboRenderer());
        jPanel.add((Component)this.k, "newline,alignx trailing");
        jPanel.add((Component)this.f, "growx,split 2");
        jPanel.add((Component)this.l, "newline,alignx trailing");
        jPanel.add((Component)this.o, "growx,split 4");
        jPanel.add(this.m);
        jPanel.add((Component)this.p, "w 70!,split 2");
        jPanel.add((Component)this.n, "newline,alignx trailing");
        jPanel.add((Component)this.q, "growx,split 2");
        jPanel.add((Component)this.u, "right");
        this.v = new JLabel("Text Length:");
        jPanel.add((Component)this.v, "newline,alignx trailing");
        jPanel.add((Component)this.s, "growx,split 2");
        this.w = new JButton("Test");
        this.w.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterDialog.this.a(true);
            }
        });
        jPanel.add((Component)this.w, "right");
        this.g = new JCheckBox(Messages.getString("AddPrinterDialog.12"));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, "spanx,growx,gapy 50px");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton2 = new JButton(Messages.getString("OK"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterDialog.this.doOk();
            }
        });
        jPanel2.add(jButton2);
        JButton jButton3 = new JButton(Messages.getString("CANCEL"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPrinterDialog.this.setCanceled(true);
                AddPrinterDialog.this.dispose();
            }
        });
        jPanel2.add(jButton3);
        this.add((Component)jPanel2, "South");
        this.h.setSelected(true);
        this.a();
    }

    private void a() {
        boolean bl;
        String string = (String)this.t.getSelectedItem();
        boolean bl2 = bl = string == null || string.equals("Standard");
        if (bl) {
            this.h.setSelected(bl);
        }
        this.i.setVisible(!bl);
        this.j.setVisible(!bl);
        this.v.setVisible(!bl);
        this.s.setVisible(!bl);
        this.w.setVisible(!bl);
        this.c();
    }

    private void a(boolean bl) {
        try {
            if (!this.b(true)) {
                return;
            }
            String string = this.r.getPrinterName();
            if (string == null) {
                return;
            }
            String string2 = bl ? this.b() : ReceiptPrintService.getSystemInfo(this.r.getPrinterName(), this.c.getName());
            ReceiptPrintService.testPrinter(PosPrinters.createPrinter(this.r), bl ? "" : "System Information", string2);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError("Failed to print.");
        }
    }

    private String b() {
        if (this.s.getInteger() <= 0) {
            throw new PosException("Character length must be greater than zero.");
        }
        String string = "";
        for (int i = 0; i < this.s.getInteger(); ++i) {
            string = string + "W";
        }
        return string;
    }

    private void c() {
        this.l.setVisible(this.i.isSelected());
        this.o.setVisible(this.i.isSelected());
        this.m.setVisible(this.i.isSelected());
        this.p.setVisible(this.i.isSelected());
        this.n.setVisible(this.j.isSelected());
        this.q.setVisible(this.j.isSelected());
        this.k.setVisible(this.h.isSelected());
        this.f.setVisible(this.h.isSelected());
    }

    protected void doAddNewVirtualPrinter() {
        VirtualPrinterConfigDialog virtualPrinterConfigDialog = new VirtualPrinterConfigDialog();
        virtualPrinterConfigDialog.open();
        if (virtualPrinterConfigDialog.isCanceled()) {
            return;
        }
        VirtualPrinter virtualPrinter = virtualPrinterConfigDialog.getPrinter();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.e.getModel();
        defaultComboBoxModel.addElement(virtualPrinter);
        this.e.setSelectedItem(virtualPrinter);
    }

    protected void doOk() {
        if (!this.b(false)) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    private boolean b(boolean bl) {
        String string = this.d.getText();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(this, Messages.getString("VirtualPrinterConfigDialog.11"));
            return false;
        }
        if (this.c == null) {
            this.c = new VirtualPrinter();
        }
        this.c.setName(string);
        PrintService printService = null;
        Object object = this.f.getSelectedItem();
        if (object instanceof PrintService) {
            printService = (PrintService)object;
        }
        boolean bl2 = this.g.isSelected();
        if (this.b == null) {
            this.b = new Printer();
        }
        String string2 = this.b.getDeviceName();
        this.b.setVirtualPrinter(this.c);
        string2 = printService != null && printService.getName() != null ? printService.getName() : (object != null && object.equals(ReceiptPrintService.OROPOS_PDF_PRINTER) ? ReceiptPrintService.OROPOS_PDF_PRINTER : null);
        this.b.setDefaultPrinter(bl2);
        if (this.r == null) {
            this.r = new TerminalPrinters();
        }
        PrinterType printerType = this.getPrinterType();
        this.r.addProperty("receipt.printer_type", String.valueOf(this.t.getSelectedItem()));
        this.r.addProperty("printerType", printerType.getName());
        this.r.addProperty("textLength", String.valueOf(this.s.getInteger()));
        if (printerType == PrinterType.NETWORK) {
            String string3 = this.getIPAddress();
            String string4 = this.getIPPort();
            this.r.addProperty("ipAddress", string3);
            this.r.addProperty("ipPort", string4);
            string2 = string3 + (StringUtils.isNotBlank((String)string4) ? ":" + string4 : "");
        } else if (printerType == PrinterType.SERIAL) {
            this.r.addProperty("serialPort", this.getSerialPort());
            string2 = this.getSerialPort();
        } else {
            this.r.removeProperty("ipAddress");
            this.r.removeProperty("ipPort");
            this.r.removeProperty("serialPort");
        }
        if (!bl) {
            this.b.setDeviceName(string2);
        }
        this.r.setPrinterName(string2);
        return true;
    }

    public TerminalPrinters getTerminalPrinter() {
        return this.r;
    }

    public PrinterType getPrinterType() {
        if (this.i.isSelected()) {
            return PrinterType.NETWORK;
        }
        if (this.j.isSelected()) {
            return PrinterType.SERIAL;
        }
        return PrinterType.LOCAL;
    }

    public String getIPAddress() {
        return this.o.getText();
    }

    public String getIPPort() {
        return this.p.getText();
    }

    public String getSerialPort() {
        return this.q.getText();
    }

    public Printer getPrinter() {
        return this.b;
    }

    public void setPrinter(Printer printer, TerminalPrinters terminalPrinters) {
        Object object;
        this.b = printer;
        this.r = terminalPrinters;
        this.c = printer.getVirtualPrinter();
        this.d.setText(printer.getVirtualPrinter().getName());
        this.g.setSelected(printer.isDefaultPrinter());
        if (printer != null && StringUtils.isNotEmpty((String)printer.getDeviceName())) {
            this.e.setSelectedItem(printer.getVirtualPrinter());
            if (printer.getDeviceName().equals(ReceiptPrintService.OROPOS_PDF_PRINTER)) {
                this.f.setSelectedItem(ReceiptPrintService.OROPOS_PDF_PRINTER);
                return;
            }
            if (printer.getDeviceName().equals(Messages.getString("AddPrinterDialog.2"))) {
                this.f.setSelectedItem(a);
                return;
            }
            object = (ComboBoxModel)this.f.getModel();
            for (int i = 0; i < ((ComboBoxModel)object).getSize(); ++i) {
                PrintService printService;
                Object object2 = ((ComboBoxModel)object).getElementAt(i);
                if (!(object2 instanceof PrintService) || (printService = (PrintService)object2) == null || !printService.getName().equals(printer.getDeviceName())) continue;
                this.f.setSelectedIndex(i);
                break;
            }
        }
        if (terminalPrinters != null) {
            object = PrinterType.fromString(terminalPrinters.getProperty("printerType", PrinterType.LOCAL.getName()));
            if (object == PrinterType.NETWORK) {
                this.i.setSelected(true);
            } else if (object == PrinterType.SERIAL) {
                this.j.setSelected(true);
            } else {
                this.h.setSelected(true);
            }
            this.t.setSelectedItem(terminalPrinters.getProperty("receipt.printer_type", "Standard"));
            this.o.setText(terminalPrinters.getProperty("ipAddress", "192.168.0.1"));
            this.p.setText(terminalPrinters.getProperty("ipPort", ""));
            this.q.setText(terminalPrinters.getProperty("serialPort", ""));
            this.s.setText(terminalPrinters.getProperty("textLength", "42"));
        } else {
            this.s.setText(terminalPrinters.getProperty("textLength", "42"));
            this.h.setSelected(true);
        }
        this.c();
    }
}

