/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopSeat;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"shopTable", "member"})
public class ShopSeat
extends BaseShopSeat
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private Customer member;
    private ShopTable shopTable;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;

    public ShopSeat() {
    }

    public ShopSeat(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public ShopSeat(ShopTable shopTable, int n, int n2, int n3) {
        this.setTableId(shopTable.getId());
        this.setSeatNumber(n);
        this.setPosX(n2);
        this.setPosY(n3);
    }

    @Override
    public String toString() {
        return String.valueOf(super.getSeatNumber());
    }

    public TicketItemSeat convertTicketItemSeat() {
        TicketItemSeat ticketItemSeat = new TicketItemSeat();
        ticketItemSeat.setShopSeat(this);
        return ticketItemSeat;
    }

    public Customer getMember() {
        return this.member;
    }

    public void setMember(Customer customer) {
        this.member = customer;
    }

    public ShopTable getShopTable() {
        return this.shopTable;
    }

    public void setShopTable(ShopTable shopTable) {
        this.shopTable = shopTable;
    }

    public double getAngle() {
        String string = this.getProperty("angle");
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                return Double.parseDouble(string);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        return 0.0;
    }

    public void setAngle(double d) {
        this.addProperty("angle", String.valueOf(d));
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }
}

