/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.dao.BaseCashBreakdownDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class CashBreakdownDAO
extends BaseCashBreakdownDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateCashBreakdown(List<CashBreakdown> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (CashBreakdown cashBreakdown : list) {
                CashBreakdown cashBreakdown2 = this.get(cashBreakdown.getId());
                if (cashBreakdown2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(cashBreakdown.getLastUpdateTime(), cashBreakdown2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), cashBreakdown.getId() + " already updated");
                        continue;
                    }
                    long l = cashBreakdown2.getVersion();
                    PropertyUtils.copyProperties((Object)cashBreakdown2, (Object)cashBreakdown);
                    cashBreakdown2.setVersion(l);
                    cashBreakdown2.setUpdateLastUpdateTime(bl);
                    cashBreakdown2.setUpdateSyncTime(bl2);
                    this.update(cashBreakdown2, session);
                    continue;
                }
                cashBreakdown.setUpdateLastUpdateTime(bl);
                cashBreakdown.setUpdateSyncTime(bl2);
                this.save(cashBreakdown, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

