/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.Store;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.util.POSUtil;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.DottedLineSeparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class ITextPrinter {
    private static final int a = 9;
    private static final int b = 12;
    private Font c = new Font(1, 11.0f, 1);
    private Font d = new Font(1, 9.0f, 0);
    private Font e = new Font(1, 9.0f, 1);
    private Font f = new Font(1, 9.0f, 0);
    private Document g = null;
    private PdfWriter h;
    private ByteArrayOutputStream i = new ByteArrayOutputStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(ReciptPaperSize reciptPaperSize, Map<String, Object> map, AbstractReportDataSource abstractReportDataSource) throws Exception {
        try {
            this.a(abstractReportDataSource);
            Document document = this.createDocument();
            int n = 19;
            int n2 = 228;
            int n3 = 600;
            int[] nArray = new int[]{138, 50};
            int n4 = nArray[0] + nArray[1];
            Rectangle rectangle = new Rectangle((float)n2, (float)n3);
            document.setPageSize(rectangle);
            document.setMargins((float)n, (float)n, 0.0f, 0.0f);
            document.newPage();
            Paragraph paragraph = new Paragraph(" ");
            document.add((Element)paragraph);
            this.addText(map, "headerLine1", 1, this.c);
            this.addText(map, "ticketHeader", 1);
            this.addText(map, "additionalOrderInfo", 0);
            document.add((Element)this.a());
            PdfPTable pdfPTable = this.a(2, n4, nArray);
            this.a(abstractReportDataSource, pdfPTable);
            document.add((Element)pdfPTable);
            document.add((Element)paragraph);
            document.add((Element)this.a());
            if (abstractReportDataSource instanceof TicketDataSource) {
                boolean bl;
                int[] nArray2 = new int[]{115, 73};
                PdfPTable pdfPTable2 = this.a(2, n4, nArray2);
                this.a(pdfPTable2, map, "totalText", "grandSubtotal", false);
                this.a(pdfPTable2, map, "discountText", "discountAmount");
                boolean bl2 = Boolean.parseBoolean(String.valueOf(map.get("isShowTaxBreakdown")));
                if (!bl2) {
                    this.a(pdfPTable2, map, "taxText", "taxAmount");
                } else {
                    document.add((Element)pdfPTable2);
                    this.addText(map, "taxBreakdownText", 2);
                    pdfPTable2 = this.a(2, n4, nArray2);
                }
                this.a(pdfPTable2, map, "serviceChargeText", "serviceCharge");
                this.a(pdfPTable2, map, "deliveryChargeText", "deliveryCharge");
                pdfPTable2.setSpacingAfter(5.0f);
                document.add((Element)pdfPTable2);
                document.add((Element)this.a());
                pdfPTable2 = this.a(2, n4, nArray2);
                this.a(pdfPTable2, map, "netAmountText", "netAmount", false);
                this.a(pdfPTable2, map, "paidAmountText", "paidAmount", false);
                this.a(pdfPTable2, map, "refundAmountText", "refundAmount");
                this.a(pdfPTable2, map, "tenderAmountText", "tenderAmount");
                this.a(pdfPTable2, map, "dueAmountText", "dueAmount", false);
                if (map.get("tenderAmount") != null) {
                    this.a(pdfPTable2, map, "changeAmountText", "changedAmount", false);
                }
                this.a(pdfPTable2, map, "tipsText", "tipAmount");
                document.add((Element)pdfPTable2);
                this.addText(map, "showTips", 1);
                pdfPTable2 = this.a(2, n4, nArray2);
                this.a(pdfPTable2, map, "feeAmountText", "feeAmount");
                document.add((Element)pdfPTable2);
                this.addText(map, "additionalPaymentProperties", 2);
                this.addText(map, "additionalProperties", 2);
                boolean bl3 = Boolean.parseBoolean(String.valueOf(map.get("cardPayment")));
                boolean bl4 = bl = bl3 && Boolean.parseBoolean(String.valueOf(map.get("showTipsBlock")));
                if (bl) {
                    pdfPTable2 = this.a(2, n4, nArray2);
                    pdfPTable2.setWidthPercentage(80.0f);
                    pdfPTable2.setHorizontalAlignment(2);
                    this.addTextWithUnderline(pdfPTable2, "Tips:");
                    this.addTextWithUnderline(pdfPTable2, "Total:");
                    this.addTextWithUnderline(pdfPTable2, "Sign:");
                    document.add((Element)pdfPTable2);
                }
                if (bl3) {
                    this.addText(map, "approvalCode", 0);
                }
                this.addText(map, "bottomMessage", 0);
                document.add((Element)paragraph);
                this.addText(map, "copyType", 1);
                this.addText(map, "footerMessage", 1);
            } else {
                this.addText(map, "printerName", 0);
                this.addText(map, "bottomMessage", 0);
                document.add((Element)paragraph);
                this.addText(map, "footerMessage", 1);
            }
        }
        finally {
            this.closeDocument();
        }
    }

    private void a(AbstractReportDataSource abstractReportDataSource) {
        if (abstractReportDataSource instanceof KitchenTicketDataSource) {
            this.c.setSize(12.0f);
            this.e.setSize(12.0f);
            this.d.setSize(12.0f);
            this.f.setSize(16.0f);
        } else {
            this.c.setSize(9.0f);
            this.e.setSize(9.0f);
            this.d.setSize(9.0f);
            this.f.setSize(9.0f);
        }
    }

    private void a(AbstractReportDataSource abstractReportDataSource, PdfPTable pdfPTable) {
        Store store = DataProvider.get().getStore();
        List list = abstractReportDataSource.getRows();
        if (list != null) {
            if (abstractReportDataSource instanceof TicketDataSource) {
                TicketDataSource ticketDataSource = (TicketDataSource)abstractReportDataSource;
                for (ITicketItem iTicketItem : list) {
                    String string = ticketDataSource.getColorCode(store, iTicketItem);
                    this.f.setColor(ITextPrinter.decodeHtmlColorString(string));
                    PdfPCell pdfPCell = this.a(iTicketItem.getNameDisplay(), 0);
                    PdfPCell pdfPCell2 = this.a(iTicketItem.getSubTotalAmountDisplay(), 2);
                    pdfPTable.addCell(pdfPCell);
                    pdfPTable.addCell(pdfPCell2);
                }
            } else if (abstractReportDataSource instanceof KitchenTicketDataSource) {
                KitchenTicketDataSource kitchenTicketDataSource = (KitchenTicketDataSource)abstractReportDataSource;
                for (KitchenTicketItem kitchenTicketItem : list) {
                    String string = kitchenTicketDataSource.getColorCode(kitchenTicketItem, kitchenTicketItem.getKitchenTicket().getOrderTypeId());
                    this.f.setColor(ITextPrinter.decodeHtmlColorString(string));
                    PdfPCell pdfPCell = this.a(kitchenTicketItem.getMenuItemNameDisplay(), 0);
                    pdfPCell.setColspan(2);
                    pdfPTable.addCell(pdfPCell);
                }
            }
        }
        this.f.setColor(Color.black);
    }

    public static Color decodeHtmlColorString(String string) {
        Color color;
        if (StringUtils.isEmpty((String)string)) {
            return Color.BLACK;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        switch (string.length()) {
            case 6: {
                int n = Integer.parseInt(string.substring(0, 2), 16);
                int n2 = Integer.parseInt(string.substring(2, 4), 16);
                int n3 = Integer.parseInt(string.substring(4, 6), 16);
                color = new Color(n, n2, n3);
                break;
            }
            case 3: {
                int n = Integer.parseInt(string.substring(0, 1), 16);
                int n4 = Integer.parseInt(string.substring(1, 2), 16);
                int n5 = Integer.parseInt(string.substring(2, 3), 16);
                color = new Color(n, n4, n5);
                break;
            }
            case 1: {
                int n;
                int n6 = n = Integer.parseInt(string.substring(0, 1), 16);
                int n7 = n;
                color = new Color(n7, n6, n);
                break;
            }
            default: {
                return Color.BLACK;
            }
        }
        return color;
    }

    private PdfPTable a(int n, int n2, int[] nArray) throws DocumentException {
        PdfPTable pdfPTable = new PdfPTable(n);
        pdfPTable.setHorizontalAlignment(1);
        pdfPTable.setWidths(nArray);
        pdfPTable.setKeepTogether(true);
        pdfPTable.setTotalWidth((float)n2);
        pdfPTable.setWidthPercentage(100.0f);
        return pdfPTable;
    }

    private Image a(Map<String, Object> map) throws DocumentException {
        Object object = map.get(ReceiptParam.BARCODE.getParamName());
        if (object != null) {
            PdfContentByte pdfContentByte = this.getPdfWriter().getDirectContent();
            Barcode128 barcode128 = new Barcode128();
            barcode128.setBaseline(-1.0f);
            barcode128.setSize(12.0f);
            barcode128.setFont(this.d.getBaseFont());
            barcode128.setCode(String.valueOf(object));
            barcode128.setCodeType(9);
            barcode128.setBarHeight(20.0f);
            barcode128.setX(1.0f);
            barcode128.setTextAlignment(1);
            Image image = barcode128.createImageWithBarcode(pdfContentByte, null, null);
            image.setAlignment(1);
            image.setSpacingBefore(1.0f);
            image.setSpacingAfter(1.0f);
            image.setWidthPercentage(90.0f);
            return image;
        }
        return null;
    }

    private Image a(Map<String, Object> map, int n) throws BadElementException, MalformedURLException, IOException, DocumentException {
        java.awt.Image image = (java.awt.Image)map.get("storeLogoIcon");
        if (image != null) {
            Image image2 = Image.getInstance((java.awt.Image)POSUtil.convertBlackAndWhiteImage(image), null);
            image2.setAlignment(1);
            float f = image2.getWidth();
            float f2 = image2.getHeight();
            if (f > (float)n) {
                f2 = f2 * (float)n / f;
                f = n;
            }
            image2.scaleToFit(f, f2);
            return image2;
        }
        return null;
    }

    public PdfWriter getPdfWriter() {
        return this.h;
    }

    private void a(PdfPTable pdfPTable, Map<String, Object> map, String string, String string2) {
        this.a(pdfPTable, map, string, string2, true);
    }

    private void a(PdfPTable pdfPTable, Map<String, Object> map, String string, String string2, boolean bl) {
        Object object = map.get(string2);
        if (bl && (object == null || object.equals("null") || object.equals("0.00"))) {
            return;
        }
        pdfPTable.addCell(this.a(String.valueOf(map.get(string)), 2));
        pdfPTable.addCell(this.a(String.valueOf(object), 2));
    }

    private PdfPCell a(String string, int n) {
        Font font = new Font(this.f);
        PdfPCell pdfPCell = new PdfPCell(new Phrase(string, font));
        pdfPCell.setHorizontalAlignment(n);
        pdfPCell.setBorder(0);
        return pdfPCell;
    }

    private DottedLineSeparator a() {
        return this.a(2.0f, 2.0f);
    }

    private DottedLineSeparator a(float f, float f2) {
        DottedLineSeparator dottedLineSeparator = new DottedLineSeparator();
        dottedLineSeparator.setAlignment(1);
        dottedLineSeparator.setOffset(f);
        dottedLineSeparator.setGap(f2);
        return dottedLineSeparator;
    }

    public Document createDocument() throws Exception {
        this.g = new Document();
        this.h = PdfWriter.getInstance((Document)this.g, (OutputStream)this.i);
        this.g.open();
        return this.g;
    }

    public void closeDocument() {
        if (this.g != null) {
            this.g.close();
            this.g = null;
        }
    }

    public void rendererReport(JPanel jPanel) throws Exception {
        PDDocument pDDocument = PDDocument.load((InputStream)new ByteArrayInputStream(this.getPrintableByteArray()));
        MigLayout migLayout = new MigLayout("fill,hidemode 3,wrap 1,ins 0", "", "[]0px[]");
        JPanel jPanel2 = new JPanel((LayoutManager)migLayout);
        jPanel2.setBackground(Color.WHITE);
        float f = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0f;
        for (int i = 0; i < pDDocument.getNumberOfPages(); ++i) {
            BufferedImage bufferedImage = this.crop(new PDFRenderer(pDDocument).renderImage(i, f), i + 1 == pDDocument.getNumberOfPages() ? 20 : 0);
            if (bufferedImage == null) continue;
            jPanel2.add((Component)new JLabel(new ImageIcon(bufferedImage)), "gap 0");
        }
        jPanel.add(jPanel2);
    }

    public BufferedImage crop(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = this.a(bufferedImage);
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3 + n, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((java.awt.Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    private int a(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = 0;
        block0: for (int i = 0; i < n; ++i) {
            for (int j = n2 - 1; j >= 0; --j) {
                if (bufferedImage.getRGB(i, j) == Color.WHITE.getRGB() || j <= n3) continue;
                n3 = j;
                continue block0;
            }
        }
        return n3;
    }

    public boolean allWhiteRow(int n, BufferedImage bufferedImage, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) != 255) continue;
            return true;
        }
        return false;
    }

    public boolean allWhiteColumn(int n, BufferedImage bufferedImage, int n2) {
        for (int i = 0; i < n2; ++i) {
            if (bufferedImage.getRGB(i, n) != 255) continue;
            return true;
        }
        return false;
    }

    public byte[] getPrintableByteArray() {
        return this.i.toByteArray();
    }

    public void addText(Map<String, Object> map, String string, int n) throws Exception {
        this.addText(map, string, n, null);
    }

    public Document getDocument() {
        return this.g;
    }

    public void addText(Map<String, Object> map, String string, int n, Font font) throws Exception {
        Document document = this.getDocument();
        String string2 = String.valueOf(map.get(string));
        if (StringUtils.isEmpty((String)string2) || string2.equals("null")) {
            return;
        }
        boolean bl = false;
        if (string2.contains("<div>")) {
            string2 = string2.replaceAll("<div>", "").replaceAll("</div>", "<br>");
            bl = true;
        }
        PdfPTable pdfPTable = new PdfPTable(1);
        pdfPTable.setHorizontalAlignment(1);
        pdfPTable.setWidthPercentage(100.0f);
        String[] stringArray = string2.split("<br>");
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Image image;
                String string3;
                String string4 = stringArray[i];
                if (string4.contains("<b>")) {
                    font = this.e;
                }
                if (font == null) {
                    font = this.d;
                }
                if (StringUtils.isEmpty((String)(string3 = string4.replaceAll("<.*?>", "").replaceAll("</", "")))) continue;
                if (bl) {
                    string3 = string3.replaceAll("\n", "");
                }
                if (string4.contains("<strike>")) {
                    string3 = "*Voided " + string3;
                }
                PdfPCell pdfPCell = new PdfPCell(new Phrase(string3, font));
                pdfPCell.setHorizontalAlignment(n);
                pdfPCell.setBorder(0);
                pdfPTable.addCell(pdfPCell);
                if (string4.contains("<barcode>")) {
                    image = this.a(map);
                    if (image != null) {
                        pdfPCell = new PdfPCell(image);
                        pdfPCell.setHorizontalAlignment(n);
                        pdfPCell.setBorder(0);
                        pdfPTable.addCell(pdfPCell);
                    }
                } else if (string4.contains("<storeLogo>") && (image = this.a(map, 200)) != null) {
                    pdfPCell = new PdfPCell(image);
                    pdfPCell.setHorizontalAlignment(n);
                    pdfPCell.setBorder(0);
                    pdfPTable.addCell(pdfPCell);
                }
                if (!string4.contains("</b>")) continue;
                font = this.d;
            }
        }
        PdfPCell pdfPCell = new PdfPCell(new Phrase(Chunk.NEWLINE));
        pdfPCell.setBorder(0);
        pdfPTable.addCell(pdfPCell);
        document.add((Element)pdfPTable);
    }

    private Chunk a(String string, Font font) {
        Chunk chunk = new Chunk(string, font);
        chunk.setUnderline(0.5f, 3.0f);
        return chunk;
    }

    public void addTextWithUnderline(PdfPTable pdfPTable, String string) throws DocumentException {
        PdfPCell pdfPCell = this.a("          ", 0);
        PdfPCell pdfPCell2 = this.a(string, 0);
        pdfPCell2.setColspan(2);
        pdfPCell2.setBorder(2);
        pdfPTable.addCell(pdfPCell2);
        pdfPTable.addCell(pdfPCell);
        pdfPTable.addCell(pdfPCell);
    }

    public void addLine(Document document, int n) throws DocumentException {
        for (int i = 0; i < n; ++i) {
            document.add((Element)new Paragraph(" "));
        }
    }

    public static ITextPrinter create() {
        return new ITextPrinter();
    }
}

