/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.CurrencyUtil;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUtil {
    private static Log a = LogFactory.getLog(ReportUtil.class);
    private static final String b = "/com/floreantpos/report/template/";

    public static void populateRestaurantProperties(Map map) {
        ReportUtil.populateRestaurantProperties(map, false);
    }

    public static void populateRestaurantProperties(Map map, boolean bl) {
        JasperReport jasperReport = null;
        jasperReport = bl ? ReportUtil.getReport("report_header_portrait") : ReportUtil.getReport(PaperSize.getReportNameAccording2Size("report_header"));
        Store store = StoreDAO.getRestaurant();
        if (store != null) {
            map.put("restaurantName", store.getName());
            map.put("addressLine1", store.getAddressLine1());
            map.put("addressLine2", store.getAddressLine2());
            map.put("addressLine3", store.getAddressLine3());
            map.put("phone", store.getTelephone());
            map.put("reportHeader", jasperReport);
        }
    }

    public static JasperReport getReport(String string) {
        return ReportUtil.a(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JasperReport a(String string) {
        InputStream inputStream = null;
        try {
            inputStream = ReceiptPrintService.class.getResourceAsStream(b + string + ".jasper");
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return jasperReport;
        }
        catch (Exception exception) {
            a.error((Object)exception);
            JasperReport jasperReport = null;
            return jasperReport;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void populateReportHeader(HashMap hashMap, Terminal terminal, Date date, Date date2, String string) {
        String string2 = terminal == null ? POSConstants.ALL : terminal.getName();
        ReportUtil.populateReportTime(hashMap, date, date2);
        if (string != null) {
            hashMap.put("userType", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_TYPE) + " " + string);
        } else {
            hashMap.put("systemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.SYSTEM_TYPE) + " " + POSConstants.SYSTEM_TOTAL);
        }
        hashMap.put("terminalName", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + " " + string2);
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
    }

    public static void populateReportTime(HashMap hashMap, Date date, Date date2) {
        hashMap.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatDateWithTime(new Date()));
        hashMap.put("fromDate", ReportUtil.reportLabelWithBoldTag(POSConstants.FROM_DATE) + DateUtil.formatDateWithTime(date));
        hashMap.put("toDate", ReportUtil.reportLabelWithBoldTag(POSConstants.TO_DATE) + DateUtil.formatDateWithTime(date2));
    }

    public static void populateReportFooter(HashMap hashMap) {
        hashMap.put("footerPage", ReportUtil.reportLabelWithBoldTag(POSConstants.PAGE));
    }

    public static String reportLabelWithBoldTag(String string) {
        String string2 = "<b>" + string + "</b>";
        return string2;
    }
}

