/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class CashDrawerReportService {
    private CashDrawer a;
    private Session b;

    public CashDrawerReportService(CashDrawer cashDrawer) {
        this.a = cashDrawer;
    }

    public void populateReport() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            this.populateReport(this.b);
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    public void populateSummaryOfCashdrawer() {
        GenericDAO genericDAO = new GenericDAO();
        try {
            this.b = genericDAO.createNewSession();
            this.populateSummaryOfCashdrawer(this.b);
        }
        finally {
            if (this.b != null) {
                this.b.close();
            }
        }
    }

    public void populateSummaryOfCashdrawer(Session session) {
        this.b = session;
        this.e();
        this.n();
        this.q();
        this.f();
        this.g();
        double d = this.a.getNetSales() - this.a.getRefundAmount() - this.a.getDrawerBleedAmount() + this.a.getSalesTax() + this.a.getServiceCharge();
        this.a.setTotalRevenue(POSUtil.getRoundedDouble(d));
        this.a.setGrossReceipts(POSUtil.getRoundedDouble(this.a.getTotalRevenue() + this.a.getCashTips() + this.a.getChargedTips()));
    }

    public void populateReport(Session session) {
        this.b = session;
        this.e();
        this.n();
        this.q();
        this.f();
        this.g();
        double d = this.a.getNetSales() - this.a.getRefundAmount() - this.a.getDrawerBleedAmount() + this.a.getSalesTax() + this.a.getServiceCharge();
        this.a.setTotalRevenue(POSUtil.getRoundedDouble(d));
        this.a.setGrossReceipts(POSUtil.getRoundedDouble(this.a.getTotalRevenue() + this.a.getCashTips() + this.a.getChargedTips()));
        this.h();
        this.i();
        this.j();
        this.a();
        this.k();
        this.l();
        this.m();
        this.o();
        this.p();
        this.r();
        this.s();
        this.d();
        this.c();
        this.b();
    }

    private void a() {
        Criteria criteria = this.a(CustomerAccountTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.a.setCustomerPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void b() {
        double d = this.a.getCashReceiptAmount() - this.a.getTipsPaid() - this.a.getPayOutAmount() - this.a.getCashBack() + this.a.getBeginCash() - this.a.getDrawerBleedAmount();
        this.a.setDrawerAccountable(POSUtil.getRoundedDouble(d));
    }

    private void c() {
        double d = this.a.getCashTips() + this.a.getChargedTips() - this.a.getTipsPaid();
        this.a.setTipsDifferential(POSUtil.getRoundedDouble(d));
    }

    private void d() {
        double d = this.a.getGrossReceipts() - this.a.getCashReceiptAmount() - this.a.getCreditCardReceiptAmount() - this.a.getDebitCardReceiptAmount() - this.a.getCustomerPaymentAmount() - this.a.getCustomPaymentAmount() - this.a.getPromotionAmount() - this.a.getGiftCertChangeAmount() - this.a.getGiftCertReturnAmount() + this.a.getTotalVoid() + this.a.getRefundAmount();
        this.a.setReceiptDifferential(POSUtil.getRoundedDouble(d));
    }

    private Criteria a(Class clazz) {
        Criteria criteria = this.b.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class) || clazz.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        return criteria;
    }

    private void e() {
        Criteria criteria = this.a(PosTransaction.class);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TAX_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_SERVICE_CHARGE_AMOUNT));
        criteria.setProjection((Projection)projectionList);
        List list = criteria.list();
        for (Object[] objectArray : list) {
            if (objectArray[0] == null) {
                return;
            }
            double d = objectArray[0] != null ? ((Number)objectArray[0]).doubleValue() : 0.0;
            double d2 = objectArray[1] != null ? ((Number)objectArray[1]).doubleValue() : 0.0;
            double d3 = objectArray[2] != null ? ((Number)objectArray[2]).doubleValue() : 0.0;
            double d4 = objectArray[3] != null ? ((Number)objectArray[3]).doubleValue() : 0.0;
            double d5 = d - d2 - d3 - d4;
            this.a.setNetSales(NumberUtil.round(d5));
            this.a.setSalesTax(NumberUtil.round(d2));
            this.a.setServiceCharge(NumberUtil.round(d4));
        }
    }

    private void f() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.a.setCashTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void g() {
        Criteria criteria = this.a(PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        this.a.setChargedTips(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void h() {
        Criteria criteria = this.a(CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.a.setCashReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void i() {
        Criteria criteria = this.a(CreditCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        this.a.setCreditCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void j() {
        Criteria criteria = this.a(DebitCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        this.a.setDebitCardReceiptAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void k() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.a.setCustomPaymentAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void l() {
        Criteria criteria = this.a(CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        this.a.setPromotionAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void m() {
        Criteria criteria = this.a(GiftCertificateTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        this.a.setGiftCertChangeAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void n() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.a.setRefundAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void o() {
        Criteria criteria = this.b.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)this.a.getId()));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.a.setCardVoidAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void p() {
        Criteria criteria = this.a(PayOutTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.a.setPayOutAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void q() {
        Criteria criteria = this.a(CashDropTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PayOutTransaction.PROP_AMOUNT));
        this.a.setDrawerBleedAmount(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void r() {
        Criteria criteria = this.a(RefundTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        this.a.setCashBack(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }

    private void s() {
        Criteria criteria = this.b.createCriteria(GratuityPaymentHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)GratuityPaymentHistory.PROP_CASH_DRAWER, (Object)this.a));
        criteria.setProjection((Projection)Projections.sum((String)GratuityPaymentHistory.PROP_AMOUNT));
        this.a.setTipsPaid(POSUtil.getRoundedDouble(criteria.uniqueResult()));
    }
}

