/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class BeanTableModel<M>
extends AbstractTableModel
implements PaginationSupport {
    private int a;
    private int b;
    private int c = 100;
    private List<M> d = new ArrayList<M>();
    private List<BeanColumn> e = new ArrayList<BeanColumn>();
    private Class<?> f;
    private BeanTableCellEditor g;
    private BeanTableCellEditor h;
    private String i;
    private boolean j;

    public BeanTableModel(Class<?> clazz) {
        this(clazz, 50);
    }

    public BeanTableModel(Class<?> clazz, int n) {
        this.f = clazz;
        this.c = n;
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setHorizontalAlignment(4);
        this.g = new BeanTableCellEditor(doubleTextField);
        this.g.setClickCountToStart(1);
        JTextField jTextField = new JTextField();
        this.h = new BeanTableCellEditor(jTextField);
        this.h.setClickCountToStart(1);
    }

    public void addColumn(String string, String string2, EditMode editMode) {
        this.addColumn(string, string2, editMode, 10, null);
    }

    public void addColumn(String string, String string2, EditMode editMode, int n, DataType dataType) {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string2, this.f);
            this.e.add(new BeanColumn(string, editMode, propertyDescriptor, n, dataType));
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void addColumn(String string, String string2) {
        this.addColumn(string, string2, EditMode.NON_EDITABLE);
    }

    public void addColumn(String string, String string2, int n, DataType dataType) {
        this.addColumn(string, string2, EditMode.NON_EDITABLE, n, dataType);
    }

    public void addRow(M m) {
        this.d.add(m);
        this.fireTableDataChanged();
    }

    public void removeRow(M m) {
        this.d.remove(m);
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        this.d.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void removeAll() {
        this.d.clear();
        this.fireTableDataChanged();
    }

    public void addRows(List<M> list) {
        if (list == null) {
            return;
        }
        for (M m : list) {
            this.addRow(m);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setRows(List list) {
        this.d = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.e.size();
    }

    @Override
    public int getRowCount() {
        if (this.d == null) {
            return 0;
        }
        return this.d.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        BeanColumn beanColumn = this.e.get(n2);
        M m = this.d.get(n);
        Object object = null;
        try {
            object = beanColumn.c.getReadMethod().invoke(m, new Object[0]);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        return object;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        M m = this.d.get(n);
        BeanColumn beanColumn = this.e.get(n2);
        try {
            beanColumn.c.getWriteMethod().invoke(m, object);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        BeanColumn beanColumn = this.e.get(n);
        Class<?> clazz = beanColumn.c.getReadMethod().getReturnType();
        return clazz;
    }

    @Override
    public String getColumnName(int n) {
        return this.e.get(n).a;
    }

    public BeanColumn getColumn(int n) {
        return this.e.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.e.get(n2).b == EditMode.EDITABLE;
    }

    public void setRow(int n, M m) {
        this.getRows().set(n, m);
        this.fireTableRowsUpdated(n, n);
    }

    public M getRow(int n) {
        return this.getRows().get(n);
    }

    public List<M> getRows() {
        return this.d;
    }

    @Override
    public int getNumRows() {
        return this.a;
    }

    @Override
    public void setNumRows(int n) {
        this.a = n;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.b;
    }

    @Override
    public void setCurrentRowIndex(int n) {
        this.b = n;
    }

    @Override
    public int getPageSize() {
        return this.c;
    }

    @Override
    public void setPageSize(int n) {
        this.c = n;
    }

    @Override
    public boolean hasNext() {
        return this.b + this.c < this.a;
    }

    @Override
    public boolean hasPrevious() {
        return this.b > 0;
    }

    @Override
    public int getNextRowIndex() {
        if (this.a == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    @Override
    public int getPreviousRowIndex() {
        int n = this.getCurrentRowIndex() - this.getPageSize();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void initTableRenderer(JTable jTable) {
        BeanTableCellRenderer beanTableCellRenderer = new BeanTableCellRenderer();
        jTable.setDefaultRenderer(Object.class, beanTableCellRenderer);
        jTable.setDefaultRenderer(Double.class, beanTableCellRenderer);
        jTable.setDefaultRenderer(Number.class, beanTableCellRenderer);
        jTable.setRowHeight(PosUIManager.getSize(30));
        for (int i = 0; i < this.e.size(); ++i) {
            BeanColumn beanColumn = this.e.get(i);
            if (!beanColumn.isEditable()) continue;
            if (beanColumn.getDataType() == DataType.MONEY || beanColumn.getDataType() == DataType.NUMBER) {
                jTable.setDefaultEditor(jTable.getColumnClass(i), this.g);
                continue;
            }
            jTable.setDefaultEditor(jTable.getColumnClass(i), this.h);
        }
    }

    public void setSortBy(String string, boolean bl) {
        this.i = string;
        this.j = bl;
    }

    public boolean isAscOrder() {
        return this.j;
    }

    public String getSortBy() {
        return this.i;
    }

    class BeanTableCellEditor
    extends DefaultCellEditor {
        public BeanTableCellEditor(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editorComponent instanceof DoubleTextField) {
                return ((DoubleTextField)this.editorComponent).getDoubleOrZero();
            }
            if (this.editorComponent instanceof IntegerTextField) {
                return ((IntegerTextField)this.editorComponent).getInteger();
            }
            return super.getCellEditorValue();
        }
    }

    public static class BeanTableCellRenderer
    extends DefaultTableCellRenderer {
        private Border a = null;
        private Border b = null;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            BeanTableModel beanTableModel = (BeanTableModel)jTable.getModel();
            BeanColumn beanColumn = beanTableModel.getColumn(n2);
            this.setHorizontalAlignment(beanColumn.getHorizontalAlignment());
            if (this.b == null) {
                this.b = BorderFactory.createMatteBorder(5, 5, 5, 5, jTable.getSelectionBackground());
            }
            if (this.a == null) {
                this.a = BorderFactory.createMatteBorder(5, 5, 5, 5, jTable.getBackground());
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                ImageIcon imageIcon = new ImageIcon(byArray);
                imageIcon = ImageResource.getScaledImageIcon(imageIcon, 40);
                JLabel jLabel = new JLabel(imageIcon);
                if (bl) {
                    jLabel.setBorder(this.b);
                } else {
                    jLabel.setBorder(this.a);
                }
                jLabel.setHorizontalAlignment(0);
                return jLabel;
            }
            if (object instanceof Color) {
                JLabel jLabel = new JLabel();
                Color color = (Color)object;
                jLabel.setOpaque(true);
                jLabel.setBackground(color);
                if (bl) {
                    jLabel.setBorder(this.b);
                } else {
                    jLabel.setBorder(this.a);
                }
                return jLabel;
            }
            if (object instanceof Date) {
                String string = DateUtil.formatFullDateAndTimeWithoutYearAsString((Date)object);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
            DataType dataType = beanColumn.getDataType();
            if (dataType == null) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            switch (dataType) {
                case MONEY: {
                    try {
                        object = NumberUtil.getCurrencyFormat(object);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case NUMBER: {
                    try {
                        object = NumberUtil.format6DigitNumber((Double)object);
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    object = "<html>" + object + "</html>";
                }
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public static class BeanColumn {
        private String a;
        private EditMode b;
        private PropertyDescriptor c;
        private int d = 10;
        private DataType e;

        public BeanColumn(String string, EditMode editMode, PropertyDescriptor propertyDescriptor, int n, DataType dataType) {
            this.a = string;
            this.b = editMode;
            this.c = propertyDescriptor;
            this.d = n;
            this.e = dataType;
        }

        public boolean isEditable() {
            if (this.b == null) {
                return false;
            }
            return this.b == EditMode.EDITABLE;
        }

        public int getHorizontalAlignment() {
            return this.d;
        }

        public void setHorizontalAlignment(int n) {
            this.d = n;
        }

        public DataType getDataType() {
            return this.e;
        }
    }

    public static enum EditMode {
        NON_EDITABLE,
        EDITABLE;

    }

    public static enum DataType {
        MONEY,
        NUMBER,
        DATE;

    }
}

