/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.SerialPortUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jssc.SerialPortException;
import net.miginfocom.swing.MigLayout;

public class AutomatedWeightInputDialog
extends OkCancelOptionDialog
implements ActionListener {
    private double a;
    private static DoubleTextField b;
    private boolean c = true;
    private static final String d = "KG";
    private static final String e = "LB";
    private static final String f = "OZ";
    private static final String g = "G";
    private POSToggleButton h;
    private POSToggleButton i;
    private POSToggleButton j;
    private POSToggleButton k;
    private PosButton l;
    private JTextField m;
    private ButtonGroup n;

    public AutomatedWeightInputDialog(String string) {
        super((Window)Application.getPosWindow(), string);
        this.a();
    }

    private void a() {
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        MigLayout migLayout = new MigLayout("fill,inset 0", "sg, fill", "");
        jPanel.setLayout((LayoutManager)migLayout);
        Dimension dimension = PosUIManager.getSize_w100_h70();
        b = new DoubleTextField();
        b.setText(String.valueOf(this.a));
        b.setFont(b.getFont().deriveFont(1, 24.0f));
        b.setFocusable(true);
        b.requestFocus();
        b.setBackground(Color.WHITE);
        this.m = new JTextField();
        this.m.setText(Messages.getString("AutomatedWeightInputDialog.0"));
        this.m.setFont(b.getFont().deriveFont(1, 24.0f));
        this.m.setFocusable(false);
        this.m.setEnabled(false);
        this.m.setHorizontalAlignment(4);
        this.m.setBackground(Color.WHITE);
        this.m.setForeground(Color.LIGHT_GRAY);
        jPanel.add((Component)b, "span 2, grow");
        jPanel.add((Component)this.m, "span, grow");
        String[][] stringArrayArray = new String[][]{{"7", "8", "9"}, {"4", "5", "6"}, {"1", "2", "3"}, {".", "0", "CLEAR ALL"}};
        String[][] stringArrayArray2 = new String[][]{{"7.png", "8.png", "9.png"}, {"4.png", "5.png", "6.png"}, {"1.png", "2.png", "3.png"}, {"dot.png", "0.png", ""}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            for (int j = 0; j < stringArrayArray[i].length; ++j) {
                PosButton posButton = new PosButton();
                posButton.setFocusable(false);
                ImageIcon imageIcon = IconFactory.getIcon("/ui_icons/", stringArrayArray2[i][j]);
                String string = String.valueOf(stringArrayArray[i][j]);
                if (imageIcon == null) {
                    posButton.setText(string);
                } else {
                    posButton.setIcon(imageIcon);
                    if (POSConstants.CLEAR_ALL.equals(string)) {
                        posButton.setText(Messages.getString("AutomatedWeightInputDialog.1"));
                    }
                }
                posButton.setActionCommand(string);
                posButton.addActionListener(this);
                String string2 = "w " + dimension.width + "!,h " + dimension.height + "!,grow";
                if (j == stringArrayArray[i].length - 1) {
                    string2 = string2 + ",wrap";
                }
                jPanel.add((Component)posButton, string2);
            }
        }
        this.getContentPanel().add((Component)jPanel, "Center");
        this.b();
    }

    private void b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill, inset 0 10 0 0", "sg, fill", ""));
        Dimension dimension = PosUIManager.getSize_w100_h70();
        this.n = new ButtonGroup();
        this.l = new PosButton(Messages.getString("AutomatedWeightInputDialog.2"));
        this.h = new POSToggleButton(e);
        this.i = new POSToggleButton(f);
        this.j = new POSToggleButton(d);
        this.k = new POSToggleButton(g);
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutomatedWeightInputDialog.this.readWeight();
            }
        });
        this.h.addActionListener(this);
        this.i.addActionListener(this);
        this.j.addActionListener(this);
        this.j.setSelected(true);
        this.k.addActionListener(this);
        this.n.add(this.h);
        this.n.add(this.i);
        this.n.add(this.j);
        this.n.add(this.k);
        jPanel.add((Component)this.l, "w " + dimension.width + "!,h " + 40 + "!,wrap");
        jPanel.add((Component)this.h, "w " + dimension.width + "!, h " + dimension.height + "!,wrap");
        jPanel.add((Component)this.i, "w " + dimension.width + "!, h " + dimension.height + "!,wrap");
        jPanel.add((Component)this.j, "w " + dimension.width + "!, h " + dimension.height + "!,wrap");
        jPanel.add((Component)this.k, "w " + dimension.width + "!, h " + dimension.height + "!,wrap");
        this.getContentPanel().add((Component)jPanel, "East");
    }

    public void readWeight() {
        try {
            String string = SerialPortUtil.readWeight(TerminalConfig.getScalePort());
            this.updateScaleView(string);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    protected void updateScaleView(String string) throws SerialPortException {
        string = string.replaceAll("\n", "");
        String string2 = "(\\d*\\.?\\d*)(lb|oz|g|kg)";
        Pattern pattern = Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            b.setText(matcher.group(1));
            String string3 = matcher.group(2).toUpperCase();
            if (string3.equals(d)) {
                this.j.setSelected(true);
                this.m.setText(d);
            } else if (string3.equals(e)) {
                this.h.setSelected(true);
                this.m.setText(e);
            } else if (string3.equals(g)) {
                this.k.setSelected(true);
                this.m.setText(g);
            } else if (string3.equals(f)) {
                this.i.setSelected(true);
                this.m.setText(f);
            }
        } else {
            b.setText(String.valueOf(0));
            this.n.clearSelection();
        }
    }

    private double a(String string, double d) {
        String string2 = this.m.getText();
        if (string2.equals(d)) {
            if (string.equals(e)) {
                return NumberUtil.roundToTwoDigit(2.2 * d);
            }
            if (string.equals(f)) {
                return NumberUtil.roundToTwoDigit(35.27 * d);
            }
            if (string.equals(g)) {
                return NumberUtil.roundToTwoDigit(1000.0 * d);
            }
        } else if (string2.equals(e)) {
            if (string.equals(d)) {
                return NumberUtil.roundToTwoDigit(0.45 * d);
            }
            if (string.equals(f)) {
                return NumberUtil.roundToTwoDigit(16.0 * d);
            }
            if (string.equals(g)) {
                return NumberUtil.roundToTwoDigit(453.59 * d);
            }
        } else if (string2.equals(g)) {
            if (string.equals(d)) {
                return NumberUtil.roundToTwoDigit(0.001 * d);
            }
            if (string.equals(f)) {
                return NumberUtil.roundToTwoDigit(0.035 * d);
            }
            if (string.equals(e)) {
                return NumberUtil.roundToTwoDigit(0.00220462 * d);
            }
        } else if (string2.equals(f)) {
            if (string.equals(d)) {
                return NumberUtil.roundToTwoDigit(0.0283495 * d);
            }
            if (string.equals(g)) {
                return NumberUtil.roundToTwoDigit(28.3495 * d);
            }
            if (string.equals(e)) {
                return NumberUtil.roundToTwoDigit(0.0625 * d);
            }
        }
        return d;
    }

    private void c() {
        b.setText(String.valueOf(0.0));
    }

    private void a(String string) {
        if (this.c) {
            b.setText("0");
            this.c = false;
        }
        String string2 = b.getText();
        double d = 0.0;
        try {
            d = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d == 0.0 && !string2.contains(".")) {
            b.setText(string);
            return;
        }
        if (!this.b(string2 = string2 + string)) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        b.setText(string2);
    }

    private void d() {
        String string = b.getText() + ".";
        if (!this.b(string)) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        b.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        double d = b.getDouble();
        if (string.equals(POSConstants.CLEAR_ALL)) {
            this.c();
        } else if (string.equals(".")) {
            this.d();
        } else if (string.equals(e)) {
            b.setText(String.valueOf(this.a(e, d)));
            this.m.setText(e);
        } else if (string.equals(f)) {
            b.setText(String.valueOf(this.a(f, d)));
            this.m.setText(f);
        } else if (string.equals(g)) {
            b.setText(String.valueOf(this.a(g, d)));
            this.m.setText(g);
        } else if (string.equals(d)) {
            b.setText(String.valueOf(this.a(d, d)));
            this.m.setText(d);
        } else {
            this.a(string);
        }
    }

    private boolean b(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public double getValue() {
        return Double.parseDouble(b.getText());
    }

    public void setValue(double d) {
        b.setText(String.valueOf(d));
    }

    public static double takeDoubleInput(String string, double d) {
        AutomatedWeightInputDialog automatedWeightInputDialog = new AutomatedWeightInputDialog(Messages.getString("AutomatedWeightInputDialog.3"));
        automatedWeightInputDialog.setCaption(string);
        automatedWeightInputDialog.setValue(d);
        if (TerminalConfig.isActiveScaleDisplay()) {
            automatedWeightInputDialog.readWeight();
        }
        automatedWeightInputDialog.pack();
        automatedWeightInputDialog.open();
        if (automatedWeightInputDialog.isCanceled()) {
            return -1.0;
        }
        return automatedWeightInputDialog.getValue();
    }

    @Override
    public void doOk() {
        if (!this.b(b.getText())) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }
}

