/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.PayOutTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.PayOutView;
import com.floreantpos.util.NumberUtil;
import java.awt.Dialog;
import java.awt.Frame;

public class PayoutDialog
extends OkCancelOptionDialog {
    private PayOutView a;
    private User b;
    private Terminal c;

    public PayoutDialog(Dialog dialog, User user, Terminal terminal) {
        super(dialog, true);
        this.b = user;
        this.c = terminal;
        this.setTitle(Application.getTitle() + POSConstants.PAYOUT_BUTTON_TEXT);
        this.a();
        this.a.initialize();
    }

    public PayoutDialog(Frame frame, User user, Terminal terminal) {
        super(frame, true);
        this.b = user;
        this.c = terminal;
        this.setTitle(Application.getTitle() + POSConstants.PAYOUT_BUTTON_TEXT);
        this.a();
        this.a.initialize();
    }

    private void a() {
        this.setCaption(POSConstants.PAYOUT_BUTTON_TEXT);
        this.setOkButtonText(POSConstants.FINISH);
        this.a = new PayOutView();
        this.setDefaultCloseOperation(2);
        this.getContentPanel().add(this.a);
        this.pack();
    }

    @Override
    public void doOk() {
        double d = this.a.getPayoutAmount();
        PayoutReason payoutReason = this.a.getReason();
        PayoutRecepient payoutRecepient = this.a.getRecepient();
        String string = this.a.getNote();
        try {
            PayOutTransactionDAO.getInstance().createPayoutTransaction(payoutReason, payoutRecepient, string, d, this.b, this.c);
            this.a(d);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(double d) {
        try {
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            CashDrawer cashDrawer = terminal.getCurrentCashDrawer();
            String string = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", terminal.getId(), cashDrawer.getId(), NumberUtil.formatNumber(d));
            ActionHistoryDAO.saveHistory(this.b, "Pay out", string);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }
}

